/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import java.io.PrintWriter;
import mondrian.calc.Calc;
import mondrian.calc.ExpCompiler;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Category;
import mondrian.olap.Cube;
import mondrian.olap.Exp;
import mondrian.olap.FunDef;
import mondrian.olap.Syntax;
import mondrian.olap.Util;
import mondrian.olap.Validator;
import mondrian.olap.fun.FunUtil;
import mondrian.olap.fun.Resolver;
import mondrian.olap.type.BooleanType;
import mondrian.olap.type.CubeType;
import mondrian.olap.type.DateTimeType;
import mondrian.olap.type.DecimalType;
import mondrian.olap.type.DimensionType;
import mondrian.olap.type.EmptyType;
import mondrian.olap.type.HierarchyType;
import mondrian.olap.type.LevelType;
import mondrian.olap.type.MemberType;
import mondrian.olap.type.NumericType;
import mondrian.olap.type.ScalarType;
import mondrian.olap.type.SetType;
import mondrian.olap.type.StringType;
import mondrian.olap.type.SymbolType;
import mondrian.olap.type.Type;
import mondrian.olap.type.TypeUtil;

public abstract class FunDefBase
extends FunUtil
implements FunDef {
    protected final int flags;
    private final String name;
    final String signature;
    private final String description;
    protected final int returnCategory;
    protected final int[] parameterCategories;

    FunDefBase(String name, String signature, String description, Syntax syntax, int returnCategory, int[] parameterCategories) {
        assert (name != null);
        assert (syntax != null);
        this.name = name;
        this.signature = signature;
        this.description = description;
        this.flags = syntax.ordinal();
        this.returnCategory = returnCategory;
        this.parameterCategories = parameterCategories;
    }

    protected FunDefBase(String name, String description, String flags) {
        this(name, null, description, FunDefBase.decodeSyntacticType(flags), FunDefBase.decodeReturnCategory(flags), FunDefBase.decodeParameterCategories(flags));
    }

    protected FunDefBase(String name, String signature, String description, String flags) {
        this(name, signature, description, FunDefBase.decodeSyntacticType(flags), FunDefBase.decodeReturnCategory(flags), FunDefBase.decodeParameterCategories(flags));
    }

    FunDefBase(Resolver resolver, int returnType, int[] parameterTypes) {
        this(resolver.getName(), null, null, resolver.getSyntax(), returnType, parameterTypes);
    }

    FunDefBase(FunDef funDef) {
        this(funDef.getName(), funDef.getSignature(), funDef.getDescription(), funDef.getSyntax(), funDef.getReturnCategory(), funDef.getParameterCategories());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Syntax getSyntax() {
        return ((Syntax[])Syntax.class.getEnumConstants())[this.flags];
    }

    @Override
    public int getReturnCategory() {
        return this.returnCategory;
    }

    @Override
    public int[] getParameterCategories() {
        return this.parameterCategories;
    }

    @Override
    public Exp createCall(Validator validator, Exp[] args) {
        int[] categories = this.getParameterCategories();
        Util.assertTrue(categories.length == args.length);
        int i = 0;
        while (i < args.length) {
            args[i] = this.validateArg(validator, args, i, categories[i]);
            ++i;
        }
        Type type = this.getResultType(validator, args);
        if (type == null) {
            throw Util.newInternal("could not derive type");
        }
        return new ResolvedFunCall(this, args, type);
    }

    protected Exp validateArg(Validator validator, Exp[] args, int i, int category) {
        return args[i];
    }

    static Type castType(Type type, int category) {
        switch (category) {
            case 5: {
                return new BooleanType();
            }
            case 7: {
                return new NumericType();
            }
            case 15: {
                return new DecimalType(Integer.MAX_VALUE, 0);
            }
            case 9: {
                return new StringType();
            }
            case 18: {
                return new DateTimeType();
            }
            case 11: {
                return new SymbolType();
            }
            case 13: {
                return new ScalarType();
            }
            case 12: {
                if (type instanceof Cube) {
                    return new CubeType((Cube)((Object)type));
                }
                return null;
            }
            case 2: {
                if (type != null) {
                    return DimensionType.forType(type);
                }
                return null;
            }
            case 3: {
                if (type != null) {
                    return HierarchyType.forType(type);
                }
                return null;
            }
            case 4: {
                if (type != null) {
                    return LevelType.forType(type);
                }
                return null;
            }
            case 6: {
                MemberType memberType;
                if (type != null && (memberType = TypeUtil.toMemberType(type)) != null) {
                    return memberType;
                }
                return MemberType.Unknown;
            }
            case 10: {
                Type memberType;
                if (type != null && (memberType = TypeUtil.toMemberOrTupleType(type)) != null) {
                    return memberType;
                }
                return null;
            }
            case 8: {
                Type memberType;
                if (type != null && (memberType = TypeUtil.toMemberOrTupleType(type)) != null) {
                    return new SetType(memberType);
                }
                return null;
            }
            case 17: {
                return new EmptyType();
            }
        }
        throw Category.instance.badValue(category);
    }

    public Type getResultType(Validator validator, Exp[] args) {
        Type firstArgType = args.length > 0 ? args[0].getType() : null;
        Type type = FunDefBase.castType(firstArgType, this.getReturnCategory());
        if (type != null) {
            return type;
        }
        throw Util.newInternal("Cannot deduce type of call to function '" + this.name + "'");
    }

    @Override
    public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
        throw Util.newInternal("function '" + this.getSignature() + "' has not been implemented");
    }

    @Override
    public String getSignature() {
        return this.getSyntax().getSignature(this.getName(), this.getReturnCategory(), this.getParameterCategories());
    }

    @Override
    public void unparse(Exp[] args, PrintWriter pw) {
        this.getSyntax().unparse(this.getName(), args, pw);
    }
}

