/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mondrian.olap.FunDef;
import mondrian.olap.FunTable;
import mondrian.olap.Syntax;
import mondrian.olap.fun.FunInfo;
import mondrian.olap.fun.Resolver;
import mondrian.olap.fun.SimpleResolver;
import mondrian.util.Pair;

public abstract class FunTableImpl
implements FunTable {
    private Map<Pair<String, Syntax>, List<Resolver>> mapNameToResolvers;
    private Set<String> reservedWordSet;
    private List<String> reservedWordList;
    private Set<String> propertyWords;
    private List<FunInfo> funInfoList;

    protected FunTableImpl() {
    }

    public final void init() {
        BuilderImpl builder = new BuilderImpl();
        this.defineFunctions(builder);
        builder.organizeFunctions();
        this.funInfoList = Collections.unmodifiableList(builder.funInfoList);
        this.mapNameToResolvers = Collections.unmodifiableMap(builder.mapNameToResolvers);
        this.reservedWordSet = builder.reservedWords;
        Object[] reservedWords = builder.reservedWords.toArray(new String[builder.reservedWords.size()]);
        Arrays.sort(reservedWords);
        this.reservedWordList = Collections.unmodifiableList(Arrays.asList(reservedWords));
        this.propertyWords = Collections.unmodifiableSet(builder.propertyWords);
    }

    private static Pair<String, Syntax> makeResolverKey(String name, Syntax syntax) {
        return new Pair<String, Syntax>(name.toUpperCase(), syntax);
    }

    @Override
    public List<String> getReservedWords() {
        return this.reservedWordList;
    }

    @Override
    public boolean isReserved(String s) {
        return this.reservedWordSet.contains(s.toUpperCase());
    }

    @Override
    public List<Resolver> getResolvers() {
        ArrayList<Resolver> list = new ArrayList<Resolver>();
        for (List<Resolver> resolvers : this.mapNameToResolvers.values()) {
            list.addAll(resolvers);
        }
        return list;
    }

    @Override
    public boolean isProperty(String s) {
        return this.propertyWords.contains(s.toUpperCase());
    }

    @Override
    public List<FunInfo> getFunInfoList() {
        return this.funInfoList;
    }

    @Override
    public List<Resolver> getResolvers(String name, Syntax syntax) {
        Pair<String, Syntax> key = FunTableImpl.makeResolverKey(name, syntax);
        List<Resolver> resolvers = this.mapNameToResolvers.get(key);
        if (resolvers == null) {
            resolvers = Collections.emptyList();
        }
        return resolvers;
    }

    private class BuilderImpl
    implements FunTable.Builder {
        private final List<Resolver> resolverList = new ArrayList<Resolver>();
        private final List<FunInfo> funInfoList = new ArrayList<FunInfo>();
        private final Map<Pair<String, Syntax>, List<Resolver>> mapNameToResolvers = new HashMap<Pair<String, Syntax>, List<Resolver>>();
        private final Set<String> reservedWords = new HashSet<String>();
        private final Set<String> propertyWords = new HashSet<String>();

        private BuilderImpl() {
        }

        @Override
        public void define(FunDef funDef) {
            this.define(new SimpleResolver(funDef));
        }

        @Override
        public void define(Resolver resolver) {
            String[] reservedWords;
            this.funInfoList.add(FunInfo.make(resolver));
            if (resolver.getSyntax() == Syntax.Property) {
                this.propertyWords.add(resolver.getName().toUpperCase());
            }
            this.resolverList.add(resolver);
            String[] stringArray = reservedWords = resolver.getReservedWords();
            int n = reservedWords.length;
            int n2 = 0;
            while (n2 < n) {
                String reservedWord = stringArray[n2];
                this.defineReserved(reservedWord);
                ++n2;
            }
        }

        @Override
        public void define(FunInfo funInfo) {
            this.funInfoList.add(funInfo);
        }

        @Override
        public void defineReserved(String s) {
            this.reservedWords.add(s.toUpperCase());
        }

        protected void organizeFunctions() {
            Collections.sort(this.funInfoList);
            ArrayList<List<Resolver>> nonSingletonResolverLists = new ArrayList<List<Resolver>>();
            for (Resolver resolver : this.resolverList) {
                Pair key = FunTableImpl.makeResolverKey(resolver.getName(), resolver.getSyntax());
                List<Resolver> list = this.mapNameToResolvers.get(key);
                if (list == null) {
                    list = new ArrayList<Resolver>();
                    this.mapNameToResolvers.put(key, list);
                }
                list.add(resolver);
                if (list.size() != 2) continue;
                nonSingletonResolverLists.add(list);
            }
            Comparator<Resolver> comparator = new Comparator<Resolver>(){

                @Override
                public int compare(Resolver o1, Resolver o2) {
                    return o1.getSignature().compareTo(o2.getSignature());
                }
            };
            for (List list : nonSingletonResolverLists) {
                Collections.sort(list, comparator);
            }
        }
    }
}

