/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import mondrian.calc.Calc;
import mondrian.calc.ExpCompiler;
import mondrian.calc.IterCalc;
import mondrian.calc.ListCalc;
import mondrian.calc.StringCalc;
import mondrian.calc.TupleCollections;
import mondrian.calc.TupleCursor;
import mondrian.calc.TupleIterable;
import mondrian.calc.TupleList;
import mondrian.calc.impl.AbstractListCalc;
import mondrian.calc.impl.AbstractStringCalc;
import mondrian.calc.impl.ConstantCalc;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.FunDef;
import mondrian.olap.Hierarchy;
import mondrian.olap.Member;
import mondrian.olap.Validator;
import mondrian.olap.fun.FunDefBase;
import mondrian.olap.fun.ReflectiveMultiResolver;
import mondrian.olap.type.SetType;
import mondrian.olap.type.StringType;
import mondrian.olap.type.Type;
import mondrian.olap.type.TypeUtil;

class GenerateFunDef
extends FunDefBase {
    static final ReflectiveMultiResolver ListResolver = new ReflectiveMultiResolver("Generate", "Generate(<Set1>, <Set2>[, ALL])", "Applies a set to each member of another set and joins the resulting sets by union.", new String[]{"fxxx", "fxxxy"}, GenerateFunDef.class);
    static final ReflectiveMultiResolver StringResolver = new ReflectiveMultiResolver("Generate", "Generate(<Set>, <String>[, <String>])", "Applies a set to a string expression and joins resulting sets by string concatenation.", new String[]{"fSxS", "fSxSS"}, GenerateFunDef.class);
    private static final String[] ReservedWords = new String[]{"ALL"};

    public GenerateFunDef(FunDef dummyFunDef) {
        super(dummyFunDef);
    }

    @Override
    public Type getResultType(Validator validator, Exp[] args) {
        Type type = args[1].getType();
        if (type instanceof StringType) {
            return type;
        }
        Type memberType = TypeUtil.toMemberOrTupleType(type);
        return new SetType(memberType);
    }

    @Override
    public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
        IterCalc iterCalc = compiler.compileIter(call.getArg(0));
        if (call.getArg(1).getType() instanceof StringType) {
            StringCalc stringCalc = compiler.compileString(call.getArg(1));
            StringCalc delimCalc = call.getArgCount() == 3 ? compiler.compileString(call.getArg(2)) : ConstantCalc.constantString("");
            return new GenerateStringCalcImpl(call, iterCalc, stringCalc, delimCalc);
        }
        ListCalc listCalc2 = compiler.compileList(call.getArg(1));
        String literalArg = GenerateFunDef.getLiteralArg(call, 2, "", ReservedWords);
        boolean all = literalArg.equalsIgnoreCase("ALL");
        int arityOut = call.getType().getArity();
        return new GenerateListCalcImpl(call, iterCalc, listCalc2, arityOut, all);
    }

    private static class GenerateListCalcImpl
    extends AbstractListCalc {
        private final IterCalc iterCalc1;
        private final ListCalc listCalc2;
        private final int arityOut;
        private final boolean all;

        public GenerateListCalcImpl(ResolvedFunCall call, IterCalc iterCalc, ListCalc listCalc2, int arityOut, boolean all) {
            super(call, new Calc[]{iterCalc, listCalc2});
            this.iterCalc1 = iterCalc;
            this.listCalc2 = listCalc2;
            this.arityOut = arityOut;
            this.all = all;
        }

        @Override
        public TupleList evaluateList(Evaluator evaluator) {
            int savepoint = evaluator.savepoint();
            try {
                evaluator.setNonEmpty(false);
                TupleIterable iterable1 = this.iterCalc1.evaluateIterable(evaluator);
                evaluator.restore(savepoint);
                TupleList result = TupleCollections.createList(this.arityOut);
                if (this.all) {
                    TupleCursor cursor = iterable1.tupleCursor();
                    while (cursor.forward()) {
                        cursor.setContext(evaluator);
                        TupleList result2 = this.listCalc2.evaluateList(evaluator);
                        result.addAll(result2);
                    }
                } else {
                    HashSet<List<Member>> emitted = new HashSet<List<Member>>();
                    TupleCursor cursor = iterable1.tupleCursor();
                    while (cursor.forward()) {
                        cursor.setContext(evaluator);
                        TupleList result2 = this.listCalc2.evaluateList(evaluator);
                        GenerateListCalcImpl.addDistinctTuples(result, result2, emitted);
                    }
                }
                TupleList tupleList = result;
                return tupleList;
            }
            finally {
                evaluator.restore(savepoint);
            }
        }

        private static void addDistinctTuples(TupleList result, TupleList result2, Set<List<Member>> emitted) {
            for (List row : result2) {
                if (!emitted.add(row)) continue;
                result.add(row);
            }
        }

        @Override
        public boolean dependsOn(Hierarchy hierarchy) {
            return GenerateListCalcImpl.anyDependsButFirst(this.getCalcs(), hierarchy);
        }
    }

    private static class GenerateStringCalcImpl
    extends AbstractStringCalc {
        private final IterCalc iterCalc;
        private final StringCalc stringCalc;
        private final StringCalc sepCalc;

        public GenerateStringCalcImpl(ResolvedFunCall call, IterCalc iterCalc, StringCalc stringCalc, StringCalc sepCalc) {
            super(call, new Calc[]{iterCalc, stringCalc});
            this.iterCalc = iterCalc;
            this.stringCalc = stringCalc;
            this.sepCalc = sepCalc;
        }

        @Override
        public String evaluateString(Evaluator evaluator) {
            int savepoint = evaluator.savepoint();
            try {
                StringBuilder buf = new StringBuilder();
                int k = 0;
                TupleIterable iter11 = this.iterCalc.evaluateIterable(evaluator);
                TupleCursor cursor = iter11.tupleCursor();
                while (cursor.forward()) {
                    cursor.setContext(evaluator);
                    if (k++ > 0) {
                        String sep = this.sepCalc.evaluateString(evaluator);
                        buf.append(sep);
                    }
                    String result2 = this.stringCalc.evaluateString(evaluator);
                    buf.append(result2);
                }
                String string = buf.toString();
                return string;
            }
            finally {
                evaluator.restore(savepoint);
            }
        }

        @Override
        public boolean dependsOn(Hierarchy hierarchy) {
            return GenerateStringCalcImpl.anyDependsButFirst(this.getCalcs(), hierarchy);
        }
    }
}

