/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mondrian.calc.Calc;
import mondrian.calc.DoubleCalc;
import mondrian.calc.ExpCompiler;
import mondrian.calc.IntegerCalc;
import mondrian.calc.ResultStyle;
import mondrian.calc.StringCalc;
import mondrian.calc.impl.AbstractCalc;
import mondrian.calc.impl.GenericCalc;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.FunDef;
import mondrian.olap.Syntax;
import mondrian.olap.Util;
import mondrian.olap.fun.FunDefBase;

public class JavaFunDef
extends FunDefBase {
    private static final Map<Class, Integer> mapClazzToCategory = new HashMap<Class, Integer>();
    private static final String className = JavaFunDef.class.getName();
    private final Method method;

    static {
        mapClazzToCategory.put(String.class, 9);
        mapClazzToCategory.put(Double.class, 7);
        mapClazzToCategory.put(Double.TYPE, 7);
        mapClazzToCategory.put(Integer.class, 15);
        mapClazzToCategory.put(Integer.TYPE, 15);
        mapClazzToCategory.put(Boolean.TYPE, 5);
        mapClazzToCategory.put(Object.class, 13);
        mapClazzToCategory.put(Date.class, 18);
        mapClazzToCategory.put(Float.TYPE, 7);
        mapClazzToCategory.put(Long.TYPE, 7);
        mapClazzToCategory.put(double[].class, 1);
        mapClazzToCategory.put(Character.TYPE, 9);
        mapClazzToCategory.put(Byte.TYPE, 15);
    }

    public JavaFunDef(String name, String desc, Syntax syntax, int returnCategory, int[] paramCategories, Method method) {
        super(name, null, desc, syntax, returnCategory, paramCategories);
        this.method = method;
    }

    @Override
    public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
        Calc[] calcs = new Calc[this.parameterCategories.length];
        Class<?>[] parameterTypes = this.method.getParameterTypes();
        int i = 0;
        while (i < calcs.length) {
            calcs[i] = JavaFunDef.compileTo(compiler, call.getArgs()[i], parameterTypes[i]);
            ++i;
        }
        return new JavaMethodCalc(call, calcs, this.method);
    }

    private static int getCategory(Class clazz) {
        return mapClazzToCategory.get(clazz);
    }

    private static int getReturnCategory(Method m) {
        return JavaFunDef.getCategory(m.getReturnType());
    }

    private static int[] getParameterCategories(Method m) {
        int[] arr = new int[m.getParameterTypes().length];
        int i = 0;
        while (i < m.getParameterTypes().length) {
            arr[i] = JavaFunDef.getCategory(m.getParameterTypes()[i]);
            ++i;
        }
        return arr;
    }

    private static FunDef generateFunDef(Method method) {
        String name = JavaFunDef.getAnnotation(method, String.valueOf(className) + "$FunctionName", method.getName());
        String desc = JavaFunDef.getAnnotation(method, String.valueOf(className) + "$Description", "");
        Syntax syntax = JavaFunDef.getAnnotation(method, String.valueOf(className) + "$SyntaxDef", Syntax.Function);
        if (name.endsWith("_") && Util.PreJdk15) {
            name = name.substring(0, name.length() - 1);
        }
        int returnCategory = JavaFunDef.getReturnCategory(method);
        int[] paramCategories = JavaFunDef.getParameterCategories(method);
        return new JavaFunDef(name, desc, syntax, returnCategory, paramCategories, method);
    }

    public static List<FunDef> scan(Class clazz) {
        Method[] methods;
        ArrayList<FunDef> list = new ArrayList<FunDef>();
        Method[] methodArray = methods = clazz.getMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (Modifier.isStatic(method.getModifiers()) && !method.getName().equals("main")) {
                list.add(JavaFunDef.generateFunDef(method));
            }
            ++n2;
        }
        return list;
    }

    private static Calc compileTo(ExpCompiler compiler, Exp exp, Class clazz) {
        if (clazz == String.class) {
            return compiler.compileString(exp);
        }
        if (clazz == Date.class) {
            return compiler.compileDateTime(exp);
        }
        if (clazz == Boolean.TYPE) {
            return compiler.compileBoolean(exp);
        }
        if (clazz == Byte.TYPE) {
            final IntegerCalc integerCalc = compiler.compileInteger(exp);
            if (integerCalc.getResultStyle() == ResultStyle.VALUE_NOT_NULL) {
                return new AbstractCalc2(exp, integerCalc){

                    @Override
                    public Object evaluate(Evaluator evaluator) {
                        return (byte)integerCalc.evaluateInteger(evaluator);
                    }
                };
            }
            return new AbstractCalc2(exp, integerCalc){

                @Override
                public Object evaluate(Evaluator evaluator) {
                    Integer i = (Integer)integerCalc.evaluate(evaluator);
                    return i == null ? null : Byte.valueOf((byte)i.intValue());
                }
            };
        }
        if (clazz == Character.TYPE) {
            final StringCalc stringCalc = compiler.compileString(exp);
            return new AbstractCalc2(exp, stringCalc){

                @Override
                public Object evaluate(Evaluator evaluator) {
                    String string = stringCalc.evaluateString(evaluator);
                    return Character.valueOf(string == null || string.length() < 1 ? (char)'\u0000' : string.charAt(0));
                }
            };
        }
        if (clazz == Short.TYPE) {
            final IntegerCalc integerCalc = compiler.compileInteger(exp);
            if (integerCalc.getResultStyle() == ResultStyle.VALUE_NOT_NULL) {
                return new AbstractCalc2(exp, integerCalc){

                    @Override
                    public Object evaluate(Evaluator evaluator) {
                        return (short)integerCalc.evaluateInteger(evaluator);
                    }
                };
            }
            return new AbstractCalc2(exp, integerCalc){

                @Override
                public Object evaluate(Evaluator evaluator) {
                    Integer i = (Integer)integerCalc.evaluate(evaluator);
                    return i == null ? null : Short.valueOf((short)i.intValue());
                }
            };
        }
        if (clazz == Integer.TYPE) {
            return compiler.compileInteger(exp);
        }
        if (clazz == Long.TYPE) {
            final IntegerCalc integerCalc = compiler.compileInteger(exp);
            if (integerCalc.getResultStyle() == ResultStyle.VALUE_NOT_NULL) {
                return new AbstractCalc2(exp, integerCalc){

                    @Override
                    public Object evaluate(Evaluator evaluator) {
                        return (long)integerCalc.evaluateInteger(evaluator);
                    }
                };
            }
            return new AbstractCalc2(exp, integerCalc){

                @Override
                public Object evaluate(Evaluator evaluator) {
                    Integer i = (Integer)integerCalc.evaluate(evaluator);
                    return i == null ? null : Long.valueOf(i.intValue());
                }
            };
        }
        if (clazz == Float.TYPE) {
            final DoubleCalc doubleCalc = compiler.compileDouble(exp);
            if (doubleCalc.getResultStyle() == ResultStyle.VALUE_NOT_NULL) {
                return new AbstractCalc2(exp, doubleCalc){

                    @Override
                    public Object evaluate(Evaluator evaluator) {
                        Double v = (Double)doubleCalc.evaluate(evaluator);
                        return v == null ? null : Float.valueOf(v.floatValue());
                    }
                };
            }
            return new AbstractCalc2(exp, doubleCalc){

                @Override
                public Object evaluate(Evaluator evaluator) {
                    return Float.valueOf((float)doubleCalc.evaluateDouble(evaluator));
                }
            };
        }
        if (clazz == Double.TYPE) {
            return compiler.compileDouble(exp);
        }
        if (clazz == Object.class) {
            return compiler.compileScalar(exp, false);
        }
        throw JavaFunDef.newInternal("expected primitive type, got " + clazz);
    }

    private static abstract class AbstractCalc2
    extends AbstractCalc {
        protected AbstractCalc2(Exp exp, Calc calc) {
            super(exp, new Calc[]{calc});
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface Description {
        public String value();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface FunctionName {
        public String value();
    }

    private static class JavaMethodCalc
    extends GenericCalc {
        private final Method method;
        private final Object[] args;

        public JavaMethodCalc(ResolvedFunCall call, Calc[] calcs, Method method) {
            super(call, calcs);
            this.method = method;
            this.args = new Object[calcs.length];
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public Object evaluate(Evaluator evaluator) {
            block10: {
                calcs = this.getCalcs();
                i = 0;
                while (i < this.args.length) {
                    this.args[i] = calcs[i].evaluate(evaluator);
                    if (this.args[i] == null) {
                        return JavaFunDef.nullValue;
                    }
                    ++i;
                }
                try {
                    return this.method.invoke(null, this.args);
                }
                catch (IllegalAccessException e) {
                    throw JavaFunDef.newEvalException(e);
                }
                catch (InvocationTargetException e) {
                    throw JavaFunDef.newEvalException(e.getCause());
                }
                catch (IllegalArgumentException e) {
                    if (!e.getMessage().equals("argument type mismatch")) break block10;
                    buf = new StringBuilder("argument type mismatch: parameters (");
                    k = 0;
                    var9_9 = this.method.getParameterTypes();
                    var8_10 = var9_9.length;
                    var7_11 = 0;
                    ** while (var7_11 < var8_10)
                }
lbl-1000:
                // 1 sources

                {
                    parameterType = var9_9[var7_11];
                    if (k++ > 0) {
                        buf.append(", ");
                    }
                    buf.append(parameterType.getName());
                    ++var7_11;
                    continue;
                }
lbl31:
                // 1 sources

                buf.append("), actual (");
                k = 0;
                var9_9 = this.args;
                var8_10 = this.args.length;
                var7_11 = 0;
                while (var7_11 < var8_10) {
                    arg = var9_9[var7_11];
                    if (k++ > 0) {
                        buf.append(", ");
                    }
                    buf.append(arg == null ? "null" : arg.getClass().getName());
                    ++var7_11;
                }
                buf.append(")");
                throw JavaFunDef.newInternal(buf.toString());
            }
            throw e;
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface Signature {
        public String value();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface SyntaxDef {
        public Syntax value();
    }
}

