/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import mondrian.calc.Calc;
import mondrian.calc.ExpCompiler;
import mondrian.calc.ListCalc;
import mondrian.calc.TupleList;
import mondrian.calc.impl.AbstractDoubleCalc;
import mondrian.calc.impl.ValueCalc;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Evaluator;
import mondrian.olap.FunDef;
import mondrian.olap.Hierarchy;
import mondrian.olap.fun.AbstractAggregateFunDef;
import mondrian.olap.fun.ReflectiveMultiResolver;

class MedianFunDef
extends AbstractAggregateFunDef {
    static final ReflectiveMultiResolver Resolver = new ReflectiveMultiResolver("Median", "Median(<Set>[, <Numeric Expression>])", "Returns the median value of a numeric expression evaluated over a set.", new String[]{"fnx", "fnxn"}, MedianFunDef.class);

    public MedianFunDef(FunDef dummyFunDef) {
        super(dummyFunDef);
    }

    @Override
    public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
        final ListCalc listCalc = compiler.compileList(call.getArg(0));
        final ValueCalc calc = call.getArgCount() > 1 ? compiler.compileScalar(call.getArg(1), true) : new ValueCalc(call);
        return new AbstractDoubleCalc(call, new Calc[]{listCalc, calc}){

            @Override
            public double evaluateDouble(Evaluator evaluator) {
                int savepoint = evaluator.savepoint();
                try {
                    double percentile;
                    evaluator.setNonEmpty(false);
                    TupleList list = MedianFunDef.evaluateCurrentList(listCalc, evaluator);
                    double d = percentile = MedianFunDef.percentile(evaluator, list, calc, 0.5);
                    return d;
                }
                finally {
                    evaluator.restore(savepoint);
                }
            }

            @Override
            public boolean dependsOn(Hierarchy hierarchy) {
                return 1.anyDependsButFirst(this.getCalcs(), hierarchy);
            }
        };
    }
}

