/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import java.util.List;
import mondrian.olap.Exp;
import mondrian.olap.FunDef;
import mondrian.olap.Syntax;
import mondrian.olap.Util;
import mondrian.olap.Validator;
import mondrian.olap.fun.FunUtil;
import mondrian.olap.fun.Resolver;

public abstract class MultiResolver
extends FunUtil
implements Resolver {
    private final String name;
    private final String signature;
    private final String description;
    private final String[] signatures;
    private final Syntax syntax;

    protected MultiResolver(String name, String signature, String description, String[] signatures) {
        this.name = name;
        this.signature = signature;
        this.description = description;
        this.signatures = signatures;
        Util.assertTrue(signatures.length > 0);
        this.syntax = MultiResolver.decodeSyntacticType(signatures[0]);
        int i = 1;
        while (i < signatures.length) {
            Util.assertTrue(MultiResolver.decodeSyntacticType(signatures[i]) == this.syntax);
            ++i;
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getSignature() {
        return this.signature;
    }

    @Override
    public Syntax getSyntax() {
        return this.syntax;
    }

    @Override
    public String[] getReservedWords() {
        return emptyStringArray;
    }

    public String[] getSignatures() {
        return this.signatures;
    }

    @Override
    public FunDef getFunDef() {
        return null;
    }

    @Override
    public FunDef resolve(Exp[] args, Validator validator, List<Resolver.Conversion> conversions) {
        String[] stringArray = this.signatures;
        int n = this.signatures.length;
        int n2 = 0;
        while (n2 < n) {
            block4: {
                String signature = stringArray[n2];
                int[] parameterTypes = MultiResolver.decodeParameterCategories(signature);
                if (parameterTypes.length == args.length) {
                    conversions.clear();
                    int i = 0;
                    while (i < args.length) {
                        if (validator.canConvert(i, args[i], parameterTypes[i], conversions)) {
                            ++i;
                            continue;
                        }
                        break block4;
                    }
                    int returnType = MultiResolver.decodeReturnCategory(signature);
                    FunDef dummy = MultiResolver.createDummyFunDef(this, returnType, args);
                    return this.createFunDef(args, dummy);
                }
            }
            ++n2;
        }
        return null;
    }

    @Override
    public boolean requiresExpression(int k) {
        String[] stringArray = this.signatures;
        int n = this.signatures.length;
        int n2 = 0;
        while (n2 < n) {
            String signature = stringArray[n2];
            int[] parameterTypes = MultiResolver.decodeParameterCategories(signature);
            if (k < parameterTypes.length && parameterTypes[k] == 8) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    protected abstract FunDef createFunDef(Exp[] var1, FunDef var2);
}

