/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import mondrian.calc.Calc;
import mondrian.calc.ExpCompiler;
import mondrian.calc.IterCalc;
import mondrian.calc.ListCalc;
import mondrian.calc.MemberCalc;
import mondrian.calc.ResultStyle;
import mondrian.calc.TupleCalc;
import mondrian.calc.TupleCollections;
import mondrian.calc.TupleCursor;
import mondrian.calc.TupleIterable;
import mondrian.calc.TupleList;
import mondrian.calc.VoidCalc;
import mondrian.calc.impl.AbstractIterCalc;
import mondrian.calc.impl.AbstractListCalc;
import mondrian.calc.impl.AbstractTupleCursor;
import mondrian.calc.impl.AbstractTupleIterable;
import mondrian.calc.impl.AbstractVoidCalc;
import mondrian.calc.impl.ListTupleList;
import mondrian.calc.impl.UnaryTupleList;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.ExpBase;
import mondrian.olap.FunDef;
import mondrian.olap.Member;
import mondrian.olap.ResultStyleException;
import mondrian.olap.Syntax;
import mondrian.olap.Validator;
import mondrian.olap.fun.FunDefBase;
import mondrian.olap.fun.Resolver;
import mondrian.olap.fun.ResolverBase;
import mondrian.olap.type.MemberType;
import mondrian.olap.type.SetType;
import mondrian.olap.type.Type;
import mondrian.olap.type.TypeUtil;
import mondrian.resource.MondrianResource;

public class SetFunDef
extends FunDefBase {
    static final ResolverImpl Resolver = new ResolverImpl();

    SetFunDef(Resolver resolver, int[] argTypes) {
        super(resolver, 8, argTypes);
    }

    @Override
    public void unparse(Exp[] args, PrintWriter pw) {
        ExpBase.unparseList(pw, args, "{", ", ", "}");
    }

    @Override
    public Type getResultType(Validator validator, Exp[] args) {
        Type type0 = null;
        if (args.length == 0) {
            type0 = MemberType.Unknown;
        } else {
            int i = 0;
            while (i < args.length) {
                Exp arg = args[i];
                Type type = arg.getType();
                type = TypeUtil.toMemberOrTupleType(type);
                if (i == 0) {
                    type0 = type;
                } else if (!TypeUtil.isUnionCompatible(type0, type)) {
                    throw MondrianResource.instance().ArgsMustHaveSameHierarchy.ex(this.getName());
                }
                ++i;
            }
        }
        return new SetType(type0);
    }

    @Override
    public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
        Exp[] args = call.getArgs();
        if (args.length == 0) {
            return new EmptyListCalc(call);
        }
        if (args.length == 1 && args[0].getType() instanceof SetType) {
            return args[0].accept(compiler);
        }
        return new SetListCalc(call, args, compiler, ResultStyle.LIST_MUTABLELIST);
    }

    private static List<Calc> compileSelf(Exp[] args, ExpCompiler compiler, List<ResultStyle> resultStyles) {
        ArrayList<Calc> calcs = new ArrayList<Calc>(args.length);
        Exp[] expArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            Exp arg = expArray[n2];
            calcs.add(SetFunDef.createCalc(arg, compiler, resultStyles));
            ++n2;
        }
        return calcs;
    }

    private static IterCalc createCalc(Exp arg, ExpCompiler compiler, List<ResultStyle> resultStyles) {
        Type type = arg.getType();
        if (type instanceof SetType) {
            Calc calc = compiler.compileAs(arg, null, resultStyles);
            switch (calc.getResultStyle()) {
                case ITERABLE: {
                    final IterCalc iterCalc = (IterCalc)calc;
                    return new AbstractIterCalc(arg, new Calc[]{calc}){

                        @Override
                        public TupleIterable evaluateIterable(Evaluator evaluator) {
                            return iterCalc.evaluateIterable(evaluator);
                        }

                        @Override
                        protected String getName() {
                            return "Sublist";
                        }
                    };
                }
                case MUTABLE_LIST: 
                case LIST: {
                    final ListCalc listCalc = (ListCalc)calc;
                    return new AbstractIterCalc(arg, new Calc[]{calc}){

                        @Override
                        public TupleIterable evaluateIterable(Evaluator evaluator) {
                            TupleList list = listCalc.evaluateList(evaluator);
                            TupleList result = list.cloneList(list.size());
                            block0: for (List members : list) {
                                for (Member member : members) {
                                    if (member == null || member.isNull()) continue block0;
                                }
                                result.add(members);
                            }
                            return result;
                        }

                        @Override
                        protected String getName() {
                            return "Sublist";
                        }
                    };
                }
            }
            throw ResultStyleException.generateBadType(ResultStyle.ITERABLE_LIST_MUTABLELIST, calc.getResultStyle());
        }
        if (TypeUtil.couldBeMember(type)) {
            final MemberCalc memberCalc = compiler.compileMember(arg);
            ResolvedFunCall call = SetFunDef.wrapAsSet(arg);
            return new AbstractIterCalc(call, new Calc[]{memberCalc}){

                @Override
                public TupleIterable evaluateIterable(Evaluator evaluator) {
                    Member member = memberCalc.evaluateMember(evaluator);
                    return member == null ? TupleCollections.createList(1) : new UnaryTupleList(Collections.singletonList(member));
                }

                @Override
                protected String getName() {
                    return "Sublist";
                }
            };
        }
        final TupleCalc tupleCalc = compiler.compileTuple(arg);
        ResolvedFunCall call = SetFunDef.wrapAsSet(arg);
        return new AbstractIterCalc(call, new Calc[]{tupleCalc}){

            @Override
            public TupleIterable evaluateIterable(Evaluator evaluator) {
                Member[] members = tupleCalc.evaluateTuple(evaluator);
                return new ListTupleList(tupleCalc.getType().getArity(), Arrays.asList(members));
            }

            @Override
            protected String getName() {
                return "Sublist";
            }
        };
    }

    public static ResolvedFunCall wrapAsSet(Exp ... args) {
        assert (args.length > 0);
        int[] categories = new int[args.length];
        Type type = null;
        int i = 0;
        while (i < args.length) {
            Exp arg = args[i];
            categories[i] = arg.getCategory();
            Type argType = arg.getType();
            type = argType instanceof SetType ? ((SetType)argType).getElementType() : argType;
            ++i;
        }
        return new ResolvedFunCall(new SetFunDef(Resolver, categories), args, new SetType(type));
    }

    private static class EmptyListCalc
    extends AbstractListCalc {
        private final TupleList list;

        EmptyListCalc(ResolvedFunCall call) {
            super(call, new Calc[0]);
            this.list = TupleCollections.emptyList(call.getType().getArity());
        }

        @Override
        public TupleList evaluateList(Evaluator evaluator) {
            return this.list;
        }
    }

    public static class ExprIterCalc
    extends AbstractIterCalc {
        private final IterCalc[] iterCalcs;

        public ExprIterCalc(Exp exp, Exp[] args, ExpCompiler compiler, List<ResultStyle> resultStyles) {
            super(exp, null);
            List calcList = SetFunDef.compileSelf(args, compiler, resultStyles);
            this.iterCalcs = calcList.toArray(new IterCalc[calcList.size()]);
        }

        public IterCalc[] getCalcs() {
            return this.iterCalcs;
        }

        @Override
        public TupleIterable evaluateIterable(final Evaluator evaluator) {
            return new AbstractTupleIterable(this.getType().getArity()){

                @Override
                public TupleCursor tupleCursor() {
                    return new AbstractTupleCursor(this.arity){
                        Iterator<IterCalc> calcIterator;
                        TupleCursor currentCursor;
                        {
                            super($anonymous0);
                            this.calcIterator = Arrays.asList(ExprIterCalc.this.iterCalcs).iterator();
                            this.currentCursor = TupleCollections.emptyList(1).tupleCursor();
                        }

                        @Override
                        public boolean forward() {
                            while (!this.currentCursor.forward()) {
                                if (!this.calcIterator.hasNext()) {
                                    return false;
                                }
                                this.currentCursor = this.calcIterator.next().evaluateIterable(evaluator).tupleCursor();
                            }
                            return true;
                        }

                        @Override
                        public List<Member> current() {
                            return this.currentCursor.current();
                        }

                        @Override
                        public void setContext(Evaluator evaluator2) {
                            this.currentCursor.setContext(evaluator2);
                        }

                        @Override
                        public void currentToArray(Member[] members, int offset) {
                            this.currentCursor.currentToArray(members, offset);
                        }

                        @Override
                        public Member member(int column) {
                            return this.currentCursor.member(column);
                        }
                    };
                }
            };
        }
    }

    private static class ResolverImpl
    extends ResolverBase {
        public ResolverImpl() {
            super("{}", "{<Member> [, <Member>...]}", "Brace operator constructs a set.", Syntax.Braces);
        }

        @Override
        public FunDef resolve(Exp[] args, Validator validator, List<Resolver.Conversion> conversions) {
            int[] parameterTypes = new int[args.length];
            int i = 0;
            while (i < args.length) {
                if (validator.canConvert(i, args[i], 6, conversions)) {
                    parameterTypes[i] = 6;
                } else if (validator.canConvert(i, args[i], 10, conversions)) {
                    parameterTypes[i] = 10;
                } else if (validator.canConvert(i, args[i], 8, conversions)) {
                    parameterTypes[i] = 8;
                } else {
                    return null;
                }
                ++i;
            }
            return new SetFunDef(this, parameterTypes);
        }
    }

    public static class SetListCalc
    extends AbstractListCalc {
        private TupleList result;
        private final VoidCalc[] voidCalcs;

        public SetListCalc(Exp exp, Exp[] args, ExpCompiler compiler, List<ResultStyle> resultStyles) {
            super(exp, null);
            this.voidCalcs = this.compileSelf(args, compiler, resultStyles);
            this.result = TupleCollections.createList(this.getType().getArity());
        }

        @Override
        public Calc[] getCalcs() {
            return this.voidCalcs;
        }

        private VoidCalc[] compileSelf(Exp[] args, ExpCompiler compiler, List<ResultStyle> resultStyles) {
            VoidCalc[] voidCalcs = new VoidCalc[args.length];
            int i = 0;
            while (i < args.length) {
                voidCalcs[i] = this.createCalc(args[i], compiler, resultStyles);
                ++i;
            }
            return voidCalcs;
        }

        private VoidCalc createCalc(Exp arg, ExpCompiler compiler, List<ResultStyle> resultStyles) {
            Type type = arg.getType();
            if (type instanceof SetType) {
                final ListCalc listCalc = compiler.compileList(arg);
                return new AbstractVoidCalc(arg, new Calc[]{listCalc}){

                    @Override
                    public void evaluateVoid(Evaluator evaluator) {
                        TupleList list = listCalc.evaluateList(evaluator);
                        block0: for (List members : list) {
                            for (Member member : members) {
                                if (member == null || member.isNull()) continue block0;
                            }
                            SetListCalc.this.result.add(members);
                        }
                    }

                    @Override
                    protected String getName() {
                        return "Sublist";
                    }
                };
            }
            if (type.getArity() == 1) {
                final MemberCalc memberCalc = compiler.compileMember(arg);
                return new AbstractVoidCalc(arg, new Calc[]{memberCalc}){
                    final Member[] members;
                    {
                        super($anonymous0, $anonymous1);
                        this.members = new Member[1];
                    }

                    @Override
                    public void evaluateVoid(Evaluator evaluator) {
                        Member member = memberCalc.evaluateMember(evaluator);
                        if (member == null || member.isNull()) {
                            return;
                        }
                        this.members[0] = member;
                        SetListCalc.this.result.addTuple(this.members);
                    }
                };
            }
            final TupleCalc tupleCalc = compiler.compileTuple(arg);
            return new AbstractVoidCalc(arg, new Calc[]{tupleCalc}){

                @Override
                public void evaluateVoid(Evaluator evaluator) {
                    Member[] members = tupleCalc.evaluateTuple(evaluator);
                    if (members == null || SetFunDef.tupleContainsNullMember(members)) {
                        return;
                    }
                    SetListCalc.this.result.addTuple(members);
                }
            };
        }

        @Override
        public TupleList evaluateList(Evaluator evaluator) {
            this.result.clear();
            VoidCalc[] voidCalcArray = this.voidCalcs;
            int n = this.voidCalcs.length;
            int n2 = 0;
            while (n2 < n) {
                VoidCalc voidCalc = voidCalcArray[n2];
                voidCalc.evaluateVoid(evaluator);
                ++n2;
            }
            return this.result.cloneList(-1);
        }
    }
}

