/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import java.util.ArrayList;
import java.util.List;
import mondrian.calc.Calc;
import mondrian.calc.ExpCompiler;
import mondrian.calc.IntegerCalc;
import mondrian.calc.ListCalc;
import mondrian.calc.StringCalc;
import mondrian.calc.TupleList;
import mondrian.calc.impl.AbstractMemberCalc;
import mondrian.calc.impl.AbstractTupleCalc;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.FunDef;
import mondrian.olap.Member;
import mondrian.olap.Syntax;
import mondrian.olap.Util;
import mondrian.olap.Validator;
import mondrian.olap.fun.FunDefBase;
import mondrian.olap.fun.ReflectiveMultiResolver;
import mondrian.olap.fun.Resolver;
import mondrian.olap.fun.ResolverBase;
import mondrian.olap.type.MemberType;
import mondrian.olap.type.SetType;
import mondrian.olap.type.StringType;
import mondrian.olap.type.TupleType;
import mondrian.olap.type.Type;

class SetItemFunDef
extends FunDefBase {
    static final Resolver intResolver = new ReflectiveMultiResolver("Item", "<Set>.Item(<Index>)", "Returns a tuple from the set specified in <Set>. The tuple to be returned is specified by the zero-based position of the tuple in the set in <Index>.", new String[]{"mmxn"}, SetItemFunDef.class);
    static final Resolver stringResolver = new ResolverBase("Item", "<Set>.Item(<String> [, ...])", "Returns a tuple from the set specified in <Set>. The tuple to be returned is specified by the member name (or names) in <String>.", Syntax.Method){

        @Override
        public FunDef resolve(Exp[] args, Validator validator, List<Resolver.Conversion> conversions) {
            if (args.length < 1) {
                return null;
            }
            Exp setExp = args[0];
            if (!(setExp.getType() instanceof SetType)) {
                return null;
            }
            SetType setType = (SetType)setExp.getType();
            int arity = setType.getArity();
            int i = 1;
            while (i < args.length) {
                if (!validator.canConvert(i, args[i], 9, conversions)) {
                    return null;
                }
                ++i;
            }
            if (args.length - 1 != arity) {
                throw Util.newError("Argument count does not match set's cardinality " + arity);
            }
            int category = arity == 1 ? 6 : 10;
            FunDef dummy = 1.createDummyFunDef(this, category, args);
            return new SetItemFunDef(dummy);
        }
    };

    public SetItemFunDef(FunDef dummyFunDef) {
        super(dummyFunDef);
    }

    @Override
    public Type getResultType(Validator validator, Exp[] args) {
        SetType setType = (SetType)args[0].getType();
        return setType.getElementType();
    }

    @Override
    public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
        StringCalc[] stringCalcs;
        IntegerCalc indexCalc;
        final ListCalc listCalc = compiler.compileList(call.getArg(0));
        Type elementType = ((SetType)listCalc.getType()).getElementType();
        boolean isString = call.getArgCount() < 2 || call.getArg(1).getType() instanceof StringType;
        ArrayList<Calc> calcList = new ArrayList<Calc>();
        calcList.add(listCalc);
        if (isString) {
            indexCalc = null;
            stringCalcs = new StringCalc[call.getArgCount() - 1];
            int i = 0;
            while (i < stringCalcs.length) {
                stringCalcs[i] = compiler.compileString(call.getArg(i + 1));
                calcList.add(stringCalcs[i]);
                ++i;
            }
        } else {
            stringCalcs = null;
            indexCalc = compiler.compileInteger(call.getArg(1));
            calcList.add(indexCalc);
        }
        Calc[] calcs = calcList.toArray(new Calc[calcList.size()]);
        if (elementType instanceof TupleType) {
            TupleType tupleType = (TupleType)elementType;
            final Member[] nullTuple = SetItemFunDef.makeNullTuple(tupleType);
            if (isString) {
                return new AbstractTupleCalc(call, calcs){

                    @Override
                    public Member[] evaluateTuple(Evaluator evaluator) {
                        TupleList list;
                        int savepoint = evaluator.savepoint();
                        try {
                            evaluator.setNonEmpty(false);
                            list = listCalc.evaluateList(evaluator);
                            if (!$assertionsDisabled && list == null) {
                                throw new AssertionError();
                            }
                        }
                        finally {
                            evaluator.restore(savepoint);
                        }
                        try {
                            String[] results = new String[stringCalcs.length];
                            int i = 0;
                            while (i < stringCalcs.length) {
                                results[i] = stringCalcs[i].evaluateString(evaluator);
                                ++i;
                            }
                            block8: for (List members : list) {
                                int j = 0;
                                while (j < results.length) {
                                    String result = results[j];
                                    Member member = (Member)members.get(j);
                                    if (!SetItemFunDef.matchMember(member, result)) continue block8;
                                    ++j;
                                }
                                Member[] memberArray = members.toArray(new Member[members.size()]);
                                return memberArray;
                            }
                        }
                        finally {
                            evaluator.restore(savepoint);
                        }
                        return null;
                    }
                };
            }
            return new AbstractTupleCalc(call, calcs){

                @Override
                public Member[] evaluateTuple(Evaluator evaluator) {
                    TupleList list;
                    int savepoint = evaluator.savepoint();
                    try {
                        evaluator.setNonEmpty(false);
                        list = listCalc.evaluateList(evaluator);
                    }
                    finally {
                        evaluator.restore(savepoint);
                    }
                    if (!$assertionsDisabled && list == null) {
                        throw new AssertionError();
                    }
                    try {
                        int index = indexCalc.evaluateInteger(evaluator);
                        int listSize = list.size();
                        if (index >= listSize || index < 0) {
                            Member[] memberArray = nullTuple;
                            return memberArray;
                        }
                        List members = (List)list.get(index);
                        Member[] memberArray = members.toArray(new Member[members.size()]);
                        return memberArray;
                    }
                    finally {
                        evaluator.restore(savepoint);
                    }
                }
            };
        }
        MemberType memberType = (MemberType)elementType;
        final Member nullMember = SetItemFunDef.makeNullMember(memberType);
        if (isString) {
            return new AbstractMemberCalc(call, calcs){

                @Override
                public Member evaluateMember(Evaluator evaluator) {
                    List<Member> list;
                    int savepoint = evaluator.savepoint();
                    try {
                        evaluator.setNonEmpty(false);
                        list = listCalc.evaluateList(evaluator).slice(0);
                        if (!$assertionsDisabled && list == null) {
                            throw new AssertionError();
                        }
                    }
                    finally {
                        evaluator.restore(savepoint);
                    }
                    try {
                        String result = stringCalcs[0].evaluateString(evaluator);
                        for (Member member : list) {
                            if (!SetItemFunDef.matchMember(member, result)) continue;
                            Member member2 = member;
                            return member2;
                        }
                        Member member = nullMember;
                        return member;
                    }
                    finally {
                        evaluator.restore(savepoint);
                    }
                }
            };
        }
        return new AbstractMemberCalc(call, calcs){

            @Override
            public Member evaluateMember(Evaluator evaluator) {
                List<Member> list;
                int savepoint = evaluator.savepoint();
                try {
                    evaluator.setNonEmpty(false);
                    list = listCalc.evaluateList(evaluator).slice(0);
                    if (!$assertionsDisabled && list == null) {
                        throw new AssertionError();
                    }
                }
                finally {
                    evaluator.restore(savepoint);
                }
                try {
                    int index = indexCalc.evaluateInteger(evaluator);
                    int listSize = list.size();
                    if (index >= listSize || index < 0) {
                        Member member = nullMember;
                        return member;
                    }
                    Member member = list.get(index);
                    return member;
                }
                finally {
                    evaluator.restore(savepoint);
                }
            }
        };
    }

    private static boolean matchMember(Member member, String name) {
        return member.getName().equals(name);
    }
}

