/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import mondrian.calc.Calc;
import mondrian.calc.ExpCompiler;
import mondrian.calc.ListCalc;
import mondrian.calc.TupleList;
import mondrian.calc.impl.AbstractDoubleCalc;
import mondrian.calc.impl.ValueCalc;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Evaluator;
import mondrian.olap.FunDef;
import mondrian.olap.Hierarchy;
import mondrian.olap.fun.AbstractAggregateFunDef;
import mondrian.olap.fun.ReflectiveMultiResolver;
import mondrian.olap.fun.Resolver;

class StdevPFunDef
extends AbstractAggregateFunDef {
    static final Resolver StdevpResolver = new ReflectiveMultiResolver("StdevP", "StdevP(<Set>[, <Numeric Expression>])", "Returns the standard deviation of a numeric expression evaluated over a set (biased).", new String[]{"fnx", "fnxn"}, StdevPFunDef.class);
    static final Resolver StddevpResolver = new ReflectiveMultiResolver("StddevP", "StddevP(<Set>[, <Numeric Expression>])", "Alias for StdevP.", new String[]{"fnx", "fnxn"}, StdevPFunDef.class);

    public StdevPFunDef(FunDef dummyFunDef) {
        super(dummyFunDef);
    }

    @Override
    public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
        final ListCalc listCalc = compiler.compileList(call.getArg(0));
        final ValueCalc calc = call.getArgCount() > 1 ? compiler.compileScalar(call.getArg(1), true) : new ValueCalc(call);
        return new AbstractDoubleCalc(call, new Calc[]{listCalc, calc}){

            @Override
            public double evaluateDouble(Evaluator evaluator) {
                int savepoint = evaluator.savepoint();
                try {
                    double stdev;
                    evaluator.setNonEmpty(false);
                    TupleList list = StdevPFunDef.evaluateCurrentList(listCalc, evaluator);
                    double d = stdev = ((Double)StdevPFunDef.stdev(evaluator, list, calc, true)).doubleValue();
                    return d;
                }
                finally {
                    evaluator.restore(savepoint);
                }
            }

            @Override
            public boolean dependsOn(Hierarchy hierarchy) {
                return 1.anyDependsButFirst(this.getCalcs(), hierarchy);
            }
        };
    }
}

