/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import java.util.ArrayList;
import java.util.List;
import mondrian.calc.Calc;
import mondrian.calc.ExpCompiler;
import mondrian.calc.StringCalc;
import mondrian.calc.impl.AbstractMemberCalc;
import mondrian.calc.impl.AbstractTupleCalc;
import mondrian.mdx.DimensionExpr;
import mondrian.mdx.HierarchyExpr;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Dimension;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.FunDef;
import mondrian.olap.Hierarchy;
import mondrian.olap.Member;
import mondrian.olap.Syntax;
import mondrian.olap.Validator;
import mondrian.olap.fun.FunDefBase;
import mondrian.olap.fun.Resolver;
import mondrian.olap.fun.ResolverBase;
import mondrian.olap.type.MemberType;
import mondrian.olap.type.NullType;
import mondrian.olap.type.StringType;
import mondrian.olap.type.TupleType;
import mondrian.olap.type.Type;
import mondrian.olap.type.TypeUtil;
import mondrian.resource.MondrianResource;

class StrToTupleFunDef
extends FunDefBase {
    static final ResolverImpl Resolver = new ResolverImpl();

    private StrToTupleFunDef(int[] parameterTypes) {
        super("StrToTuple", null, "Constructs a tuple from a string.", Syntax.Function, 10, parameterTypes);
    }

    @Override
    public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
        final StringCalc stringCalc = compiler.compileString(call.getArg(0));
        Type elementType = call.getType();
        if (elementType instanceof MemberType) {
            final Hierarchy hierarchy = elementType.getHierarchy();
            return new AbstractMemberCalc(call, new Calc[]{stringCalc}){

                @Override
                public Member evaluateMember(Evaluator evaluator) {
                    String string = stringCalc.evaluateString(evaluator);
                    if (string == null) {
                        throw StrToTupleFunDef.newEvalException(MondrianResource.instance().NullValue.ex());
                    }
                    return StrToTupleFunDef.parseMember(evaluator, string, hierarchy);
                }
            };
        }
        TupleType tupleType = (TupleType)elementType;
        final List<Hierarchy> hierarchies = tupleType.getHierarchies();
        return new AbstractTupleCalc(call, new Calc[]{stringCalc}){

            @Override
            public Member[] evaluateTuple(Evaluator evaluator) {
                String string = stringCalc.evaluateString(evaluator);
                if (string == null) {
                    throw StrToTupleFunDef.newEvalException(MondrianResource.instance().NullValue.ex());
                }
                return StrToTupleFunDef.parseTuple(evaluator, string, hierarchies);
            }
        };
    }

    @Override
    public Exp createCall(Validator validator, Exp[] args) {
        int argCount = args.length;
        if (argCount <= 1) {
            throw MondrianResource.instance().MdxFuncArgumentsNum.ex(this.getName());
        }
        int i = 1;
        while (i < argCount) {
            Exp arg = args[i];
            if (arg instanceof DimensionExpr) {
                DimensionExpr dimensionExpr = (DimensionExpr)arg;
                Dimension dimension = dimensionExpr.getDimension();
                args[i] = new HierarchyExpr(dimension.getHierarchy());
            } else if (!(arg instanceof HierarchyExpr)) {
                throw MondrianResource.instance().MdxFuncNotHier.ex(i + 1, this.getName());
            }
            ++i;
        }
        return super.createCall(validator, args);
    }

    @Override
    public Type getResultType(Validator validator, Exp[] args) {
        switch (args.length) {
            case 1: {
                return new TupleType(null);
            }
            case 2: {
                Type argType = args[1].getType();
                return new MemberType(argType.getDimension(), argType.getHierarchy(), argType.getLevel(), null);
            }
        }
        ArrayList<MemberType> list = new ArrayList<MemberType>();
        int i = 1;
        while (i < args.length) {
            Exp arg = args[i];
            Type type = arg.getType();
            list.add(TypeUtil.toMemberType(type));
            ++i;
        }
        Type[] types = list.toArray(new MemberType[list.size()]);
        TupleType.checkHierarchies((MemberType[])types);
        return new TupleType(types);
    }

    /* synthetic */ StrToTupleFunDef(int[] nArray, StrToTupleFunDef strToTupleFunDef) {
        this(nArray);
    }

    private static class ResolverImpl
    extends ResolverBase {
        ResolverImpl() {
            super("StrToTuple", "StrToTuple(<String Expression>)", "Constructs a tuple from a string.", Syntax.Function);
        }

        @Override
        public FunDef resolve(Exp[] args, Validator validator, List<Resolver.Conversion> conversions) {
            if (args.length < 1) {
                return null;
            }
            Type type = args[0].getType();
            if (!(type instanceof StringType) && !(type instanceof NullType)) {
                return null;
            }
            int i = 1;
            while (i < args.length) {
                Exp exp = args[i];
                if (!(exp instanceof DimensionExpr) && !(exp instanceof HierarchyExpr)) {
                    return null;
                }
                ++i;
            }
            int[] argTypes = new int[args.length];
            argTypes[0] = 9;
            int i2 = 1;
            while (i2 < argTypes.length) {
                argTypes[i2] = 3;
                ++i2;
            }
            return new StrToTupleFunDef(argTypes, null);
        }

        @Override
        public FunDef getFunDef() {
            return new StrToTupleFunDef(new int[]{9}, null);
        }
    }
}

