/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import mondrian.calc.Calc;
import mondrian.calc.ExpCompiler;
import mondrian.calc.IntegerCalc;
import mondrian.calc.ListCalc;
import mondrian.calc.TupleCollections;
import mondrian.calc.TupleList;
import mondrian.calc.impl.AbstractListCalc;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Evaluator;
import mondrian.olap.FunDef;
import mondrian.olap.fun.FunDefBase;
import mondrian.olap.fun.ReflectiveMultiResolver;

class SubsetFunDef
extends FunDefBase {
    static final ReflectiveMultiResolver Resolver = new ReflectiveMultiResolver("Subset", "Subset(<Set>, <Start>[, <Count>])", "Returns a subset of elements from a set.", new String[]{"fxxn", "fxxnn"}, SubsetFunDef.class);

    public SubsetFunDef(FunDef dummyFunDef) {
        super(dummyFunDef);
    }

    @Override
    public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
        final ListCalc listCalc = compiler.compileList(call.getArg(0));
        final IntegerCalc startCalc = compiler.compileInteger(call.getArg(1));
        final IntegerCalc countCalc = call.getArgCount() > 2 ? compiler.compileInteger(call.getArg(2)) : null;
        return new AbstractListCalc(call, new Calc[]{listCalc, startCalc, countCalc}){

            @Override
            public TupleList evaluateList(Evaluator evaluator) {
                int savepoint = evaluator.savepoint();
                try {
                    int end;
                    evaluator.setNonEmpty(false);
                    TupleList list = listCalc.evaluateList(evaluator);
                    int start = startCalc.evaluateInteger(evaluator);
                    if (countCalc != null) {
                        int count = countCalc.evaluateInteger(evaluator);
                        end = start + count;
                    } else {
                        end = list.size();
                    }
                    if (end > list.size()) {
                        end = list.size();
                    }
                    if (start >= end || start < 0) {
                        TupleList tupleList = TupleCollections.emptyList(list.getArity());
                        return tupleList;
                    }
                    if (start == 0 && end == list.size()) {
                        TupleList tupleList = list;
                        return tupleList;
                    }
                    if (!$assertionsDisabled && start < 0) {
                        throw new AssertionError();
                    }
                    if (!$assertionsDisabled && start >= end) {
                        throw new AssertionError();
                    }
                    if (!$assertionsDisabled && end > list.size()) {
                        throw new AssertionError();
                    }
                    TupleList tupleList = list.subList(start, end);
                    return tupleList;
                }
                finally {
                    evaluator.restore(savepoint);
                }
            }
        };
    }
}

