/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import java.util.List;
import java.util.Map;
import mondrian.calc.Calc;
import mondrian.calc.DoubleCalc;
import mondrian.calc.ExpCompiler;
import mondrian.calc.ListCalc;
import mondrian.calc.ResultStyle;
import mondrian.calc.TupleList;
import mondrian.calc.impl.AbstractListCalc;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.FunDef;
import mondrian.olap.Hierarchy;
import mondrian.olap.Member;
import mondrian.olap.Util;
import mondrian.olap.fun.FunDefBase;
import mondrian.olap.fun.MultiResolver;

class TopBottomPercentSumFunDef
extends FunDefBase {
    final boolean top;
    final boolean percent;
    static final ResolverImpl TopPercentResolver = new ResolverImpl("TopPercent", "TopPercent(<Set>, <Percentage>, <Numeric Expression>)", "Sorts a set and returns the top N elements whose cumulative total is at least a specified percentage.", new String[]{"fxxnn"}, true, true);
    static final ResolverImpl BottomPercentResolver = new ResolverImpl("BottomPercent", "BottomPercent(<Set>, <Percentage>, <Numeric Expression>)", "Sorts a set and returns the bottom N elements whose cumulative total is at least a specified percentage.", new String[]{"fxxnn"}, false, true);
    static final ResolverImpl TopSumResolver = new ResolverImpl("TopSum", "TopSum(<Set>, <Value>, <Numeric Expression>)", "Sorts a set and returns the top N elements whose cumulative total is at least a specified value.", new String[]{"fxxnn"}, true, false);
    static final ResolverImpl BottomSumResolver = new ResolverImpl("BottomSum", "BottomSum(<Set>, <Value>, <Numeric Expression>)", "Sorts a set and returns the bottom N elements whose cumulative total is at least a specified value.", new String[]{"fxxnn"}, false, false);

    public TopBottomPercentSumFunDef(FunDef dummyFunDef, boolean top, boolean percent) {
        super(dummyFunDef);
        this.top = top;
        this.percent = percent;
    }

    @Override
    public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
        ListCalc listCalc = (ListCalc)compiler.compileAs(call.getArg(0), null, ResultStyle.MUTABLELIST_ONLY);
        DoubleCalc doubleCalc = compiler.compileDouble(call.getArg(1));
        Calc calc = compiler.compileScalar(call.getArg(2), true);
        return new CalcImpl(call, listCalc, doubleCalc, calc);
    }

    private class CalcImpl
    extends AbstractListCalc {
        private final ListCalc listCalc;
        private final DoubleCalc doubleCalc;
        private final Calc calc;

        public CalcImpl(ResolvedFunCall call, ListCalc listCalc, DoubleCalc doubleCalc, Calc calc) {
            super(call, new Calc[]{listCalc, doubleCalc, calc});
            this.listCalc = listCalc;
            this.doubleCalc = doubleCalc;
            this.calc = calc;
        }

        @Override
        public TupleList evaluateList(Evaluator evaluator) {
            TupleList list = this.listCalc.evaluateList(evaluator);
            double target = this.doubleCalc.evaluateDouble(evaluator);
            if (list.isEmpty()) {
                return list;
            }
            Map<List<Member>, Object> mapMemberToValue = TopBottomPercentSumFunDef.evaluateTuples(evaluator, this.calc, list);
            int savepoint = evaluator.savepoint();
            try {
                evaluator.setNonEmpty(false);
                list = TopBottomPercentSumFunDef.sortTuples(evaluator, list, list, this.calc, TopBottomPercentSumFunDef.this.top, true, this.getType().getArity());
            }
            finally {
                evaluator.restore(savepoint);
            }
            if (TopBottomPercentSumFunDef.this.percent) {
                TopBottomPercentSumFunDef.toPercent(list, mapMemberToValue);
            }
            double runningTotal = 0.0;
            int memberCount = list.size();
            int nullCount = 0;
            int i = 0;
            while (i < memberCount) {
                if (runningTotal >= target) {
                    list = list.subList(0, i);
                    break;
                }
                List key = (List)list.get(i);
                Object o = mapMemberToValue.get(key);
                if (o == Util.nullValue) {
                    ++nullCount;
                } else if (o instanceof Number) {
                    runningTotal += ((Number)o).doubleValue();
                } else if (!(o instanceof Exception)) {
                    throw Util.newInternal("got " + o + " when expecting Number");
                }
                ++i;
            }
            if (memberCount > 0 && TopBottomPercentSumFunDef.this.percent && nullCount == memberCount) {
                return TopBottomPercentSumFunDef.this.top ? list.subList(0, 1) : list.subList(memberCount - 1, memberCount);
            }
            return list;
        }

        @Override
        public boolean dependsOn(Hierarchy hierarchy) {
            return CalcImpl.anyDependsButFirst(this.getCalcs(), hierarchy);
        }
    }

    private static class ResolverImpl
    extends MultiResolver {
        private final boolean top;
        private final boolean percent;

        public ResolverImpl(String name, String signature, String description, String[] signatures, boolean top, boolean percent) {
            super(name, signature, description, signatures);
            this.top = top;
            this.percent = percent;
        }

        @Override
        protected FunDef createFunDef(Exp[] args, FunDef dummyFunDef) {
            return new TopBottomPercentSumFunDef(dummyFunDef, this.top, this.percent);
        }
    }
}

