/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import java.io.PrintWriter;
import java.util.List;
import mondrian.calc.Calc;
import mondrian.calc.ExpCompiler;
import mondrian.calc.MemberCalc;
import mondrian.calc.impl.AbstractTupleCalc;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.ExpBase;
import mondrian.olap.FunDef;
import mondrian.olap.Member;
import mondrian.olap.Syntax;
import mondrian.olap.Validator;
import mondrian.olap.fun.FunDefBase;
import mondrian.olap.fun.ParenthesesFunDef;
import mondrian.olap.fun.Resolver;
import mondrian.olap.fun.ResolverBase;
import mondrian.olap.type.MemberType;
import mondrian.olap.type.TupleType;
import mondrian.olap.type.Type;
import mondrian.olap.type.TypeUtil;

public class TupleFunDef
extends FunDefBase {
    private final int[] argTypes;
    static final ResolverImpl Resolver = new ResolverImpl();

    private TupleFunDef(int[] argTypes) {
        super("()", "(<Member> [, <Member>]...)", "Parenthesis operator constructs a tuple.  If there is only one member, the expression is equivalent to the member expression.", Syntax.Parentheses, 10, argTypes);
        this.argTypes = argTypes;
    }

    @Override
    public int getReturnCategory() {
        return 10;
    }

    @Override
    public int[] getParameterCategories() {
        return this.argTypes;
    }

    @Override
    public void unparse(Exp[] args, PrintWriter pw) {
        ExpBase.unparseList(pw, args, "(", ", ", ")");
    }

    @Override
    public Type getResultType(Validator validator, Exp[] args) {
        if (args.length == 1) {
            return TypeUtil.toMemberType(args[0].getType());
        }
        Type[] types = new MemberType[args.length];
        int i = 0;
        while (i < args.length) {
            Exp arg = args[i];
            types[i] = TypeUtil.toMemberType(arg.getType());
            ++i;
        }
        TupleType.checkHierarchies((MemberType[])types);
        return new TupleType(types);
    }

    @Override
    public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
        Exp[] args = call.getArgs();
        MemberCalc[] memberCalcs = new MemberCalc[args.length];
        int i = 0;
        while (i < args.length) {
            memberCalcs[i] = compiler.compileMember(args[i]);
            ++i;
        }
        return new CalcImpl(call, memberCalcs);
    }

    /* synthetic */ TupleFunDef(int[] nArray, TupleFunDef tupleFunDef) {
        this(nArray);
    }

    public static class CalcImpl
    extends AbstractTupleCalc {
        private final MemberCalc[] memberCalcs;

        public CalcImpl(ResolvedFunCall call, MemberCalc[] memberCalcs) {
            super(call, memberCalcs);
            this.memberCalcs = memberCalcs;
        }

        @Override
        public Member[] evaluateTuple(Evaluator evaluator) {
            Member[] members = new Member[this.memberCalcs.length];
            int i = 0;
            while (i < members.length) {
                members[i] = this.memberCalcs[i].evaluateMember(evaluator);
                Member member = members[i];
                if (member == null || member.isNull()) {
                    return null;
                }
                ++i;
            }
            return members;
        }

        public MemberCalc[] getMemberCalcs() {
            return this.memberCalcs;
        }
    }

    private static class ResolverImpl
    extends ResolverBase {
        public ResolverImpl() {
            super("()", null, null, Syntax.Parentheses);
        }

        @Override
        public FunDef resolve(Exp[] args, Validator validator, List<Resolver.Conversion> conversions) {
            if (args.length == 1) {
                return new ParenthesesFunDef(args[0].getCategory());
            }
            int[] argTypes = new int[args.length];
            int i = 0;
            while (i < args.length) {
                if (!validator.canConvert(i, args[i], 6, conversions)) {
                    return null;
                }
                argTypes[i] = 6;
                ++i;
            }
            return new TupleFunDef(argTypes, null);
        }
    }
}

