/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import mondrian.calc.Calc;
import mondrian.calc.ExpCompiler;
import mondrian.calc.MemberCalc;
import mondrian.calc.TupleCalc;
import mondrian.calc.impl.GenericCalc;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Cube;
import mondrian.olap.Dimension;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.Hierarchy;
import mondrian.olap.Member;
import mondrian.olap.fun.FunDefBase;
import mondrian.olap.type.TypeUtil;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapMember;

public class ValidMeasureFunDef
extends FunDefBase {
    static final ValidMeasureFunDef instance = new ValidMeasureFunDef();

    private ValidMeasureFunDef() {
        super("ValidMeasure", "Returns a valid measure in a virtual cube by forcing inapplicable dimensions to their top level.", "fnt");
    }

    @Override
    public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
        Exp arg = call.getArg(0);
        Calc calc = TypeUtil.couldBeMember(arg.getType()) ? compiler.compileMember(arg) : compiler.compileTuple(arg);
        return new CalcImpl(call, calc);
    }

    private static class CalcImpl
    extends GenericCalc {
        private final Calc calc;

        public CalcImpl(ResolvedFunCall call, Calc calc) {
            super(call);
            this.calc = calc;
        }

        @Override
        public Object evaluate(Evaluator evaluator) {
            List<Object> memberList;
            if (this.calc.isWrapperFor(MemberCalc.class)) {
                memberList = new ArrayList<Member>(1);
                memberList.add(this.calc.unwrap(MemberCalc.class).evaluateMember(evaluator));
            } else {
                Member[] tupleMembers = this.calc.unwrap(TupleCalc.class).evaluateTuple(evaluator);
                memberList = Arrays.asList(tupleMembers);
            }
            RolapCube baseCube = null;
            RolapCube virtualCube = (RolapCube)evaluator.getCube();
            int measurePosition = -1;
            int i = 0;
            while (i < memberList.size()) {
                if (((Member)memberList.get(i)).getDimension().isMeasures()) {
                    measurePosition = i;
                    break;
                }
                ++i;
            }
            baseCube = this.getBaseCubeofMeasure(evaluator, (Member)memberList.get(measurePosition), baseCube);
            List<Dimension> vMinusBDimensions = this.getDimensionsToForceToAllLevel(virtualCube, baseCube, memberList);
            ArrayList<Object> validMeasureMembers = new ArrayList<Object>(memberList);
            for (Dimension vMinusBDimension : vMinusBDimensions) {
                Hierarchy hierarchy = vMinusBDimension.getHierarchy();
                if (hierarchy.hasAll()) {
                    validMeasureMembers.add(hierarchy.getAllMember());
                    continue;
                }
                validMeasureMembers.add(hierarchy.getDefaultMember());
            }
            List<Member> calculatedMembers = this.getCalculatedMembersFromContext(evaluator);
            evaluator.setContext(validMeasureMembers);
            evaluator.setContext(calculatedMembers);
            return evaluator.evaluateCurrent();
        }

        private List<Member> getCalculatedMembersFromContext(Evaluator evaluator) {
            Member[] currentMembers = evaluator.getMembers();
            ArrayList<Member> calculatedMembers = new ArrayList<Member>();
            Member[] memberArray = currentMembers;
            int n = currentMembers.length;
            int n2 = 0;
            while (n2 < n) {
                Member currentMember = memberArray[n2];
                if (currentMember.isCalculated()) {
                    calculatedMembers.add(currentMember);
                }
                ++n2;
            }
            return calculatedMembers;
        }

        @Override
        public Calc[] getCalcs() {
            return new Calc[]{this.calc};
        }

        private RolapCube getBaseCubeofMeasure(Evaluator evaluator, Member member, RolapCube baseCube) {
            Cube[] cubes;
            Cube[] cubeArray = cubes = evaluator.getSchemaReader().getCubes();
            int n = cubes.length;
            int n2 = 0;
            while (n2 < n) {
                Cube cube1 = cubeArray[n2];
                RolapCube cube = (RolapCube)cube1;
                if (!cube.isVirtual()) {
                    for (RolapMember measure : cube.getMeasuresMembers()) {
                        if (!measure.getName().equals(member.getName())) continue;
                        baseCube = cube;
                    }
                }
                if (baseCube != null) break;
                ++n2;
            }
            return baseCube;
        }

        private List<Dimension> getDimensionsToForceToAllLevel(RolapCube virtualCube, RolapCube baseCube, List<Member> memberList) {
            ArrayList<Dimension> vMinusBDimensions = new ArrayList<Dimension>();
            HashSet<Dimension> virtualCubeDims = new HashSet<Dimension>();
            virtualCubeDims.addAll(Arrays.asList(virtualCube.getDimensions()));
            Set<Dimension> nonJoiningDims = baseCube.nonJoiningDimensions(virtualCubeDims);
            for (Dimension nonJoiningDim : nonJoiningDims) {
                if (this.isDimInMembersList(memberList, nonJoiningDim)) continue;
                vMinusBDimensions.add(nonJoiningDim);
            }
            return vMinusBDimensions;
        }

        private boolean isDimInMembersList(List<Member> members, Dimension dimension) {
            for (Member member : members) {
                if (!member.getName().equalsIgnoreCase(dimension.getName())) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean dependsOn(Hierarchy hierarchy) {
            return CalcImpl.butDepends(this.getCalcs(), hierarchy);
        }
    }
}

