/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.type;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mondrian.olap.Dimension;
import mondrian.olap.Hierarchy;
import mondrian.olap.Level;
import mondrian.olap.type.MemberType;
import mondrian.olap.type.ScalarType;
import mondrian.olap.type.Type;
import mondrian.resource.MondrianResource;

public class TupleType
implements Type {
    public final Type[] elementTypes;
    private final String digest;

    public TupleType(Type[] elementTypes) {
        assert (elementTypes != null);
        this.elementTypes = (Type[])elementTypes.clone();
        StringBuilder buf = new StringBuilder();
        buf.append("TupleType<");
        int k = 0;
        Type[] typeArray = elementTypes;
        int n = elementTypes.length;
        int n2 = 0;
        while (n2 < n) {
            Type elementType = typeArray[n2];
            if (k++ > 0) {
                buf.append(", ");
            }
            buf.append(elementType);
            ++n2;
        }
        buf.append(">");
        this.digest = buf.toString();
    }

    public String toString() {
        return this.digest;
    }

    public boolean equals(Object obj) {
        if (obj instanceof TupleType) {
            TupleType that = (TupleType)obj;
            return Arrays.equals(this.elementTypes, that.elementTypes);
        }
        return false;
    }

    public int hashCode() {
        return this.digest.hashCode();
    }

    @Override
    public boolean usesDimension(Dimension dimension, boolean definitely) {
        Type[] typeArray = this.elementTypes;
        int n = this.elementTypes.length;
        int n2 = 0;
        while (n2 < n) {
            Type elementType = typeArray[n2];
            if (elementType.usesDimension(dimension, definitely)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public boolean usesHierarchy(Hierarchy hierarchy, boolean definitely) {
        Type[] typeArray = this.elementTypes;
        int n = this.elementTypes.length;
        int n2 = 0;
        while (n2 < n) {
            Type elementType = typeArray[n2];
            if (elementType.usesHierarchy(hierarchy, definitely)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public List<Hierarchy> getHierarchies() {
        ArrayList<Hierarchy> hierarchies = new ArrayList<Hierarchy>(this.elementTypes.length);
        Type[] typeArray = this.elementTypes;
        int n = this.elementTypes.length;
        int n2 = 0;
        while (n2 < n) {
            Type elementType = typeArray[n2];
            hierarchies.add(elementType.getHierarchy());
            ++n2;
        }
        return hierarchies;
    }

    @Override
    public int getArity() {
        return this.elementTypes.length;
    }

    @Override
    public Dimension getDimension() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Hierarchy getHierarchy() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Level getLevel() {
        throw new UnsupportedOperationException();
    }

    public Type getValueType() {
        Type[] typeArray = this.elementTypes;
        int n = this.elementTypes.length;
        int n2 = 0;
        while (n2 < n) {
            MemberType memberType;
            Dimension dimension;
            Type elementType = typeArray[n2];
            if (elementType instanceof MemberType && (dimension = (memberType = (MemberType)elementType).getDimension()) != null && dimension.isMeasures()) {
                return memberType.getValueType();
            }
            ++n2;
        }
        return new ScalarType();
    }

    @Override
    public Type computeCommonType(Type type, int[] conversionCount) {
        if (type instanceof ScalarType) {
            return this.getValueType().computeCommonType(type, conversionCount);
        }
        if (type instanceof MemberType) {
            return this.commonTupleType(new TupleType(new Type[]{type}), conversionCount);
        }
        if (!(type instanceof TupleType)) {
            return null;
        }
        return this.commonTupleType(type, conversionCount);
    }

    @Override
    public boolean isInstance(Object value) {
        if (!(value instanceof Object[])) {
            return false;
        }
        Object[] objects = (Object[])value;
        if (objects.length != this.elementTypes.length) {
            return false;
        }
        int i = 0;
        while (i < objects.length) {
            if (!this.elementTypes[i].isInstance(objects[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private Type commonTupleType(Type type, int[] conversionCount) {
        TupleType that = (TupleType)type;
        if (this.elementTypes.length < that.elementTypes.length) {
            return this.createCommonTupleType(that, conversionCount);
        }
        return that.createCommonTupleType(this, conversionCount);
    }

    private Type createCommonTupleType(TupleType that, int[] conversionCount) {
        ArrayList<Type> elementTypes = new ArrayList<Type>();
        int i = 0;
        while (i < this.elementTypes.length) {
            Type commonType = this.elementTypes[i].computeCommonType(that.elementTypes[i], conversionCount);
            elementTypes.add(commonType);
            if (commonType == null) {
                return null;
            }
            ++i;
        }
        if (elementTypes.size() < that.elementTypes.length) {
            i = elementTypes.size();
            while (i < that.elementTypes.length) {
                elementTypes.add(new ScalarType());
                ++i;
            }
        }
        return new TupleType(elementTypes.toArray(new Type[elementTypes.size()]));
    }

    public static void checkHierarchies(MemberType[] memberTypes) {
        int i = 0;
        while (i < memberTypes.length) {
            MemberType memberType = memberTypes[i];
            int j = 0;
            while (j < i) {
                MemberType member1 = memberTypes[j];
                Hierarchy hierarchy = memberType.getHierarchy();
                Hierarchy hierarchy1 = member1.getHierarchy();
                if (hierarchy != null && hierarchy == hierarchy1) {
                    throw MondrianResource.instance().DupHierarchiesInTuple.ex(hierarchy.getUniqueName());
                }
                ++j;
            }
            ++i;
        }
    }
}

