/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap4j;

import java.util.List;
import mondrian.olap.Hierarchy;
import mondrian.olap.Level;
import mondrian.olap.Member;
import mondrian.olap.OlapElement;
import mondrian.olap.SchemaReader;
import mondrian.olap4j.MondrianOlap4jConnection;
import mondrian.olap4j.MondrianOlap4jDimension;
import mondrian.olap4j.MondrianOlap4jMetadataElement;
import mondrian.olap4j.MondrianOlap4jSchema;
import org.olap4j.OlapException;
import org.olap4j.impl.AbstractNamedList;
import org.olap4j.impl.Named;
import org.olap4j.impl.NamedListImpl;
import org.olap4j.impl.Olap4jUtil;
import org.olap4j.metadata.Dimension;
import org.olap4j.metadata.NamedList;

class MondrianOlap4jHierarchy
extends MondrianOlap4jMetadataElement
implements org.olap4j.metadata.Hierarchy,
Named {
    final MondrianOlap4jSchema olap4jSchema;
    final Hierarchy hierarchy;

    MondrianOlap4jHierarchy(MondrianOlap4jSchema olap4jSchema, Hierarchy hierarchy) {
        this.olap4jSchema = olap4jSchema;
        this.hierarchy = hierarchy;
    }

    public boolean equals(Object obj) {
        return obj instanceof MondrianOlap4jHierarchy && this.hierarchy.equals(((MondrianOlap4jHierarchy)obj).hierarchy);
    }

    public int hashCode() {
        return this.hierarchy.hashCode();
    }

    public Dimension getDimension() {
        return new MondrianOlap4jDimension(this.olap4jSchema, this.hierarchy.getDimension());
    }

    public NamedList<org.olap4j.metadata.Level> getLevels() {
        NamedListImpl list = new NamedListImpl();
        MondrianOlap4jConnection olap4jConnection = this.olap4jSchema.olap4jCatalog.olap4jDatabaseMetaData.olap4jConnection;
        SchemaReader schemaReader = olap4jConnection.getMondrianConnection2().getSchemaReader().withLocus();
        for (Level level : schemaReader.getHierarchyLevels(this.hierarchy)) {
            list.add((Object)olap4jConnection.toOlap4j(level));
        }
        return Olap4jUtil.cast((NamedList)list);
    }

    public boolean hasAll() {
        return this.hierarchy.hasAll();
    }

    public org.olap4j.metadata.Member getDefaultMember() {
        MondrianOlap4jConnection olap4jConnection = this.olap4jSchema.olap4jCatalog.olap4jDatabaseMetaData.olap4jConnection;
        return olap4jConnection.toOlap4j(this.hierarchy.getDefaultMember());
    }

    public NamedList<org.olap4j.metadata.Member> getRootMembers() throws OlapException {
        final MondrianOlap4jConnection olap4jConnection = this.olap4jSchema.olap4jCatalog.olap4jDatabaseMetaData.olap4jConnection;
        final List<Member> levelMembers = olap4jConnection.getMondrianConnection().getSchemaReader().withLocus().getLevelMembers(this.hierarchy.getLevels()[0], true);
        return new AbstractNamedList<org.olap4j.metadata.Member>(){

            public String getName(Object member) {
                return ((org.olap4j.metadata.Member)member).getName();
            }

            public org.olap4j.metadata.Member get(int index) {
                return olap4jConnection.toOlap4j((Member)levelMembers.get(index));
            }

            public int size() {
                return levelMembers.size();
            }
        };
    }

    public String getName() {
        return this.hierarchy.getName();
    }

    public String getUniqueName() {
        return this.hierarchy.getUniqueName();
    }

    public String getCaption() {
        return this.hierarchy.getLocalized(OlapElement.LocalizedProperty.CAPTION, this.olap4jSchema.getLocale());
    }

    public String getDescription() {
        return this.hierarchy.getLocalized(OlapElement.LocalizedProperty.DESCRIPTION, this.olap4jSchema.getLocale());
    }

    public boolean isVisible() {
        return this.hierarchy.isVisible();
    }

    @Override
    protected OlapElement getOlapElement() {
        return this.hierarchy;
    }
}

