/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap4j;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Locale;
import java.util.TreeSet;
import mondrian.olap.Cube;
import mondrian.olap.Hierarchy;
import mondrian.olap.OlapElement;
import mondrian.olap.Role;
import mondrian.olap.Schema;
import mondrian.olap4j.MondrianOlap4jCatalog;
import mondrian.olap4j.MondrianOlap4jConnection;
import mondrian.olap4j.MondrianOlap4jDimension;
import mondrian.olap4j.MondrianOlap4jMetadataElement;
import org.olap4j.OlapException;
import org.olap4j.impl.Named;
import org.olap4j.impl.NamedListImpl;
import org.olap4j.impl.Olap4jUtil;
import org.olap4j.metadata.Catalog;
import org.olap4j.metadata.Dimension;
import org.olap4j.metadata.NamedList;

class MondrianOlap4jSchema
extends MondrianOlap4jMetadataElement
implements org.olap4j.metadata.Schema,
Named {
    final MondrianOlap4jCatalog olap4jCatalog;
    final String schemaName;
    final Schema schema;

    MondrianOlap4jSchema(MondrianOlap4jCatalog olap4jCatalog, String schemaName, Schema schema) {
        this.olap4jCatalog = olap4jCatalog;
        this.schemaName = schemaName;
        this.schema = schema;
    }

    public Catalog getCatalog() {
        return this.olap4jCatalog;
    }

    public NamedList<org.olap4j.metadata.Cube> getCubes() throws OlapException {
        NamedListImpl list = new NamedListImpl();
        MondrianOlap4jConnection olap4jConnection = this.olap4jCatalog.olap4jDatabaseMetaData.olap4jConnection;
        Cube[] cubeArray = olap4jConnection.getMondrianConnection().getSchemaReader().getCubes();
        int n = cubeArray.length;
        int n2 = 0;
        while (n2 < n) {
            Cube cube = cubeArray[n2];
            list.add((Object)olap4jConnection.toOlap4j(cube));
            ++n2;
        }
        return Olap4jUtil.cast((NamedList)list);
    }

    public NamedList<Dimension> getSharedDimensions() throws OlapException {
        MondrianOlap4jConnection olap4jConnection = this.olap4jCatalog.olap4jDatabaseMetaData.olap4jConnection;
        TreeSet<MondrianOlap4jDimension> dimensions = new TreeSet<MondrianOlap4jDimension>(new Comparator<MondrianOlap4jDimension>(){

            @Override
            public int compare(MondrianOlap4jDimension o1, MondrianOlap4jDimension o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        Role role = olap4jConnection.getMondrianConnection().getRole();
        Hierarchy[] hierarchyArray = this.schema.getSharedHierarchies();
        int n = hierarchyArray.length;
        int n2 = 0;
        while (n2 < n) {
            Hierarchy hierarchy = hierarchyArray[n2];
            if (role.canAccess(hierarchy)) {
                dimensions.add(olap4jConnection.toOlap4j(hierarchy.getDimension()));
            }
            ++n2;
        }
        NamedListImpl list = new NamedListImpl();
        list.addAll(dimensions);
        return Olap4jUtil.cast((NamedList)list);
    }

    public Collection<Locale> getSupportedLocales() throws OlapException {
        return Collections.emptyList();
    }

    public String getName() {
        return this.schemaName;
    }

    final Locale getLocale() {
        return this.olap4jCatalog.olap4jDatabase.getOlapConnection().getLocale();
    }

    @Override
    protected OlapElement getOlapElement() {
        return null;
    }
}

