/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.io.Serializable;
import java.util.BitSet;
import java.util.Iterator;

public interface BitKey
extends Serializable,
Comparable<BitKey>,
Iterable<Integer> {
    public static final BitKey EMPTY = Factory.makeBitKey(0);
    public static final byte[] bitPositionTable;

    static {
        byte[] byArray = new byte[256];
        byArray[0] = -1;
        byArray[2] = 1;
        byArray[4] = 2;
        byArray[6] = 1;
        byArray[8] = 3;
        byArray[10] = 1;
        byArray[12] = 2;
        byArray[14] = 1;
        byArray[16] = 4;
        byArray[18] = 1;
        byArray[20] = 2;
        byArray[22] = 1;
        byArray[24] = 3;
        byArray[26] = 1;
        byArray[28] = 2;
        byArray[30] = 1;
        byArray[32] = 5;
        byArray[34] = 1;
        byArray[36] = 2;
        byArray[38] = 1;
        byArray[40] = 3;
        byArray[42] = 1;
        byArray[44] = 2;
        byArray[46] = 1;
        byArray[48] = 4;
        byArray[50] = 1;
        byArray[52] = 2;
        byArray[54] = 1;
        byArray[56] = 3;
        byArray[58] = 1;
        byArray[60] = 2;
        byArray[62] = 1;
        byArray[64] = 6;
        byArray[66] = 1;
        byArray[68] = 2;
        byArray[70] = 1;
        byArray[72] = 3;
        byArray[74] = 1;
        byArray[76] = 2;
        byArray[78] = 1;
        byArray[80] = 4;
        byArray[82] = 1;
        byArray[84] = 2;
        byArray[86] = 1;
        byArray[88] = 3;
        byArray[90] = 1;
        byArray[92] = 2;
        byArray[94] = 1;
        byArray[96] = 5;
        byArray[98] = 1;
        byArray[100] = 2;
        byArray[102] = 1;
        byArray[104] = 3;
        byArray[106] = 1;
        byArray[108] = 2;
        byArray[110] = 1;
        byArray[112] = 4;
        byArray[114] = 1;
        byArray[116] = 2;
        byArray[118] = 1;
        byArray[120] = 3;
        byArray[122] = 1;
        byArray[124] = 2;
        byArray[126] = 1;
        byArray[128] = 7;
        byArray[130] = 1;
        byArray[132] = 2;
        byArray[134] = 1;
        byArray[136] = 3;
        byArray[138] = 1;
        byArray[140] = 2;
        byArray[142] = 1;
        byArray[144] = 4;
        byArray[146] = 1;
        byArray[148] = 2;
        byArray[150] = 1;
        byArray[152] = 3;
        byArray[154] = 1;
        byArray[156] = 2;
        byArray[158] = 1;
        byArray[160] = 5;
        byArray[162] = 1;
        byArray[164] = 2;
        byArray[166] = 1;
        byArray[168] = 3;
        byArray[170] = 1;
        byArray[172] = 2;
        byArray[174] = 1;
        byArray[176] = 4;
        byArray[178] = 1;
        byArray[180] = 2;
        byArray[182] = 1;
        byArray[184] = 3;
        byArray[186] = 1;
        byArray[188] = 2;
        byArray[190] = 1;
        byArray[192] = 6;
        byArray[194] = 1;
        byArray[196] = 2;
        byArray[198] = 1;
        byArray[200] = 3;
        byArray[202] = 1;
        byArray[204] = 2;
        byArray[206] = 1;
        byArray[208] = 4;
        byArray[210] = 1;
        byArray[212] = 2;
        byArray[214] = 1;
        byArray[216] = 3;
        byArray[218] = 1;
        byArray[220] = 2;
        byArray[222] = 1;
        byArray[224] = 5;
        byArray[226] = 1;
        byArray[228] = 2;
        byArray[230] = 1;
        byArray[232] = 3;
        byArray[234] = 1;
        byArray[236] = 2;
        byArray[238] = 1;
        byArray[240] = 4;
        byArray[242] = 1;
        byArray[244] = 2;
        byArray[246] = 1;
        byArray[248] = 3;
        byArray[250] = 1;
        byArray[252] = 2;
        byArray[254] = 1;
        bitPositionTable = byArray;
    }

    public void set(int var1, boolean var2);

    public void set(int var1);

    public boolean get(int var1);

    public void clear(int var1);

    public void clear();

    public boolean isSuperSetOf(BitKey var1);

    public BitKey or(BitKey var1);

    public BitKey orNot(BitKey var1);

    public BitKey and(BitKey var1);

    public BitKey andNot(BitKey var1);

    public BitKey copy();

    public BitKey emptyCopy();

    public boolean isEmpty();

    public boolean intersects(BitKey var1);

    public BitSet toBitSet();

    @Override
    public Iterator<Integer> iterator();

    public int nextSetBit(int var1);

    public int cardinality();

    public static abstract class AbstractBitKey
    implements BitKey {
        private static final long serialVersionUID = -2942302671676103450L;
        protected static final int ChunkBitCount = 6;
        protected static final int Mask = 63;
        protected static final long WORD_MASK = -1L;

        protected static long bit(int pos) {
            return 1L << (pos & 0x3F);
        }

        protected static int chunkPos(int size) {
            return size >> 6;
        }

        protected static int chunkCount(int size) {
            return size + 63 >> 6;
        }

        protected static int bitCount(long i) {
            i -= i >>> 1 & 0x5555555555555555L;
            i = (i & 0x3333333333333333L) + (i >>> 2 & 0x3333333333333333L);
            i = i + (i >>> 4) & 0xF0F0F0F0F0F0F0FL;
            i += i >>> 8;
            i += i >>> 16;
            i += i >>> 32;
            return (int)i & 0x7F;
        }

        @Override
        public final void set(int pos, boolean value) {
            if (value) {
                this.set(pos);
            } else {
                this.clear(pos);
            }
        }

        protected static void copyFromByte(BitSet bitSet, int pos, byte x) {
            if (x == 0) {
                return;
            }
            if ((x & 1) != 0) {
                bitSet.set(pos, true);
            }
            ++pos;
            if ((x & 2) != 0) {
                bitSet.set(pos, true);
            }
            ++pos;
            if ((x & 4) != 0) {
                bitSet.set(pos, true);
            }
            ++pos;
            if ((x & 8) != 0) {
                bitSet.set(pos, true);
            }
            ++pos;
            if ((x & 0x10) != 0) {
                bitSet.set(pos, true);
            }
            ++pos;
            if ((x & 0x20) != 0) {
                bitSet.set(pos, true);
            }
            ++pos;
            if ((x & 0x40) != 0) {
                bitSet.set(pos, true);
            }
            ++pos;
            if ((x & 0x80) != 0) {
                bitSet.set(pos, true);
            }
        }

        protected static void copyFromLong(BitSet bitSet, int pos, long x) {
            while (x != 0L) {
                AbstractBitKey.copyFromByte(bitSet, pos, (byte)(x & 0xFFL));
                x >>>= 8;
                pos += 8;
            }
        }

        protected IllegalArgumentException createException(BitKey bitKey) {
            String msg = bitKey == null ? "Null BitKey" : "Bad BitKey type: " + bitKey.getClass().getName();
            return new IllegalArgumentException(msg);
        }

        /*
         * Unable to fully structure code
         */
        static int compareUnsignedArrays(long[] a1, long[] a2) {
            i1 = a1.length - 1;
            i2 = a2.length - 1;
            if (i1 > i2) {
                do {
                    if (a1[i1] == 0L) continue;
                    return 1;
                } while (--i1 > i2);
            } else if (i2 > i1) {
                do {
                    if (a2[i2] == 0L) continue;
                    return -1;
                } while (--i2 > i1);
            }
            if (AbstractBitKey.$assertionsDisabled || i1 == i2) ** GOTO lbl20
            throw new AssertionError();
lbl-1000:
            // 1 sources

            {
                c = AbstractBitKey.compareUnsigned(a1[i1], a2[i1]);
                if (c != 0) {
                    return c;
                }
                --i1;
lbl20:
                // 2 sources

                ** while (i1 >= 0)
            }
lbl21:
            // 1 sources

            return 0;
        }

        static int compareUnsigned(long i1, long i2) {
            if (i1 == i2) {
                return 0;
            }
            if (i1 < 0L == i2 < 0L) {
                return i1 < i2 ? -1 : 1;
            }
            return i1 < i2 ? 1 : -1;
        }
    }

    public static class Big
    extends AbstractBitKey {
        private static final long serialVersionUID = -3715282769845236295L;
        private long[] bits;

        private Big(int size) {
            this.bits = new long[Big.chunkCount(size + 1)];
        }

        private Big(Big big) {
            this.bits = (long[])big.bits.clone();
        }

        private int size() {
            return this.bits.length;
        }

        private int effectiveSize() {
            int n = this.bits.length;
            while (n > 0 && this.bits[n - 1] == 0L) {
                --n;
            }
            return n;
        }

        @Override
        public void set(int pos) {
            int n = Big.chunkPos(pos);
            this.bits[n] = this.bits[n] | Big.bit(pos);
        }

        @Override
        public boolean get(int pos) {
            return (this.bits[Big.chunkPos(pos)] & Big.bit(pos)) != 0L;
        }

        @Override
        public void clear(int pos) {
            int n = Big.chunkPos(pos);
            this.bits[n] = this.bits[n] & (Big.bit(pos) ^ 0xFFFFFFFFFFFFFFFFL);
        }

        @Override
        public void clear() {
            int i = 0;
            while (i < this.bits.length) {
                this.bits[i] = 0L;
                ++i;
            }
        }

        @Override
        public int cardinality() {
            int n = 0;
            int i = 0;
            while (i < this.bits.length) {
                n += Big.bitCount(this.bits[i]);
                ++i;
            }
            return n;
        }

        private void or(long bits0) {
            this.bits[0] = this.bits[0] | bits0;
        }

        private void or(long bits0, long bits1) {
            this.bits[0] = this.bits[0] | bits0;
            this.bits[1] = this.bits[1] | bits1;
        }

        private void or(long[] bits) {
            int i = 0;
            while (i < bits.length) {
                int n = i;
                this.bits[n] = this.bits[n] | bits[i];
                ++i;
            }
        }

        private void orNot(long bits0) {
            this.bits[0] = this.bits[0] ^ bits0;
        }

        private void orNot(long bits0, long bits1) {
            this.bits[0] = this.bits[0] ^ bits0;
            this.bits[1] = this.bits[1] ^ bits1;
        }

        private void orNot(long[] bits) {
            int i = 0;
            while (i < bits.length) {
                int n = i;
                this.bits[n] = this.bits[n] ^ bits[i];
                ++i;
            }
        }

        private void and(long[] bits) {
            int length = Math.min(bits.length, this.bits.length);
            int i = 0;
            while (i < length) {
                int n = i;
                this.bits[n] = this.bits[n] & bits[i];
                ++i;
            }
            i = bits.length;
            while (i < this.bits.length) {
                this.bits[i] = 0L;
                ++i;
            }
        }

        @Override
        public BitKey or(BitKey bitKey) {
            if (bitKey instanceof Small) {
                Small other = (Small)bitKey;
                Big bk = (Big)this.copy();
                bk.or(other.bits);
                return bk;
            }
            if (bitKey instanceof Mid128) {
                Mid128 other = (Mid128)bitKey;
                Big bk = (Big)this.copy();
                bk.or(other.bits0, other.bits1);
                return bk;
            }
            if (bitKey instanceof Big) {
                Big other = (Big)bitKey;
                if (other.size() > this.size()) {
                    Big bk = (Big)other.copy();
                    bk.or(this.bits);
                    return bk;
                }
                Big bk = (Big)this.copy();
                bk.or(other.bits);
                return bk;
            }
            throw this.createException(bitKey);
        }

        @Override
        public BitKey orNot(BitKey bitKey) {
            if (bitKey instanceof Small) {
                Small other = (Small)bitKey;
                Big bk = (Big)this.copy();
                bk.orNot(other.bits);
                return bk;
            }
            if (bitKey instanceof Mid128) {
                Mid128 other = (Mid128)bitKey;
                Big bk = (Big)this.copy();
                bk.orNot(other.bits0, other.bits1);
                return bk;
            }
            if (bitKey instanceof Big) {
                Big other = (Big)bitKey;
                if (other.size() > this.size()) {
                    Big bk = (Big)other.copy();
                    bk.orNot(this.bits);
                    return bk;
                }
                Big bk = (Big)this.copy();
                bk.orNot(other.bits);
                return bk;
            }
            throw this.createException(bitKey);
        }

        @Override
        public BitKey and(BitKey bitKey) {
            if (bitKey instanceof Small) {
                Small bk = (Small)bitKey.copy();
                bk.and(this.bits[0]);
                return bk;
            }
            if (bitKey instanceof Mid128) {
                Mid128 bk = (Mid128)bitKey.copy();
                bk.and(this.bits[0], this.bits[1]);
                return bk;
            }
            if (bitKey instanceof Big) {
                Big other = (Big)bitKey;
                if (other.size() < this.size()) {
                    Big bk = (Big)other.copy();
                    bk.and(this.bits);
                    return bk;
                }
                Big bk = (Big)this.copy();
                bk.and(other.bits);
                return bk;
            }
            throw this.createException(bitKey);
        }

        @Override
        public BitKey andNot(BitKey bitKey) {
            if (bitKey instanceof Small) {
                Small other = (Small)bitKey;
                Big bk = (Big)this.copy();
                bk.andNot(other.bits);
                return bk;
            }
            if (bitKey instanceof Mid128) {
                Mid128 other = (Mid128)bitKey;
                Big bk = (Big)this.copy();
                bk.andNot(other.bits0, other.bits1);
                return bk;
            }
            if (bitKey instanceof Big) {
                Big other = (Big)bitKey;
                Big bk = (Big)this.copy();
                bk.andNot(other.bits);
                return bk;
            }
            throw this.createException(bitKey);
        }

        private void andNot(long[] bits) {
            int i = 0;
            while (i < bits.length) {
                int n = i;
                this.bits[n] = this.bits[n] & (bits[i] ^ 0xFFFFFFFFFFFFFFFFL);
                ++i;
            }
        }

        private void andNot(long bits0, long bits1) {
            this.bits[0] = this.bits[0] & (bits0 ^ 0xFFFFFFFFFFFFFFFFL);
            this.bits[1] = this.bits[1] & (bits1 ^ 0xFFFFFFFFFFFFFFFFL);
        }

        private void andNot(long bits) {
            this.bits[0] = this.bits[0] & (bits ^ 0xFFFFFFFFFFFFFFFFL);
        }

        @Override
        public boolean isSuperSetOf(BitKey bitKey) {
            if (bitKey instanceof Small) {
                Small other = (Small)bitKey;
                return (this.bits[0] | other.bits) == this.bits[0];
            }
            if (bitKey instanceof Mid128) {
                Mid128 other = (Mid128)bitKey;
                return (this.bits[0] | other.bits0) == this.bits[0] && (this.bits[1] | other.bits1) == this.bits[1];
            }
            if (bitKey instanceof Big) {
                Big other = (Big)bitKey;
                int len = Math.min(this.bits.length, other.bits.length);
                int i = 0;
                while (i < len) {
                    if ((this.bits[i] | other.bits[i]) != this.bits[i]) {
                        return false;
                    }
                    ++i;
                }
                if (other.bits.length > this.bits.length) {
                    i = len;
                    while (i < other.bits.length) {
                        if (other.bits[i] != 0L) {
                            return false;
                        }
                        ++i;
                    }
                }
                return true;
            }
            return false;
        }

        @Override
        public boolean intersects(BitKey bitKey) {
            if (bitKey instanceof Small) {
                Small other = (Small)bitKey;
                return (this.bits[0] & other.bits) != 0L;
            }
            if (bitKey instanceof Mid128) {
                Mid128 other = (Mid128)bitKey;
                return (this.bits[0] & other.bits0) != 0L || (this.bits[1] & other.bits1) != 0L;
            }
            if (bitKey instanceof Big) {
                Big other = (Big)bitKey;
                int len = Math.min(this.bits.length, other.bits.length);
                int i = 0;
                while (i < len) {
                    if ((this.bits[i] & other.bits[i]) != 0L) {
                        return true;
                    }
                    ++i;
                }
                return false;
            }
            return false;
        }

        @Override
        public BitSet toBitSet() {
            BitSet bitSet = new BitSet(64);
            int pos = 0;
            int i = 0;
            while (i < this.bits.length) {
                Big.copyFromLong(bitSet, pos, this.bits[i]);
                pos += 64;
                ++i;
            }
            return bitSet;
        }

        @Override
        public Iterator<Integer> iterator() {
            return new Iterator<Integer>(){
                long[] bits;
                int pos;
                int index;
                {
                    this.bits = (long[])Big.this.bits.clone();
                    this.pos = -1;
                    this.index = 0;
                }

                @Override
                public boolean hasNext() {
                    long bs;
                    if (this.index >= this.bits.length) {
                        return false;
                    }
                    if (this.pos < 0) {
                        while (this.bits[this.index] == 0L) {
                            ++this.index;
                            if (this.index < this.bits.length) continue;
                            return false;
                        }
                        this.pos = 64 * this.index - 1;
                    }
                    if ((bs = this.bits[this.index]) == 0L) {
                        while (this.bits[this.index] == 0L) {
                            ++this.index;
                            if (this.index < this.bits.length) continue;
                            return false;
                        }
                        this.pos = 64 * this.index - 1;
                        bs = this.bits[this.index];
                    }
                    if (bs != 0L) {
                        if (bs == Long.MIN_VALUE) {
                            this.pos = 64 * this.index + 63;
                            this.bits[this.index] = 0L;
                            return true;
                        }
                        long b = bs & -bs;
                        int delta = 0;
                        while (b >= 256L) {
                            b >>= 8;
                            delta += 8;
                        }
                        int p = bitPositionTable[(int)b];
                        p = p >= 0 ? (p += delta) : delta;
                        this.pos = this.pos < 0 ? p : (p == 0 ? ++this.pos : (this.pos += p + 1));
                        this.bits[this.index] = this.bits[this.index] >>> p + 1;
                        return true;
                    }
                    return false;
                }

                @Override
                public Integer next() {
                    return this.pos;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("remove");
                }
            };
        }

        @Override
        public int nextSetBit(int fromIndex) {
            if (fromIndex < 0) {
                throw new IndexOutOfBoundsException("fromIndex < 0: " + fromIndex);
            }
            int u = Big.chunkPos(fromIndex);
            if (u >= this.bits.length) {
                return -1;
            }
            long word = this.bits[u] & -1L << fromIndex;
            while (word == 0L) {
                if (++u == this.bits.length) {
                    return -1;
                }
                word = this.bits[u];
            }
            return u * 64 + Long.numberOfTrailingZeros(word);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof Small) {
                Small other = (Small)o;
                if (this.bits[0] != other.bits) {
                    return false;
                }
                int i = 1;
                while (i < this.bits.length) {
                    if (this.bits[i] != 0L) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
            if (o instanceof Mid128) {
                Mid128 other = (Mid128)o;
                if (this.bits[0] != other.bits0) {
                    return false;
                }
                if (this.bits[1] != other.bits1) {
                    return false;
                }
                int i = 2;
                while (i < this.bits.length) {
                    if (this.bits[i] != 0L) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
            if (o instanceof Big) {
                Big other = (Big)o;
                int len = Math.min(this.bits.length, other.bits.length);
                int i = 0;
                while (i < len) {
                    if (this.bits[i] != other.bits[i]) {
                        return false;
                    }
                    ++i;
                }
                if (this.bits.length > other.bits.length) {
                    i = len;
                    while (i < this.bits.length) {
                        if (this.bits[i] != 0L) {
                            return false;
                        }
                        ++i;
                    }
                } else if (other.bits.length > this.bits.length) {
                    i = len;
                    while (i < other.bits.length) {
                        if (other.bits[i] != 0L) {
                            return false;
                        }
                        ++i;
                    }
                }
                return true;
            }
            return false;
        }

        public int hashCode() {
            long h = 1234L;
            int i = this.bits.length;
            while (--i >= 0) {
                h ^= this.bits[i] * (long)(i + 1);
            }
            return (int)(h >> 32 ^ h);
        }

        public String toString() {
            int start;
            StringBuilder buf = new StringBuilder(64);
            buf.append("0x");
            int i = start = this.bits.length * 64 - 1;
            while (i >= 0) {
                buf.append(this.get(i) ? (char)'1' : '0');
                --i;
            }
            return buf.toString();
        }

        @Override
        public BitKey copy() {
            return new Big(this);
        }

        @Override
        public BitKey emptyCopy() {
            return new Big(this.bits.length << 6);
        }

        @Override
        public boolean isEmpty() {
            long[] lArray = this.bits;
            int n = this.bits.length;
            int n2 = 0;
            while (n2 < n) {
                long bit = lArray[n2];
                if (bit != 0L) {
                    return false;
                }
                ++n2;
            }
            return true;
        }

        @Override
        public int compareTo(BitKey bitKey) {
            if (bitKey instanceof Big) {
                return Big.compareUnsignedArrays(this.bits, ((Big)bitKey).bits);
            }
            if (bitKey instanceof Mid128) {
                Mid128 that = (Mid128)bitKey;
                return -that.compareToBig(this);
            }
            Small that = (Small)bitKey;
            return -that.compareToBig(this);
        }
    }

    public static abstract class Factory {
        public static BitKey makeBitKey(int size) {
            return Factory.makeBitKey(size, false);
        }

        public static BitKey makeBitKey(int size, boolean init) {
            if (size < 0) {
                String msg = "Negative size \"" + size + "\" not allowed";
                throw new IllegalArgumentException(msg);
            }
            AbstractBitKey bk = size < 64 ? new Small() : (size < 128 ? new Mid128(null, null) : new Big(size));
            if (init) {
                int i = 0;
                while (i < size) {
                    bk.set(i, init);
                    ++i;
                }
            }
            return bk;
        }

        public static BitKey makeBitKey(BitSet bitSet) {
            BitKey bitKey = Factory.makeBitKey(bitSet.length());
            int i = bitSet.nextSetBit(0);
            while (i >= 0) {
                bitKey.set(i);
                i = bitSet.nextSetBit(i + 1);
            }
            return bitKey;
        }
    }

    public static class Mid128
    extends AbstractBitKey {
        private static final long serialVersionUID = -8409143207943258659L;
        private long bits0;
        private long bits1;

        private Mid128() {
        }

        private Mid128(Mid128 mid) {
            this.bits0 = mid.bits0;
            this.bits1 = mid.bits1;
        }

        @Override
        public void set(int pos) {
            if (pos < 64) {
                this.bits0 |= Mid128.bit(pos);
            } else if (pos < 128) {
                this.bits1 |= Mid128.bit(pos);
            } else {
                throw new IllegalArgumentException("pos " + pos + " exceeds capacity 128");
            }
        }

        @Override
        public boolean get(int pos) {
            if (pos < 64) {
                return (this.bits0 & Mid128.bit(pos)) != 0L;
            }
            if (pos < 128) {
                return (this.bits1 & Mid128.bit(pos)) != 0L;
            }
            return false;
        }

        @Override
        public void clear(int pos) {
            if (pos < 64) {
                this.bits0 &= Mid128.bit(pos) ^ 0xFFFFFFFFFFFFFFFFL;
            } else if (pos < 128) {
                this.bits1 &= Mid128.bit(pos) ^ 0xFFFFFFFFFFFFFFFFL;
            } else {
                throw new IndexOutOfBoundsException("pos " + pos + " exceeds size " + 128);
            }
        }

        @Override
        public void clear() {
            this.bits0 = 0L;
            this.bits1 = 0L;
        }

        @Override
        public int cardinality() {
            return Mid128.bitCount(this.bits0) + Mid128.bitCount(this.bits1);
        }

        private void or(long bits0, long bits1) {
            this.bits0 |= bits0;
            this.bits1 |= bits1;
        }

        private void orNot(long bits0, long bits1) {
            this.bits0 ^= bits0;
            this.bits1 ^= bits1;
        }

        private void and(long bits0, long bits1) {
            this.bits0 &= bits0;
            this.bits1 &= bits1;
        }

        @Override
        public BitKey or(BitKey bitKey) {
            if (bitKey instanceof Small) {
                Small other = (Small)bitKey;
                Mid128 bk = (Mid128)this.copy();
                bk.or(other.bits, 0L);
                return bk;
            }
            if (bitKey instanceof Mid128) {
                Mid128 other = (Mid128)bitKey;
                Mid128 bk = (Mid128)this.copy();
                bk.or(other.bits0, other.bits1);
                return bk;
            }
            if (bitKey instanceof Big) {
                Big other = (Big)bitKey;
                Big bk = (Big)other.copy();
                bk.or(this.bits0, this.bits1);
                return bk;
            }
            throw this.createException(bitKey);
        }

        @Override
        public BitKey orNot(BitKey bitKey) {
            if (bitKey instanceof Small) {
                Small other = (Small)bitKey;
                Mid128 bk = (Mid128)this.copy();
                bk.orNot(other.bits, 0L);
                return bk;
            }
            if (bitKey instanceof Mid128) {
                Mid128 other = (Mid128)bitKey;
                Mid128 bk = (Mid128)this.copy();
                bk.orNot(other.bits0, other.bits1);
                return bk;
            }
            if (bitKey instanceof Big) {
                Big other = (Big)bitKey;
                Big bk = (Big)other.copy();
                bk.orNot(this.bits0, this.bits1);
                return bk;
            }
            throw this.createException(bitKey);
        }

        @Override
        public BitKey and(BitKey bitKey) {
            if (bitKey instanceof Small) {
                Small other = (Small)bitKey;
                Mid128 bk = (Mid128)this.copy();
                bk.and(other.bits, 0L);
                return bk;
            }
            if (bitKey instanceof Mid128) {
                Mid128 other = (Mid128)bitKey;
                Mid128 bk = (Mid128)this.copy();
                bk.and(other.bits0, other.bits1);
                return bk;
            }
            if (bitKey instanceof Big) {
                Big other = (Big)bitKey;
                Mid128 bk = (Mid128)this.copy();
                bk.and(other.bits[0], other.bits[1]);
                return bk;
            }
            throw this.createException(bitKey);
        }

        @Override
        public BitKey andNot(BitKey bitKey) {
            if (bitKey instanceof Small) {
                Small other = (Small)bitKey;
                Mid128 bk = (Mid128)this.copy();
                bk.andNot(other.bits, 0L);
                return bk;
            }
            if (bitKey instanceof Mid128) {
                Mid128 other = (Mid128)bitKey;
                Mid128 bk = (Mid128)this.copy();
                bk.andNot(other.bits0, other.bits1);
                return bk;
            }
            if (bitKey instanceof Big) {
                Big other = (Big)bitKey;
                Mid128 bk = (Mid128)this.copy();
                bk.andNot(other.bits[0], other.bits[1]);
                return bk;
            }
            throw this.createException(bitKey);
        }

        private void andNot(long bits0, long bits1) {
            this.bits0 &= bits0 ^ 0xFFFFFFFFFFFFFFFFL;
            this.bits1 &= bits1 ^ 0xFFFFFFFFFFFFFFFFL;
        }

        @Override
        public boolean isSuperSetOf(BitKey bitKey) {
            if (bitKey instanceof Small) {
                Small other = (Small)bitKey;
                return (this.bits0 | other.bits) == this.bits0;
            }
            if (bitKey instanceof Mid128) {
                Mid128 other = (Mid128)bitKey;
                return (this.bits0 | other.bits0) == this.bits0 && (this.bits1 | other.bits1) == this.bits1;
            }
            if (bitKey instanceof Big) {
                Big other = (Big)bitKey;
                if ((this.bits0 | other.bits[0]) != this.bits0) {
                    return false;
                }
                if ((this.bits1 | other.bits[1]) != this.bits1) {
                    return false;
                }
                int i = 2;
                while (i < other.bits.length) {
                    if (other.bits[i] != 0L) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
            return false;
        }

        @Override
        public boolean intersects(BitKey bitKey) {
            if (bitKey instanceof Small) {
                Small other = (Small)bitKey;
                return (this.bits0 & other.bits) != 0L;
            }
            if (bitKey instanceof Mid128) {
                Mid128 other = (Mid128)bitKey;
                return (this.bits0 & other.bits0) != 0L || (this.bits1 & other.bits1) != 0L;
            }
            if (bitKey instanceof Big) {
                Big other = (Big)bitKey;
                if ((this.bits0 & other.bits[0]) != 0L) {
                    return true;
                }
                return (this.bits1 & other.bits[1]) != 0L;
            }
            return false;
        }

        @Override
        public BitSet toBitSet() {
            BitSet bitSet = new BitSet(128);
            Mid128.copyFromLong(bitSet, 0, this.bits0);
            Mid128.copyFromLong(bitSet, 64, this.bits1);
            return bitSet;
        }

        @Override
        public Iterator<Integer> iterator() {
            return new Iterator<Integer>(){
                long bits0;
                long bits1;
                int pos;
                {
                    this.bits0 = Mid128.this.bits0;
                    this.bits1 = Mid128.this.bits1;
                    this.pos = -1;
                }

                @Override
                public boolean hasNext() {
                    if (this.bits0 != 0L) {
                        if (this.bits0 == Long.MIN_VALUE) {
                            this.pos = 63;
                            this.bits0 = 0L;
                            return true;
                        }
                        long b = this.bits0 & -this.bits0;
                        int delta = 0;
                        while (b >= 256L) {
                            b >>= 8;
                            delta += 8;
                        }
                        int p = bitPositionTable[(int)b];
                        p = p >= 0 ? (p += delta) : delta;
                        this.pos = this.pos < 0 ? p : (p == 0 ? ++this.pos : (this.pos += p + 1));
                        this.bits0 >>>= p + 1;
                        return true;
                    }
                    if (this.pos < 63) {
                        this.pos = 63;
                    }
                    if (this.bits1 == Long.MIN_VALUE) {
                        this.pos = 127;
                        this.bits1 = 0L;
                        return true;
                    }
                    long b = this.bits1 & -this.bits1;
                    if (b == 0L) {
                        return false;
                    }
                    int delta = 0;
                    while (b >= 256L) {
                        b >>= 8;
                        delta += 8;
                    }
                    int p = bitPositionTable[(int)b];
                    p = p >= 0 ? (p += delta) : delta;
                    this.pos = this.pos < 0 ? p : (p == 63 ? ++this.pos : (this.pos += p + 1));
                    this.bits1 >>>= p + 1;
                    return true;
                }

                @Override
                public Integer next() {
                    return this.pos;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("remove");
                }
            };
        }

        @Override
        public int nextSetBit(int fromIndex) {
            if (fromIndex < 0) {
                throw new IndexOutOfBoundsException("fromIndex < 0: " + fromIndex);
            }
            int u = fromIndex >> 6;
            switch (u) {
                case 0: {
                    long word = this.bits0 & -1L << fromIndex;
                    if (word != 0L) {
                        return Long.numberOfTrailingZeros(word);
                    }
                    word = this.bits1;
                    if (word != 0L) {
                        return 64 + Long.numberOfTrailingZeros(word);
                    }
                    return -1;
                }
                case 1: {
                    long word = this.bits1 & -1L << fromIndex;
                    if (word != 0L) {
                        return 64 + Long.numberOfTrailingZeros(word);
                    }
                    return -1;
                }
            }
            return -1;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof Small) {
                Small other = (Small)o;
                return this.bits0 == other.bits && this.bits1 == 0L;
            }
            if (o instanceof Mid128) {
                Mid128 other = (Mid128)o;
                return this.bits0 == other.bits0 && this.bits1 == other.bits1;
            }
            if (o instanceof Big) {
                Big other = (Big)o;
                if (this.bits0 != other.bits[0]) {
                    return false;
                }
                if (this.bits1 != other.bits[1]) {
                    return false;
                }
                int i = 2;
                while (i < other.bits.length) {
                    if (other.bits[i] != 0L) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
            return false;
        }

        public int hashCode() {
            long h = 1234L;
            h ^= this.bits0;
            return (int)((h ^= this.bits1 * 2L) >> 32 ^ h);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(64);
            buf.append("0x");
            int i = 127;
            while (i >= 0) {
                buf.append(this.get(i) ? (char)'1' : '0');
                --i;
            }
            return buf.toString();
        }

        @Override
        public BitKey copy() {
            return new Mid128(this);
        }

        @Override
        public BitKey emptyCopy() {
            return new Mid128();
        }

        @Override
        public boolean isEmpty() {
            return this.bits0 == 0L && this.bits1 == 0L;
        }

        @Override
        public int compareTo(BitKey bitKey) {
            if (bitKey instanceof Mid128) {
                Mid128 that = (Mid128)bitKey;
                if (this.bits1 != that.bits1) {
                    return Mid128.compareUnsigned(this.bits1, that.bits1);
                }
                return Mid128.compareUnsigned(this.bits0, that.bits0);
            }
            if (bitKey instanceof Small) {
                Small that = (Small)bitKey;
                if (this.bits1 != 0L) {
                    return 1;
                }
                return Mid128.compareUnsigned(this.bits0, that.bits);
            }
            return this.compareToBig((Big)bitKey);
        }

        int compareToBig(Big that) {
            int thatBitsLength = that.effectiveSize();
            switch (thatBitsLength) {
                case 0: {
                    return this.bits1 == 0L && this.bits0 == 0L ? 0 : 1;
                }
                case 1: {
                    if (this.bits1 != 0L) {
                        return 1;
                    }
                    return Mid128.compareUnsigned(this.bits0, that.bits[0]);
                }
                case 2: {
                    if (this.bits1 != that.bits[1]) {
                        return Mid128.compareUnsigned(this.bits1, that.bits[1]);
                    }
                    return Mid128.compareUnsigned(this.bits0, that.bits[0]);
                }
            }
            return -1;
        }

        /* synthetic */ Mid128(Mid128 mid128, Mid128 mid1282) {
            this();
        }
    }

    public static class Small
    extends AbstractBitKey {
        private static final long serialVersionUID = -7891880560056571197L;
        private long bits;

        private Small() {
        }

        private Small(long bits) {
            this.bits = bits;
        }

        @Override
        public void set(int pos) {
            if (pos < 64) {
                this.bits |= Small.bit(pos);
            } else {
                throw new IllegalArgumentException("pos " + pos + " exceeds capacity 64");
            }
        }

        @Override
        public boolean get(int pos) {
            return pos < 64 && (this.bits & Small.bit(pos)) != 0L;
        }

        @Override
        public void clear(int pos) {
            this.bits &= Small.bit(pos) ^ 0xFFFFFFFFFFFFFFFFL;
        }

        @Override
        public void clear() {
            this.bits = 0L;
        }

        @Override
        public int cardinality() {
            return Small.bitCount(this.bits);
        }

        private void or(long bits) {
            this.bits |= bits;
        }

        private void orNot(long bits) {
            this.bits ^= bits;
        }

        private void and(long bits) {
            this.bits &= bits;
        }

        @Override
        public BitKey or(BitKey bitKey) {
            if (bitKey instanceof Small) {
                Small other = (Small)bitKey;
                Small bk = (Small)this.copy();
                bk.or(other.bits);
                return bk;
            }
            if (bitKey instanceof Mid128) {
                Mid128 other = (Mid128)bitKey;
                Mid128 bk = (Mid128)other.copy();
                bk.or(this.bits, 0L);
                return bk;
            }
            if (bitKey instanceof Big) {
                Big other = (Big)bitKey;
                Big bk = (Big)other.copy();
                bk.or(this.bits);
                return bk;
            }
            throw this.createException(bitKey);
        }

        @Override
        public BitKey orNot(BitKey bitKey) {
            if (bitKey instanceof Small) {
                Small other = (Small)bitKey;
                Small bk = (Small)this.copy();
                bk.orNot(other.bits);
                return bk;
            }
            if (bitKey instanceof Mid128) {
                Mid128 other = (Mid128)bitKey;
                Mid128 bk = (Mid128)other.copy();
                bk.orNot(this.bits, 0L);
                return bk;
            }
            if (bitKey instanceof Big) {
                Big other = (Big)bitKey;
                Big bk = (Big)other.copy();
                bk.orNot(this.bits);
                return bk;
            }
            throw this.createException(bitKey);
        }

        @Override
        public BitKey and(BitKey bitKey) {
            if (bitKey instanceof Small) {
                Small other = (Small)bitKey;
                Small bk = (Small)this.copy();
                bk.and(other.bits);
                return bk;
            }
            if (bitKey instanceof Mid128) {
                Mid128 other = (Mid128)bitKey;
                Small bk = (Small)this.copy();
                bk.and(other.bits0);
                return bk;
            }
            if (bitKey instanceof Big) {
                Big other = (Big)bitKey;
                Small bk = (Small)this.copy();
                bk.and(other.bits[0]);
                return bk;
            }
            throw this.createException(bitKey);
        }

        @Override
        public BitKey andNot(BitKey bitKey) {
            if (bitKey instanceof Small) {
                Small other = (Small)bitKey;
                Small bk = (Small)this.copy();
                bk.andNot(other.bits);
                return bk;
            }
            if (bitKey instanceof Mid128) {
                Mid128 other = (Mid128)bitKey;
                Small bk = (Small)this.copy();
                bk.andNot(other.bits0);
                return bk;
            }
            if (bitKey instanceof Big) {
                Big other = (Big)bitKey;
                Small bk = (Small)this.copy();
                bk.andNot(other.bits[0]);
                return bk;
            }
            throw this.createException(bitKey);
        }

        private void andNot(long bits) {
            this.bits &= bits ^ 0xFFFFFFFFFFFFFFFFL;
        }

        @Override
        public boolean isSuperSetOf(BitKey bitKey) {
            if (bitKey instanceof Small) {
                Small other = (Small)bitKey;
                return (this.bits | other.bits) == this.bits;
            }
            if (bitKey instanceof Mid128) {
                Mid128 other = (Mid128)bitKey;
                return (this.bits | other.bits0) == this.bits && other.bits1 == 0L;
            }
            if (bitKey instanceof Big) {
                Big other = (Big)bitKey;
                if ((this.bits | other.bits[0]) != this.bits) {
                    return false;
                }
                int i = 1;
                while (i < other.bits.length) {
                    if (other.bits[i] != 0L) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
            return false;
        }

        @Override
        public boolean intersects(BitKey bitKey) {
            if (bitKey instanceof Small) {
                Small other = (Small)bitKey;
                return (this.bits & other.bits) != 0L;
            }
            if (bitKey instanceof Mid128) {
                Mid128 other = (Mid128)bitKey;
                return (this.bits & other.bits0) != 0L;
            }
            if (bitKey instanceof Big) {
                Big other = (Big)bitKey;
                return (this.bits & other.bits[0]) != 0L;
            }
            return false;
        }

        @Override
        public BitSet toBitSet() {
            BitSet bitSet = new BitSet(64);
            long x = this.bits;
            int pos = 0;
            while (x != 0L) {
                Small.copyFromByte(bitSet, pos, (byte)(x & 0xFFL));
                x >>>= 8;
                pos += 8;
            }
            return bitSet;
        }

        @Override
        public Iterator<Integer> iterator() {
            return new Iterator<Integer>(){
                int pos = -1;
                long bits;
                {
                    this.bits = Small.this.bits;
                }

                @Override
                public boolean hasNext() {
                    if (this.bits == 0L) {
                        return false;
                    }
                    if (this.bits == Long.MIN_VALUE) {
                        this.pos = 63;
                        this.bits = 0L;
                        return true;
                    }
                    long b = this.bits & -this.bits;
                    if (b == 0L) {
                        return false;
                    }
                    int delta = 0;
                    while (b >= 256L) {
                        b >>= 8;
                        delta += 8;
                    }
                    int p = bitPositionTable[(int)b];
                    p = p >= 0 ? (p += delta) : delta;
                    this.pos = this.pos < 0 ? p : (p == 0 ? ++this.pos : (this.pos += p + 1));
                    this.bits >>>= p + 1;
                    return true;
                }

                @Override
                public Integer next() {
                    return this.pos;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("remove");
                }
            };
        }

        @Override
        public int nextSetBit(int fromIndex) {
            long word;
            if (fromIndex < 0) {
                throw new IndexOutOfBoundsException("fromIndex < 0: " + fromIndex);
            }
            if (fromIndex < 64 && (word = this.bits & -1L << fromIndex) != 0L) {
                return Long.numberOfTrailingZeros(word);
            }
            return -1;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof Small) {
                Small other = (Small)o;
                return this.bits == other.bits;
            }
            if (o instanceof Mid128) {
                Mid128 other = (Mid128)o;
                return this.bits == other.bits0 && other.bits1 == 0L;
            }
            if (o instanceof Big) {
                Big other = (Big)o;
                if (this.bits != other.bits[0]) {
                    return false;
                }
                int i = 1;
                while (i < other.bits.length) {
                    if (other.bits[i] != 0L) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
            return false;
        }

        public int hashCode() {
            return (int)(0x4D2L ^ this.bits ^ this.bits >>> 32);
        }

        @Override
        public int compareTo(BitKey bitKey) {
            if (bitKey instanceof Small) {
                Small that = (Small)bitKey;
                return this.bits == that.bits ? 0 : (this.bits < that.bits ? -1 : 1);
            }
            if (bitKey instanceof Mid128) {
                Mid128 that = (Mid128)bitKey;
                if (that.bits1 != 0L) {
                    return -1;
                }
                return Small.compareUnsigned(this.bits, that.bits0);
            }
            return this.compareToBig((Big)bitKey);
        }

        protected int compareToBig(Big that) {
            int thatBitsLength = that.effectiveSize();
            switch (thatBitsLength) {
                case 0: {
                    return this.bits == 0L ? 0 : 1;
                }
                case 1: {
                    return Small.compareUnsigned(this.bits, that.bits[0]);
                }
            }
            return -1;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(64);
            buf.append("0x");
            int i = 63;
            while (i >= 0) {
                buf.append(this.get(i) ? (char)'1' : '0');
                --i;
            }
            return buf.toString();
        }

        @Override
        public BitKey copy() {
            return new Small(this.bits);
        }

        @Override
        public BitKey emptyCopy() {
            return new Small();
        }

        @Override
        public boolean isEmpty() {
            return this.bits == 0L;
        }
    }
}

