/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import mondrian.olap.MondrianProperties;
import mondrian.olap.Util;
import mondrian.rolap.BatchLoader;
import mondrian.rolap.CellReader;
import mondrian.rolap.RolapAggregationManager;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapEvaluator;
import mondrian.rolap.RolapStar;
import mondrian.rolap.RolapUtil;
import mondrian.rolap.agg.AggregationManager;
import mondrian.rolap.agg.CellRequest;
import mondrian.rolap.agg.CellRequestQuantumExceededException;
import mondrian.rolap.agg.Segment;
import mondrian.rolap.agg.SegmentBuilder;
import mondrian.rolap.agg.SegmentCacheManager;
import mondrian.rolap.agg.SegmentWithData;
import mondrian.rolap.cache.SegmentCacheIndex;
import mondrian.rolap.cache.SegmentCacheIndexImpl;
import mondrian.server.Execution;
import mondrian.server.Locus;
import mondrian.spi.Dialect;
import mondrian.spi.SegmentBody;
import mondrian.spi.SegmentHeader;
import mondrian.util.Pair;
import mondrian.util.SlotFuture;
import org.apache.log4j.Logger;

public class FastBatchingCellReader
implements CellReader {
    private static final Logger LOGGER = Logger.getLogger(FastBatchingCellReader.class);
    private final RolapCube cube;
    private int missCount;
    private int hitCount;
    private int pendingCount;
    private final AggregationManager aggMgr;
    private final SegmentCacheManager cacheMgr;
    private final RolapAggregationManager.PinSet pinnedSegments;
    private boolean dirty;
    private final List<CellRequest> cellRequests = new ArrayList<CellRequest>();

    public FastBatchingCellReader(Execution execution, RolapCube cube, AggregationManager aggMgr) {
        assert (cube != null);
        assert (execution != null);
        this.cube = cube;
        this.aggMgr = aggMgr;
        this.cacheMgr = aggMgr.cacheMgr;
        this.pinnedSegments = this.aggMgr.createPinSet();
    }

    @Override
    public Object get(RolapEvaluator evaluator) {
        SegmentWithData segmentWithData;
        CellRequest request = RolapAggregationManager.makeRequest(evaluator);
        if (request == null || request.isUnsatisfiable()) {
            return Util.nullValue;
        }
        Object o = this.aggMgr.getCellFromCache(request, this.pinnedSegments);
        assert (o != Boolean.TRUE) : "getCellFromCache no longer returns TRUE";
        if (o != null) {
            ++this.hitCount;
            return o;
        }
        if (!MondrianProperties.instance().DisableCaching.get() && this.missCount == 0 && (segmentWithData = this.cacheMgr.peek(request)) != null) {
            segmentWithData.getStar().register(segmentWithData);
            Object o2 = this.aggMgr.getCellFromCache(request, this.pinnedSegments);
            if (o2 != null) {
                ++this.hitCount;
                return o2;
            }
        }
        this.recordCellRequest(request);
        return RolapUtil.valueNotReadyException;
    }

    @Override
    public int getMissCount() {
        return this.missCount;
    }

    public int getHitCount() {
        return this.hitCount;
    }

    public int getPendingCount() {
        return this.pendingCount;
    }

    public final void recordCellRequest(CellRequest request) {
        assert (!request.isUnsatisfiable());
        ++this.missCount;
        this.cellRequests.add(request);
        int limit = MondrianProperties.instance().CellBatchSize.get();
        if (limit <= 0) {
            limit = 5000;
        }
        if (this.cellRequests.size() % limit == 0) {
            throw CellRequestQuantumExceededException.INSTANCE;
        }
    }

    @Override
    public boolean isDirty() {
        return this.dirty || !this.cellRequests.isEmpty();
    }

    boolean loadAggregations() {
        if (!this.isDirty()) {
            return false;
        }
        ArrayList<Future<Map<Segment, SegmentWithData>>> sqlSegmentMapFutures = new ArrayList<Future<Map<Segment, SegmentWithData>>>();
        ArrayList<CellRequest> cellRequests1 = new ArrayList<CellRequest>(this.cellRequests);
        int iteration = 0;
        while (true) {
            final BatchLoader.LoadBatchResponse response = this.cacheMgr.execute(new BatchLoader.LoadBatchCommand(Locus.peek(), this.cacheMgr, this.getDialect(), this.cube, Collections.unmodifiableList(cellRequests1)));
            int failureCount = 0;
            HashMap<SegmentHeader, SegmentBody> headerBodies = new HashMap<SegmentHeader, SegmentBody>();
            for (SegmentHeader header : response.cacheSegments) {
                SegmentBody body = this.cacheMgr.compositeCache.get(header);
                if (body == null) {
                    if (this.cube.getStar() != null) {
                        this.cacheMgr.remove(this.cube.getStar(), header);
                    }
                    ++failureCount;
                    continue;
                }
                headerBodies.put(header, body);
                SegmentWithData segmentWithData = response.convert(header, body);
                segmentWithData.getStar().register(segmentWithData);
            }
            HashMap<SegmentHeader, SegmentBody> succeededRollups = new HashMap<SegmentHeader, SegmentBody>();
            for (BatchLoader.RollupInfo rollupInfo : response.rollups) {
                Map<SegmentHeader, SegmentBody> map = this.findResidentRollupCandidate(headerBodies, rollupInfo);
                if (map == null) continue;
                HashSet<String> keepColumns = new HashSet<String>();
                RolapStar.Column[] columnArray = rollupInfo.constrainedColumns;
                int n = rollupInfo.constrainedColumns.length;
                int n2 = 0;
                while (n2 < n) {
                    RolapStar.Column column = columnArray[n2];
                    keepColumns.add(column.getExpression().getGenericExpression());
                    ++n2;
                }
                Pair<SegmentHeader, SegmentBody> rollupHeaderBody = SegmentBuilder.rollup(map, keepColumns, rollupInfo.constrainedColumnsBitKey, rollupInfo.measure.getAggregator().getRollup(), rollupInfo.measure.getDatatype());
                SegmentHeader header = (SegmentHeader)rollupHeaderBody.left;
                final SegmentBody body = (SegmentBody)rollupHeaderBody.right;
                if (headerBodies.containsKey(header)) continue;
                headerBodies.put(header, body);
                succeededRollups.put(header, body);
                final SegmentWithData segmentWithData = response.convert(header, body);
                segmentWithData.getStar().register(segmentWithData);
                if (MondrianProperties.instance().DisableCaching.get()) continue;
                final Locus locus = Locus.peek();
                this.cacheMgr.execute(new SegmentCacheManager.Command<Void>(){

                    @Override
                    public Void call() throws Exception {
                        SegmentCacheIndex index = FastBatchingCellReader.this.cacheMgr.getIndexRegistry().getIndex(segmentWithData.getStar());
                        boolean added = index.add(segmentWithData.getHeader(), true, response.converterMap.get(SegmentCacheIndexImpl.makeConverterKey(segmentWithData.getHeader())));
                        if (added) {
                            ((SlotFuture)index.getFuture(segmentWithData.getHeader())).put(body);
                        }
                        return null;
                    }

                    @Override
                    public Locus getLocus() {
                        return locus;
                    }
                });
            }
            sqlSegmentMapFutures.addAll(response.sqlSegmentMapFutures);
            if (failureCount == 0 || iteration > 0) {
                for (Map.Entry<SegmentHeader, Future<SegmentBody>> entry : response.futures.entrySet()) {
                    SegmentHeader header = entry.getKey();
                    Future<SegmentBody> bodyFuture = entry.getValue();
                    SegmentBody body = Util.safeGet(bodyFuture, "Waiting for someone else's segment to load via SQL");
                    SegmentWithData segmentWithData = response.convert(header, body);
                    segmentWithData.getStar().register(segmentWithData);
                }
                for (Future future : sqlSegmentMapFutures) {
                    Map segmentMap = (Map)Util.safeGet(future, "Waiting for segment to load via SQL");
                    for (SegmentWithData segmentWithData : segmentMap.values()) {
                        segmentWithData.getStar().register(segmentWithData);
                    }
                }
            }
            if (failureCount == 0) break;
            ArrayList<CellRequest> arrayList = new ArrayList<CellRequest>(cellRequests1);
            cellRequests1.clear();
            for (CellRequest cellRequest : arrayList) {
                if (cellRequest.getMeasure().getStar().getCellFromCache(cellRequest, null) != null) continue;
                cellRequests1.add(cellRequest);
            }
            if (cellRequests1.isEmpty()) break;
            if (cellRequests1.size() >= arrayList.size() && iteration > 10) {
                throw Util.newError("Cache round-trip did not resolve any cell requests. Iteration #" + iteration + "; request count " + cellRequests1.size() + "; requested headers: " + response.cacheSegments.size() + "; requested rollups: " + response.rollups.size() + "; requested SQL: " + response.sqlSegmentMapFutures.size());
            }
            ++iteration;
        }
        this.dirty = false;
        this.cellRequests.clear();
        return true;
    }

    private Map<SegmentHeader, SegmentBody> findResidentRollupCandidate(Map<SegmentHeader, SegmentBody> headerBodies, BatchLoader.RollupInfo rollup) {
        block0: for (List<SegmentHeader> headers : rollup.candidateLists) {
            HashMap<SegmentHeader, SegmentBody> map = new HashMap<SegmentHeader, SegmentBody>();
            for (SegmentHeader header : headers) {
                SegmentBody body = this.loadSegmentFromCache(headerBodies, header);
                if (body == null) continue block0;
                map.put(header, body);
            }
            return map;
        }
        return null;
    }

    private SegmentBody loadSegmentFromCache(Map<SegmentHeader, SegmentBody> headerBodies, SegmentHeader header) {
        SegmentBody body = headerBodies.get(header);
        if (body != null) {
            return body;
        }
        body = this.cacheMgr.compositeCache.get(header);
        if (body == null) {
            if (this.cube.getStar() != null) {
                this.cacheMgr.remove(this.cube.getStar(), header);
            }
            return null;
        }
        headerBodies.put(header, body);
        return body;
    }

    Dialect getDialect() {
        RolapStar star = this.cube.getStar();
        if (star != null) {
            return star.getSqlQueryDialect();
        }
        return this.cube.getSchema().getDialect();
    }

    void setDirty(boolean dirty) {
        this.dirty = dirty;
    }
}

