/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import mondrian.olap.Level;
import mondrian.olap.MondrianDef;
import mondrian.olap.MondrianProperties;
import mondrian.olap.Util;
import mondrian.resource.MondrianResource;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapHierarchy;
import mondrian.rolap.RolapLevel;
import org.apache.log4j.Logger;

public class HierarchyUsage {
    private static final Logger LOGGER = Logger.getLogger(HierarchyUsage.class);
    protected final MondrianDef.Relation fact;
    private final String hierarchyName;
    private final String name;
    private final String fullName;
    private final String foreignKey;
    private final String source;
    private final String usagePrefix;
    private final String level;
    private MondrianDef.Relation joinTable;
    private MondrianDef.Expression joinExp;
    private final Kind kind;

    HierarchyUsage(RolapCube cube, RolapHierarchy hierarchy, MondrianDef.CubeDimension cubeDim) {
        assert (cubeDim != null) : "precondition: cubeDim != null";
        this.fact = cube.fact;
        this.name = cubeDim.name;
        this.foreignKey = cubeDim.foreignKey;
        if (cubeDim instanceof MondrianDef.DimensionUsage) {
            this.kind = Kind.SHARED;
            MondrianDef.DimensionUsage du = (MondrianDef.DimensionUsage)cubeDim;
            this.hierarchyName = this.deriveHierarchyName(hierarchy);
            int index = this.hierarchyName.indexOf(46);
            if (index == -1) {
                this.fullName = this.name;
                this.source = du.source;
            } else {
                String hname = this.hierarchyName.substring(index + 1, this.hierarchyName.length());
                StringBuilder buf = new StringBuilder(32);
                buf.append(this.name);
                buf.append('.');
                buf.append(hname);
                this.fullName = buf.toString();
                buf.setLength(0);
                buf.append(du.source);
                buf.append('.');
                buf.append(hname);
                this.source = buf.toString();
            }
            this.level = du.level;
            this.usagePrefix = du.usagePrefix;
            this.init(cube, hierarchy, du);
        } else if (cubeDim instanceof MondrianDef.Dimension) {
            this.kind = Kind.PRIVATE;
            MondrianDef.Dimension d = (MondrianDef.Dimension)cubeDim;
            this.hierarchyName = this.deriveHierarchyName(hierarchy);
            this.fullName = this.name;
            this.source = null;
            this.usagePrefix = d.usagePrefix;
            this.level = null;
            this.init(cube, hierarchy, null);
        } else if (cubeDim instanceof MondrianDef.VirtualCubeDimension) {
            this.kind = Kind.VIRTUAL;
            MondrianDef.VirtualCubeDimension vd = (MondrianDef.VirtualCubeDimension)cubeDim;
            this.hierarchyName = cubeDim.name;
            this.fullName = this.name;
            this.source = null;
            this.usagePrefix = null;
            this.level = null;
            this.init(cube, hierarchy, null);
        } else {
            this.getLogger().warn((Object)("HierarchyUsage<init>: Unknown cubeDim=" + ((Object)((Object)cubeDim)).getClass().getName()));
            this.kind = Kind.UNKNOWN;
            this.hierarchyName = cubeDim.name;
            this.fullName = this.name;
            this.source = null;
            this.usagePrefix = null;
            this.level = null;
            this.init(cube, hierarchy, null);
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)(String.valueOf(this.toString()) + ", cubeDim=" + ((Object)((Object)cubeDim)).getClass().getName()));
        }
    }

    private String deriveHierarchyName(RolapHierarchy hierarchy) {
        String name = hierarchy.getName();
        if (!MondrianProperties.instance().SsasCompatibleNaming.get()) {
            return name;
        }
        String dimensionName = hierarchy.getDimension().getName();
        if (name == null || name.equals("") || name.equals(dimensionName)) {
            return name;
        }
        return String.valueOf(dimensionName) + '.' + name;
    }

    protected Logger getLogger() {
        return LOGGER;
    }

    public String getHierarchyName() {
        return this.hierarchyName;
    }

    public String getFullName() {
        return this.fullName;
    }

    public String getName() {
        return this.name;
    }

    public String getForeignKey() {
        return this.foreignKey;
    }

    public String getSource() {
        return this.source;
    }

    public String getLevelName() {
        return this.level;
    }

    public String getUsagePrefix() {
        return this.usagePrefix;
    }

    public MondrianDef.Relation getJoinTable() {
        return this.joinTable;
    }

    public MondrianDef.Expression getJoinExp() {
        return this.joinExp;
    }

    public Kind getKind() {
        return this.kind;
    }

    public boolean isShared() {
        return this.kind == Kind.SHARED;
    }

    public boolean isVirtual() {
        return this.kind == Kind.VIRTUAL;
    }

    public boolean isPrivate() {
        return this.kind == Kind.PRIVATE;
    }

    public boolean equals(Object o) {
        if (o instanceof HierarchyUsage) {
            HierarchyUsage other = (HierarchyUsage)o;
            return this.kind == other.kind && Util.equals((Object)this.fact, (Object)other.fact) && this.hierarchyName.equals(other.hierarchyName) && Util.equalName(this.name, other.name) && Util.equalName(this.source, other.source) && Util.equalName(this.foreignKey, other.foreignKey);
        }
        return false;
    }

    public int hashCode() {
        int h = this.fact.hashCode();
        h = Util.hash(h, this.hierarchyName);
        h = Util.hash(h, this.name);
        h = Util.hash(h, this.source);
        h = Util.hash(h, this.foreignKey);
        return h;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(100);
        buf.append("HierarchyUsage: ");
        buf.append("kind=");
        buf.append(this.kind.name());
        buf.append(", hierarchyName=");
        buf.append(this.hierarchyName);
        buf.append(", fullName=");
        buf.append(this.fullName);
        buf.append(", foreignKey=");
        buf.append(this.foreignKey);
        buf.append(", source=");
        buf.append(this.source);
        buf.append(", level=");
        buf.append(this.level);
        buf.append(", name=");
        buf.append(this.name);
        return buf.toString();
    }

    void init(RolapCube cube, RolapHierarchy hierarchy, MondrianDef.DimensionUsage cubeDim) {
        if (cubeDim != null && cubeDim.level != null) {
            RolapLevel joinLevel = (RolapLevel)Util.lookupHierarchyLevel(hierarchy, cubeDim.level);
            if (joinLevel == null) {
                throw MondrianResource.instance().DimensionUsageHasUnknownLevel.ex(hierarchy.getUniqueName(), cube.getName(), cubeDim.level);
            }
            this.joinTable = this.findJoinTable(hierarchy, joinLevel.getKeyExp().getTableAlias());
            this.joinExp = joinLevel.getKeyExp();
        } else if (hierarchy.getXmlHierarchy() != null && hierarchy.getXmlHierarchy().primaryKey != null) {
            this.joinTable = this.findJoinTable(hierarchy, hierarchy.getXmlHierarchy().primaryKeyTable);
            this.joinExp = new MondrianDef.Column(this.joinTable.getAlias(), hierarchy.getXmlHierarchy().primaryKey);
        } else {
            Level[] levels = hierarchy.getLevels();
            RolapLevel joinLevel = (RolapLevel)levels[levels.length - 1];
            this.joinTable = this.findJoinTable(hierarchy, joinLevel.getKeyExp().getTableAlias());
            this.joinExp = joinLevel.getKeyExp();
        }
        boolean inFactTable = this.joinTable.equals((Object)cube.getFact());
        if (!inFactTable) {
            if (this.joinExp == null) {
                throw MondrianResource.instance().MustSpecifyPrimaryKeyForHierarchy.ex(hierarchy.getUniqueName(), cube.getName());
            }
            if (this.foreignKey == null) {
                throw MondrianResource.instance().MustSpecifyForeignKeyForHierarchy.ex(hierarchy.getUniqueName(), cube.getName());
            }
        }
    }

    private MondrianDef.Relation findJoinTable(RolapHierarchy hierarchy, String tableName) {
        MondrianDef.Relation table;
        if (tableName == null) {
            table = hierarchy.getUniqueTable();
            if (table == null) {
                throw MondrianResource.instance().MustSpecifyPrimaryKeyTableForHierarchy.ex(hierarchy.getUniqueName());
            }
        } else {
            table = hierarchy.getRelation().find(tableName);
            if (table == null) {
                throw Util.newError("no table '" + tableName + "' found in hierarchy " + hierarchy.getUniqueName());
            }
        }
        return table;
    }

    static enum Kind {
        UNKNOWN,
        SHARED,
        VIRTUAL,
        PRIVATE;

    }
}

