/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import mondrian.olap.Level;
import mondrian.olap.Util;
import mondrian.rolap.DefaultMemberChildrenConstraint;
import mondrian.rolap.MemberCache;
import mondrian.rolap.MemberKey;
import mondrian.rolap.RolapHierarchy;
import mondrian.rolap.RolapLevel;
import mondrian.rolap.RolapMember;
import mondrian.rolap.SmartMemberListCache;
import mondrian.rolap.SqlConstraintFactory;
import mondrian.rolap.cache.SmartCache;
import mondrian.rolap.cache.SoftSmartCache;
import mondrian.rolap.sql.MemberChildrenConstraint;
import mondrian.rolap.sql.TupleConstraint;
import mondrian.spi.DataSourceChangeListener;
import mondrian.util.Pair;

public class MemberCacheHelper
implements MemberCache {
    private final SqlConstraintFactory sqlConstraintFactory = SqlConstraintFactory.instance();
    final SmartMemberListCache<RolapMember, List<RolapMember>> mapMemberToChildren;
    SmartCache<Object, RolapMember> mapKeyToMember;
    RolapHierarchy rolapHierarchy;
    DataSourceChangeListener changeListener;
    final SmartMemberListCache<RolapLevel, List<RolapMember>> mapLevelToMembers;
    final Map<Object, List<RolapMember>> mapkeyToChildren;

    public MemberCacheHelper(RolapHierarchy rolapHierarchy) {
        this.rolapHierarchy = rolapHierarchy;
        this.mapLevelToMembers = new SmartMemberListCache();
        this.mapKeyToMember = new SoftSmartCache<Object, RolapMember>();
        this.mapMemberToChildren = new SmartMemberListCache();
        this.mapkeyToChildren = new HashMap<Object, List<RolapMember>>();
        this.changeListener = rolapHierarchy != null ? rolapHierarchy.getRolapSchema().getDataSourceChangeListener() : null;
    }

    @Override
    public RolapMember getMember(Object key, boolean mustCheckCacheStatus) {
        if (mustCheckCacheStatus) {
            this.checkCacheStatus();
        }
        return this.mapKeyToMember.get(key);
    }

    @Override
    public Object putMember(Object key, RolapMember value) {
        return this.mapKeyToMember.put(key, value);
    }

    @Override
    public Object makeKey(RolapMember parent, Object key) {
        return new MemberKey(parent, key);
    }

    @Override
    public RolapMember getMember(Object key) {
        return this.getMember(key, true);
    }

    public synchronized void checkCacheStatus() {
        if (this.changeListener != null && this.changeListener.isHierarchyChanged(this.rolapHierarchy)) {
            this.flushCache();
        }
    }

    @Deprecated
    public void putLevelMembersInCache(RolapLevel level, TupleConstraint constraint, List<RolapMember> members) {
        this.putChildren(level, constraint, members);
    }

    @Override
    public void putChildren(RolapLevel level, TupleConstraint constraint, List<RolapMember> members) {
        this.mapLevelToMembers.put(level, constraint, members);
    }

    @Override
    public List<RolapMember> getChildrenFromCache(RolapMember member, MemberChildrenConstraint constraint) {
        if (constraint == null) {
            constraint = this.sqlConstraintFactory.getMemberChildrenConstraint(null);
        }
        return this.mapMemberToChildren.get(member, constraint);
    }

    @Override
    public void putChildrenFromCacheBykey(Object key, MemberChildrenConstraint constraint, List<RolapMember> members) {
        this.mapkeyToChildren.put(key, members);
    }

    @Override
    public List<RolapMember> getChildrenFromCacheBykey(Object key, MemberChildrenConstraint constraint) {
        if (constraint == null) {
            constraint = this.sqlConstraintFactory.getMemberChildrenConstraint(null);
        }
        return this.mapkeyToChildren.get(key);
    }

    @Override
    public void putChildren(RolapMember member, MemberChildrenConstraint constraint, List<RolapMember> children) {
        if (constraint == null) {
            constraint = this.sqlConstraintFactory.getMemberChildrenConstraint(null);
        }
        this.mapMemberToChildren.put(member, constraint, children);
    }

    @Override
    public List<RolapMember> getLevelMembersFromCache(RolapLevel level, TupleConstraint constraint) {
        if (constraint == null) {
            constraint = this.sqlConstraintFactory.getLevelMembersConstraint(null);
        }
        return this.mapLevelToMembers.get(level, constraint);
    }

    public synchronized void flushCache() {
        this.mapMemberToChildren.clear();
        this.mapKeyToMember.clear();
        this.mapLevelToMembers.clear();
        Level[] levelArray = this.rolapHierarchy.getLevels();
        int n = levelArray.length;
        int n2 = 0;
        while (n2 < n) {
            Level level = levelArray[n2];
            ((RolapLevel)level).setApproxRowCount(Integer.MIN_VALUE);
            ++n2;
        }
    }

    public DataSourceChangeListener getChangeListener() {
        return this.changeListener;
    }

    public void setChangeListener(DataSourceChangeListener listener) {
        this.changeListener = listener;
    }

    @Override
    public boolean isMutable() {
        return true;
    }

    @Override
    public synchronized RolapMember removeMember(Object key) {
        RolapLevel level = ((MemberKey)key).getLevel();
        if (level == null) {
            level = (RolapLevel)this.rolapHierarchy.getLevels()[0];
        }
        final RolapLevel levelRef = level;
        this.mapLevelToMembers.getCache().execute(new SmartCache.SmartCacheTask<Pair<RolapLevel, Object>, List<RolapMember>>(){

            @Override
            public void execute(Iterator<Map.Entry<Pair<RolapLevel, Object>, List<RolapMember>>> iterator) {
                while (iterator.hasNext()) {
                    Map.Entry<Pair<RolapLevel, Object>, List<RolapMember>> entry = iterator.next();
                    RolapLevel cacheLevel = (RolapLevel)entry.getKey().left;
                    if (!cacheLevel.equals(levelRef) && (!cacheLevel.getHierarchy().equals(levelRef.getHierarchy()) || cacheLevel.getDepth() < levelRef.getDepth())) continue;
                    iterator.remove();
                }
            }
        });
        final RolapMember member = this.getMember(key);
        if (member == null) {
            return null;
        }
        final RolapMember parent = member.getParentMember();
        this.mapMemberToChildren.cache.execute(new SmartCache.SmartCacheTask<Pair<RolapMember, Object>, List<RolapMember>>(){

            @Override
            public void execute(Iterator<Map.Entry<Pair<RolapMember, Object>, List<RolapMember>>> iter) {
                while (iter.hasNext()) {
                    Map.Entry<Pair<RolapMember, Object>, List<RolapMember>> entry = iter.next();
                    RolapMember member1 = (RolapMember)entry.getKey().left;
                    Object constraint = entry.getKey().right;
                    if (Util.equals(member1, parent)) {
                        if (constraint == DefaultMemberChildrenConstraint.instance()) {
                            List<RolapMember> siblings = entry.getValue();
                            boolean removedIt = siblings.remove(member);
                            Util.discard((boolean)removedIt);
                        } else {
                            iter.remove();
                        }
                    }
                    if (!Util.equals(member1, member)) continue;
                    iter.remove();
                }
            }
        });
        return this.mapKeyToMember.put(key, null);
    }

    @Override
    public RolapMember removeMemberAndDescendants(Object key) {
        return null;
    }
}

