/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mondrian.olap.Access;
import mondrian.olap.Id;
import mondrian.olap.Member;
import mondrian.olap.Util;
import mondrian.rolap.MemberCache;
import mondrian.rolap.MemberKey;
import mondrian.rolap.MemberReader;
import mondrian.rolap.RolapHierarchy;
import mondrian.rolap.RolapLevel;
import mondrian.rolap.RolapMember;
import mondrian.rolap.RolapUtil;
import mondrian.rolap.SqlConstraintFactory;
import mondrian.rolap.TupleReader;
import mondrian.rolap.sql.MemberChildrenConstraint;
import mondrian.rolap.sql.TupleConstraint;
import mondrian.util.ConcatenableList;
import org.apache.log4j.Logger;

public class NoCacheMemberReader
implements MemberReader,
MemberCache {
    private static final Logger LOGGER = Logger.getLogger(NoCacheMemberReader.class);
    private final SqlConstraintFactory sqlConstraintFactory = SqlConstraintFactory.instance();
    private final MemberReader source;

    NoCacheMemberReader(MemberReader source) {
        this.source = source;
        if (!source.setCache(this)) {
            throw Util.newInternal("MemberSource (" + source + ", " + source.getClass() + ") does not support cache-writeback");
        }
    }

    @Override
    public boolean isMutable() {
        return false;
    }

    @Override
    public RolapMember removeMember(Object key) {
        return null;
    }

    @Override
    public RolapMember removeMemberAndDescendants(Object key) {
        return null;
    }

    @Override
    public RolapHierarchy getHierarchy() {
        return this.source.getHierarchy();
    }

    @Override
    public boolean setCache(MemberCache cache) {
        return false;
    }

    @Override
    public Object makeKey(RolapMember parent, Object key) {
        LOGGER.debug((Object)"Entering makeKey");
        return new MemberKey(parent, key);
    }

    @Override
    public synchronized RolapMember getMember(Object key) {
        return this.getMember(key, true);
    }

    @Override
    public RolapMember getMember(Object key, boolean mustCheckCacheStatus) {
        LOGGER.debug((Object)"Returning null member: no cache");
        return null;
    }

    @Override
    public Object putMember(Object key, RolapMember value) {
        LOGGER.debug((Object)"putMember void for no caching");
        return value;
    }

    @Override
    public List<RolapMember> getMembers() {
        RolapLevel[] levels;
        System.out.println("NoCache getMembers");
        ArrayList<RolapMember> v = new ArrayList<RolapMember>();
        RolapLevel[] rolapLevelArray = levels = (RolapLevel[])this.getHierarchy().getLevels();
        int n = levels.length;
        int n2 = 0;
        while (n2 < n) {
            RolapLevel level = rolapLevelArray[n2];
            List<RolapMember> membersInLevel = this.getMembersInLevel(level);
            v.addAll(membersInLevel);
            ++n2;
        }
        return v;
    }

    @Override
    public List<RolapMember> getRootMembers() {
        LOGGER.debug((Object)"Getting root members");
        return this.source.getRootMembers();
    }

    @Override
    public List<RolapMember> getMembersInLevel(RolapLevel level) {
        TupleConstraint constraint = this.sqlConstraintFactory.getLevelMembersConstraint(null);
        return this.getMembersInLevel(level, constraint);
    }

    @Override
    public List<RolapMember> getMembersInLevel(RolapLevel level, TupleConstraint constraint) {
        LOGGER.debug((Object)"Entering getMembersInLevel");
        return this.source.getMembersInLevel(level, constraint);
    }

    @Override
    public RolapMember getMemberByKey(RolapLevel level, List<Comparable> keyValues) {
        return this.source.getMemberByKey(level, keyValues);
    }

    @Override
    public void getMemberChildren(RolapMember parentMember, List<RolapMember> children) {
        MemberChildrenConstraint constraint = this.sqlConstraintFactory.getMemberChildrenConstraint(null);
        this.getMemberChildren(parentMember, children, constraint);
    }

    @Override
    public Map<? extends Member, Access> getMemberChildren(RolapMember parentMember, List<RolapMember> children, MemberChildrenConstraint constraint) {
        ArrayList<RolapMember> parentMembers = new ArrayList<RolapMember>();
        parentMembers.add(parentMember);
        return this.getMemberChildren(parentMembers, children, constraint);
    }

    @Override
    public void getMemberChildren(List<RolapMember> parentMembers, List<RolapMember> children) {
        MemberChildrenConstraint constraint = this.sqlConstraintFactory.getMemberChildrenConstraint(null);
        this.getMemberChildren(parentMembers, children, constraint);
    }

    @Override
    public Map<? extends Member, Access> getMemberChildren(List<RolapMember> parentMembers, List<RolapMember> children, MemberChildrenConstraint constraint) {
        assert (constraint != null);
        LOGGER.debug((Object)"Entering getMemberChildren");
        return this.source.getMemberChildren(parentMembers, children, constraint);
    }

    @Override
    public RolapMember lookupMember(List<Id.Segment> uniqueNameParts, boolean failIfNotFound) {
        return RolapUtil.lookupMember(this, uniqueNameParts, failIfNotFound);
    }

    @Override
    public List<RolapMember> getChildrenFromCache(RolapMember member, MemberChildrenConstraint constraint) {
        return null;
    }

    @Override
    public List<RolapMember> getLevelMembersFromCache(RolapLevel level, TupleConstraint constraint) {
        return null;
    }

    @Override
    public void putChildren(RolapMember member, MemberChildrenConstraint constraint, List<RolapMember> children) {
    }

    @Override
    public void putChildren(RolapLevel level, TupleConstraint constraint, List<RolapMember> children) {
    }

    @Override
    public RolapMember getLeadMember(RolapMember member, int n) {
        if (n == 0 || member.isNull()) {
            return member;
        }
        SiblingIterator iter = new SiblingIterator(this, member);
        if (n > 0) {
            RolapMember sibling = null;
            while (n-- > 0) {
                if (!iter.hasNext()) {
                    return (RolapMember)member.getHierarchy().getNullMember();
                }
                sibling = iter.nextMember();
            }
            return sibling;
        }
        n = -n;
        RolapMember sibling = null;
        while (n-- > 0) {
            if (!iter.hasPrevious()) {
                return (RolapMember)member.getHierarchy().getNullMember();
            }
            sibling = iter.previousMember();
        }
        return sibling;
    }

    @Override
    public void getMemberRange(RolapLevel level, RolapMember startMember, RolapMember endMember, List<RolapMember> list) {
        assert (startMember != null) : "pre";
        assert (endMember != null) : "pre";
        assert (startMember.getLevel() == endMember.getLevel()) : "pre: startMember.getLevel() == endMember.getLevel()";
        if (this.compare(startMember, endMember, false) > 0) {
            return;
        }
        list.add(startMember);
        if (startMember.equals(endMember)) {
            return;
        }
        SiblingIterator siblings = new SiblingIterator(this, startMember);
        while (siblings.hasNext()) {
            RolapMember member = siblings.nextMember();
            list.add(member);
            if (!member.equals(endMember)) continue;
            return;
        }
        throw Util.newInternal("sibling iterator did not hit end point, start=" + startMember + ", end=" + endMember);
    }

    @Override
    public int getMemberCount() {
        return this.source.getMemberCount();
    }

    @Override
    public int compare(RolapMember m1, RolapMember m2, boolean siblingsAreEqual) {
        int levelDepth2;
        if (Util.equals(m1, m2)) {
            return 0;
        }
        if (Util.equals(m1.getParentMember(), m2.getParentMember())) {
            if (siblingsAreEqual) {
                return 0;
            }
            if (m1.getParentMember() == null) {
                int pos1 = -1;
                int pos2 = -1;
                List<RolapMember> siblingList = this.getRootMembers();
                int i = 0;
                int n = siblingList.size();
                while (i < n) {
                    RolapMember child = siblingList.get(i);
                    if (child.equals(m1)) {
                        pos1 = i;
                    }
                    if (child.equals(m2)) {
                        pos2 = i;
                    }
                    ++i;
                }
                if (pos1 == -1) {
                    throw Util.newInternal(m1 + " not found among siblings");
                }
                if (pos2 == -1) {
                    throw Util.newInternal(m2 + " not found among siblings");
                }
                Util.assertTrue(pos1 != pos2);
                return pos1 < pos2 ? -1 : 1;
            }
            ArrayList<RolapMember> children = new ArrayList<RolapMember>();
            this.getMemberChildren(m1.getParentMember(), children);
            int pos1 = -1;
            int pos2 = -1;
            int i = 0;
            int n = children.size();
            while (i < n) {
                RolapMember child = (RolapMember)children.get(i);
                if (child.equals(m1)) {
                    pos1 = i;
                }
                if (child.equals(m2)) {
                    pos2 = i;
                }
                ++i;
            }
            if (pos1 == -1) {
                throw Util.newInternal(m1 + " not found among siblings");
            }
            if (pos2 == -1) {
                throw Util.newInternal(m2 + " not found among siblings");
            }
            assert (pos1 != pos2);
            return pos1 < pos2 ? -1 : 1;
        }
        int levelDepth1 = m1.getLevel().getDepth();
        if (levelDepth1 < (levelDepth2 = m2.getLevel().getDepth())) {
            int c = this.compare(m1, m2.getParentMember(), false);
            return c == 0 ? -1 : c;
        }
        if (levelDepth1 > levelDepth2) {
            int c = this.compare(m1.getParentMember(), m2, false);
            return c == 0 ? 1 : c;
        }
        return this.compare(m1.getParentMember(), m2.getParentMember(), false);
    }

    @Override
    public TupleReader.MemberBuilder getMemberBuilder() {
        return this.source.getMemberBuilder();
    }

    @Override
    public RolapMember getDefaultMember() {
        RolapMember defaultMember = (RolapMember)this.getHierarchy().getDefaultMember();
        if (defaultMember != null) {
            return defaultMember;
        }
        return this.getRootMembers().get(0);
    }

    @Override
    public int getLevelMemberCount(RolapLevel level) {
        return this.source.getLevelMemberCount(level);
    }

    @Override
    public RolapMember desubstitute(RolapMember member) {
        return member;
    }

    @Override
    public RolapMember substitute(RolapMember member) {
        return member;
    }

    @Override
    public RolapMember getMemberParent(RolapMember member) {
        RolapMember parentMember = member.getParentMember();
        while (parentMember != null && parentMember.isHidden()) {
            parentMember = parentMember.getParentMember();
        }
        return parentMember;
    }

    protected void readMemberChildren(List<RolapMember> members, List<RolapMember> result, MemberChildrenConstraint constraint) {
        ConcatenableList<RolapMember> children = new ConcatenableList<RolapMember>();
        this.source.getMemberChildren(members, children, constraint);
        HashMap<RolapMember, List> tempMap = new HashMap<RolapMember, List>();
        for (RolapMember member1 : members) {
            tempMap.put(member1, Collections.EMPTY_LIST);
        }
        for (RolapMember child : children) {
            assert (child != null) : "child";
            RolapMember parentMember = child.getParentMember();
            ArrayList<RolapMember> list = (ArrayList<RolapMember>)tempMap.get(parentMember);
            if (list == null) continue;
            if (list == Collections.EMPTY_LIST) {
                list = new ArrayList<RolapMember>();
                tempMap.put(parentMember, list);
            }
            list.add(child);
            result.add(child);
        }
    }

    @Override
    public void putChildrenFromCacheBykey(Object key, MemberChildrenConstraint constraint, List<RolapMember> members) {
    }

    @Override
    public List<RolapMember> getChildrenFromCacheBykey(Object key, MemberChildrenConstraint constraint) {
        return null;
    }

    class SiblingIterator {
        private final MemberReader reader;
        private final SiblingIterator parentIterator;
        private List<? extends Member> siblings;
        private int position;

        SiblingIterator(MemberReader reader, RolapMember member) {
            List<RolapMember> siblingList;
            this.reader = reader;
            RolapMember parent = member.getParentMember();
            if (parent == null) {
                siblingList = reader.getRootMembers();
                this.parentIterator = null;
            } else {
                siblingList = new ArrayList<RolapMember>();
                reader.getMemberChildren(parent, siblingList);
                this.parentIterator = new SiblingIterator(reader, parent);
            }
            this.siblings = siblingList;
            this.position = -1;
            int i = 0;
            while (i < this.siblings.size()) {
                if (this.siblings.get(i).equals(member)) {
                    this.position = i;
                    break;
                }
                ++i;
            }
            if (this.position == -1) {
                throw Util.newInternal("member " + member + " not found among its siblings");
            }
        }

        boolean hasNext() {
            return this.position < this.siblings.size() - 1 || this.parentIterator != null && this.parentIterator.hasNext();
        }

        Object next() {
            return this.nextMember();
        }

        RolapMember nextMember() {
            if (++this.position >= this.siblings.size()) {
                if (this.parentIterator == null) {
                    throw Util.newInternal("there is no next member");
                }
                RolapMember parent = this.parentIterator.nextMember();
                ArrayList<RolapMember> siblingList = new ArrayList<RolapMember>();
                this.reader.getMemberChildren(parent, siblingList);
                this.siblings = siblingList;
                this.position = 0;
            }
            return (RolapMember)this.siblings.get(this.position);
        }

        boolean hasPrevious() {
            return this.position > 0 || this.parentIterator != null && this.parentIterator.hasPrevious();
        }

        Object previous() {
            return this.previousMember();
        }

        RolapMember previousMember() {
            if (--this.position < 0) {
                if (this.parentIterator == null) {
                    throw Util.newInternal("there is no next member");
                }
                RolapMember parent = this.parentIterator.previousMember();
                ArrayList<RolapMember> siblingList = new ArrayList<RolapMember>();
                this.reader.getMemberChildren(parent, siblingList);
                this.siblings = siblingList;
                this.position = this.siblings.size() - 1;
            }
            return (RolapMember)this.siblings.get(this.position);
        }
    }
}

