/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import mondrian.calc.Calc;
import mondrian.calc.DummyExp;
import mondrian.calc.ExpCompiler;
import mondrian.calc.ResultStyle;
import mondrian.calc.TupleCollections;
import mondrian.calc.TupleList;
import mondrian.calc.impl.DelegatingExpCompiler;
import mondrian.calc.impl.GenericCalc;
import mondrian.calc.impl.GenericIterCalc;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.Hierarchy;
import mondrian.olap.Level;
import mondrian.olap.Member;
import mondrian.olap.MondrianProperties;
import mondrian.olap.SchemaReader;
import mondrian.olap.Util;
import mondrian.olap.type.SetType;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapEvaluator;
import mondrian.rolap.RolapEvaluatorRoot;
import mondrian.rolap.RolapHierarchy;
import mondrian.rolap.RolapMember;
import mondrian.rolap.RolapResult;

public class RolapDependencyTestingEvaluator
extends RolapEvaluator {
    RolapDependencyTestingEvaluator(RolapResult result, int expDeps) {
        super(new DteRoot(result, expDeps));
    }

    private RolapDependencyTestingEvaluator(RolapEvaluatorRoot root, RolapDependencyTestingEvaluator evaluator, List<List<Member>> aggregationList) {
        super(root, evaluator, aggregationList);
    }

    public Object evaluate(Calc calc, Hierarchy[] independentHierarchies, String mdxString) {
        List list;
        DteRoot dteRoot = (DteRoot)this.root;
        if (dteRoot.faking) {
            ++dteRoot.fakeCallCount;
        } else {
            ++dteRoot.callCount;
        }
        Object result = calc.evaluate(this);
        if (dteRoot.result.isDirty()) {
            return result;
        }
        if (calc.getResultStyle() == ResultStyle.MUTABLE_LIST && (list = (List)result).size() > 0) {
            Object zeroth = list.get(0);
            list.set(0, zeroth);
        }
        if (dteRoot.disabled || dteRoot.faking || this.isNonEmpty() || (double)dteRoot.fakeCallCount > (double)dteRoot.callCount * dteRoot.random.nextDouble() * 2.0 * (double)dteRoot.expDeps) {
            return result;
        }
        if (independentHierarchies.length == 0) {
            return result;
        }
        dteRoot.faking = true;
        ++dteRoot.fakeCount;
        ++dteRoot.fakeCallCount;
        int i = dteRoot.random.nextInt(independentHierarchies.length);
        RolapMember saveMember = this.getContext(independentHierarchies[i]);
        Member otherMember = dteRoot.chooseOtherMember(saveMember, this.getQuery().getSchemaReader(false));
        this.setContext(otherMember);
        Object otherResult = calc.evaluate(this);
        if (!this.equals(otherResult, result)) {
            Member[] members = this.getMembers();
            StringBuilder buf = new StringBuilder();
            int j = 0;
            while (j < members.length) {
                if (j > 0) {
                    buf.append(", ");
                }
                buf.append(members[j].getUniqueName());
                ++j;
            }
            throw Util.newInternal("Expression '" + mdxString + "' claims to be independent of dimension " + saveMember.getDimension() + " but is not; context is {" + buf.toString() + "}; First result: " + this.toString(result) + ", Second result: " + this.toString(otherResult));
        }
        this.setContext(saveMember);
        dteRoot.faking = false;
        return result;
    }

    @Override
    public RolapEvaluator _push(List<List<Member>> aggregationList) {
        return new RolapDependencyTestingEvaluator(this.root, this, aggregationList);
    }

    private boolean equals(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        if (o2 == null) {
            return false;
        }
        if (o1 instanceof Object[]) {
            Object[] a2;
            Object[] a1;
            if (o2 instanceof Object[] && (a1 = (Object[])o1).length == (a2 = (Object[])o2).length) {
                int i = 0;
                while (i < a1.length) {
                    if (!this.equals(a1[i], a2[i])) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
            return false;
        }
        if (o1 instanceof List) {
            return o2 instanceof List && this.equals(((List)o1).toArray(), ((List)o2).toArray());
        }
        if (o1 instanceof Iterable) {
            if (o2 instanceof Iterable) {
                return this.equals(this.toList((Iterable)o1), this.toList((Iterable)o2));
            }
            return false;
        }
        return o1.equals(o2);
    }

    private String toString(Object o) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        this.toString(o, pw);
        return sw.toString();
    }

    private <T> List<T> toList(Iterable<T> iterable) {
        ArrayList<T> list = new ArrayList<T>();
        for (T t : iterable) {
            list.add(t);
        }
        return list;
    }

    private void toString(Object o, PrintWriter pw) {
        if (o instanceof Object[]) {
            Object[] a = (Object[])o;
            pw.print("{");
            int i = 0;
            while (i < a.length) {
                Object o1 = a[i];
                if (i > 0) {
                    pw.print(", ");
                }
                this.toString(o1, pw);
                ++i;
            }
            pw.print("}");
        } else if (o instanceof List) {
            List list = (List)o;
            this.toString(list.toArray(), pw);
        } else if (o instanceof Member) {
            Member member = (Member)o;
            pw.print(member.getUniqueName());
        } else {
            pw.print(o);
        }
    }

    static class DteCompiler
    extends DelegatingExpCompiler {
        DteCompiler(ExpCompiler compiler) {
            super(compiler);
        }

        @Override
        protected Calc afterCompile(Exp exp, Calc calc, boolean mutable) {
            Hierarchy[] dimensions = this.getIndependentHierarchies(calc);
            if ((calc = super.afterCompile(exp, calc, mutable)).getType() instanceof SetType) {
                return new DteIterCalcImpl(calc, dimensions, mutable, Util.unparse(exp));
            }
            return new DteScalarCalcImpl(calc, dimensions, Util.unparse(exp));
        }

        private Hierarchy[] getIndependentHierarchies(Calc calc) {
            ArrayList<Hierarchy> list = new ArrayList<Hierarchy>();
            List<RolapHierarchy> hierarchies = ((RolapCube)this.getValidator().getQuery().getCube()).getHierarchies();
            for (Hierarchy hierarchy : hierarchies) {
                if (calc.dependsOn(hierarchy)) continue;
                list.add(hierarchy);
            }
            return list.toArray(new Hierarchy[list.size()]);
        }
    }

    private static class DteIterCalcImpl
    extends GenericIterCalc {
        private final Calc calc;
        private final Hierarchy[] independentHierarchies;
        private final boolean mutableList;
        private final String mdxString;

        DteIterCalcImpl(Calc calc, Hierarchy[] independentHierarchies, boolean mutableList, String mdxString) {
            super(new DummyExp(calc.getType()));
            this.calc = calc;
            this.independentHierarchies = independentHierarchies;
            this.mutableList = mutableList;
            this.mdxString = mdxString;
        }

        @Override
        public Calc[] getCalcs() {
            return new Calc[]{this.calc};
        }

        @Override
        public Object evaluate(Evaluator evaluator) {
            RolapDependencyTestingEvaluator dtEval = (RolapDependencyTestingEvaluator)evaluator;
            return dtEval.evaluate(this.calc, this.independentHierarchies, this.mdxString);
        }

        @Override
        public TupleList evaluateList(Evaluator evaluator) {
            TupleList list = super.evaluateList(evaluator);
            if (!this.mutableList) {
                list = TupleCollections.unmodifiableList(list);
            }
            return list;
        }

        @Override
        public ResultStyle getResultStyle() {
            return this.calc.getResultStyle();
        }
    }

    static class DteRoot
    extends RolapResult.RolapResultEvaluatorRoot {
        final int expDeps;
        int callCount;
        int fakeCallCount;
        int fakeCount;
        boolean faking;
        boolean disabled;
        final Random random;

        DteRoot(RolapResult result, int expDeps) {
            super(result);
            this.random = Util.createRandom(MondrianProperties.instance().TestSeed.get());
            this.expDeps = expDeps;
        }

        private Member chooseOtherMember(Member save, SchemaReader schemaReader) {
            Member member;
            Hierarchy hierarchy = save.getHierarchy();
            int attempt = 0;
            block0: do {
                Level[] levels = hierarchy.getLevels();
                int levelDepth = this.random.nextInt(levels.length) + 1;
                member = null;
                int i = 0;
                while (i < levelDepth) {
                    List<Member> members = i == 0 ? schemaReader.getLevelMembers(levels[i], false) : schemaReader.getMemberChildren(member);
                    if (members.size() == 0) continue block0;
                    member = members.get(this.random.nextInt(members.size()));
                    ++i;
                }
            } while (member == save && ++attempt <= 100);
            return member;
        }
    }

    private static class DteScalarCalcImpl
    extends GenericCalc {
        private final Calc calc;
        private final Hierarchy[] independentHierarchies;
        private final String mdxString;

        DteScalarCalcImpl(Calc calc, Hierarchy[] independentHierarchies, String mdxString) {
            super(new DummyExp(calc.getType()));
            this.calc = calc;
            this.independentHierarchies = independentHierarchies;
            this.mdxString = mdxString;
        }

        @Override
        public Calc[] getCalcs() {
            return new Calc[]{this.calc};
        }

        @Override
        public Object evaluate(Evaluator evaluator) {
            RolapDependencyTestingEvaluator dtEval = (RolapDependencyTestingEvaluator)evaluator;
            return dtEval.evaluate(this.calc, this.independentHierarchies, this.mdxString);
        }

        @Override
        public ResultStyle getResultStyle() {
            return this.calc.getResultStyle();
        }
    }
}

