/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import mondrian.calc.Calc;
import mondrian.calc.ParameterSlot;
import mondrian.olap.Dimension;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.ExpCacheDescriptor;
import mondrian.olap.FunDef;
import mondrian.olap.Hierarchy;
import mondrian.olap.Member;
import mondrian.olap.MondrianProperties;
import mondrian.olap.NamedSet;
import mondrian.olap.Property;
import mondrian.olap.Query;
import mondrian.olap.QueryTiming;
import mondrian.olap.SchemaReader;
import mondrian.olap.Util;
import mondrian.olap.fun.FunUtil;
import mondrian.rolap.CellReader;
import mondrian.rolap.RolapCalculation;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapEvaluatorRoot;
import mondrian.rolap.RolapHierarchy;
import mondrian.rolap.RolapMember;
import mondrian.rolap.RolapMemberBase;
import mondrian.rolap.RolapStoredMeasure;
import mondrian.server.Statement;
import mondrian.spi.Dialect;
import mondrian.util.Format;
import org.apache.log4j.Logger;

public class RolapEvaluator
implements Evaluator {
    private static final Logger LOGGER = Logger.getLogger(RolapEvaluator.class);
    private static final Object nullResult = new Object();
    private final RolapMember[] currentMembers;
    private final RolapEvaluator parent;
    protected CellReader cellReader;
    private final int ancestorCommandCount;
    private Member expandingMember;
    private boolean firstExpanding;
    private boolean nonEmpty;
    protected final RolapEvaluatorRoot root;
    private int iterationLength = 1;
    private boolean evalAxes;
    private final RolapCalculation[] calculations;
    private int calculationCount;
    protected final List<List<List<Member>>> aggregationLists;
    private final List<Member> slicerMembers;
    private boolean nativeEnabled;
    private Member[] nonAllMembers;
    private int commandCount;
    private Object[] commands;

    public Set<Exp> getActiveNativeExpansions() {
        return this.root.activeNativeExpansions;
    }

    protected RolapEvaluator(RolapEvaluatorRoot root, RolapEvaluator parent, List<List<Member>> aggregationList) {
        this.root = root;
        assert (parent != null);
        this.parent = parent;
        this.ancestorCommandCount = parent.ancestorCommandCount + parent.commandCount;
        this.nonEmpty = parent.nonEmpty;
        this.nativeEnabled = parent.nativeEnabled;
        this.evalAxes = parent.evalAxes;
        this.cellReader = parent.cellReader;
        this.currentMembers = (RolapMember[])parent.currentMembers.clone();
        this.calculations = (RolapCalculation[])parent.calculations.clone();
        this.calculationCount = parent.calculationCount;
        this.slicerMembers = new ArrayList<Member>(parent.slicerMembers);
        this.commands = new Object[10];
        this.commands[0] = Command.SAVEPOINT;
        this.commandCount = 1;
        ArrayList<List<List<Member>>> aggregationLists = null;
        if (parent.aggregationLists != null) {
            aggregationLists = new ArrayList<List<List<Member>>>(parent.aggregationLists);
        }
        if (aggregationList != null) {
            if (aggregationLists == null) {
                aggregationLists = new ArrayList();
            }
            aggregationLists.add(aggregationList);
            List<Member> tuple = aggregationList.get(0);
            for (Member member : tuple) {
                this.setContext(member.getHierarchy().getAllMember());
            }
        }
        this.aggregationLists = aggregationLists;
        this.expandingMember = parent.expandingMember;
    }

    public RolapEvaluator(RolapEvaluatorRoot root) {
        this.root = root;
        this.parent = null;
        this.ancestorCommandCount = 0;
        this.nonEmpty = false;
        this.nativeEnabled = MondrianProperties.instance().EnableNativeNonEmpty.get() || MondrianProperties.instance().EnableNativeCrossJoin.get();
        this.evalAxes = false;
        this.cellReader = null;
        this.currentMembers = (RolapMember[])root.defaultMembers.clone();
        this.calculations = new RolapCalculation[this.currentMembers.length];
        this.calculationCount = 0;
        this.slicerMembers = new ArrayList<Member>();
        this.aggregationLists = null;
        this.commands = new Object[10];
        this.commands[0] = Command.SAVEPOINT;
        this.commandCount = 1;
        RolapMember[] rolapMemberArray = this.currentMembers;
        int n = this.currentMembers.length;
        int n2 = 0;
        while (n2 < n) {
            RolapMember member = rolapMemberArray[n2];
            if (member.isEvaluated()) {
                this.addCalculation(member, true);
            }
            ++n2;
        }
    }

    public static Evaluator create(Statement statement) {
        RolapEvaluatorRoot root = new RolapEvaluatorRoot(statement);
        return new RolapEvaluator(root);
    }

    @Override
    public RolapCube getMeasureCube() {
        RolapMember measure = this.currentMembers[0];
        if (measure instanceof RolapStoredMeasure) {
            return ((RolapStoredMeasure)((Object)measure)).getCube();
        }
        return null;
    }

    @Override
    public boolean mightReturnNullForUnrelatedDimension() {
        if (!MondrianProperties.instance().IgnoreMeasureForNonJoiningDimension.get()) {
            return false;
        }
        RolapCube virtualCube = this.getCube();
        return virtualCube.isVirtual();
    }

    @Override
    public boolean needToReturnNullForUnrelatedDimension(Member[] members) {
        assert (this.mightReturnNullForUnrelatedDimension()) : "Should not even call this method if nulls are impossible";
        RolapCube baseCube = this.getMeasureCube();
        if (baseCube == null) {
            return false;
        }
        RolapCube virtualCube = this.getCube();
        if (virtualCube.shouldIgnoreUnrelatedDimensions(baseCube.getName())) {
            return false;
        }
        Set<Dimension> nonJoiningDimensions = baseCube.nonJoiningDimensions(members);
        return !nonJoiningDimensions.isEmpty();
    }

    @Override
    public boolean nativeEnabled() {
        return this.nativeEnabled;
    }

    @Override
    public boolean currentIsEmpty() {
        Object o = this.evaluateCurrent();
        if (o == Util.nullValue || o == null) {
            return true;
        }
        RolapCube measureCube = this.getMeasureCube();
        if (measureCube == null) {
            return false;
        }
        int savepoint = this.savepoint();
        try {
            this.setContext(measureCube.getFactCountMeasure());
            o = this.evaluateCurrent();
        }
        finally {
            this.restore(savepoint);
        }
        return o == null || o instanceof Number && ((Number)o).intValue() == 0;
    }

    @Override
    public Member getPreviousContext(Hierarchy hierarchy) {
        RolapEvaluator e = this;
        while (e != null) {
            int i = this.commandCount - 1;
            while (i > 0) {
                Command command = (Command)((Object)this.commands[i]);
                if (command == Command.SET_CONTEXT) {
                    return (Member)this.commands[i - 2];
                }
                i -= command.width;
            }
            e = e.parent;
        }
        return null;
    }

    @Override
    public final QueryTiming getTiming() {
        return this.root.execution.getQueryTiming();
    }

    @Override
    public final int savepoint() {
        int commandCount1 = this.commandCount;
        if (this.commands[this.commandCount - 1] == Command.SAVEPOINT) {
            return commandCount1;
        }
        this.ensureCommandCapacity(this.commandCount + 3);
        this.commands[this.commandCount++] = Command.SAVEPOINT;
        return commandCount1;
    }

    @Override
    public final void setNativeEnabled(boolean nativeEnabled) {
        if (nativeEnabled != this.nativeEnabled) {
            this.ensureCommandCapacity(this.commandCount + 2);
            this.commands[this.commandCount++] = this.nativeEnabled;
            this.commands[this.commandCount++] = Command.SET_NATIVE_ENABLED;
            this.nativeEnabled = nativeEnabled;
        }
    }

    protected final Logger getLogger() {
        return LOGGER;
    }

    @Override
    public final Member[] getMembers() {
        return this.currentMembers;
    }

    @Override
    public final Member[] getNonAllMembers() {
        if (this.nonAllMembers == null) {
            this.nonAllMembers = new RolapMember[this.root.nonAllPositionCount];
            int i = 0;
            while (i < this.root.nonAllPositionCount) {
                int nonAllPosition = this.root.nonAllPositions[i];
                this.nonAllMembers[i] = this.currentMembers[nonAllPosition];
                ++i;
            }
        }
        return this.nonAllMembers;
    }

    public final List<List<List<Member>>> getAggregationLists() {
        return this.aggregationLists;
    }

    final void setCellReader(CellReader cellReader) {
        if (cellReader != this.cellReader) {
            this.ensureCommandCapacity(this.commandCount + 2);
            this.commands[this.commandCount++] = this.cellReader;
            this.commands[this.commandCount++] = Command.SET_CELL_READER;
            this.cellReader = cellReader;
        }
    }

    @Override
    public final RolapCube getCube() {
        return this.root.cube;
    }

    @Override
    public final Query getQuery() {
        return this.root.query;
    }

    @Override
    public final int getDepth() {
        return 0;
    }

    @Override
    public final RolapEvaluator getParent() {
        return this.parent;
    }

    @Override
    public final SchemaReader getSchemaReader() {
        return this.root.schemaReader;
    }

    @Override
    public Date getQueryStartTime() {
        return this.root.getQueryStartTime();
    }

    public Dialect getDialect() {
        return this.root.currentDialect;
    }

    @Override
    public final RolapEvaluator push(Member[] members) {
        RolapEvaluator evaluator = this._push(null);
        evaluator.setContext(members);
        return evaluator;
    }

    @Override
    public final RolapEvaluator push(Member member) {
        RolapEvaluator evaluator = this._push(null);
        evaluator.setContext(member);
        return evaluator;
    }

    @Override
    public final Evaluator push(boolean nonEmpty) {
        RolapEvaluator evaluator = this._push(null);
        evaluator.setNonEmpty(nonEmpty);
        return evaluator;
    }

    @Override
    public final Evaluator push(boolean nonEmpty, boolean nativeEnabled) {
        RolapEvaluator evaluator = this._push(null);
        evaluator.setNonEmpty(nonEmpty);
        evaluator.setNativeEnabled(nativeEnabled);
        return evaluator;
    }

    @Override
    public final RolapEvaluator push() {
        return this._push(null);
    }

    private void ensureCommandCapacity(int minCapacity) {
        if (minCapacity > this.commands.length) {
            int newCapacity = this.commands.length * 2;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this.commands = Util.copyOf(this.commands, newCapacity);
        }
    }

    private boolean addChecksumStateCommand() {
        this.commands[this.commandCount++] = this.checksumState();
        this.commands[this.commandCount++] = Command.CHECKSUM;
        return true;
    }

    protected RolapEvaluator _push(List<List<Member>> aggregationList) {
        this.root.execution.checkCancelOrTimeout();
        return new RolapEvaluator(this.root, this, aggregationList);
    }

    @Override
    public final void restore(int savepoint) {
        while (this.commandCount > savepoint) {
            ((Command)((Object)this.commands[--this.commandCount])).execute(this);
        }
    }

    @Override
    public final Evaluator pushAggregation(List<List<Member>> list) {
        return this._push(list);
    }

    public final boolean equals(Object obj) {
        if (!(obj instanceof RolapEvaluator)) {
            return false;
        }
        RolapEvaluator that = (RolapEvaluator)obj;
        return Arrays.equals(this.currentMembers, that.currentMembers);
    }

    public final int hashCode() {
        return Util.hashArray(0, this.currentMembers);
    }

    public final void setSlicerContext(Member member) {
        this.setContext(member);
        this.slicerMembers.add(member);
    }

    public final List<Member> getSlicerMembers() {
        return this.slicerMembers;
    }

    @Override
    public final Member setContext(Member member) {
        RolapMemberBase m = (RolapMemberBase)member;
        int ordinal = m.getHierarchy().getOrdinalInCube();
        RolapMember previous = this.currentMembers[ordinal];
        if (m == previous) {
            return previous;
        }
        if (!this.exists(ordinal)) {
            this.ensureCommandCapacity(this.commandCount + 3);
            this.commands[this.commandCount++] = previous;
            this.commands[this.commandCount++] = ordinal;
            this.commands[this.commandCount++] = Command.SET_CONTEXT;
        }
        if (previous.isEvaluated()) {
            this.removeCalculation(previous, false);
        }
        this.currentMembers[ordinal] = m;
        if (previous.isAll() && !m.isAll() && this.isNewPosition(ordinal)) {
            this.root.nonAllPositions[this.root.nonAllPositionCount] = ordinal;
            ++this.root.nonAllPositionCount;
        }
        if (m.isEvaluated()) {
            this.addCalculation(m, false);
        }
        this.nonAllMembers = null;
        return previous;
    }

    @Override
    public final void setContext(Member member, boolean safe) {
        RolapMemberBase m = (RolapMemberBase)member;
        int ordinal = m.getHierarchy().getOrdinalInCube();
        RolapMember previous = this.currentMembers[ordinal];
        if (m == previous) {
            return;
        }
        if (safe && !this.exists(ordinal)) {
            this.ensureCommandCapacity(this.commandCount + 3);
            this.commands[this.commandCount++] = previous;
            this.commands[this.commandCount++] = ordinal;
            this.commands[this.commandCount++] = Command.SET_CONTEXT;
        }
        if (previous.isEvaluated()) {
            this.removeCalculation(previous, false);
        }
        this.currentMembers[ordinal] = m;
        if (previous.isAll() && !m.isAll() && this.isNewPosition(ordinal)) {
            this.root.nonAllPositions[this.root.nonAllPositionCount] = ordinal;
            ++this.root.nonAllPositionCount;
        }
        if (m.isEvaluated()) {
            this.addCalculation(m, false);
        }
        this.nonAllMembers = null;
    }

    private boolean exists(int ordinal) {
        int i = this.commandCount - 1;
        while (true) {
            Command command = (Command)((Object)this.commands[i]);
            switch (command) {
                case SAVEPOINT: {
                    return false;
                }
                case SET_CONTEXT: {
                    Integer memberOrdinal = (Integer)this.commands[i - 1];
                    if (ordinal != memberOrdinal) break;
                    return true;
                }
            }
            i -= command.width;
        }
    }

    private boolean isNewPosition(int ordinal) {
        int[] nArray = this.root.nonAllPositions;
        int n = this.root.nonAllPositions.length;
        int n2 = 0;
        while (n2 < n) {
            int nonAllPosition = nArray[n2];
            if (ordinal == nonAllPosition) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Override
    public final void setContext(List<Member> memberList) {
        int i = 0;
        int n = memberList.size();
        while (i < n) {
            Member member = memberList.get(i);
            assert (member != null) : "null member in " + memberList;
            this.setContext(member);
            ++i;
        }
    }

    @Override
    public final void setContext(List<Member> memberList, boolean safe) {
        int i = 0;
        int n = memberList.size();
        while (i < n) {
            Member member = memberList.get(i);
            assert (member != null) : "null member in " + memberList;
            this.setContext(member, safe);
            ++i;
        }
    }

    @Override
    public final void setContext(Member[] members) {
        int i = 0;
        int length = members.length;
        while (i < length) {
            Member member = members[i];
            assert (member != null) : "null member in " + Arrays.toString(members);
            this.setContext(member);
            ++i;
        }
    }

    @Override
    public final void setContext(Member[] members, boolean safe) {
        int i = 0;
        int length = members.length;
        while (i < length) {
            Member member = members[i];
            assert (member != null) : Arrays.asList(members);
            this.setContext(member, safe);
            ++i;
        }
    }

    @Override
    public final RolapMember getContext(Hierarchy hierarchy) {
        return this.currentMembers[((RolapHierarchy)hierarchy).getOrdinalInCube()];
    }

    public final RolapMember getContext(RolapHierarchy hierarchy) {
        return this.currentMembers[hierarchy.getOrdinalInCube()];
    }

    @Override
    public final Object evaluateCurrent() {
        Object o;
        RolapCalculation maxSolveMember;
        block1 : switch (this.calculationCount) {
            case 0: {
                Object o2 = this.cellReader.get(this);
                if (o2 == Util.nullValue) {
                    return null;
                }
                return o2;
            }
            case 1: {
                maxSolveMember = this.calculations[0];
                break;
            }
            default: {
                switch (this.root.solveOrderMode) {
                    case ABSOLUTE: {
                        maxSolveMember = this.getAbsoluteMaxSolveOrder();
                        break block1;
                    }
                    case SCOPED: {
                        maxSolveMember = this.getScopedMaxSolveOrder();
                        break block1;
                    }
                }
                throw Util.unexpected(this.root.solveOrderMode);
            }
        }
        int savepoint = this.savepoint();
        maxSolveMember.setContextIn(this);
        Calc calc = maxSolveMember.getCompiledExpression(this.root);
        try {
            o = calc.evaluate(this);
        }
        finally {
            this.restore(savepoint);
        }
        if (o == Util.nullValue) {
            return null;
        }
        return o;
    }

    void setExpanding(Member member) {
        assert (member != null);
        this.ensureCommandCapacity(this.commandCount + 3);
        this.commands[this.commandCount++] = this.expandingMember;
        this.commands[this.commandCount++] = this.firstExpanding;
        this.commands[this.commandCount++] = Command.SET_EXPANDING;
        this.expandingMember = member;
        this.firstExpanding = true;
        int totalCommandCount = this.commandCount + this.ancestorCommandCount;
        if (totalCommandCount > this.root.recursionCheckCommandCount) {
            RolapEvaluator.checkRecursion(this, this.commandCount - 4);
            this.root.recursionCheckCommandCount = totalCommandCount + (this.root.defaultMembers.length << 4);
        }
    }

    Member getExpanding() {
        return this.expandingMember;
    }

    private static void checkRecursion(RolapEvaluator eval, int c) {
        Object[] members = (RolapMember[])eval.currentMembers.clone();
        Member expanding = eval.expandingMember;
        while (true) {
            if (c < 0) {
                eval = eval.parent;
                if (eval == null) {
                    return;
                }
                c = eval.commandCount - 1;
                continue;
            }
            Command command = (Command)((Object)eval.commands[c]);
            switch (command) {
                case SET_CONTEXT: {
                    int memberOrdinal = (Integer)eval.commands[c - 1];
                    RolapMember member = (RolapMember)eval.commands[c - 2];
                    members[memberOrdinal] = member;
                    break;
                }
                case SET_EXPANDING: {
                    expanding = (RolapMember)eval.commands[c - 2];
                    if (!Arrays.equals(members, eval.currentMembers) || expanding != eval.expandingMember) break;
                    throw FunUtil.newEvalException(null, "Infinite loop while evaluating calculated member '" + eval.expandingMember + "'; context stack is " + eval.getContextString());
                }
            }
            c -= command.width;
        }
    }

    private String getContextString() {
        RolapMember[] members = (RolapMember[])this.currentMembers.clone();
        boolean skipDefaultMembers = true;
        StringBuilder buf = new StringBuilder("{");
        int frameCount = 0;
        boolean changedSinceLastSavepoint = false;
        RolapEvaluator eval = this;
        while (eval != null) {
            if (eval.expandingMember != null) {
                int c = eval.commandCount - 1;
                while (c > 0) {
                    Command command = (Command)((Object)eval.commands[c]);
                    switch (command) {
                        case SAVEPOINT: {
                            if (changedSinceLastSavepoint) {
                                if (frameCount++ > 0) {
                                    buf.append(", ");
                                }
                                buf.append("(");
                                int memberCount = 0;
                                RolapMember[] rolapMemberArray = members;
                                int n = members.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    RolapMember m = rolapMemberArray[n2];
                                    if (m != m.getHierarchy().getDefaultMember()) {
                                        if (memberCount++ > 0) {
                                            buf.append(", ");
                                        }
                                        buf.append(m.getUniqueName());
                                    }
                                    ++n2;
                                }
                                buf.append(")");
                            }
                            changedSinceLastSavepoint = false;
                            break;
                        }
                        case SET_CONTEXT: {
                            RolapMember member;
                            changedSinceLastSavepoint = true;
                            int memberOrdinal = (Integer)eval.commands[c - 1];
                            members[memberOrdinal] = member = (RolapMember)eval.commands[c - 2];
                        }
                    }
                    c -= command.width;
                }
            }
            eval = eval.parent;
        }
        buf.append("}");
        return buf.toString();
    }

    @Override
    public final Object getProperty(String name, Object defaultValue) {
        Object o = defaultValue;
        int maxSolve = Integer.MIN_VALUE;
        int i = -1;
        Member[] memberArray = this.getNonAllMembers();
        int n = memberArray.length;
        int n2 = 0;
        while (n2 < n) {
            Member member = memberArray[n2];
            ++i;
            if (member == null) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug((Object)("RolapEvaluator.getProperty: member == null  , count=" + i));
                }
            } else {
                Object p;
                int solve = member.getSolveOrder();
                if (solve > maxSolve && (p = member.getPropertyValue(name)) != null) {
                    o = p;
                    maxSolve = solve;
                }
            }
            ++n2;
        }
        return o;
    }

    @Override
    public final String getFormatString() {
        Exp formatExp = (Exp)this.getProperty(Property.FORMAT_EXP_PARSED.name, null);
        if (formatExp == null) {
            return "Standard";
        }
        Calc formatCalc = this.root.getCompiled(formatExp, true, null);
        Object o = formatCalc.evaluate(this);
        if (o == null) {
            return "Standard";
        }
        return o.toString();
    }

    private Format getFormat() {
        String formatString = this.getFormatString();
        return this.getFormat(formatString);
    }

    private Format getFormat(String formatString) {
        return Format.get(formatString, this.root.connection.getLocale());
    }

    @Override
    public final Locale getConnectionLocale() {
        return this.root.connection.getLocale();
    }

    @Override
    public final String format(Object o) {
        if (o == Util.nullValue) {
            o = null;
        }
        if (o instanceof Throwable) {
            return "#ERR: " + o.toString();
        }
        Format format = this.getFormat();
        return format.format(o);
    }

    @Override
    public final String format(Object o, String formatString) {
        if (o == Util.nullValue) {
            o = null;
        }
        if (o instanceof Throwable) {
            return "#ERR: " + o.toString();
        }
        Format format = this.getFormat(formatString);
        return format.format(o);
    }

    private Object getExpResultCacheKey(ExpCacheDescriptor descriptor) {
        ArrayList<Object> key;
        if (this.nonEmpty) {
            key = new ArrayList<Object>(this.currentMembers.length + 1);
            key.add(descriptor.getExp());
            RolapMember[] rolapMemberArray = this.currentMembers;
            int n = this.currentMembers.length;
            int n2 = 0;
            while (n2 < n) {
                RolapMember currentMember = rolapMemberArray[n2];
                key.add(currentMember);
                ++n2;
            }
        } else {
            int[] hierarchyOrdinals = descriptor.getDependentHierarchyOrdinals();
            key = new ArrayList(hierarchyOrdinals.length + 1);
            key.add(descriptor.getExp());
            int[] nArray = hierarchyOrdinals;
            int n = hierarchyOrdinals.length;
            int n3 = 0;
            while (n3 < n) {
                int hierarchyOrdinal = nArray[n3];
                RolapMember member = this.currentMembers[hierarchyOrdinal];
                assert (member != null);
                key.add(member);
                ++n3;
            }
        }
        return key;
    }

    @Override
    public final Object getCachedResult(ExpCacheDescriptor cacheDescriptor) {
        Object key = this.getExpResultCacheKey(cacheDescriptor);
        Object result = this.root.getCacheResult(key);
        if (result == null) {
            boolean aggCacheDirty = this.cellReader.isDirty();
            int aggregateCacheMissCountBefore = this.cellReader.getMissCount();
            result = cacheDescriptor.evaluate(this);
            int aggregateCacheMissCountAfter = this.cellReader.getMissCount();
            boolean isValidResult = !aggCacheDirty && aggregateCacheMissCountBefore == aggregateCacheMissCountAfter;
            this.root.putCacheResult(key, result == null ? nullResult : result, isValidResult);
        } else if (result == nullResult) {
            result = null;
        }
        return result;
    }

    public final void clearExpResultCache(boolean clearValidResult) {
        this.root.clearResultCache(clearValidResult);
    }

    @Override
    public final boolean isNonEmpty() {
        return this.nonEmpty;
    }

    @Override
    public final void setNonEmpty(boolean nonEmpty) {
        if (nonEmpty != this.nonEmpty) {
            this.ensureCommandCapacity(this.commandCount + 2);
            this.commands[this.commandCount++] = this.nonEmpty;
            this.commands[this.commandCount++] = Command.SET_NON_EMPTY;
            this.nonEmpty = nonEmpty;
        }
    }

    @Override
    public final RuntimeException newEvalException(Object context, String s) {
        return FunUtil.newEvalException((FunDef)context, s);
    }

    @Override
    public final Evaluator.NamedSetEvaluator getNamedSetEvaluator(NamedSet namedSet, boolean create) {
        return this.root.evaluateNamedSet(namedSet, create);
    }

    @Override
    public final int getMissCount() {
        return this.cellReader.getMissCount();
    }

    @Override
    public final Object getParameterValue(ParameterSlot slot) {
        return this.root.getParameterValue(slot);
    }

    final void addCalculation(RolapCalculation calculation, boolean reversible) {
        assert (calculation != null);
        this.calculations[this.calculationCount++] = calculation;
        if (reversible && !(calculation instanceof RolapMember)) {
            this.ensureCommandCapacity(this.commandCount + 2);
            this.commands[this.commandCount++] = calculation;
            this.commands[this.commandCount++] = Command.REMOVE_CALCULATION;
        }
    }

    private RolapCalculation getAbsoluteMaxSolveOrder() {
        RolapCalculation maxSolveMember = this.calculations[0];
        int i = 1;
        while (i < this.calculationCount) {
            RolapCalculation member = this.calculations[i];
            if (this.expandsBefore(member, maxSolveMember)) {
                maxSolveMember = member;
            }
            ++i;
        }
        return maxSolveMember;
    }

    private RolapCalculation getScopedMaxSolveOrder() {
        RolapCalculation maxSolveMember = null;
        ScopedMaxSolveOrderFinderState state = ScopedMaxSolveOrderFinderState.START;
        int i = 0;
        while (i < this.calculationCount) {
            RolapCalculation calculation = this.calculations[i];
            switch (state) {
                case START: {
                    maxSolveMember = calculation;
                    if (maxSolveMember.containsAggregateFunction()) {
                        state = ScopedMaxSolveOrderFinderState.AGG_SCOPE;
                        break;
                    }
                    if (maxSolveMember.isCalculatedInQuery()) {
                        state = ScopedMaxSolveOrderFinderState.QUERY_SCOPE;
                        break;
                    }
                    state = ScopedMaxSolveOrderFinderState.CUBE_SCOPE;
                    break;
                }
                case AGG_SCOPE: {
                    if (calculation.containsAggregateFunction()) {
                        if (!this.expandsBefore(calculation, maxSolveMember)) break;
                        maxSolveMember = calculation;
                        break;
                    }
                    if (calculation.isCalculatedInQuery()) {
                        maxSolveMember = calculation;
                        state = ScopedMaxSolveOrderFinderState.QUERY_SCOPE;
                        break;
                    }
                    maxSolveMember = calculation;
                    state = ScopedMaxSolveOrderFinderState.CUBE_SCOPE;
                    break;
                }
                case CUBE_SCOPE: {
                    if (calculation.containsAggregateFunction()) break;
                    if (calculation.isCalculatedInQuery()) {
                        maxSolveMember = calculation;
                        state = ScopedMaxSolveOrderFinderState.QUERY_SCOPE;
                        break;
                    }
                    if (!this.expandsBefore(calculation, maxSolveMember)) break;
                    maxSolveMember = calculation;
                    break;
                }
                case QUERY_SCOPE: {
                    if (calculation.containsAggregateFunction()) break;
                    if (calculation.isCalculatedInQuery()) {
                        if (!this.expandsBefore(calculation, maxSolveMember)) break;
                        maxSolveMember = calculation;
                        break;
                    }
                    maxSolveMember = calculation;
                    state = ScopedMaxSolveOrderFinderState.CUBE_SCOPE;
                }
            }
            ++i;
        }
        return maxSolveMember;
    }

    private boolean expandsBefore(RolapCalculation calc1, RolapCalculation calc2) {
        int solveOrder2;
        int solveOrder1 = calc1.getSolveOrder();
        if (solveOrder1 > (solveOrder2 = calc2.getSolveOrder())) {
            return true;
        }
        return solveOrder1 == solveOrder2 && calc1.getHierarchyOrdinal() < calc2.getHierarchyOrdinal();
    }

    final void removeCalculation(RolapCalculation calculation, boolean reversible) {
        int i = 0;
        while (i < this.calculationCount) {
            if (this.calculations[i] == calculation) {
                --this.calculationCount;
                this.calculations[i] = this.calculations[this.calculationCount];
                assert (this.calculations[i] != null);
                this.calculations[this.calculationCount] = null;
                if (reversible && !(calculation instanceof RolapMember)) {
                    this.ensureCommandCapacity(this.commandCount + 2);
                    this.commands[this.commandCount++] = calculation;
                    this.commands[this.commandCount++] = Command.ADD_CALCULATION;
                }
                return;
            }
            ++i;
        }
        throw new AssertionError((Object)("calculation " + calculation + " not on stack"));
    }

    @Override
    public final int getIterationLength() {
        return this.iterationLength;
    }

    @Override
    public final void setIterationLength(int iterationLength) {
        this.ensureCommandCapacity(this.commandCount + 2);
        this.commands[this.commandCount++] = this.iterationLength;
        this.commands[this.commandCount++] = Command.SET_ITERATION_LENGTH;
        this.iterationLength = iterationLength;
    }

    @Override
    public final boolean isEvalAxes() {
        return this.evalAxes;
    }

    @Override
    public final void setEvalAxes(boolean evalAxes) {
        if (evalAxes != this.evalAxes) {
            this.ensureCommandCapacity(this.commandCount + 2);
            this.commands[this.commandCount++] = this.evalAxes;
            this.commands[this.commandCount++] = Command.SET_EVAL_AXES;
            this.evalAxes = evalAxes;
        }
    }

    private int checksumState() {
        int h = 0;
        h = h * 31 + Arrays.asList(this.currentMembers).hashCode();
        h = h * 31 + new HashSet<RolapCalculation>(Arrays.asList(this.calculations).subList(0, this.calculationCount)).hashCode();
        h = h * 31 + this.slicerMembers.hashCode();
        h = h * 31 + (this.expandingMember == null ? 0 : this.expandingMember.hashCode());
        h = h * 31 + (this.aggregationLists == null ? 0 : this.aggregationLists.hashCode());
        h = h * 31 + (this.nonEmpty ? 1 : 2) + (this.nativeEnabled ? 4 : 8) + (this.firstExpanding ? 16 : 32) + (this.evalAxes ? 64 : 128);
        return h;
    }

    @Override
    public boolean shouldIgnoreUnrelatedDimensions() {
        return this.getCube().shouldIgnoreUnrelatedDimensions(this.getMeasureCube().getName());
    }

    private static abstract class Command
    extends Enum<Command> {
        public static final /* enum */ Command SET_CONTEXT = new Command(2){

            @Override
            void execute(RolapEvaluator evaluator) {
                Object[] objectArray = evaluator.commands;
                RolapEvaluator rolapEvaluator = evaluator;
                int n = rolapEvaluator.commandCount - 1;
                rolapEvaluator.commandCount = n;
                int memberOrdinal = (Integer)objectArray[n];
                Object[] objectArray2 = evaluator.commands;
                RolapEvaluator rolapEvaluator2 = evaluator;
                int n2 = rolapEvaluator2.commandCount - 1;
                rolapEvaluator2.commandCount = n2;
                RolapMember member = (RolapMember)objectArray2[n2];
                evaluator.setContext(member, false);
            }
        };
        public static final /* enum */ Command SET_NATIVE_ENABLED = new Command(1){

            @Override
            void execute(RolapEvaluator evaluator) {
                Object[] objectArray = evaluator.commands;
                RolapEvaluator rolapEvaluator = evaluator;
                int n = rolapEvaluator.commandCount - 1;
                rolapEvaluator.commandCount = n;
                evaluator.nativeEnabled = (Boolean)objectArray[n];
            }
        };
        public static final /* enum */ Command SET_NON_EMPTY = new Command(1){

            @Override
            void execute(RolapEvaluator evaluator) {
                Object[] objectArray = evaluator.commands;
                RolapEvaluator rolapEvaluator = evaluator;
                int n = rolapEvaluator.commandCount - 1;
                rolapEvaluator.commandCount = n;
                evaluator.nonEmpty = (Boolean)objectArray[n];
            }
        };
        public static final /* enum */ Command SET_EVAL_AXES = new Command(1){

            @Override
            void execute(RolapEvaluator evaluator) {
                Object[] objectArray = evaluator.commands;
                RolapEvaluator rolapEvaluator = evaluator;
                int n = rolapEvaluator.commandCount - 1;
                rolapEvaluator.commandCount = n;
                evaluator.evalAxes = (Boolean)objectArray[n];
            }
        };
        public static final /* enum */ Command SET_EXPANDING = new Command(2){

            @Override
            void execute(RolapEvaluator evaluator) {
                Object[] objectArray = evaluator.commands;
                RolapEvaluator rolapEvaluator = evaluator;
                int n = rolapEvaluator.commandCount - 1;
                rolapEvaluator.commandCount = n;
                evaluator.firstExpanding = (Boolean)objectArray[n];
                Object[] objectArray2 = evaluator.commands;
                RolapEvaluator rolapEvaluator2 = evaluator;
                int n2 = rolapEvaluator2.commandCount - 1;
                rolapEvaluator2.commandCount = n2;
                evaluator.expandingMember = (Member)objectArray2[n2];
            }
        };
        public static final /* enum */ Command SET_ITERATION_LENGTH = new Command(1){

            @Override
            void execute(RolapEvaluator evaluator) {
                Object[] objectArray = evaluator.commands;
                RolapEvaluator rolapEvaluator = evaluator;
                int n = rolapEvaluator.commandCount - 1;
                rolapEvaluator.commandCount = n;
                evaluator.iterationLength = (Integer)objectArray[n];
            }
        };
        public static final /* enum */ Command SET_CELL_READER = new Command(1){

            @Override
            void execute(RolapEvaluator evaluator) {
                Object[] objectArray = evaluator.commands;
                RolapEvaluator rolapEvaluator = evaluator;
                int n = rolapEvaluator.commandCount - 1;
                rolapEvaluator.commandCount = n;
                evaluator.cellReader = (CellReader)objectArray[n];
            }
        };
        public static final /* enum */ Command CHECKSUM = new Command(1){

            @Override
            void execute(RolapEvaluator evaluator) {
                Object[] objectArray = evaluator.commands;
                RolapEvaluator rolapEvaluator = evaluator;
                int n = rolapEvaluator.commandCount - 1;
                rolapEvaluator.commandCount = n;
                int value = (Integer)objectArray[n];
                int currentState = evaluator.checksumState();
                if (!$assertionsDisabled && value != currentState) {
                    throw new AssertionError((Object)("Current checksum " + currentState + " != previous checksum " + value));
                }
            }
        };
        public static final /* enum */ Command ADD_CALCULATION = new Command(1){

            @Override
            void execute(RolapEvaluator evaluator) {
                Object[] objectArray = evaluator.commands;
                RolapEvaluator rolapEvaluator = evaluator;
                int n = rolapEvaluator.commandCount - 1;
                rolapEvaluator.commandCount = n;
                RolapCalculation calculation = (RolapCalculation)objectArray[n];
                RolapCalculation[] rolapCalculationArray = evaluator.calculations;
                RolapEvaluator rolapEvaluator2 = evaluator;
                int n2 = rolapEvaluator2.calculationCount;
                rolapEvaluator2.calculationCount = n2 + 1;
                rolapCalculationArray[n2] = calculation;
            }
        };
        public static final /* enum */ Command REMOVE_CALCULATION = new Command(1){

            @Override
            void execute(RolapEvaluator evaluator) {
                Object[] objectArray = evaluator.commands;
                RolapEvaluator rolapEvaluator = evaluator;
                int n = rolapEvaluator.commandCount - 1;
                rolapEvaluator.commandCount = n;
                RolapCalculation calculation = (RolapCalculation)objectArray[n];
                evaluator.removeCalculation(calculation, false);
            }
        };
        public static final /* enum */ Command SAVEPOINT = new Command(0){

            @Override
            void execute(RolapEvaluator evaluator) {
            }
        };
        public final int width;
        private static final /* synthetic */ Command[] ENUM$VALUES;

        static {
            ENUM$VALUES = new Command[]{SET_CONTEXT, SET_NATIVE_ENABLED, SET_NON_EMPTY, SET_EVAL_AXES, SET_EXPANDING, SET_ITERATION_LENGTH, SET_CELL_READER, CHECKSUM, ADD_CALCULATION, REMOVE_CALCULATION, SAVEPOINT};
        }

        private Command(int argCount) {
            this.width = argCount + 1;
        }

        abstract void execute(RolapEvaluator var1);

        public static Command[] values() {
            Command[] commandArray = ENUM$VALUES;
            int n = commandArray.length;
            Command[] commandArray2 = new Command[n];
            System.arraycopy(ENUM$VALUES, 0, commandArray2, 0, n);
            return commandArray2;
        }

        public static Command valueOf(String string) {
            return Enum.valueOf(Command.class, string);
        }
    }

    private static enum ScopedMaxSolveOrderFinderState {
        START,
        AGG_SCOPE,
        CUBE_SCOPE,
        QUERY_SCOPE;

    }
}

