/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.util.List;
import mondrian.calc.Calc;
import mondrian.calc.ResultStyle;
import mondrian.calc.TupleCollections;
import mondrian.calc.TupleCursor;
import mondrian.calc.TupleIterable;
import mondrian.calc.TupleList;
import mondrian.olap.Evaluator;
import mondrian.olap.Member;
import mondrian.olap.NamedSet;
import mondrian.olap.Util;
import mondrian.rolap.RolapResult;

class RolapNamedSetEvaluator
implements Evaluator.NamedSetEvaluator,
TupleList.PositionCallback {
    private final RolapResult.RolapResultEvaluatorRoot rrer;
    private final NamedSet namedSet;
    private TupleList list;
    private static final TupleList DUMMY_LIST = TupleCollections.createList(1);
    private int currentOrdinal;

    public RolapNamedSetEvaluator(RolapResult.RolapResultEvaluatorRoot rrer, NamedSet namedSet) {
        this.rrer = rrer;
        this.namedSet = namedSet;
    }

    @Override
    public TupleIterable evaluateTupleIterable() {
        this.ensureList();
        return this.list;
    }

    private void ensureList() {
        if (this.list != null) {
            if (this.list == DUMMY_LIST) {
                throw this.rrer.result.slicerEvaluator.newEvalException(null, "Illegal attempt to reference value of named set '" + this.namedSet.getName() + "' while evaluating itself");
            }
            return;
        }
        if (RolapResult.LOGGER.isDebugEnabled()) {
            RolapResult.LOGGER.debug((Object)("Named set " + this.namedSet.getName() + ": starting evaluation"));
        }
        this.list = DUMMY_LIST;
        try {
            TupleList rawList;
            Calc calc = this.rrer.getCompiled(this.namedSet.getExp(), false, ResultStyle.ITERABLE);
            TupleIterable iterable = (TupleIterable)this.rrer.result.evaluateExp(calc, this.rrer.result.slicerEvaluator);
            if (iterable instanceof TupleList) {
                rawList = (TupleList)iterable;
            } else {
                rawList = TupleCollections.createList(iterable.getArity());
                TupleCursor cursor = iterable.tupleCursor();
                while (cursor.forward()) {
                    rawList.addCurrent(cursor);
                }
            }
            if (RolapResult.LOGGER.isDebugEnabled()) {
                RolapResult.LOGGER.debug((Object)this.generateDebugMessage(calc, rawList));
            }
            this.list = rawList.withPositionCallback(this);
        }
        finally {
            if (this.list == DUMMY_LIST) {
                this.list = null;
            }
        }
    }

    private String generateDebugMessage(Calc calc, TupleList rawList) {
        StringBuilder buf = new StringBuilder();
        buf.append(this);
        buf.append(": ");
        buf.append("Named set ");
        buf.append(this.namedSet.getName());
        buf.append(" evaluated to:");
        buf.append(Util.nl);
        int arity = calc.getType().getArity();
        int rowCount = 0;
        int maxRowCount = 100;
        if (arity == 1) {
            for (Member t : rawList.slice(0)) {
                if (rowCount++ > 100) {
                    buf.append("...");
                    buf.append(Util.nl);
                    break;
                }
                buf.append(t);
                buf.append(Util.nl);
            }
        } else {
            for (List t : rawList) {
                if (rowCount++ > 100) {
                    buf.append("...");
                    buf.append(Util.nl);
                    break;
                }
                int k = 0;
                for (Member member : t) {
                    if (k++ > 0) {
                        buf.append(", ");
                    }
                    buf.append(member);
                }
                buf.append(Util.nl);
            }
        }
        return buf.toString();
    }

    @Override
    public int currentOrdinal() {
        return this.currentOrdinal;
    }

    @Override
    public void onPosition(int index) {
        this.currentOrdinal = index;
    }

    @Override
    public Member[] currentTuple() {
        List tuple = (List)this.list.get(this.currentOrdinal);
        return tuple.toArray(new Member[tuple.size()]);
    }

    @Override
    public Member currentMember() {
        return this.list.get(0, this.currentOrdinal);
    }
}

