/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import mondrian.calc.ResultStyle;
import mondrian.calc.TupleList;
import mondrian.calc.impl.DelegatingTupleList;
import mondrian.olap.DelegatingSchemaReader;
import mondrian.olap.Hierarchy;
import mondrian.olap.Member;
import mondrian.olap.MondrianProperties;
import mondrian.olap.NativeEvaluator;
import mondrian.olap.ResultStyleException;
import mondrian.olap.SchemaReader;
import mondrian.olap.Util;
import mondrian.rolap.HighCardSqlTupleReader;
import mondrian.rolap.MemberReader;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapEvaluator;
import mondrian.rolap.RolapHierarchy;
import mondrian.rolap.RolapLevel;
import mondrian.rolap.RolapMember;
import mondrian.rolap.RolapNative;
import mondrian.rolap.RolapStoredMeasure;
import mondrian.rolap.SqlContextConstraint;
import mondrian.rolap.SqlTupleReader;
import mondrian.rolap.TupleReader;
import mondrian.rolap.aggmatcher.AggStar;
import mondrian.rolap.cache.HardSmartCache;
import mondrian.rolap.cache.SmartCache;
import mondrian.rolap.cache.SoftSmartCache;
import mondrian.rolap.sql.CrossJoinArg;
import mondrian.rolap.sql.CrossJoinArgFactory;
import mondrian.rolap.sql.MemberChildrenConstraint;
import mondrian.rolap.sql.MemberListCrossJoinArg;
import mondrian.rolap.sql.SqlQuery;
import mondrian.rolap.sql.TupleConstraint;
import org.apache.log4j.Logger;

public abstract class RolapNativeSet
extends RolapNative {
    protected static final Logger LOGGER = Logger.getLogger(RolapNativeSet.class);
    private SmartCache<Object, TupleList> cache = new SoftSmartCache<Object, TupleList>();

    protected abstract boolean restrictMemberTypes();

    protected CrossJoinArgFactory crossJoinArgFactory() {
        return new CrossJoinArgFactory(this.restrictMemberTypes());
    }

    protected boolean isPreferInterpreter(CrossJoinArg[] args, boolean joinArg) {
        CrossJoinArg[] crossJoinArgArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            CrossJoinArg arg = crossJoinArgArray[n2];
            if (!arg.isPreferInterpreter(joinArg)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Override
    void useHardCache(boolean hard) {
        this.cache = hard ? new HardSmartCache<Object, TupleList>() : new SoftSmartCache<Object, TupleList>();
    }

    protected void overrideContext(RolapEvaluator evaluator, CrossJoinArg[] cargs, RolapStoredMeasure storedMeasure) {
        SchemaReader schemaReader = evaluator.getSchemaReader();
        CrossJoinArg[] crossJoinArgArray = cargs;
        int n = cargs.length;
        int n2 = 0;
        while (n2 < n) {
            CrossJoinArg carg = crossJoinArgArray[n2];
            RolapLevel level = carg.getLevel();
            if (level != null) {
                RolapHierarchy hierarchy = level.getHierarchy();
                Member defaultMember = schemaReader.getHierarchyDefaultMember(hierarchy);
                evaluator.setContext(defaultMember);
            }
            ++n2;
        }
        if (storedMeasure != null) {
            evaluator.setContext(storedMeasure);
        }
    }

    public static interface SchemaReaderWithMemberReaderAvailable
    extends SchemaReader {
        public MemberReader getMemberReader(Hierarchy var1);
    }

    private static class SchemaReaderWithMemberReaderCache
    extends DelegatingSchemaReader
    implements SchemaReaderWithMemberReaderAvailable {
        private final Map<Hierarchy, MemberReader> hierarchyReaders = new HashMap<Hierarchy, MemberReader>();

        SchemaReaderWithMemberReaderCache(SchemaReader schemaReader) {
            super(schemaReader);
        }

        @Override
        public synchronized MemberReader getMemberReader(Hierarchy hierarchy) {
            MemberReader memberReader = this.hierarchyReaders.get(hierarchy);
            if (memberReader == null) {
                memberReader = ((RolapHierarchy)hierarchy).createMemberReader(this.schemaReader.getRole());
                this.hierarchyReaders.put(hierarchy, memberReader);
            }
            return memberReader;
        }
    }

    protected static abstract class SetConstraint
    extends SqlContextConstraint {
        CrossJoinArg[] args;

        SetConstraint(CrossJoinArg[] args, RolapEvaluator evaluator, boolean strict) {
            super(evaluator, strict);
            this.args = args;
        }

        @Override
        protected boolean isJoinRequired() {
            return this.args.length > 1 || super.isJoinRequired();
        }

        @Override
        public void addConstraint(SqlQuery sqlQuery, RolapCube baseCube, AggStar aggStar) {
            super.addConstraint(sqlQuery, baseCube, aggStar);
            CrossJoinArg[] crossJoinArgArray = this.args;
            int n = this.args.length;
            int n2 = 0;
            while (n2 < n) {
                RolapLevel level;
                CrossJoinArg arg = crossJoinArgArray[n2];
                if (!(arg instanceof MemberListCrossJoinArg && ((MemberListCrossJoinArg)arg).hasCalcMembers() || (level = arg.getLevel()) != null && !this.levelIsOnBaseCube(baseCube, level))) {
                    arg.addConstraint(sqlQuery, baseCube, aggStar);
                }
                ++n2;
            }
        }

        private boolean levelIsOnBaseCube(RolapCube baseCube, RolapLevel level) {
            return baseCube.findBaseCubeHierarchy(level.getHierarchy()) != null;
        }

        @Override
        public MemberChildrenConstraint getMemberChildrenConstraint(RolapMember parent) {
            return null;
        }

        @Override
        public Object getCacheKey() {
            ArrayList<Object> key = new ArrayList<Object>();
            key.add(super.getCacheKey());
            CrossJoinArg[] crossJoinArgArray = this.args;
            int n = this.args.length;
            int n2 = 0;
            while (n2 < n) {
                CrossJoinArg arg = crossJoinArgArray[n2];
                if (!(arg instanceof MemberListCrossJoinArg) || !((MemberListCrossJoinArg)arg).hasCalcMembers()) {
                    key.add(arg);
                }
                ++n2;
            }
            return key;
        }
    }

    protected class SetEvaluator
    implements NativeEvaluator {
        private final CrossJoinArg[] args;
        private final SchemaReaderWithMemberReaderAvailable schemaReader;
        private final TupleConstraint constraint;
        private int maxRows = 0;

        public SetEvaluator(CrossJoinArg[] args, SchemaReader schemaReader, TupleConstraint constraint) {
            this.args = args;
            this.schemaReader = schemaReader instanceof SchemaReaderWithMemberReaderAvailable ? (SchemaReaderWithMemberReaderAvailable)schemaReader : new SchemaReaderWithMemberReaderCache(schemaReader);
            this.constraint = constraint;
        }

        @Override
        public Object execute(ResultStyle desiredResultStyle) {
            switch (desiredResultStyle) {
                case ITERABLE: {
                    return this.executeList(new HighCardSqlTupleReader(this.constraint));
                }
                case MUTABLE_LIST: 
                case LIST: {
                    return this.executeList(new SqlTupleReader(this.constraint));
                }
            }
            throw ResultStyleException.generate(ResultStyle.ITERABLE_MUTABLELIST_LIST, Collections.singletonList(desiredResultStyle));
        }

        protected TupleList executeList(SqlTupleReader tr) {
            RolapNative.TupleEvent e;
            boolean hasEnumTargets;
            tr.setMaxRows(this.maxRows);
            CrossJoinArg[] crossJoinArgArray = this.args;
            int n = this.args.length;
            int n2 = 0;
            while (n2 < n) {
                CrossJoinArg arg = crossJoinArgArray[n2];
                this.addLevel(tr, arg);
                ++n2;
            }
            ArrayList<Object> key = new ArrayList<Object>();
            key.add(tr.getCacheKey());
            key.addAll(Arrays.asList(this.args));
            TupleList result = (TupleList)RolapNativeSet.this.cache.get(key);
            boolean bl = hasEnumTargets = tr.getEnumTargetCount() > 0;
            if (result != null && !hasEnumTargets) {
                if (RolapNativeSet.this.listener != null) {
                    e = new RolapNative.TupleEvent(this, tr);
                    RolapNativeSet.this.listener.foundInCache(e);
                }
                return new DelegatingTupleList(this.args.length, Util.cast(result));
            }
            if (result == null && RolapNativeSet.this.listener != null) {
                e = new RolapNative.TupleEvent(this, tr);
                RolapNativeSet.this.listener.executingSql(e);
            }
            TupleList partialResult = result;
            ArrayList<List<RolapMember>> newPartialResult = null;
            if (hasEnumTargets && partialResult == null) {
                newPartialResult = new ArrayList<List<RolapMember>>();
            }
            DataSource dataSource = this.schemaReader.getDataSource();
            result = this.args.length == 1 ? tr.readMembers(dataSource, partialResult, newPartialResult) : tr.readTuples(dataSource, partialResult, newPartialResult);
            if (!MondrianProperties.instance().DisableCaching.get()) {
                if (hasEnumTargets) {
                    if (newPartialResult != null) {
                        RolapNativeSet.this.cache.put(key, new DelegatingTupleList(this.args.length, Util.cast(newPartialResult)));
                    }
                } else {
                    RolapNativeSet.this.cache.put(key, result);
                }
            }
            return result;
        }

        private void addLevel(TupleReader tr, CrossJoinArg arg) {
            RolapLevel level = arg.getLevel();
            if (level == null) {
                return;
            }
            RolapHierarchy hierarchy = level.getHierarchy();
            MemberReader mr = this.schemaReader.getMemberReader(hierarchy);
            TupleReader.MemberBuilder mb = mr.getMemberBuilder();
            Util.assertTrue(mb != null, "MemberBuilder not found");
            if (arg instanceof MemberListCrossJoinArg && ((MemberListCrossJoinArg)arg).hasCalcMembers()) {
                tr.addLevelMembers(level, mb, arg.getMembers());
            } else {
                tr.addLevelMembers(level, mb, null);
            }
        }

        int getMaxRows() {
            return this.maxRows;
        }

        void setMaxRows(int maxRows) {
            this.maxRows = maxRows;
        }
    }
}

