/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import mondrian.olap.MondrianException;
import mondrian.olap.MondrianProperties;
import mondrian.olap.ResourceLimitExceededException;
import mondrian.olap.Result;
import mondrian.olap.Util;
import mondrian.resource.MondrianResource;
import mondrian.server.Execution;
import mondrian.util.Pair;
import org.eigenbase.util.property.IntegerProperty;

public class RolapResultShepherd {
    private final ExecutorService executor;
    private final List<Pair<FutureTask<Result>, Execution>> tasks = new CopyOnWriteArrayList<Pair<FutureTask<Result>, Execution>>();
    private final Timer timer = Util.newTimer("mondrian.rolap.RolapResultShepherd#timer", true);

    public RolapResultShepherd() {
        final IntegerProperty property = MondrianProperties.instance().RolapConnectionShepherdNbThreads;
        final int maximumPoolSize = property.get();
        this.executor = Util.getExecutorService(maximumPoolSize, 0, 1L, "mondrian.rolap.RolapResultShepherd$executor", new RejectedExecutionHandler(){

            @Override
            public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
                throw MondrianResource.instance().QueryLimitReached.ex(maximumPoolSize, property.getPath());
            }
        });
        Pair<Long, TimeUnit> interval = Util.parseInterval(String.valueOf(MondrianProperties.instance().RolapConnectionShepherdThreadPollingInterval.get()), TimeUnit.MILLISECONDS);
        long period = ((TimeUnit)((Object)interval.right)).toMillis((Long)interval.left);
        this.timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                for (final Pair task : RolapResultShepherd.this.tasks) {
                    if (((FutureTask)task.left).isDone()) {
                        RolapResultShepherd.this.tasks.remove(task);
                        continue;
                    }
                    if (!((Execution)task.right).isCancelOrTimeout()) continue;
                    RolapResultShepherd.this.tasks.remove(task);
                    ((FutureTask)task.left).cancel(false);
                    RolapResultShepherd.this.executor.submit(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                ((Execution)task.right).cancelSqlStatements();
                            }
                            catch (Throwable e) {
                                e.printStackTrace();
                            }
                        }
                    });
                }
            }
        }, period, period);
    }

    public Result shepherdExecution(Execution execution, Callable<Result> callable) {
        FutureTask<Result> task = new FutureTask<Result>(callable);
        Pair<FutureTask<Result>, Execution> pair = new Pair<FutureTask<Result>, Execution>(task, execution);
        this.tasks.add(pair);
        try {
            this.executor.execute(task);
            return task.get();
        }
        catch (Exception e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            Throwable node = e;
            if (e instanceof ExecutionException) {
                ExecutionException executionException = (ExecutionException)e;
                node = executionException.getCause();
            }
            execution.checkCancelOrTimeout();
            ResourceLimitExceededException t = Util.getMatchingCause(node, ResourceLimitExceededException.class);
            if (t != null) {
                throw t;
            }
            if (node instanceof RuntimeException) {
                throw (RuntimeException)node;
            }
            if (node instanceof Error) {
                throw (Error)node;
            }
            throw new MondrianException(node);
        }
    }

    public void shutdown() {
        this.timer.cancel();
        this.executor.shutdown();
        this.tasks.clear();
    }
}

