/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import mondrian.olap.Access;
import mondrian.olap.Member;
import mondrian.olap.Role;
import mondrian.rolap.MemberReader;
import mondrian.rolap.RestrictedMemberReader;
import mondrian.rolap.RolapHierarchy;
import mondrian.rolap.RolapMember;
import mondrian.rolap.sql.MemberChildrenConstraint;

class SmartRestrictedMemberReader
extends RestrictedMemberReader {
    final Map<RolapMember, AccessAwareMemberList> memberToChildren = new WeakHashMap<RolapMember, AccessAwareMemberList>();
    final ReadWriteLock lock = new ReentrantReadWriteLock();

    SmartRestrictedMemberReader(MemberReader memberReader, Role role) {
        super(memberReader, role);
    }

    @Override
    public Map<? extends Member, Access> getMemberChildren(RolapMember member, List<RolapMember> children, MemberChildrenConstraint constraint) {
        if (member instanceof RolapHierarchy.LimitedRollupMember) {
            member = ((RolapHierarchy.LimitedRollupMember)member).member;
        }
        try {
            this.lock.readLock().lock();
            AccessAwareMemberList memberList = this.memberToChildren.get(member);
            if (memberList != null) {
                children.addAll(memberList.children);
                Map map = memberList.accessMap;
                return map;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        try {
            this.lock.writeLock().lock();
            Map<? extends Member, Access> membersWithAccessDetails = super.getMemberChildren(member, children, constraint);
            this.memberToChildren.put(member, new AccessAwareMemberList(membersWithAccessDetails, new ArrayList<Member>(membersWithAccessDetails.keySet())));
            Map<? extends Member, Access> map = membersWithAccessDetails;
            return map;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private static class AccessAwareMemberList {
        private final Map<? extends Member, Access> accessMap;
        private final Collection<RolapMember> children;

        public AccessAwareMemberList(Map<? extends Member, Access> accessMap, Collection<RolapMember> children) {
            this.accessMap = accessMap;
            this.children = children;
        }
    }
}

