/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.SequencedCollection;
import java.util.Set;
import mondrian.olap.Evaluator;
import mondrian.olap.Hierarchy;
import mondrian.olap.Level;
import mondrian.olap.Member;
import mondrian.olap.MondrianDef;
import mondrian.olap.MondrianProperties;
import mondrian.olap.SchemaReader;
import mondrian.olap.Util;
import mondrian.rolap.RestrictedMemberReader;
import mondrian.rolap.RolapAggregationManager;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapCubeHierarchy;
import mondrian.rolap.RolapCubeLevel;
import mondrian.rolap.RolapEvaluator;
import mondrian.rolap.RolapHierarchy;
import mondrian.rolap.RolapLevel;
import mondrian.rolap.RolapMember;
import mondrian.rolap.RolapStar;
import mondrian.rolap.RolapUtil;
import mondrian.rolap.StarColumnPredicate;
import mondrian.rolap.agg.CellRequest;
import mondrian.rolap.agg.ListColumnPredicate;
import mondrian.rolap.agg.LiteralStarPredicate;
import mondrian.rolap.agg.MemberColumnPredicate;
import mondrian.rolap.aggmatcher.AggStar;
import mondrian.rolap.sql.SqlQuery;
import mondrian.spi.Dialect;
import mondrian.util.FilteredIterableList;

public class SqlConstraintUtils {
    private SqlConstraintUtils() {
    }

    public static void addContextConstraint(SqlQuery sqlQuery, AggStar aggStar, Evaluator evaluator, boolean restrictMemberTypes) {
        CellRequest request;
        Member[] members = evaluator.getNonAllMembers();
        RolapCube baseCube = null;
        if (evaluator instanceof RolapEvaluator) {
            baseCube = ((RolapEvaluator)evaluator).getCube();
        }
        HashMap mapOfSlicerMembers = new HashMap();
        HashMap<MondrianDef.Relation, Boolean> done = new HashMap<MondrianDef.Relation, Boolean>();
        if (restrictMemberTypes) {
            if (SqlConstraintUtils.containsCalculatedMember(members)) {
                throw Util.newInternal("can not restrict SQL to calculated Members");
            }
            if (SqlConstraintUtils.hasMultiPositionSlicer(evaluator)) {
                List<Member> slicerMembers = ((RolapEvaluator)evaluator).getSlicerMembers();
                for (Member slicerMember : slicerMembers) {
                    MondrianDef.RelationOrJoin rel = ((RolapCubeHierarchy)slicerMember.getHierarchy()).getRelation();
                    if (!mapOfSlicerMembers.containsKey((Object)rel)) {
                        mapOfSlicerMembers.put(rel, new HashSet());
                    }
                    ((Set)mapOfSlicerMembers.get((Object)rel)).add((RolapMember)slicerMember);
                }
            }
        } else {
            members = SqlConstraintUtils.removeCalculatedAndDefaultMembers(members);
            members = SqlConstraintUtils.removeMultiPositionSlicerMembers(members, evaluator);
        }
        if ((request = RolapAggregationManager.makeRequest(members)) == null) {
            if (restrictMemberTypes) {
                throw Util.newInternal("CellRequest is null - why?");
            }
            return;
        }
        RolapStar.Column[] columns = request.getConstrainedColumns();
        Object[] values = request.getSingleValues();
        int arity = columns.length;
        int i = 0;
        while (i < arity) {
            String expr;
            RolapStar.Column column = columns[i];
            if (aggStar != null) {
                int bitPos = column.getBitPosition();
                AggStar.Table.Column aggColumn = aggStar.lookupColumn(bitPos);
                AggStar.Table table = aggColumn.getTable();
                table.addToFrom(sqlQuery, false, true);
                expr = aggColumn.generateExprString(sqlQuery);
            } else {
                RolapStar.Table table = column.getTable();
                table.addToFrom(sqlQuery, false, true);
                expr = column.generateExprString(sqlQuery);
            }
            String value = String.valueOf(values[i]);
            if (RolapUtil.mdxNullLiteral().equalsIgnoreCase(value) || value.equalsIgnoreCase(RolapUtil.sqlNullValue.toString())) {
                sqlQuery.addWhere(expr, " is ", "null");
            } else {
                MondrianDef.Relation keyForSlicerMap;
                if (column.getDatatype().isNumeric()) {
                    Double.valueOf(value);
                }
                if (mapOfSlicerMembers.containsKey((Object)(keyForSlicerMap = column.getTable().getRelation()))) {
                    if (!done.containsKey((Object)keyForSlicerMap)) {
                        Set slicerMembersArray = (Set)mapOfSlicerMembers.get((Object)keyForSlicerMap);
                        ArrayList<RolapMember> slicerMembers = new ArrayList<RolapMember>(slicerMembersArray);
                        RolapMember allMember = null;
                        for (RolapMember slicerMember : slicerMembers) {
                            if (!slicerMember.isAll()) continue;
                            allMember = slicerMember;
                            break;
                        }
                        if (allMember != null) {
                            slicerMembers.remove(allMember);
                        }
                        if (slicerMembers.size() > 0) {
                            int levelIndex = ((RolapMember)slicerMembers.get(0)).getHierarchy().getLevels().length;
                            RolapLevel levelForWhere = (RolapLevel)((RolapMember)slicerMembers.get(0)).getHierarchy().getLevels()[levelIndex - 1];
                            String where = SqlConstraintUtils.generateSingleValueInExpr(sqlQuery, baseCube, aggStar, slicerMembers, levelForWhere, restrictMemberTypes, false);
                            sqlQuery.addWhere(where);
                        } else {
                            StringBuilder buf = new StringBuilder();
                            sqlQuery.getDialect().quote(buf, value, column.getDatatype());
                            sqlQuery.addWhere(expr, " = ", buf.toString());
                        }
                        done.put(keyForSlicerMap, Boolean.TRUE);
                    }
                } else {
                    StringBuilder buf = new StringBuilder();
                    sqlQuery.getDialect().quote(buf, value, column.getDatatype());
                    sqlQuery.addWhere(expr, " = ", buf.toString());
                }
            }
            ++i;
        }
        LinkedHashMap<RolapCubeLevel, String> whereClausesForRoleConstraints = new LinkedHashMap<RolapCubeLevel, String>();
        SchemaReader schemaReader = evaluator.getSchemaReader();
        Member[] mm = evaluator.getMembers();
        int mIndex = 0;
        while (mIndex < mm.length) {
            if (mm[mIndex] instanceof RolapHierarchy.LimitedRollupMember || mm[mIndex] instanceof RestrictedMemberReader.MultiCardinalityDefaultMember) {
                List<Level> hierarchyLevels = schemaReader.getHierarchyLevels(mm[mIndex].getHierarchy());
                for (Level affectedLevel : hierarchyLevels) {
                    ArrayList<RolapMember> slicerMembers = new ArrayList<RolapMember>();
                    List<Member> availableMembers = schemaReader.getLevelMembers(affectedLevel, false);
                    for (Member member : availableMembers) {
                        if (member.isAll()) continue;
                        slicerMembers.add((RolapMember)member);
                    }
                    if (slicerMembers.size() <= 0) continue;
                    String where = SqlConstraintUtils.generateSingleValueInExpr(sqlQuery, baseCube, aggStar, slicerMembers, (RolapCubeLevel)affectedLevel, restrictMemberTypes, false);
                    whereClausesForRoleConstraints.put((RolapCubeLevel)affectedLevel, where);
                }
            }
            ++mIndex;
        }
        for (Map.Entry entry : whereClausesForRoleConstraints.entrySet()) {
            SqlConstraintUtils.joinLevelTableToFactTable(sqlQuery, baseCube, aggStar, evaluator, (RolapCubeLevel)entry.getKey());
            sqlQuery.addWhere((String)entry.getValue());
        }
    }

    public static boolean hasMultiPositionSlicer(Evaluator evaluator) {
        if (evaluator instanceof RolapEvaluator) {
            HashMap<Hierarchy, Member> mapOfSlicerMembers = new HashMap<Hierarchy, Member>();
            for (Member slicerMember : ((RolapEvaluator)evaluator).getSlicerMembers()) {
                Hierarchy hierarchy = slicerMember.getHierarchy();
                if (mapOfSlicerMembers.containsKey(hierarchy)) {
                    return true;
                }
                mapOfSlicerMembers.put(hierarchy, slicerMember);
            }
        }
        return false;
    }

    protected static Member[] removeMultiPositionSlicerMembers(Member[] members, Evaluator evaluator) {
        List<Member> slicerMembers = null;
        if (evaluator instanceof RolapEvaluator) {
            slicerMembers = ((RolapEvaluator)evaluator).getSlicerMembers();
        }
        if (slicerMembers != null) {
            HashMap mapOfSlicerMembers = new HashMap();
            for (Member slicerMember : slicerMembers) {
                Hierarchy hierarchy = slicerMember.getHierarchy();
                if (!mapOfSlicerMembers.containsKey(hierarchy)) {
                    mapOfSlicerMembers.put(hierarchy, new HashSet());
                }
                ((Set)mapOfSlicerMembers.get(hierarchy)).add(slicerMember);
            }
            ArrayList<Member> listOfMembers = new ArrayList<Member>();
            Member[] memberArray = members;
            int n = members.length;
            int n2 = 0;
            while (n2 < n) {
                Member member = memberArray[n2];
                Hierarchy hierarchy = member.getHierarchy();
                if (!mapOfSlicerMembers.containsKey(hierarchy) || ((Set)mapOfSlicerMembers.get(hierarchy)).size() < 2) {
                    listOfMembers.add(member);
                }
                ++n2;
            }
            members = listOfMembers.toArray(new Member[listOfMembers.size()]);
        }
        return members;
    }

    private static Member[] removeCalculatedAndDefaultMembers(Member[] members) {
        ArrayList<Member> memberList = new ArrayList<Member>(members.length);
        int i = 0;
        while (i < members.length) {
            Member member = members[i];
            if (!(member.isCalculated() && !member.isParentChildLeaf() || i > 0 && member.getHierarchy().getDefaultMember().equals(member))) {
                memberList.add(member);
            }
            ++i;
        }
        return memberList.toArray(new Member[memberList.size()]);
    }

    static List<Member> removeCalculatedMembers(List<Member> members) {
        return new FilteredIterableList<Member>(members, new FilteredIterableList.Filter<Member>(){

            @Override
            public boolean accept(Member m) {
                return !m.isCalculated() || m.isParentChildLeaf();
            }
        });
    }

    public static boolean containsCalculatedMember(Member[] members) {
        Member[] memberArray = members;
        int n = members.length;
        int n2 = 0;
        while (n2 < n) {
            Member member = memberArray[n2];
            if (member.isCalculated()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static void joinLevelTableToFactTable(SqlQuery sqlQuery, RolapCube baseCube, AggStar aggStar, Evaluator e, RolapCubeLevel level) {
        RolapStar.Column starColumn = level.getBaseStarKeyColumn(baseCube);
        if (aggStar != null) {
            int bitPos = starColumn.getBitPosition();
            AggStar.Table.Column aggColumn = aggStar.lookupColumn(bitPos);
            AggStar.Table table = aggColumn.getTable();
            table.addToFrom(sqlQuery, false, true);
        } else {
            RolapStar.Table table = starColumn.getTable();
            assert (table != null);
            table.addToFrom(sqlQuery, false, true);
        }
    }

    public static void addMemberConstraint(SqlQuery sqlQuery, RolapCube baseCube, AggStar aggStar, RolapMember parent, boolean restrictMemberTypes) {
        List<RolapMember> list = Collections.singletonList(parent);
        boolean exclude = false;
        SqlConstraintUtils.addMemberConstraint(sqlQuery, baseCube, aggStar, list, restrictMemberTypes, false, exclude);
    }

    public static void addMemberConstraint(SqlQuery sqlQuery, RolapCube baseCube, AggStar aggStar, List<RolapMember> members, boolean restrictMemberTypes, boolean crossJoin, boolean exclude) {
        if (members.size() == 0) {
            String predicate = "(1 = 0)";
            if (exclude) {
                predicate = "(1 = 1)";
            }
            sqlQuery.addWhere(predicate);
            return;
        }
        RolapMember member = members.get(0);
        RolapLevel memberLevel = member.getLevel();
        RolapMember firstUniqueParent = member;
        RolapLevel firstUniqueParentLevel = null;
        while (firstUniqueParent != null && !firstUniqueParent.getLevel().isUnique()) {
            firstUniqueParent = firstUniqueParent.getParentMember();
        }
        if (firstUniqueParent != null) {
            firstUniqueParentLevel = firstUniqueParent.getLevel();
        }
        String condition = "(";
        if (crossJoin && !memberLevel.isUnique() && !SqlConstraintUtils.membersAreCrossProduct(members)) {
            assert (member.getParentMember() != null);
            condition = String.valueOf(condition) + SqlConstraintUtils.constrainMultiLevelMembers(sqlQuery, baseCube, aggStar, members, firstUniqueParentLevel, restrictMemberTypes, exclude);
        } else {
            condition = String.valueOf(condition) + SqlConstraintUtils.generateSingleValueInExpr(sqlQuery, baseCube, aggStar, members, firstUniqueParentLevel, restrictMemberTypes, exclude);
        }
        if (condition.length() > 1) {
            condition = String.valueOf(condition) + ")";
            sqlQuery.addWhere(condition);
        }
    }

    private static StarColumnPredicate getColumnPredicates(RolapStar.Column column, Collection<RolapMember> members) {
        switch (members.size()) {
            case 0: {
                return new LiteralStarPredicate(column, false);
            }
            case 1: {
                return new MemberColumnPredicate(column, members.iterator().next());
            }
        }
        ArrayList<StarColumnPredicate> predicateList = new ArrayList<StarColumnPredicate>();
        for (RolapMember member : members) {
            predicateList.add(new MemberColumnPredicate(column, member));
        }
        return new ListColumnPredicate(column, predicateList);
    }

    private static LinkedHashSet<RolapMember> getUniqueParentMembers(Collection<RolapMember> members) {
        LinkedHashSet<RolapMember> set = new LinkedHashSet<RolapMember>();
        for (RolapMember m : members) {
            if ((m = m.getParentMember()) == null) continue;
            set.add(m);
        }
        return set;
    }

    private static String constrainMultiLevelMembers(SqlQuery sqlQuery, RolapCube baseCube, AggStar aggStar, List<RolapMember> members, RolapLevel fromLevel, boolean restrictMemberTypes, boolean exclude) {
        LinkedHashMap<RolapMember, List<RolapMember>> parentChildrenMap = new LinkedHashMap<RolapMember, List<RolapMember>>();
        StringBuilder condition = new StringBuilder();
        StringBuilder condition1 = new StringBuilder();
        if (exclude) {
            condition.append("not (");
        }
        if (sqlQuery.getDialect().supportsMultiValueInExpr()) {
            condition1.append(SqlConstraintUtils.generateMultiValueInExpr(sqlQuery, baseCube, aggStar, members, fromLevel, restrictMemberTypes, parentChildrenMap));
            if (parentChildrenMap.isEmpty()) {
                condition.append(condition1.toString());
                if (exclude) {
                    condition.append(")");
                    condition.append(" or ");
                    condition.append(SqlConstraintUtils.generateMultiValueIsNullExprs(sqlQuery, baseCube, members.get(0), fromLevel));
                }
                return condition.toString();
            }
        } else {
            for (RolapMember m : members) {
                if (m.isCalculated()) {
                    if (!restrictMemberTypes) continue;
                    throw Util.newInternal("addMemberConstraint: cannot restrict SQL to calculated member :" + m);
                }
                RolapMember p = m.getParentMember();
                ArrayList<RolapMember> childrenList = (ArrayList<RolapMember>)parentChildrenMap.get(p);
                if (childrenList == null) {
                    childrenList = new ArrayList<RolapMember>();
                    parentChildrenMap.put(p, childrenList);
                }
                childrenList.add(m);
            }
        }
        boolean firstParent = true;
        StringBuilder condition2 = new StringBuilder();
        if (condition1.length() > 0) {
            firstParent = false;
            condition.append(condition1.toString());
            condition.append(" or ");
        }
        RolapLevel memberLevel = members.get(0).getLevel();
        for (RolapMember p : parentChildrenMap.keySet()) {
            assert (p != null);
            if (condition2.toString().length() > 0) {
                condition2.append(" or ");
            }
            condition2.append("(");
            int levelCount = 0;
            RolapMember gp = p;
            while (gp != null) {
                if (!gp.isAll()) {
                    RolapLevel level = gp.getLevel();
                    if (firstParent) {
                        RolapHierarchy hierarchy = level.getHierarchy();
                        RolapStar.Column column = null;
                        if (level instanceof RolapCubeLevel) {
                            column = ((RolapCubeLevel)level).getBaseStarKeyColumn(baseCube);
                        }
                        if (column != null) {
                            if (aggStar != null) {
                                int bitPos = column.getBitPosition();
                                AggStar.Table.Column aggColumn = aggStar.lookupColumn(bitPos);
                                AggStar.Table table = aggColumn.getTable();
                                table.addToFrom(sqlQuery, false, true);
                            } else {
                                RolapStar.Table targetTable = column.getTable();
                                hierarchy.addToFrom(sqlQuery, targetTable);
                            }
                        } else {
                            assert (aggStar == null);
                            hierarchy.addToFrom(sqlQuery, level.getKeyExp());
                        }
                    }
                    if (levelCount > 0) {
                        condition2.append(" and ");
                    }
                    ++levelCount;
                    condition2.append(SqlConstraintUtils.constrainLevel(level, sqlQuery, baseCube, aggStar, SqlConstraintUtils.getColumnValue(level.nameExp != null ? gp.getName() : gp.getKey(), sqlQuery.getDialect(), level.getDatatype()), false));
                    if (gp.getLevel() == fromLevel) break;
                }
                gp = gp.getParentMember();
            }
            firstParent = false;
            List children = (List)parentChildrenMap.get(p);
            if (!children.isEmpty()) {
                HashMap<RolapMember, List<RolapMember>> tmpParentChildrenMap = new HashMap<RolapMember, List<RolapMember>>();
                if (levelCount > 0) {
                    condition2.append(" and ");
                }
                RolapLevel childrenLevel = (RolapLevel)p.getLevel().getChildLevel();
                if (sqlQuery.getDialect().supportsMultiValueInExpr() && childrenLevel != memberLevel) {
                    condition2.append(SqlConstraintUtils.generateMultiValueInExpr(sqlQuery, baseCube, aggStar, children, childrenLevel, restrictMemberTypes, tmpParentChildrenMap));
                    assert (tmpParentChildrenMap.isEmpty());
                } else {
                    assert (childrenLevel == memberLevel);
                    condition2.append(SqlConstraintUtils.generateSingleValueInExpr(sqlQuery, baseCube, aggStar, children, childrenLevel, restrictMemberTypes, false));
                }
            }
            condition2.append(")");
        }
        condition.append(condition2.toString());
        if (exclude) {
            condition.append(") or (");
            condition.append(SqlConstraintUtils.generateMultiValueIsNullExprs(sqlQuery, baseCube, members.get(0), fromLevel));
            condition.append(" and not(");
            condition.append(condition2.toString());
            condition.append("))");
        }
        return condition.toString();
    }

    private static boolean membersAreCrossProduct(List<RolapMember> members) {
        int crossProdSize = SqlConstraintUtils.getNumUniqueMemberKeys(members);
        LinkedHashSet<RolapMember> parents = SqlConstraintUtils.getUniqueParentMembers(members);
        while (!parents.isEmpty()) {
            crossProdSize *= parents.size();
            parents = SqlConstraintUtils.getUniqueParentMembers(parents);
        }
        return crossProdSize == members.size();
    }

    private static int getNumUniqueMemberKeys(List<RolapMember> members) {
        HashSet<Object> set = new HashSet<Object>();
        for (RolapMember m : members) {
            set.add(m.getKey());
        }
        return set.size();
    }

    private static String getColumnValue(Object key, Dialect dialect, Dialect.Datatype datatype) {
        if (key != RolapUtil.sqlNullValue) {
            return key.toString();
        }
        return RolapUtil.mdxNullLiteral();
    }

    public static String constrainLevel(RolapLevel level, SqlQuery query, RolapCube baseCube, AggStar aggStar, String columnValue, boolean caseSensitive) {
        String constraint;
        String columnString;
        Dialect.Datatype datatype;
        RolapStar.Column column = null;
        if (level instanceof RolapCubeLevel) {
            column = ((RolapCubeLevel)level).getBaseStarKeyColumn(baseCube);
        }
        if (column != null) {
            if (column.getNameColumn() == null) {
                datatype = level.getDatatype();
            } else {
                column = column.getNameColumn();
                datatype = Dialect.Datatype.String;
            }
            if (aggStar != null) {
                int bitPos = column.getBitPosition();
                AggStar.Table.Column aggColumn = aggStar.lookupColumn(bitPos);
                columnString = aggColumn.generateExprString(query);
            } else {
                columnString = column.generateExprString(query);
            }
        } else {
            assert (aggStar == null);
            MondrianDef.Expression exp = level.getNameExp();
            if (exp == null) {
                exp = level.getKeyExp();
                datatype = level.getDatatype();
            } else {
                datatype = Dialect.Datatype.String;
            }
            columnString = exp.getExpression(query);
        }
        if (RolapUtil.mdxNullLiteral().equalsIgnoreCase(columnValue)) {
            constraint = String.valueOf(columnString) + " is " + "null";
        } else {
            if (datatype.isNumeric()) {
                Double.valueOf(columnValue);
            }
            StringBuilder buf = new StringBuilder();
            query.getDialect().quote(buf, columnValue, datatype);
            String value = buf.toString();
            if (caseSensitive && datatype == Dialect.Datatype.String && !MondrianProperties.instance().CaseSensitive.get()) {
                columnString = query.getDialect().toUpper(columnString);
                value = query.getDialect().toUpper(value);
            }
            constraint = String.valueOf(columnString) + " = " + value;
        }
        return constraint;
    }

    public static String constrainLevel2(SqlQuery query, MondrianDef.Expression exp, Dialect.Datatype datatype, Comparable columnValue) {
        String columnString = exp.getExpression(query);
        if (columnValue == RolapUtil.sqlNullValue) {
            return String.valueOf(columnString) + " is " + "null";
        }
        StringBuilder buf = new StringBuilder();
        buf.append(columnString);
        buf.append(" = ");
        query.getDialect().quote(buf, columnValue, datatype);
        return buf.toString();
    }

    private static String generateMultiValueInExpr(SqlQuery sqlQuery, RolapCube baseCube, AggStar aggStar, List<RolapMember> members, RolapLevel fromLevel, boolean restrictMemberTypes, Map<RolapMember, List<RolapMember>> parentWithNullToChildrenMap) {
        StringBuilder columnBuf = new StringBuilder();
        StringBuilder valueBuf = new StringBuilder();
        StringBuilder memberBuf = new StringBuilder();
        columnBuf.append("(");
        int ordinalInMultiple = 0;
        RolapMember m = members.get(0);
        while (m != null) {
            if (!m.isAll()) {
                String columnString;
                RolapLevel level = m.getLevel();
                RolapHierarchy hierarchy = level.getHierarchy();
                RolapStar.Column column = null;
                if (level instanceof RolapCubeLevel) {
                    column = ((RolapCubeLevel)level).getBaseStarKeyColumn(baseCube);
                }
                if (column != null) {
                    if (aggStar != null) {
                        int bitPos = column.getBitPosition();
                        AggStar.Table.Column aggColumn = aggStar.lookupColumn(bitPos);
                        AggStar.Table table = aggColumn.getTable();
                        table.addToFrom(sqlQuery, false, true);
                        columnString = aggColumn.generateExprString(sqlQuery);
                    } else {
                        RolapStar.Table targetTable = column.getTable();
                        hierarchy.addToFrom(sqlQuery, targetTable);
                        columnString = column.generateExprString(sqlQuery);
                    }
                } else {
                    assert (aggStar == null);
                    hierarchy.addToFrom(sqlQuery, level.getKeyExp());
                    MondrianDef.Expression nameExp = level.getNameExp();
                    if (nameExp == null) {
                        nameExp = level.getKeyExp();
                    }
                    columnString = nameExp.getExpression(sqlQuery);
                }
                if (ordinalInMultiple++ > 0) {
                    columnBuf.append(", ");
                }
                columnBuf.append(columnString);
                if (m.getLevel() == fromLevel) break;
            }
            m = m.getParentMember();
        }
        columnBuf.append(")");
        valueBuf.append("(");
        int memberOrdinal = 0;
        for (RolapMember m2 : members) {
            if (m2.isCalculated()) {
                if (!restrictMemberTypes) continue;
                throw Util.newInternal("addMemberConstraint: cannot restrict SQL to calculated member :" + m2);
            }
            ordinalInMultiple = 0;
            memberBuf.setLength(0);
            memberBuf.append("(");
            boolean containsNull = false;
            RolapMember p = m2;
            while (p != null) {
                if (!p.isAll()) {
                    RolapLevel level = p.getLevel();
                    String value = SqlConstraintUtils.getColumnValue(p.getKey(), sqlQuery.getDialect(), level.getDatatype());
                    if (RolapUtil.mdxNullLiteral().equalsIgnoreCase(value)) {
                        List<RolapMember> childrenList = parentWithNullToChildrenMap.get(p);
                        if (childrenList == null) {
                            childrenList = new ArrayList<RolapMember>();
                            parentWithNullToChildrenMap.put(p, childrenList);
                        }
                        if (m2 != p) {
                            childrenList.add(m2);
                        }
                        containsNull = true;
                        break;
                    }
                    if (ordinalInMultiple++ > 0) {
                        memberBuf.append(", ");
                    }
                    sqlQuery.getDialect().quote(memberBuf, value, level.getDatatype());
                    if (p.getLevel() == fromLevel) break;
                }
                p = p.getParentMember();
            }
            if (containsNull) continue;
            memberBuf.append(")");
            if (memberOrdinal++ > 0) {
                valueBuf.append(", ");
            }
            valueBuf.append((CharSequence)memberBuf);
        }
        StringBuilder condition = new StringBuilder();
        if (memberOrdinal > 0) {
            condition.append((CharSequence)columnBuf);
            condition.append(" in ");
            condition.append((CharSequence)valueBuf);
            condition.append(")");
        }
        return condition.toString();
    }

    private static String generateMultiValueIsNullExprs(SqlQuery sqlQuery, RolapCube baseCube, RolapMember member, RolapLevel fromLevel) {
        StringBuilder conditionBuf = new StringBuilder();
        conditionBuf.append("(");
        boolean isFirstLevelInMultiple = true;
        RolapMember m = member;
        while (m != null) {
            if (!m.isAll()) {
                String columnString;
                RolapLevel level = m.getLevel();
                RolapStar.Column column = null;
                if (level instanceof RolapCubeLevel) {
                    column = ((RolapCubeLevel)level).getBaseStarKeyColumn(baseCube);
                }
                if (column != null) {
                    RolapStar.Column nameColumn = column.getNameColumn();
                    if (nameColumn == null) {
                        nameColumn = column;
                    }
                    columnString = nameColumn.generateExprString(sqlQuery);
                } else {
                    MondrianDef.Expression nameExp = level.getNameExp();
                    if (nameExp == null) {
                        nameExp = level.getKeyExp();
                    }
                    columnString = nameExp.getExpression(sqlQuery);
                }
                if (!isFirstLevelInMultiple) {
                    conditionBuf.append(" or ");
                } else {
                    isFirstLevelInMultiple = false;
                }
                conditionBuf.append(columnString);
                conditionBuf.append(" is null");
                if (m.getLevel() == fromLevel) break;
            }
            m = m.getParentMember();
        }
        conditionBuf.append(")");
        return conditionBuf.toString();
    }

    private static String generateSingleValueInExpr(SqlQuery sqlQuery, RolapCube baseCube, AggStar aggStar, List<RolapMember> members, RolapLevel fromLevel, boolean restrictMemberTypes, boolean exclude) {
        int maxConstraints = MondrianProperties.instance().MaxConstraints.get();
        Dialect dialect = sqlQuery.getDialect();
        String condition = "";
        boolean firstLevel = true;
        SequencedCollection<RolapMember> c = members;
        while (!c.isEmpty()) {
            RolapMember m2 = (RolapMember)c.iterator().next();
            if (!m2.isAll()) {
                if (m2.isNull()) {
                    return "1 = 0";
                }
                if (m2.isCalculated() && !m2.isParentChildLeaf()) {
                    if (restrictMemberTypes) {
                        throw Util.newInternal("addMemberConstraint: cannot restrict SQL to calculated member :" + m2);
                    }
                } else {
                    String where;
                    String q;
                    boolean containsNullKey = false;
                    for (RolapMember m2 : c) {
                        if (m2.getKey() != RolapUtil.sqlNullValue) continue;
                        containsNullKey = true;
                    }
                    RolapLevel level = m2.getLevel();
                    RolapHierarchy hierarchy = level.getHierarchy();
                    RolapStar.Column column = null;
                    if (level instanceof RolapCubeLevel) {
                        column = ((RolapCubeLevel)level).getBaseStarKeyColumn(baseCube);
                    }
                    if (column != null) {
                        if (aggStar != null) {
                            int bitPos = column.getBitPosition();
                            AggStar.Table.Column aggColumn = aggStar.lookupColumn(bitPos);
                            if (aggColumn == null) {
                                throw Util.newInternal("AggStar " + aggStar + " has no column for " + column + " (bitPos " + bitPos + ")");
                            }
                            AggStar.Table table = aggColumn.getTable();
                            table.addToFrom(sqlQuery, false, true);
                            q = aggColumn.generateExprString(sqlQuery);
                        } else {
                            RolapStar.Table targetTable = column.getTable();
                            hierarchy.addToFrom(sqlQuery, targetTable);
                            q = column.generateExprString(sqlQuery);
                        }
                    } else {
                        assert (aggStar == null);
                        hierarchy.addToFrom(sqlQuery, level.getKeyExp());
                        q = level.getKeyExp().getExpression(sqlQuery);
                    }
                    StarColumnPredicate cc = SqlConstraintUtils.getColumnPredicates(column, c);
                    if (!(!dialect.supportsUnlimitedValueList() && cc instanceof ListColumnPredicate && ((ListColumnPredicate)cc).getPredicates().size() > maxConstraints || (where = RolapStar.Column.createInExpr(q, cc, level.getDatatype(), sqlQuery)).equals("true"))) {
                        if (!firstLevel) {
                            condition = exclude ? String.valueOf(condition) + " or " : String.valueOf(condition) + " and ";
                        } else {
                            firstLevel = false;
                        }
                        if (exclude) {
                            where = "not (" + where + ")";
                            if (!containsNullKey) {
                                where = "(" + where + " or " + "(" + q + " is null))";
                            }
                        }
                        condition = String.valueOf(condition) + where;
                    }
                    if (m2.getLevel().isUnique() || m2.getLevel() == fromLevel) break;
                }
            }
            c = SqlConstraintUtils.getUniqueParentMembers(c);
        }
        return condition;
    }
}

