/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import javax.sql.DataSource;
import mondrian.olap.Util;
import mondrian.rolap.RolapSchema;
import mondrian.rolap.RolapUtil;
import mondrian.server.Execution;
import mondrian.server.Locus;
import mondrian.server.monitor.SqlStatementEndEvent;
import mondrian.server.monitor.SqlStatementEvent;
import mondrian.server.monitor.SqlStatementExecuteEvent;
import mondrian.server.monitor.SqlStatementStartEvent;
import mondrian.spi.Dialect;
import mondrian.util.Counters;
import mondrian.util.DelegatingInvocationHandler;
import org.apache.log4j.Logger;

public class SqlStatement {
    private static final Logger LOG = Logger.getLogger(SqlStatement.class);
    private static final String TIMING_NAME = "SqlStatement-";
    private static final AtomicLong ID_GENERATOR = new AtomicLong();
    private static final RolapUtil.Semaphore querySemaphore = RolapUtil.getQuerySemaphore();
    private final DataSource dataSource;
    private Connection jdbcConnection;
    private ResultSet resultSet;
    private final String sql;
    private final List<Type> types;
    private final int maxRows;
    private final int firstRowOrdinal;
    private final Locus locus;
    private final int resultSetType;
    private final int resultSetConcurrency;
    private boolean haveSemaphore;
    public int rowCount;
    private long startTimeNanos;
    private long startTimeMillis;
    private final List<Accessor> accessors = new ArrayList<Accessor>();
    private State state = State.FRESH;
    private final long id = ID_GENERATOR.getAndIncrement();

    public SqlStatement(DataSource dataSource, String sql, List<Type> types, int maxRows, int firstRowOrdinal, Locus locus, int resultSetType, int resultSetConcurrency) {
        this.dataSource = dataSource;
        this.sql = sql;
        this.types = types;
        this.maxRows = maxRows;
        this.firstRowOrdinal = firstRowOrdinal;
        this.locus = locus;
        this.resultSetType = resultSetType;
        this.resultSetConcurrency = resultSetConcurrency;
    }

    public void execute() {
        assert (this.state == State.FRESH) : "cannot re-execute";
        this.state = State.ACTIVE;
        Counters.SQL_STATEMENT_EXECUTE_COUNT.incrementAndGet();
        Counters.SQL_STATEMENT_EXECUTING_IDS.add(this.id);
        String status = "failed";
        try {
            RolapUtil.ExecuteQueryHook hook;
            this.jdbcConnection = this.dataSource.getConnection();
            querySemaphore.enter();
            this.haveSemaphore = true;
            if (RolapUtil.SQL_LOGGER.isDebugEnabled()) {
                StringBuilder sqllog = new StringBuilder();
                sqllog.append(this.id).append(": ").append(this.locus.component).append(": executing sql [");
                if (this.sql.indexOf(10) >= 0) {
                    sqllog.append("\n");
                }
                sqllog.append(this.sql);
                sqllog.append(']');
                RolapUtil.SQL_LOGGER.debug((Object)sqllog.toString());
            }
            if ((hook = RolapUtil.getHook()) != null) {
                hook.onExecuteQuery(this.sql);
            }
            this.startTimeNanos = System.nanoTime();
            this.startTimeMillis = System.currentTimeMillis();
            Statement statement = this.resultSetType < 0 || this.resultSetConcurrency < 0 ? this.jdbcConnection.createStatement() : this.jdbcConnection.createStatement(this.resultSetType, this.resultSetConcurrency);
            if (this.maxRows > 0) {
                statement.setMaxRows(this.maxRows);
            }
            this.locus.execution.registerStatement(this.locus, statement);
            this.locus.getServer().getMonitor().sendEvent(new SqlStatementStartEvent(this.startTimeMillis, this.id, this.locus, this.sql, this.getPurpose(), this.getCellRequestCount()));
            this.resultSet = statement.executeQuery(this.sql);
            this.state = State.ACTIVE;
            if (this.firstRowOrdinal > 0) {
                if (this.resultSetType == 1003) {
                    int i = 0;
                    while (i < this.firstRowOrdinal) {
                        if (!this.resultSet.next()) {
                            this.state = State.DONE;
                            break;
                        }
                        ++i;
                    }
                } else if (!this.resultSet.absolute(this.firstRowOrdinal)) {
                    this.state = State.DONE;
                }
            }
            long timeMillis = System.currentTimeMillis();
            long timeNanos = System.nanoTime();
            long executeNanos = timeNanos - this.startTimeNanos;
            long executeMillis = executeNanos / 1000000L;
            Util.addDatabaseTime(executeMillis);
            status = ", exec " + executeMillis + " ms";
            this.locus.getServer().getMonitor().sendEvent(new SqlStatementExecuteEvent(timeMillis, this.id, this.locus, this.sql, this.getPurpose(), executeNanos));
            this.accessors.clear();
            for (Type type : this.guessTypes()) {
                this.accessors.add(this.createAccessor(this.accessors.size(), type));
            }
        }
        catch (Throwable e) {
            status = ", failed (" + e + ")";
            if (e instanceof Error) {
                try {
                    this.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                throw (Error)e;
            }
            throw this.handle(e);
        }
    }

    public void close() {
        if (this.state == State.CLOSED) {
            return;
        }
        this.state = State.CLOSED;
        if (this.haveSemaphore) {
            this.haveSemaphore = false;
            querySemaphore.leave();
        }
        SQLException ex = Util.close(this.resultSet, null, this.jdbcConnection);
        this.resultSet = null;
        this.jdbcConnection = null;
        if (ex != null) {
            throw Util.newError(ex, String.valueOf(this.locus.message) + "; sql=[" + this.sql + "]");
        }
        long endTime = System.currentTimeMillis();
        long totalMs = endTime - this.startTimeMillis;
        String status = ", exec+fetch " + totalMs + " ms, " + this.rowCount + " rows";
        this.locus.execution.getQueryTiming().markFull(TIMING_NAME + this.locus.component, totalMs);
        Counters.SQL_STATEMENT_CLOSE_COUNT.incrementAndGet();
        boolean remove = Counters.SQL_STATEMENT_EXECUTING_IDS.remove(this.id);
        status = String.valueOf(status) + ", ex=" + Counters.SQL_STATEMENT_EXECUTE_COUNT.get() + ", close=" + Counters.SQL_STATEMENT_CLOSE_COUNT.get() + ", open=" + Counters.SQL_STATEMENT_EXECUTING_IDS;
        if (!remove) {
            throw new AssertionError((Object)("SqlStatement closed that was never executed: " + this.id));
        }
        this.locus.getServer().getMonitor().sendEvent(new SqlStatementEndEvent(endTime, this.id, this.locus, this.sql, this.getPurpose(), this.rowCount, false, null));
    }

    public ResultSet getResultSet() {
        return this.resultSet;
    }

    public RuntimeException handle(Throwable e) {
        RuntimeException runtimeException = Util.newError(e, String.valueOf(this.locus.message) + "; sql=[" + this.sql + "]");
        try {
            this.close();
        }
        catch (RuntimeException runtimeException2) {
            // empty catch block
        }
        return runtimeException;
    }

    private static Type getDecimalType(int precision, int scale, Dialect dialect) {
        if (dialect != null && dialect.getDatabaseProduct() == Dialect.DatabaseProduct.NETEZZA && scale == 0 && precision == 38) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Using type DOUBLE for Neteeza scale 0 and precision 38.");
            }
            return Type.DOUBLE;
        }
        if (dialect != null && dialect.getDatabaseProduct() == Dialect.DatabaseProduct.MSSQL && scale == 0 && (precision == 15 || precision == 38)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Using type Long for ORACLE scale=" + scale + " and precision=" + precision));
            }
            return Type.LONG;
        }
        if (dialect != null && dialect.getDatabaseProduct() == Dialect.DatabaseProduct.ORACLE && scale == 0 && (precision == 15 || precision == 38)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Using type Long for ORACLE scale=" + scale + " and precision=" + precision));
            }
            return Type.LONG;
        }
        if (!(scale != 0 && scale != -127 || precision > 9 && precision != 38)) {
            return Type.INT;
        }
        return Type.DOUBLE;
    }

    public static Type guessType(Type suggestedType, ResultSetMetaData metaData, int i, Dialect dialect) throws SQLException {
        String columnName = metaData.getColumnName(i + 1);
        if (suggestedType != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("SqlStatement.guessType - Column " + columnName + " is of explicit type " + suggestedType.name()));
            }
            return suggestedType;
        }
        String typeName = metaData.getColumnTypeName(i + 1);
        int columnType = metaData.getColumnType(i + 1);
        switch (columnType) {
            case 4: 
            case 5: 
            case 16: {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("SqlStatement.guessType - Column " + columnName + " is of internal type INT. JDBC type was " + columnType));
                }
                return Type.INT;
            }
            case 2: {
                int precision = metaData.getPrecision(i + 1);
                int scale = metaData.getScale(i + 1);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("SqlStatement.guessType - Column " + columnName + " has precision " + precision + " and scale " + scale + " for JDBC type " + typeName));
                }
                if (precision == 0 && (scale == 0 || scale == -127) && (typeName.equalsIgnoreCase("NUMBER") || typeName.equalsIgnoreCase("NUMERIC"))) {
                    if (columnName.startsWith("m")) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("SqlStatement.guessType - Column " + columnName + " is of internal type OBJECT. JDBC type was " + columnType));
                        }
                        return Type.OBJECT;
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("SqlStatement.guessType - Column " + columnName + " is of internal type INT. JDBC type was " + columnType));
                    }
                    return Type.DOUBLE;
                }
                Type decimalType = SqlStatement.getDecimalType(precision, scale, dialect);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("SqlStatement.guessType - Column " + columnName + " is of internal type " + decimalType.name() + ". JDBC type was " + columnType));
                }
                return decimalType;
            }
            case 3: {
                int precision = metaData.getPrecision(i + 1);
                int scale = metaData.getScale(i + 1);
                Type dt = SqlStatement.getDecimalType(precision, scale, dialect);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("SqlStatement.guessType - Column " + columnName + " is of internal type " + dt.name() + ". JDBC type was " + columnType));
                }
                return dt;
            }
            case -5: 
            case 6: 
            case 8: {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("SqlStatement.guessType - Column " + columnName + " is of internal type DOUBLE. JDBC type was " + columnType));
                }
                return Type.DOUBLE;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("SqlStatement.guessType - Column " + columnName + " is of internal type OBJECT. JDBC type was " + columnType));
        }
        return Type.OBJECT;
    }

    private Accessor createAccessor(int column, Type type) {
        final int columnPlusOne = column + 1;
        switch (type) {
            case OBJECT: {
                return new Accessor(){

                    @Override
                    public Object get() throws SQLException {
                        return SqlStatement.this.resultSet.getObject(columnPlusOne);
                    }
                };
            }
            case STRING: {
                return new Accessor(){

                    @Override
                    public Object get() throws SQLException {
                        return SqlStatement.this.resultSet.getString(columnPlusOne);
                    }
                };
            }
            case INT: {
                return new Accessor(){

                    @Override
                    public Object get() throws SQLException {
                        int val = SqlStatement.this.resultSet.getInt(columnPlusOne);
                        if (val == 0 && SqlStatement.this.resultSet.wasNull()) {
                            return null;
                        }
                        return val;
                    }
                };
            }
            case LONG: {
                return new Accessor(){

                    @Override
                    public Object get() throws SQLException {
                        long val = SqlStatement.this.resultSet.getLong(columnPlusOne);
                        if (val == 0L && SqlStatement.this.resultSet.wasNull()) {
                            return null;
                        }
                        return val;
                    }
                };
            }
            case DOUBLE: {
                return new Accessor(){

                    @Override
                    public Object get() throws SQLException {
                        double val = SqlStatement.this.resultSet.getDouble(columnPlusOne);
                        if (val == 0.0 && SqlStatement.this.resultSet.wasNull()) {
                            return null;
                        }
                        return val;
                    }
                };
            }
        }
        throw Util.unexpected(type);
    }

    public List<Type> guessTypes() throws SQLException {
        ResultSetMetaData metaData = this.resultSet.getMetaData();
        int columnCount = metaData.getColumnCount();
        assert (this.types == null || this.types.size() == columnCount);
        ArrayList<Type> types = new ArrayList<Type>();
        int i = 0;
        while (i < columnCount) {
            Type suggestedType = null;
            RolapSchema schema = this.locus.execution.getMondrianStatement().getMondrianConnection().getSchema();
            types.add(SqlStatement.guessType(suggestedType, metaData, i, schema != null ? schema.getDialect() : null));
            ++i;
        }
        return types;
    }

    public List<Accessor> getAccessors() throws SQLException {
        return this.accessors;
    }

    public ResultSet getWrappedResultSet() {
        return (ResultSet)Proxy.newProxyInstance(null, new Class[]{ResultSet.class}, (InvocationHandler)new MyDelegatingInvocationHandler(this));
    }

    private SqlStatementEvent.Purpose getPurpose() {
        if (this.locus instanceof StatementLocus) {
            return ((StatementLocus)this.locus).purpose;
        }
        return SqlStatementEvent.Purpose.OTHER;
    }

    private int getCellRequestCount() {
        if (this.locus instanceof StatementLocus) {
            return ((StatementLocus)this.locus).cellRequestCount;
        }
        return 0;
    }

    public static interface Accessor {
        public Object get() throws SQLException;
    }

    public static class MyDelegatingInvocationHandler
    extends DelegatingInvocationHandler {
        private final SqlStatement sqlStatement;

        MyDelegatingInvocationHandler(SqlStatement sqlStatement) {
            this.sqlStatement = sqlStatement;
        }

        @Override
        protected Object getTarget() throws InvocationTargetException {
            ResultSet resultSet = this.sqlStatement.getResultSet();
            if (resultSet == null) {
                throw new InvocationTargetException(new SQLException("Invalid operation. Statement is closed."));
            }
            return resultSet;
        }

        public void close() throws SQLException {
            this.sqlStatement.close();
        }
    }

    private static enum State {
        FRESH,
        ACTIVE,
        DONE,
        CLOSED;

    }

    public static class StatementLocus
    extends Locus {
        private final SqlStatementEvent.Purpose purpose;
        private final int cellRequestCount;

        public StatementLocus(Execution execution, String component, String message, SqlStatementEvent.Purpose purpose, int cellRequestCount) {
            super(execution, component, message);
            this.purpose = purpose;
            this.cellRequestCount = cellRequestCount;
        }
    }

    public static enum Type {
        OBJECT,
        DOUBLE,
        INT,
        LONG,
        STRING;


        public Object get(ResultSet resultSet, int column) throws SQLException {
            switch (this) {
                case OBJECT: {
                    return resultSet.getObject(column + 1);
                }
                case STRING: {
                    return resultSet.getString(column + 1);
                }
                case INT: {
                    return resultSet.getInt(column + 1);
                }
                case LONG: {
                    return resultSet.getLong(column + 1);
                }
                case DOUBLE: {
                    return resultSet.getDouble(column + 1);
                }
            }
            throw Util.unexpected(this);
        }
    }
}

