/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.sql.DataSource;
import mondrian.calc.TupleList;
import mondrian.calc.impl.ListTupleList;
import mondrian.calc.impl.UnaryTupleList;
import mondrian.olap.Evaluator;
import mondrian.olap.Member;
import mondrian.olap.MondrianDef;
import mondrian.olap.MondrianProperties;
import mondrian.olap.Query;
import mondrian.olap.Util;
import mondrian.olap.fun.FunUtil;
import mondrian.resource.MondrianResource;
import mondrian.rolap.BitKey;
import mondrian.rolap.DescendantsConstraint;
import mondrian.rolap.MemberCache;
import mondrian.rolap.RolapAggregationManager;
import mondrian.rolap.RolapBaseCubeMeasure;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapCubeHierarchy;
import mondrian.rolap.RolapCubeLevel;
import mondrian.rolap.RolapHierarchy;
import mondrian.rolap.RolapLevel;
import mondrian.rolap.RolapMember;
import mondrian.rolap.RolapNativeCrossJoin;
import mondrian.rolap.RolapProperty;
import mondrian.rolap.RolapStar;
import mondrian.rolap.RolapUtil;
import mondrian.rolap.SqlContextConstraint;
import mondrian.rolap.SqlMemberSource;
import mondrian.rolap.SqlStatement;
import mondrian.rolap.SqlTupleReadercopy;
import mondrian.rolap.TargetBase;
import mondrian.rolap.TupleReader;
import mondrian.rolap.agg.AggregationManager;
import mondrian.rolap.agg.CellRequest;
import mondrian.rolap.aggmatcher.AggStar;
import mondrian.rolap.sql.CrossJoinArg;
import mondrian.rolap.sql.DescendantsCrossJoinArg;
import mondrian.rolap.sql.MemberChildrenConstraint;
import mondrian.rolap.sql.MemberListCrossJoinArg;
import mondrian.rolap.sql.SqlQuery;
import mondrian.rolap.sql.TupleConstraint;
import mondrian.server.Locus;
import mondrian.server.monitor.SqlStatementEvent;
import mondrian.util.Pair;
import org.apache.log4j.Logger;

public class SqlTupleReader
implements TupleReader {
    private static final Logger LOGGER = Logger.getLogger(SqlTupleReadercopy.class);
    protected final TupleConstraint constraint;
    List<TargetBase> targets = new ArrayList<TargetBase>();
    int maxRows = 0;
    private int missedMemberCount;
    private static final String UNION = "union";

    public SqlTupleReader(TupleConstraint constraint) {
        this.constraint = constraint;
    }

    @Override
    public void addLevelMembers(RolapLevel level, TupleReader.MemberBuilder memberBuilder, List<RolapMember> srcMembers) {
        this.targets.add(new Target(level, memberBuilder, srcMembers));
    }

    @Override
    public Object getCacheKey() {
        ArrayList<Object> key = new ArrayList<Object>();
        key.add(this.constraint.getCacheKey());
        key.add(SqlTupleReadercopy.class);
        for (TargetBase target : this.targets) {
            if (target.srcMembers == null) continue;
            key.add(target.getLevel());
        }
        return key;
    }

    public int getEnumTargetCount() {
        int enumTargetCount = 0;
        for (TargetBase target : this.targets) {
            if (target.getSrcMembers() == null) continue;
            ++enumTargetCount;
        }
        return enumTargetCount;
    }

    protected void prepareTuples(DataSource dataSource, TupleList partialResult, List<List<RolapMember>> newPartialResult) {
        String message = "Populating member cache with members for " + this.targets;
        SqlStatement stmt = null;
        boolean execQuery = partialResult == null;
        try {
            try {
                boolean moreRows;
                ResultSet resultSet;
                if (execQuery) {
                    ArrayList<TargetBase> partialTargets = new ArrayList<TargetBase>();
                    for (TargetBase target : this.targets) {
                        if (target.srcMembers != null) continue;
                        partialTargets.add(target);
                    }
                    Pair<String, List<SqlStatement.Type>> pair = this.makeLevelMembersSql(dataSource);
                    String sql = (String)pair.left;
                    List types = (List)pair.right;
                    assert (sql != null && !sql.equals(""));
                    stmt = RolapUtil.executeQuery(dataSource, sql, types, this.maxRows, 0, new SqlStatement.StatementLocus(Locus.peek().execution, "SqlTupleReader.readTuples " + partialTargets, message, SqlStatementEvent.Purpose.TUPLES, 0), -1, -1);
                    resultSet = stmt.getResultSet();
                } else {
                    resultSet = null;
                }
                for (TargetBase target : this.targets) {
                    target.open();
                }
                int limit = MondrianProperties.instance().ResultLimit.get();
                int fetchCount = 0;
                int enumTargetCount = this.getEnumTargetCount();
                int[] srcMemberIdxes = null;
                if (enumTargetCount > 0) {
                    srcMemberIdxes = new int[enumTargetCount];
                }
                int currPartialResultIdx = 0;
                if (execQuery) {
                    moreRows = resultSet.next();
                    if (moreRows) {
                        ++stmt.rowCount;
                    }
                } else {
                    moreRows = currPartialResultIdx < partialResult.size();
                }
                while (moreRows) {
                    if (limit > 0 && limit < ++fetchCount) {
                        throw MondrianResource.instance().MemberFetchLimitExceeded.ex(limit);
                    }
                    if (enumTargetCount == 0) {
                        int column = 0;
                        for (TargetBase target : this.targets) {
                            target.setCurrMember(null);
                            column = target.addRow(stmt, column);
                        }
                    } else {
                        int firstEnumTarget = 0;
                        while (firstEnumTarget < this.targets.size()) {
                            if (this.targets.get((int)firstEnumTarget).srcMembers != null) break;
                            ++firstEnumTarget;
                        }
                        List partialRow = execQuery ? null : Util.cast((List)partialResult.get(currPartialResultIdx));
                        this.resetCurrMembers(partialRow);
                        this.addTargets(0, firstEnumTarget, enumTargetCount, srcMemberIdxes, stmt, message);
                        if (newPartialResult != null) {
                            this.savePartialResult(newPartialResult);
                        }
                    }
                    if (execQuery) {
                        moreRows = resultSet.next();
                        if (!moreRows) continue;
                        ++stmt.rowCount;
                        continue;
                    }
                    boolean bl = moreRows = ++currPartialResultIdx < partialResult.size();
                }
            }
            catch (SQLException e) {
                if (stmt == null) {
                    throw Util.newError(e, message);
                }
                throw stmt.handle(e);
            }
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    @Override
    public TupleList readMembers(DataSource dataSource, TupleList partialResult, List<List<RolapMember>> newPartialResult) {
        block2: {
            int memberCountBefore;
            int memberCount = this.countMembers();
            do {
                this.missedMemberCount = 0;
                memberCountBefore = memberCount;
                this.prepareTuples(dataSource, partialResult, newPartialResult);
                memberCount = this.countMembers();
                if (this.missedMemberCount == 0) break block2;
            } while (memberCount != memberCountBefore);
            throw Util.newError("Parent-child hierarchy contains cyclic data");
        }
        assert (this.targets.size() == 1);
        return new UnaryTupleList(this.targets.get(0).close());
    }

    private int countMembers() {
        int n = 0;
        for (TargetBase target : this.targets) {
            if (target.getList() == null) continue;
            n += target.getList().size();
        }
        return n;
    }

    @Override
    public TupleList readTuples(DataSource jdbcConnection, TupleList partialResult, List<List<RolapMember>> newPartialResult) {
        this.prepareTuples(jdbcConnection, partialResult, newPartialResult);
        int n = this.targets.size();
        Iterator[] iter = new Iterator[n];
        int i = 0;
        while (i < n) {
            TargetBase t = this.targets.get(i);
            iter[i] = t.close().iterator();
            ++i;
        }
        ArrayList<Member> members = new ArrayList<Member>();
        while (iter[0].hasNext()) {
            int i2 = 0;
            while (i2 < n) {
                members.add((Member)iter[i2].next());
                ++i2;
            }
        }
        TupleList tupleList = n == 1 ? new UnaryTupleList(members) : new ListTupleList(n, members);
        int enumTargetCount = this.getEnumTargetCount();
        if (enumTargetCount > 0) {
            tupleList = FunUtil.hierarchizeTupleList(tupleList, false);
        }
        return tupleList;
    }

    private void resetCurrMembers(List<RolapMember> partialRow) {
        int nativeTarget = 0;
        for (TargetBase target : this.targets) {
            if (target.srcMembers != null) continue;
            if (partialRow != null) {
                target.setCurrMember(partialRow.get(nativeTarget++));
                continue;
            }
            target.setCurrMember(null);
        }
    }

    private void addTargets(int currEnumTargetIdx, int currTargetIdx, int nEnumTargets, int[] srcMemberIdxes, SqlStatement stmt, String message) {
        TargetBase currTarget = this.targets.get(currTargetIdx);
        int i = 0;
        while (i < currTarget.srcMembers.size()) {
            srcMemberIdxes[currEnumTargetIdx] = i;
            if (currEnumTargetIdx < nEnumTargets - 1) {
                int nextTargetIdx = currTargetIdx + 1;
                while (nextTargetIdx < this.targets.size()) {
                    if (this.targets.get((int)nextTargetIdx).srcMembers != null) break;
                    ++nextTargetIdx;
                }
                this.addTargets(currEnumTargetIdx + 1, nextTargetIdx, nEnumTargets, srcMemberIdxes, stmt, message);
            } else {
                int column = 0;
                int enumTargetIdx = 0;
                for (TargetBase target : this.targets) {
                    if (target.srcMembers == null) {
                        try {
                            column = target.addRow(stmt, column);
                            continue;
                        }
                        catch (Throwable e) {
                            throw Util.newError(e, message);
                        }
                    }
                    RolapMember member = target.srcMembers.get(srcMemberIdxes[enumTargetIdx++]);
                    target.getList().add(member);
                }
            }
            ++i;
        }
    }

    private void savePartialResult(List<List<RolapMember>> partialResult) {
        ArrayList<RolapMember> row = new ArrayList<RolapMember>();
        for (TargetBase target : this.targets) {
            if (target.srcMembers != null) continue;
            row.add(target.getCurrMember());
        }
        partialResult.add(row);
    }

    Pair<String, List<SqlStatement.Type>> makeLevelMembersSql(DataSource dataSource) {
        RolapCube cube = null;
        boolean virtualCube = false;
        if (this.constraint instanceof SqlContextConstraint) {
            SqlContextConstraint sqlConstraint = (SqlContextConstraint)this.constraint;
            Query query = this.constraint.getEvaluator().getQuery();
            cube = (RolapCube)query.getCube();
            if (sqlConstraint.isJoinRequired()) {
                virtualCube = cube.isVirtual();
            }
        }
        if (virtualCube) {
            Query query = this.constraint.getEvaluator().getQuery();
            Collection<RolapCube> baseCubes = this.getBaseCubeCollection(query);
            Collection<RolapCube> fullyJoiningBaseCubes = this.getFullyJoiningBaseCubes(baseCubes);
            if (fullyJoiningBaseCubes.size() == 0) {
                return this.sqlForEmptyTuple(dataSource, baseCubes);
            }
            String prependString = "";
            StringBuilder selectString = new StringBuilder();
            List types = null;
            int savepoint = this.getEvaluator(this.constraint).savepoint();
            SqlQuery unionQuery = SqlQuery.newQuery(dataSource, "");
            try {
                for (RolapCube baseCube : fullyJoiningBaseCubes) {
                    Member measureInCurrentbaseCube = null;
                    for (Member currMember : baseCube.getMeasures()) {
                        if (currMember.isCalculated()) continue;
                        measureInCurrentbaseCube = currMember;
                        break;
                    }
                    if (measureInCurrentbaseCube == null) {
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug((Object)("No non-calculated member found in cube " + baseCube.getName()));
                        }
                        measureInCurrentbaseCube = baseCube.getMeasures().get(0);
                    }
                    this.getEvaluator(this.constraint).setContext(measureInCurrentbaseCube);
                    selectString.append(prependString);
                    Pair<String, List<SqlStatement.Type>> pair = this.generateSelectForLevels(dataSource, baseCube, fullyJoiningBaseCubes.size() == 1 ? WhichSelect.ONLY : WhichSelect.NOT_LAST);
                    selectString.append((String)pair.left);
                    types = (List)pair.right;
                    String string = prependString = MondrianProperties.instance().GenerateFormattedSql.get() ? String.valueOf(Util.nl) + UNION + Util.nl : " union ";
                }
            }
            finally {
                this.getEvaluator(this.constraint).restore(savepoint);
            }
            if (fullyJoiningBaseCubes.size() == 1) {
                return Pair.of(selectString.toString(), types);
            }
            unionQuery.addFromQuery(selectString.toString(), "unionQuery", true);
            unionQuery.addSelect("*", null, null);
            if (fullyJoiningBaseCubes.size() > 1) {
                int i = 0;
                while (i < types.size()) {
                    unionQuery.addOrderBy(String.valueOf(i + 1), true, false, true);
                    ++i;
                }
            }
            return Pair.of((String)unionQuery.toSqlAndTypes().left, types);
        }
        return this.generateSelectForLevels(dataSource, cube, WhichSelect.ONLY);
    }

    private Collection<RolapCube> getFullyJoiningBaseCubes(Collection<RolapCube> baseCubes) {
        ArrayList<RolapCube> fullyJoiningCubes = new ArrayList<RolapCube>();
        for (RolapCube baseCube : baseCubes) {
            boolean allTargetsJoin = true;
            for (TargetBase target : this.targets) {
                if (this.targetIsOnBaseCube(target, baseCube)) continue;
                allTargetsJoin = false;
            }
            if (!allTargetsJoin) continue;
            fullyJoiningCubes.add(baseCube);
        }
        return fullyJoiningCubes;
    }

    Collection<RolapCube> getBaseCubeCollection(Query query) {
        RolapCube.CubeComparator cubeComparator = new RolapCube.CubeComparator();
        TreeSet<RolapCube> baseCubes = new TreeSet<RolapCube>(cubeComparator);
        baseCubes.addAll(query.getBaseCubes());
        return baseCubes;
    }

    Pair<String, List<SqlStatement.Type>> sqlForEmptyTuple(DataSource dataSource, Collection<RolapCube> baseCubes) {
        SqlQuery sqlQuery = SqlQuery.newQuery(dataSource, null);
        sqlQuery.addSelect("0", null);
        sqlQuery.addFrom(baseCubes.iterator().next().getFact(), null, true);
        sqlQuery.addWhere("1 = 0");
        return sqlQuery.toSqlAndTypes();
    }

    Pair<String, List<SqlStatement.Type>> generateSelectForLevels(DataSource dataSource, RolapCube baseCube, WhichSelect whichSelect) {
        String s = "while generating query to retrieve members of level(s) " + this.targets;
        SqlQuery sqlQuery = SqlQuery.newQuery(dataSource, s);
        sqlQuery.setAllowHints(true);
        Evaluator evaluator = this.getEvaluator(this.constraint);
        AggStar aggStar = this.chooseAggStar(this.constraint, evaluator, baseCube);
        for (TargetBase target : this.targets) {
            if (target.getSrcMembers() != null) continue;
            this.addLevelMemberSql(sqlQuery, target.getLevel(), baseCube, whichSelect, aggStar);
        }
        this.constraint.addConstraint(sqlQuery, baseCube, aggStar);
        return sqlQuery.toSqlAndTypes();
    }

    boolean targetIsOnBaseCube(TargetBase target, RolapCube baseCube) {
        return baseCube == null || baseCube.findBaseCubeHierarchy(target.getLevel().getHierarchy()) != null;
    }

    private boolean isGroupByNeeded(SqlQuery sqlQuery, RolapHierarchy hierarchy, RolapLevel[] levels, int levelDepth) {
        boolean needsGroupBy = false;
        if (hierarchy.getUniqueKeyLevelName() == null) {
            needsGroupBy = true;
        } else {
            boolean foundUniqueKeyLevelName = false;
            int i = 0;
            while (i <= levelDepth) {
                RolapLevel lvl = levels[i];
                if (!lvl.isAll()) {
                    if (hierarchy.getUniqueKeyLevelName().equals(lvl.getName())) {
                        foundUniqueKeyLevelName = true;
                    }
                    RolapProperty[] rolapPropertyArray = lvl.getProperties();
                    int n = rolapPropertyArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        RolapProperty p = rolapPropertyArray[n2];
                        if (!p.dependsOnLevelValue()) {
                            needsGroupBy = true;
                            break;
                        }
                        ++n2;
                    }
                    if (needsGroupBy) break;
                }
                ++i;
            }
            if (!foundUniqueKeyLevelName) {
                needsGroupBy = true;
            }
        }
        return needsGroupBy;
    }

    protected void addLevelMemberSql(SqlQuery sqlQuery, RolapLevel level, RolapCube baseCube, WhichSelect whichSelect, AggStar aggStar) {
        RolapHierarchy hierarchy = level.getHierarchy();
        if (hierarchy instanceof RolapCubeHierarchy) {
            RolapCubeHierarchy cubeHierarchy = (RolapCubeHierarchy)hierarchy;
            if (baseCube != null && !cubeHierarchy.getCube().equals(baseCube)) {
                hierarchy = baseCube.findBaseCubeHierarchy(hierarchy);
            }
        }
        RolapLevel[] levels = (RolapLevel[])hierarchy.getLevels();
        int levelDepth = level.getDepth();
        boolean needsGroupBy = this.isGroupByNeeded(sqlQuery, hierarchy, levels, levelDepth);
        int i = 0;
        while (i <= levelDepth) {
            RolapLevel currLevel = levels[i];
            if (!currLevel.isAll()) {
                boolean levelCollapsed = aggStar != null && SqlMemberSource.isLevelCollapsed(aggStar, (RolapCubeLevel)currLevel);
                boolean multipleCols = SqlMemberSource.levelContainsMultipleColumns(currLevel);
                if (levelCollapsed && !multipleCols) {
                    RolapStar.Column starColumn = ((RolapCubeLevel)currLevel).getStarKeyColumn();
                    int bitPos = starColumn.getBitPosition();
                    AggStar.Table.Column aggColumn = aggStar.lookupColumn(bitPos);
                    String q = aggColumn.generateExprString(sqlQuery);
                    sqlQuery.addSelectGroupBy(q, starColumn.getInternalType());
                    if (whichSelect == WhichSelect.ONLY) {
                        sqlQuery.addOrderBy(q, true, false, true);
                    }
                    aggColumn.getTable().addToFrom(sqlQuery, false, true);
                } else {
                    RolapProperty[] properties;
                    MondrianDef.Expression keyExp = currLevel.getKeyExp();
                    MondrianDef.Expression ordinalExp = currLevel.getOrdinalExp();
                    MondrianDef.Expression captionExp = currLevel.getCaptionExp();
                    MondrianDef.Expression parentExp = currLevel.getParentExp();
                    if (parentExp != null) {
                        if (!levelCollapsed) {
                            hierarchy.addToFrom(sqlQuery, parentExp);
                        }
                        String parentSql = parentExp.getExpression(sqlQuery);
                        sqlQuery.addSelectGroupBy(parentSql, currLevel.getInternalType());
                        if (whichSelect == WhichSelect.LAST || whichSelect == WhichSelect.ONLY) {
                            sqlQuery.addOrderBy(parentSql, true, false, true, false);
                        }
                    }
                    String keySql = keyExp.getExpression(sqlQuery);
                    String ordinalSql = ordinalExp.getExpression(sqlQuery);
                    if (!levelCollapsed) {
                        hierarchy.addToFrom(sqlQuery, keyExp);
                        hierarchy.addToFrom(sqlQuery, ordinalExp);
                    }
                    String captionSql = null;
                    if (captionExp != null) {
                        captionSql = captionExp.getExpression(sqlQuery);
                        if (!levelCollapsed) {
                            hierarchy.addToFrom(sqlQuery, captionExp);
                        }
                    }
                    String alias = sqlQuery.addSelect(keySql, currLevel.getInternalType());
                    if (needsGroupBy) {
                        sqlQuery.addGroupBy(keySql, alias);
                    }
                    if (captionSql != null) {
                        alias = sqlQuery.addSelect(captionSql, null);
                        if (needsGroupBy) {
                            sqlQuery.addGroupBy(captionSql, alias);
                        }
                    }
                    if (!ordinalSql.equals(keySql)) {
                        alias = sqlQuery.addSelect(ordinalSql, null);
                        if (needsGroupBy) {
                            sqlQuery.addGroupBy(ordinalSql, alias);
                        }
                    }
                    this.constraint.addLevelConstraint(sqlQuery, baseCube, aggStar, currLevel);
                    if (levelCollapsed) {
                        hierarchy.addToFromInverse(sqlQuery, keyExp);
                        RolapStar.Column starColumn = ((RolapCubeLevel)currLevel).getStarKeyColumn();
                        int bitPos = starColumn.getBitPosition();
                        AggStar.Table.Column aggColumn = aggStar.lookupColumn(bitPos);
                        RolapStar.Condition condition = new RolapStar.Condition(keyExp, aggColumn.getExpression());
                        sqlQuery.addWhere(condition.toString(sqlQuery));
                    }
                    if (whichSelect == WhichSelect.ONLY) {
                        sqlQuery.addOrderBy(ordinalSql, true, false, true);
                    }
                    RolapProperty[] rolapPropertyArray = properties = currLevel.getProperties();
                    int n = properties.length;
                    int n2 = 0;
                    while (n2 < n) {
                        RolapProperty property = rolapPropertyArray[n2];
                        MondrianDef.Expression propExp = property.getExp();
                        String propSql = propExp instanceof MondrianDef.Column ? sqlQuery.getDialect().quoteIdentifier(currLevel.getTableAlias(), ((MondrianDef.Column)propExp).name) : property.getExp().getExpression(sqlQuery);
                        alias = sqlQuery.addSelect(propSql, null);
                        if (!(!needsGroupBy || sqlQuery.getDialect().allowsSelectNotInGroupBy() && property.dependsOnLevelValue())) {
                            sqlQuery.addGroupBy(propSql, alias);
                        }
                        ++n2;
                    }
                }
            }
            ++i;
        }
    }

    protected Evaluator getEvaluator(TupleConstraint constraint) {
        DescendantsConstraint descConstraint;
        MemberChildrenConstraint mcc;
        if (constraint instanceof SqlContextConstraint) {
            return constraint.getEvaluator();
        }
        if (constraint instanceof DescendantsConstraint && (mcc = (descConstraint = (DescendantsConstraint)constraint).getMemberChildrenConstraint(null)) instanceof SqlContextConstraint) {
            SqlContextConstraint scc = (SqlContextConstraint)mcc;
            return scc.getEvaluator();
        }
        return null;
    }

    AggStar chooseAggStar(TupleConstraint constraint, Evaluator evaluator, RolapCube baseCube) {
        if (!MondrianProperties.instance().UseAggregates.get()) {
            return null;
        }
        if (evaluator == null) {
            return null;
        }
        if (baseCube == null) {
            baseCube = (RolapCube)evaluator.getCube();
        }
        if (baseCube.isVirtual()) {
            return null;
        }
        RolapStar star = baseCube.getStar();
        int starColumnCount = star.getColumnCount();
        BitKey measureBitKey = BitKey.Factory.makeBitKey(starColumnCount);
        BitKey levelBitKey = BitKey.Factory.makeBitKey(starColumnCount);
        Member[] members = evaluator.getNonAllMembers();
        if (!(members[0] instanceof RolapBaseCubeMeasure)) {
            return null;
        }
        RolapBaseCubeMeasure measure = (RolapBaseCubeMeasure)members[0];
        int bitPosition = ((RolapStar.Measure)measure.getStarMeasure()).getBitPosition();
        CellRequest request = RolapAggregationManager.makeRequest(members);
        if (request == null) {
            return null;
        }
        RolapStar.Column[] columns = request.getConstrainedColumns();
        Object[] objectArray = columns;
        int n = columns.length;
        int n2 = 0;
        while (n2 < n) {
            RolapStar.Column column1 = objectArray[n2];
            levelBitKey.set(column1.getBitPosition());
            ++n2;
        }
        for (TargetBase target : this.targets) {
            RolapStar.Column column;
            RolapLevel level = target.level;
            if (level.isAll() || (column = ((RolapCubeLevel)level).getBaseStarKeyColumn(baseCube)) == null) continue;
            levelBitKey.set(column.getBitPosition());
        }
        objectArray = evaluator.getMembers();
        n = objectArray.length;
        int n3 = 0;
        while (n3 < n) {
            Object member = objectArray[n3];
            if (member instanceof RolapHierarchy.LimitedRollupMember) {
                List<Member> lowestMembers = ((RolapHierarchy)member.getHierarchy()).getLowestMembersForAccess(evaluator, ((RolapHierarchy.LimitedRollupMember)member).hierarchyAccess, FunUtil.getNonEmptyMemberChildrenWithDetails(evaluator, (Member)member));
                for (Member lowestMember : lowestMembers) {
                    RolapStar.Column column = ((RolapCubeLevel)lowestMember.getLevel()).getBaseStarKeyColumn(baseCube);
                    if (column == null) continue;
                    levelBitKey.set(column.getBitPosition());
                }
            }
            ++n3;
        }
        measureBitKey.set(bitPosition);
        if (constraint instanceof RolapNativeCrossJoin.NonEmptyCrossJoinConstraint) {
            RolapNativeCrossJoin.NonEmptyCrossJoinConstraint necj = (RolapNativeCrossJoin.NonEmptyCrossJoinConstraint)constraint;
            CrossJoinArg[] crossJoinArgArray = necj.args;
            int n4 = necj.args.length;
            n = 0;
            while (n < n4) {
                RolapLevel level;
                CrossJoinArg arg = crossJoinArgArray[n];
                if ((arg instanceof DescendantsCrossJoinArg || arg instanceof MemberListCrossJoinArg) && (level = arg.getLevel()) != null && !level.isAll()) {
                    RolapStar.Column column = ((RolapCubeLevel)level).getBaseStarKeyColumn(baseCube);
                    levelBitKey.set(column.getBitPosition());
                }
                ++n;
            }
        }
        return AggregationManager.findAgg(star, levelBitKey, measureBitKey, new boolean[1]);
    }

    int getMaxRows() {
        return this.maxRows;
    }

    void setMaxRows(int maxRows) {
        this.maxRows = maxRows;
    }

    private class Target
    extends TargetBase {
        final MemberCache cache;
        RolapLevel[] levels;
        int levelDepth;
        boolean parentChild;
        List<RolapMember> members;
        final HashMap<Object, RolapMember> keyToMember;
        List<List<RolapMember>> siblings;
        Map<Object, Object[]> nativelList;
        Map<Integer, Object> nativeRowlList;
        int nativeRow;
        boolean chenckFirst;

        public Target(RolapLevel level, TupleReader.MemberBuilder memberBuilder, List<RolapMember> srcMembers) {
            super(srcMembers, level, memberBuilder);
            this.keyToMember = new HashMap();
            this.nativelList = null;
            this.nativeRowlList = null;
            this.nativeRow = 0;
            this.chenckFirst = true;
            this.cache = memberBuilder.getMemberCache();
        }

        @Override
        public void open() {
            this.levels = (RolapLevel[])this.level.getHierarchy().getLevels();
            this.setList(new ArrayList<RolapMember>());
            this.levelDepth = this.level.getDepth();
            this.parentChild = this.level.isParentChild();
            this.members = new ArrayList<Object>(Collections.nCopies(this.levels.length, null));
            this.siblings = new ArrayList<List<RolapMember>>();
            int i = 0;
            while (i < this.levels.length + 1) {
                this.siblings.add(new ArrayList());
                ++i;
            }
        }

        @Override
        int internalAddRow(SqlStatement stmt, int column) throws SQLException {
            int x = 0;
            if (this.parentChild) {
                return this.internalAddRownew(stmt, column);
            }
            x = this.internalAddRowold(stmt, column);
            return x;
        }

        int internalAddRownew(SqlStatement stmt, int column) throws SQLException {
            if (this.chenckFirst) {
                this.nativelList = new HashMap<Object, Object[]>();
                this.nativeRowlList = new HashMap<Integer, Object>();
                ResultSet resultSet = stmt.getResultSet();
                List<SqlStatement.Accessor> accessors = stmt.getAccessors();
                int columnSize = accessors.size();
                Object[] ob = new Object[columnSize];
                int i = 0;
                while (i < accessors.size()) {
                    ob[i] = resultSet.getObject(i + 1);
                    ++i;
                }
                int row = resultSet.getRow();
                this.nativelList.put(ob[1], ob);
                this.nativeRowlList.put(row, ob[1]);
                while (resultSet.next()) {
                    Object[] str = new Object[columnSize];
                    int j = 0;
                    while (j < columnSize) {
                        str[j] = resultSet.getObject(j + 1);
                        ++j;
                    }
                    this.nativelList.put(str[1], str);
                    this.nativeRowlList.put(resultSet.getRow(), str[1]);
                }
                this.chenckFirst = false;
                int i2 = 1;
                while (i2 < this.nativelList.size() + 1) {
                    Object[] bj = this.nativelList.get(this.nativeRowlList.get(i2));
                    this.recursionAddRow(stmt, column, bj[0], bj[1]);
                    this.nativeRow = i2++;
                }
            }
            return this.nativeRow;
        }

        void recursionAddRow(SqlStatement stmt, int column, Object parentValueid, Object childValueid) throws SQLException {
            Object[] parent = this.nativelList.get(parentValueid);
            Object[] child = this.nativelList.get(childValueid);
            if (parent != null) {
                if (this.keyToMember.get(parent[1]) != null) {
                    this.internalAddRownew(stmt, column, parent);
                    this.internalAddRownew(stmt, column, child);
                } else if (parent[0].toString().equals("0")) {
                    this.internalAddRownew(stmt, column, parent);
                    this.internalAddRownew(stmt, column, child);
                } else {
                    this.recursionAddRow(stmt, column, parent[0], parent[1]);
                    this.recursionAddRow(stmt, column, child[0], child[1]);
                }
            } else if (parent == null && child != null) {
                this.internalAddRownew(stmt, column, child);
            }
        }

        int internalAddRownew(SqlStatement stmt, int column, Object[] ob) throws SQLException {
            if (this.keyToMember.get(ob[1]) != null) {
                return 0;
            }
            RolapMember member = null;
            if (this.getCurrMember() != null) {
                this.setCurrMember(member);
            } else {
                boolean checkCacheStatus = true;
                int i = 0;
                while (i <= this.levelDepth) {
                    RolapLevel childLevel = this.levels[i];
                    if (childLevel.isAll()) {
                        member = this.memberBuilder.allMember();
                    } else {
                        Comparable<?> value;
                        RolapMember parentMember = member;
                        if (this.parentChild) {
                            Comparable<?> parentValue;
                            if ((parentValue = ob[column++]) == null || parentValue.toString().equals(childLevel.getNullParentValue())) {
                                parentValue = RolapUtil.sqlNullValue;
                            } else {
                                Object parentKey = this.cache.makeKey(member, parentValue);
                                parentMember = this.cache.getMember(parentKey);
                                if (parentMember == null) {
                                    parentMember = this.keyToMember.get(parentValue);
                                }
                                if (parentMember == null) {
                                    LOGGER.warn((Object)MondrianResource.instance().LevelTableParentNotFound.str(childLevel.getUniqueName(), String.valueOf(parentValue)));
                                }
                            }
                        }
                        if ((value = ob[column++]) == null) {
                            value = RolapUtil.sqlNullValue;
                        }
                        Object captionValue = childLevel.hasCaptionColumn() ? ob[column++] : null;
                        Object key = this.parentChild ? this.cache.makeKey(member, value) : this.cache.makeKey(parentMember, value);
                        member = this.cache.getMember(key, checkCacheStatus);
                        checkCacheStatus = false;
                        if (member == null) {
                            if (SqlTupleReader.this.constraint instanceof RolapNativeCrossJoin.NonEmptyCrossJoinConstraint && childLevel.isParentChild()) {
                                member = this.castToNonEmptyCJConstraint(SqlTupleReader.this.constraint).findMember(value);
                            }
                            if (member == null) {
                                member = this.memberBuilder.makeMemberNew(parentMember, childLevel, value, captionValue, this.parentChild, ob, key, column);
                            }
                        }
                        if (!childLevel.getOrdinalExp().equals(childLevel.getKeyExp())) {
                            ++column;
                        }
                        column += childLevel.getProperties().length;
                        this.keyToMember.put(member.getKey(), member);
                        if (member != this.members.get(i)) {
                            MemberChildrenConstraint mcc;
                            List<RolapMember> children = this.siblings.get(i + 1);
                            if (children != null && (mcc = SqlTupleReader.this.constraint.getMemberChildrenConstraint(this.members.get(i))) != null) {
                                this.cache.putChildren(this.members.get(i), mcc, children);
                            }
                            mcc = SqlTupleReader.this.constraint.getMemberChildrenConstraint(member);
                            List<RolapMember> cachedChildren = this.cache.getChildrenFromCache(member, mcc);
                            if (i < this.levelDepth && cachedChildren == null) {
                                this.siblings.set(i + 1, new ArrayList());
                            } else {
                                this.siblings.set(i + 1, null);
                            }
                            this.members.set(i, member);
                            if (this.siblings.get(i) != null) {
                                if (value == RolapUtil.sqlNullValue) {
                                    this.addAsOldestSibling(this.siblings.get(i), member);
                                } else {
                                    this.siblings.get(i).add(member);
                                }
                            }
                        }
                    }
                    ++i;
                }
            }
            this.getList().add(member);
            return column;
        }

        int internalAddRowold(SqlStatement stmt, int column) throws SQLException {
            RolapMember member = null;
            if (this.getCurrMember() != null) {
                this.setCurrMember(member);
            } else {
                boolean checkCacheStatus = true;
                int i = 0;
                while (i <= this.levelDepth) {
                    RolapLevel childLevel = this.levels[i];
                    if (childLevel.isAll()) {
                        member = this.memberBuilder.allMember();
                    } else {
                        Comparable<?> value;
                        RolapMember parentMember = member;
                        List<SqlStatement.Accessor> accessors = stmt.getAccessors();
                        if (this.parentChild) {
                            Comparable<?> parentValue;
                            if ((parentValue = accessors.get(column++).get()) == null || parentValue.toString().equals(childLevel.getNullParentValue())) {
                                parentValue = RolapUtil.sqlNullValue;
                            } else {
                                Object parentKey = this.cache.makeKey(member, parentValue);
                                parentMember = this.cache.getMember(parentKey);
                                if (parentMember == null) {
                                    parentMember = this.keyToMember.get(parentValue);
                                }
                                if (parentMember == null) {
                                    LOGGER.warn((Object)MondrianResource.instance().LevelTableParentNotFound.str(childLevel.getUniqueName(), String.valueOf(parentValue)));
                                }
                            }
                        }
                        if ((value = accessors.get(column++).get()) == null) {
                            value = RolapUtil.sqlNullValue;
                        }
                        Object captionValue = childLevel.hasCaptionColumn() ? accessors.get(column++).get() : null;
                        Object key = this.parentChild ? this.cache.makeKey(member, value) : this.cache.makeKey(parentMember, value);
                        member = this.cache.getMember(key, checkCacheStatus);
                        checkCacheStatus = false;
                        if (member == null) {
                            if (SqlTupleReader.this.constraint instanceof RolapNativeCrossJoin.NonEmptyCrossJoinConstraint && childLevel.isParentChild()) {
                                member = this.castToNonEmptyCJConstraint(SqlTupleReader.this.constraint).findMember(value);
                            }
                            if (member == null) {
                                member = this.memberBuilder.makeMember(parentMember, childLevel, value, captionValue, this.parentChild, stmt, key, column);
                            }
                        }
                        if (!childLevel.getOrdinalExp().equals(childLevel.getKeyExp())) {
                            ++column;
                        }
                        column += childLevel.getProperties().length;
                        this.keyToMember.put(member.getKey(), member);
                        if (member != this.members.get(i)) {
                            MemberChildrenConstraint mcc;
                            List<RolapMember> children = this.siblings.get(i + 1);
                            if (children != null && (mcc = SqlTupleReader.this.constraint.getMemberChildrenConstraint(this.members.get(i))) != null) {
                                this.cache.putChildren(this.members.get(i), mcc, children);
                            }
                            mcc = SqlTupleReader.this.constraint.getMemberChildrenConstraint(member);
                            List<RolapMember> cachedChildren = this.cache.getChildrenFromCache(member, mcc);
                            if (i < this.levelDepth && cachedChildren == null) {
                                this.siblings.set(i + 1, new ArrayList());
                            } else {
                                this.siblings.set(i + 1, null);
                            }
                            this.members.set(i, member);
                            if (this.siblings.get(i) != null) {
                                if (value == RolapUtil.sqlNullValue) {
                                    this.addAsOldestSibling(this.siblings.get(i), member);
                                } else {
                                    this.siblings.get(i).add(member);
                                }
                            }
                        }
                    }
                    ++i;
                }
                this.setCurrMember(member);
            }
            this.getList().add(member);
            return column;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<Member> close() {
            Object object = this.cacheLock;
            synchronized (object) {
                return this.internalClose();
            }
        }

        public List<Member> internalClose() {
            int i = 0;
            while (i < this.members.size()) {
                MemberChildrenConstraint mcc;
                RolapMember member = this.members.get(i);
                List<RolapMember> children = this.siblings.get(i + 1);
                if (member != null && children != null && member.getDepth() >= this.level.getDepth() && (mcc = SqlTupleReader.this.constraint.getMemberChildrenConstraint(member)) != null) {
                    this.cache.putChildren(member, mcc, children);
                }
                ++i;
            }
            return Util.cast(this.getList());
        }

        private void addAsOldestSibling(List<RolapMember> list, RolapMember member) {
            int i = list.size();
            while (--i >= 0) {
                RolapMember sibling = list.get(i);
                if (sibling.getParentMember() != member.getParentMember()) break;
            }
            list.add(i + 1, member);
        }
    }

    static enum WhichSelect {
        ONLY,
        NOT_LAST,
        LAST;

    }
}

