/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap.agg;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import mondrian.olap.Level;
import mondrian.olap.Member;
import mondrian.olap.MondrianProperties;
import mondrian.olap.SchemaReader;
import mondrian.olap.Util;
import mondrian.rolap.BitKey;
import mondrian.rolap.CellKey;
import mondrian.rolap.GroupingSetsCollector;
import mondrian.rolap.RolapMember;
import mondrian.rolap.RolapStar;
import mondrian.rolap.StarColumnPredicate;
import mondrian.rolap.StarPredicate;
import mondrian.rolap.agg.AggregationKey;
import mondrian.rolap.agg.GroupingSet;
import mondrian.rolap.agg.ListColumnPredicate;
import mondrian.rolap.agg.LiteralStarPredicate;
import mondrian.rolap.agg.MemberColumnPredicate;
import mondrian.rolap.agg.Segment;
import mondrian.rolap.agg.SegmentAxis;
import mondrian.rolap.agg.SegmentCacheManager;
import mondrian.rolap.agg.SegmentDataset;
import mondrian.rolap.agg.SegmentLoader;
import mondrian.rolap.agg.SegmentWithData;
import mondrian.rolap.agg.StarPredicates;

public class Aggregation {
    private final List<StarPredicate> compoundPredicateList;
    private final RolapStar star;
    private final BitKey constrainedColumnsBitKey;
    private final int maxConstraints;
    private final Date creationTimestamp;

    public Aggregation(AggregationKey aggregationKey) {
        this.compoundPredicateList = aggregationKey.getCompoundPredicateList();
        this.star = aggregationKey.getStar();
        this.constrainedColumnsBitKey = aggregationKey.getConstrainedColumnsBitKey();
        this.maxConstraints = MondrianProperties.instance().MaxConstraints.get();
        this.creationTimestamp = new Date();
    }

    public Date getCreationTimestamp() {
        return this.creationTimestamp;
    }

    public void load(SegmentCacheManager cacheMgr, int cellRequestCount, RolapStar.Column[] columns, List<RolapStar.Measure> measures, StarColumnPredicate[] predicates, GroupingSetsCollector groupingSetsCollector, List<Future<Map<Segment, SegmentWithData>>> segmentFutures) {
        BitKey measureBitKey = this.getConstrainedColumnsBitKey().emptyCopy();
        int axisCount = columns.length;
        Util.assertTrue(predicates.length == axisCount);
        List<Segment> segments = this.createSegments(columns, measures, measureBitKey, predicates);
        BitKey levelBitKey = this.getConstrainedColumnsBitKey();
        GroupingSet groupingSet = new GroupingSet(segments, levelBitKey, measureBitKey, predicates, columns);
        if (groupingSetsCollector.useGroupingSets()) {
            groupingSetsCollector.add(groupingSet);
        } else {
            SegmentLoader segmentLoader = new SegmentLoader(cacheMgr);
            segmentLoader.load(cellRequestCount, new ArrayList<GroupingSet>(Collections.singletonList(groupingSet)), this.compoundPredicateList, segmentFutures);
        }
    }

    private List<Segment> createSegments(RolapStar.Column[] columns, List<RolapStar.Measure> measures, BitKey measureBitKey, StarColumnPredicate[] predicates) {
        ArrayList<Segment> segments = new ArrayList<Segment>(measures.size());
        for (RolapStar.Measure measure : measures) {
            measureBitKey.set(measure.getBitPosition());
            Segment segment = new Segment(this.star, this.constrainedColumnsBitKey, columns, measure, predicates, Collections.<Segment.ExcludedRegion>emptyList(), this.compoundPredicateList);
            segments.add(segment);
        }
        Collections.sort(segments, new Comparator<Segment>(){

            @Override
            public int compare(Segment o1, Segment o2) {
                return Integer.valueOf(o1.measure.getBitPosition()).compareTo(o2.measure.getBitPosition());
            }
        });
        return segments;
    }

    public StarColumnPredicate[] optimizePredicates(RolapStar.Column[] columns, StarColumnPredicate[] predicates) {
        RolapStar star = this.getStar();
        Util.assertTrue(predicates.length == columns.length);
        StarColumnPredicate[] newPredicates = (StarColumnPredicate[])predicates.clone();
        double[] bloats = new double[columns.length];
        ArrayList<RolapMember> potentialParents = new ArrayList<RolapMember>();
        StarColumnPredicate[] starColumnPredicateArray = predicates;
        int n = predicates.length;
        int n2 = 0;
        while (n2 < n) {
            StarColumnPredicate predicate = starColumnPredicateArray[n2];
            if (predicate instanceof MemberColumnPredicate) {
                RolapMember m = ((MemberColumnPredicate)predicate).getMember();
                potentialParents.add(m);
            }
            ++n2;
        }
        int i = 0;
        while (i < newPredicates.length) {
            if (!(newPredicates[i] instanceof ListColumnPredicate)) {
                bloats[i] = 0.0;
            } else {
                ListColumnPredicate newPredicate = (ListColumnPredicate)newPredicates[i];
                List<StarColumnPredicate> predicateList = newPredicate.getPredicates();
                int valueCount = predicateList.size();
                if (valueCount < 2) {
                    bloats[i] = 0.0;
                } else if (valueCount > this.maxConstraints) {
                    bloats[i] = 1.0;
                } else {
                    int memberCount;
                    SchemaReader scr;
                    double constraintLength = valueCount;
                    Member parent = null;
                    Level level = null;
                    int j = 0;
                    while (j < valueCount) {
                        StarColumnPredicate value = predicateList.get(j);
                        if (!(value instanceof MemberColumnPredicate)) {
                            parent = null;
                            level = null;
                            bloats[i] = constraintLength / (double)columns[i].getCardinality();
                            break;
                        }
                        MemberColumnPredicate memberColumnPredicate = (MemberColumnPredicate)value;
                        RolapMember m = memberColumnPredicate.getMember();
                        if (j == 0) {
                            parent = m.getParentMember();
                            level = m.getLevel();
                        } else {
                            if (parent != null && !parent.equals(m.getParentMember())) {
                                parent = null;
                            }
                            if (level != null && !level.equals(m.getLevel())) {
                                level = null;
                            }
                        }
                        ++j;
                    }
                    boolean done = false;
                    if (parent != null && (parent.isAll() || potentialParents.contains(parent))) {
                        scr = star.getSchema().getSchemaReader();
                        int childCount = scr.getChildrenCountFromCache(parent);
                        if (childCount == -1) {
                            if (!parent.isAll()) {
                                bloats[i] = 0.0;
                                done = true;
                            }
                        } else {
                            bloats[i] = constraintLength / (double)childCount;
                            done = true;
                        }
                    }
                    if (!done && level != null && (memberCount = (scr = star.getSchema().getSchemaReader()).getLevelCardinality(level, true, false)) > 0) {
                        bloats[i] = constraintLength / (double)memberCount;
                        done = true;
                    }
                    if (!done) {
                        bloats[i] = constraintLength / (double)columns[i].getCardinality();
                    }
                }
            }
            ++i;
        }
        ConstraintComparator comparator = new ConstraintComparator(bloats);
        Integer[] indexes = new Integer[columns.length];
        int i2 = 0;
        while (i2 < columns.length) {
            indexes[i2] = i2;
            ++i2;
        }
        Arrays.sort(indexes, comparator);
        double abloat = 1.0;
        double aBloatLimit = 0.5;
        Integer[] integerArray = indexes;
        int n3 = indexes.length;
        int n4 = 0;
        while (n4 < n3) {
            Integer j = integerArray[n4];
            if ((abloat *= bloats[j]) <= 0.5) break;
            if (MondrianProperties.instance().OptimizePredicates.get() || bloats[j] == 1.0) {
                newPredicates[j.intValue()] = new LiteralStarPredicate(columns[j], true);
            }
            ++n4;
        }
        int i3 = 0;
        while (i3 < newPredicates.length) {
            newPredicates[i3] = StarPredicates.optimize(newPredicates[i3]);
            ++i3;
        }
        return newPredicates;
    }

    public RolapStar getStar() {
        return this.star;
    }

    public BitKey getConstrainedColumnsBitKey() {
        return this.constrainedColumnsBitKey;
    }

    private static class ConstraintComparator
    implements Comparator<Integer> {
        private final double[] bloats;

        ConstraintComparator(double[] bloats) {
            this.bloats = bloats;
        }

        @Override
        public int compare(Integer o0, Integer o1) {
            double bloat1;
            double bloat0 = this.bloats[o0];
            return bloat0 == (bloat1 = this.bloats[o1]) ? 0 : (bloat0 < bloat1 ? 1 : -1);
        }
    }

    private static class ValuePruner {
        private final StarPredicate flushPredicate;
        private final int arity;
        private final SegmentAxis[] axes;
        private final BitSet[] keepBitSets;
        private final int[] axisInverseOrdinals;
        private final Object[] values;
        private final List<Object> valueList;
        private final int[] ordinals;
        private final SegmentDataset data;
        private final CellKey cellKey;

        ValuePruner(StarPredicate flushPredicate, SegmentAxis[] segmentAxes, SegmentDataset data) {
            this.flushPredicate = flushPredicate;
            this.arity = flushPredicate.getConstrainedColumnList().size();
            this.axes = new SegmentAxis[this.arity];
            this.keepBitSets = new BitSet[this.arity];
            this.axisInverseOrdinals = new int[segmentAxes.length];
            Arrays.fill(this.axisInverseOrdinals, -1);
            this.values = new Object[this.arity];
            this.valueList = Arrays.asList(this.values);
            this.ordinals = new int[this.arity];
            assert (data != null);
            this.data = data;
            this.cellKey = CellKey.Generator.newCellKey(segmentAxes.length);
            int i = 0;
            while (i < this.arity) {
                RolapStar.Column column = flushPredicate.getConstrainedColumnList().get(i);
                int axisOrdinal = this.findAxis(segmentAxes, column.getBitPosition());
                if (axisOrdinal < 0) {
                    this.axes[i] = null;
                    this.values[i] = StarPredicate.WILDCARD;
                    this.keepBitSets[i] = new BitSet(1);
                } else {
                    this.axes[i] = segmentAxes[axisOrdinal];
                    this.axisInverseOrdinals[axisOrdinal] = i;
                    int keyCount = this.axes[i].getKeys().length;
                    this.keepBitSets[i] = new BitSet(keyCount);
                }
                ++i;
            }
        }

        private int findAxis(SegmentAxis[] axes, int bitPosition) {
            int i = 0;
            while (i < axes.length) {
                SegmentAxis axis = axes[i];
                if (axis.getPredicate().getConstrainedColumn().getBitPosition() == bitPosition) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        void go(BitSet[] axisKeepBitSets) {
            this.evaluatePredicate(0);
            int i = 0;
            while (i < axisKeepBitSets.length) {
                if (this.axisInverseOrdinals[i] >= 0) {
                    BitSet axisKeepBitSet = axisKeepBitSets[this.axisInverseOrdinals[i]];
                    BitSet keepBitSet = this.keepBitSets[i];
                    axisKeepBitSet.and(keepBitSet);
                }
                ++i;
            }
        }

        private void evaluatePredicate(int axisOrdinal) {
            block5: {
                block4: {
                    if (axisOrdinal != this.arity) break block4;
                    if (this.flushPredicate.evaluate(this.valueList) || this.data.getObject(this.cellKey) == null) break block5;
                    int k = 0;
                    while (k < this.arity) {
                        this.keepBitSets[k].set(this.ordinals[k]);
                        ++k;
                    }
                    break block5;
                }
                SegmentAxis axis = this.axes[axisOrdinal];
                if (axis == null) {
                    this.evaluatePredicate(axisOrdinal + 1);
                } else {
                    Comparable[] keys = axis.getKeys();
                    int keyOrdinal = 0;
                    while (keyOrdinal < keys.length) {
                        Comparable key = keys[keyOrdinal];
                        this.values[axisOrdinal] = key;
                        this.ordinals[axisOrdinal] = keyOrdinal;
                        this.cellKey.setAxis(this.axisInverseOrdinals[axisOrdinal], keyOrdinal);
                        this.evaluatePredicate(axisOrdinal + 1);
                        ++keyOrdinal;
                    }
                }
            }
        }
    }
}

