/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap.agg;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.SortedMap;
import mondrian.olap.Util;
import mondrian.rolap.BitKey;
import mondrian.rolap.RolapStar;
import mondrian.rolap.StarPredicate;
import mondrian.rolap.agg.CellRequest;
import mondrian.rolap.sql.SqlQuery;

public class AggregationKey {
    private final RolapStar star;
    private final BitKey constrainedColumnsBitKey;
    final List<StarPredicate> compoundPredicateList;
    private int hashCode;

    public AggregationKey(CellRequest request) {
        this.constrainedColumnsBitKey = request.getConstrainedColumnsBitKey();
        this.star = request.getMeasure().getStar();
        SortedMap<BitKey, StarPredicate> compoundPredicateMap = request.getCompoundPredicateMap();
        this.compoundPredicateList = compoundPredicateMap == null ? Collections.emptyList() : new ArrayList(compoundPredicateMap.values());
    }

    public final int computeHashCode() {
        return AggregationKey.computeHashCode(this.constrainedColumnsBitKey, this.star, (Collection<BitKey>)(this.compoundPredicateList == null ? null : new AbstractList<BitKey>(){

            @Override
            public BitKey get(int index) {
                return AggregationKey.this.compoundPredicateList.get(index).getConstrainedColumnBitKey();
            }

            @Override
            public int size() {
                return AggregationKey.this.compoundPredicateList.size();
            }
        }));
    }

    public static int computeHashCode(BitKey constrainedColumnsBitKey, RolapStar star, Collection<BitKey> compoundPredicateBitKeys) {
        int retCode = constrainedColumnsBitKey.hashCode();
        retCode = Util.hash(retCode, star);
        return Util.hash(retCode, compoundPredicateBitKeys);
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = this.computeHashCode();
        }
        return this.hashCode;
    }

    public boolean equals(Object other) {
        if (!(other instanceof AggregationKey)) {
            return false;
        }
        AggregationKey that = (AggregationKey)other;
        return this.constrainedColumnsBitKey.equals(that.constrainedColumnsBitKey) && this.star.equals(that.star) && AggregationKey.equal(this.compoundPredicateList, that.compoundPredicateList);
    }

    static boolean equal(List<StarPredicate> list1, List<StarPredicate> list2) {
        if (list1 == null) {
            return list2 == null;
        }
        if (list2 == null) {
            return false;
        }
        int size = list1.size();
        if (size != list2.size()) {
            return false;
        }
        int i = 0;
        while (i < size) {
            StarPredicate pred2;
            StarPredicate pred1 = list1.get(i);
            if (!pred1.equalConstraint(pred2 = list2.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String toString() {
        return String.valueOf(this.star.getFactTable().getTableName()) + " " + this.constrainedColumnsBitKey.toString() + "\n" + (this.compoundPredicateList == null ? "{}" : this.compoundPredicateList.toString());
    }

    public final BitKey getConstrainedColumnsBitKey() {
        return this.constrainedColumnsBitKey;
    }

    public final RolapStar getStar() {
        return this.star;
    }

    public List<StarPredicate> getCompoundPredicateList() {
        return this.compoundPredicateList;
    }

    public static List<String> getCompoundPredicateStringList(RolapStar star, List<StarPredicate> compoundPredicateList) {
        if (compoundPredicateList.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> cp = new ArrayList<String>();
        StringBuilder buf = new StringBuilder();
        for (StarPredicate compoundPredicate : compoundPredicateList) {
            buf.setLength(0);
            SqlQuery query = new SqlQuery(star.getSqlQueryDialect());
            compoundPredicate.toSql(query, buf);
            cp.add(buf.toString());
        }
        return cp;
    }
}

