/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap.agg;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import mondrian.olap.CacheControl;
import mondrian.olap.Exp;
import mondrian.olap.MondrianProperties;
import mondrian.olap.MondrianServer;
import mondrian.olap.Util;
import mondrian.rolap.BitKey;
import mondrian.rolap.CacheControlImpl;
import mondrian.rolap.GroupingSetsCollector;
import mondrian.rolap.RolapAggregationManager;
import mondrian.rolap.RolapConnection;
import mondrian.rolap.RolapStar;
import mondrian.rolap.SqlStatement;
import mondrian.rolap.StarColumnPredicate;
import mondrian.rolap.StarPredicate;
import mondrian.rolap.agg.AggQuerySpec;
import mondrian.rolap.agg.Aggregation;
import mondrian.rolap.agg.AggregationKey;
import mondrian.rolap.agg.CellRequest;
import mondrian.rolap.agg.DrillThroughCellRequest;
import mondrian.rolap.agg.DrillThroughQuerySpec;
import mondrian.rolap.agg.GroupingSetsList;
import mondrian.rolap.agg.Segment;
import mondrian.rolap.agg.SegmentArrayQuerySpec;
import mondrian.rolap.agg.SegmentCacheManager;
import mondrian.rolap.agg.SegmentCacheWorker;
import mondrian.rolap.agg.SegmentWithData;
import mondrian.rolap.aggmatcher.AggStar;
import mondrian.server.Locus;
import mondrian.util.Pair;
import org.apache.log4j.Logger;

public class AggregationManager
extends RolapAggregationManager {
    private static final MondrianProperties properties = MondrianProperties.instance();
    private static final Logger LOGGER = Logger.getLogger(AggregationManager.class);
    public final SegmentCacheManager cacheMgr;

    public AggregationManager(MondrianServer server) {
        if (AggregationManager.properties.EnableCacheHitCounters.get()) {
            LOGGER.error((Object)("Property " + AggregationManager.properties.EnableCacheHitCounters.getPath() + " is obsolete; ignored."));
        }
        this.cacheMgr = new SegmentCacheManager(server);
    }

    public final Logger getLogger() {
        return LOGGER;
    }

    public static synchronized AggregationManager instance() {
        return MondrianServer.forId(null).getAggregationManager();
    }

    public static void loadAggregation(SegmentCacheManager cacheMgr, int cellRequestCount, List<RolapStar.Measure> measures, RolapStar.Column[] columns, AggregationKey aggregationKey, StarColumnPredicate[] predicates, GroupingSetsCollector groupingSetsCollector, List<Future<Map<Segment, SegmentWithData>>> segmentFutures) {
        RolapStar star = measures.get(0).getStar();
        Aggregation aggregation = star.lookupOrCreateAggregation(aggregationKey);
        predicates = aggregation.optimizePredicates(columns, predicates);
        aggregation.load(cacheMgr, cellRequestCount, columns, measures, predicates, groupingSetsCollector, segmentFutures);
    }

    public CacheControl getCacheControl(RolapConnection connection, final PrintWriter pw) {
        return new CacheControlImpl(connection){

            @Override
            protected void flushNonUnion(CacheControl.CellRegion region) {
                SegmentCacheManager.FlushResult result = AggregationManager.this.cacheMgr.execute(new SegmentCacheManager.FlushCommand(Locus.peek(), AggregationManager.this.cacheMgr, region, this));
                ArrayList<Future<Boolean>> futures = new ArrayList<Future<Boolean>>();
                for (Callable<Boolean> callable : result.tasks) {
                    futures.add(AggregationManager.this.cacheMgr.cacheExecutor.submit(callable));
                }
                for (Future future : futures) {
                    Util.discard(Util.safeGet(future, "Flush cache"));
                }
            }

            @Override
            public void flush(CacheControl.CellRegion region) {
                if (pw != null) {
                    pw.println("Cache state before flush:");
                    this.printCacheState(pw, region);
                    pw.println();
                }
                super.flush(region);
                if (pw != null) {
                    pw.println("Cache state after flush:");
                    this.printCacheState(pw, region);
                    pw.println();
                }
            }

            @Override
            public void trace(String message) {
                if (pw != null) {
                    pw.println(message);
                }
            }

            @Override
            public boolean isTraceEnabled() {
                return pw != null;
            }
        };
    }

    @Override
    public Object getCellFromCache(CellRequest request) {
        return this.getCellFromCache(request, null);
    }

    @Override
    public Object getCellFromCache(CellRequest request, RolapAggregationManager.PinSet pinSet) {
        RolapStar.Measure measure = request.getMeasure();
        return measure.getStar().getCellFromCache(request, pinSet);
    }

    public Object getCellFromAllCaches(CellRequest request) {
        RolapStar.Measure measure = request.getMeasure();
        return measure.getStar().getCellFromAllCaches(request);
    }

    @Override
    public String getDrillThroughSql(DrillThroughCellRequest request, StarPredicate starPredicateSlicer, List<Exp> fields, boolean countOnly) {
        DrillThroughQuerySpec spec = new DrillThroughQuerySpec(request, starPredicateSlicer, countOnly);
        Pair<String, List<SqlStatement.Type>> pair = spec.generateSqlQuery();
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)("DrillThroughSQL: " + (String)pair.left + Util.nl));
        }
        return (String)pair.left;
    }

    public static Pair<String, List<SqlStatement.Type>> generateSql(GroupingSetsList groupingSetsList, List<StarPredicate> compoundPredicateList) {
        boolean[] rollup;
        AggStar aggStar2;
        RolapStar star = groupingSetsList.getStar();
        BitKey levelBitKey = groupingSetsList.getDefaultLevelBitKey();
        BitKey measureBitKey = groupingSetsList.getDefaultMeasureBitKey();
        boolean hasCompoundPredicates = false;
        if (compoundPredicateList != null && compoundPredicateList.size() > 0) {
            hasCompoundPredicates = true;
        }
        if (MondrianProperties.instance().UseAggregates.get() && !hasCompoundPredicates && (aggStar2 = AggregationManager.findAgg(star, levelBitKey, measureBitKey, rollup = new boolean[1])) != null) {
            if (LOGGER.isDebugEnabled()) {
                StringBuilder buf = new StringBuilder(256);
                buf.append("MATCH: ");
                buf.append(star.getFactTable().getAlias());
                buf.append(Util.nl);
                buf.append("   foreign=");
                buf.append(levelBitKey);
                buf.append(Util.nl);
                buf.append("   measure=");
                buf.append(measureBitKey);
                buf.append(Util.nl);
                buf.append("   aggstar=");
                buf.append(aggStar2.getBitKey());
                buf.append(Util.nl);
                buf.append("AggStar=");
                buf.append(aggStar2.getFactTable().getName());
                buf.append(Util.nl);
                for (AggStar.Table.Column column : aggStar2.getFactTable().getColumns()) {
                    buf.append("   ");
                    buf.append(column);
                    buf.append(Util.nl);
                }
                LOGGER.debug((Object)buf.toString());
            }
            AggQuerySpec aggQuerySpec = new AggQuerySpec(aggStar2, rollup[0], groupingSetsList);
            Pair<String, List<SqlStatement.Type>> sql = aggQuerySpec.generateSqlQuery();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("generateSqlQuery: sql=" + (String)sql.left));
            }
            return sql;
        }
        if (LOGGER.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append("NO MATCH : ");
            sb.append(star.getFactTable().getAlias());
            sb.append(Util.nl);
            sb.append("Foreign columns bit key=");
            sb.append(levelBitKey);
            sb.append(Util.nl);
            sb.append("Measure bit key=        ");
            sb.append(measureBitKey);
            sb.append(Util.nl);
            sb.append("Agg Stars=[");
            sb.append(Util.nl);
            for (AggStar aggStar2 : star.getAggStars()) {
                sb.append(aggStar2.toString());
            }
            sb.append(Util.nl);
            sb.append("]");
            LOGGER.debug((Object)sb.toString());
        }
        SegmentArrayQuerySpec spec = new SegmentArrayQuerySpec(groupingSetsList, compoundPredicateList);
        Pair<String, List<SqlStatement.Type>> pair = spec.generateSqlQuery();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("generateSqlQuery: sql=" + (String)pair.left));
        }
        return pair;
    }

    public static AggStar findAgg(RolapStar star, BitKey levelBitKey, BitKey measureBitKey, boolean[] rollup) {
        assert (rollup != null);
        BitKey fullBitKey = levelBitKey.or(measureBitKey);
        for (AggStar aggStar : star.getAggStars()) {
            if (!aggStar.superSetMatch(fullBitKey)) continue;
            boolean isDistinct = measureBitKey.intersects(aggStar.getDistinctMeasureBitKey());
            if (!isDistinct) {
                rollup[0] = levelBitKey.isEmpty() || !aggStar.getLevelBitKey().equals(levelBitKey);
                return aggStar;
            }
            BitKey distinctMeasuresBitKey = measureBitKey.and(aggStar.getDistinctMeasureBitKey());
            BitSet distinctMeasures = distinctMeasuresBitKey.toBitSet();
            BitKey combinedLevelBitKey = null;
            int k = distinctMeasures.nextSetBit(0);
            while (k >= 0) {
                AggStar.FactTable.Measure distinctMeasure = aggStar.lookupMeasure(k);
                BitKey rollableLevelBitKey = distinctMeasure.getRollableLevelBitKey();
                combinedLevelBitKey = combinedLevelBitKey == null ? rollableLevelBitKey : combinedLevelBitKey.and(rollableLevelBitKey);
                k = distinctMeasures.nextSetBit(k + 1);
            }
            if (aggStar.hasForeignKeys()) {
                BitKey fkBitKey = aggStar.getForeignKeyBitKey().copy();
                for (AggStar.FactTable.Measure measure : aggStar.getFactTable().getMeasures()) {
                    if (!measure.isDistinct() || !measureBitKey.get(measure.getBitPosition())) continue;
                    fkBitKey.clear(measure.getBitPosition());
                }
                if (!fkBitKey.isEmpty()) continue;
            }
            if (!aggStar.select(levelBitKey, combinedLevelBitKey, measureBitKey) || levelBitKey.isEmpty()) continue;
            rollup[0] = !aggStar.getLevelBitKey().equals(levelBitKey);
            return aggStar;
        }
        return null;
    }

    @Override
    public RolapAggregationManager.PinSet createPinSet() {
        return new PinSetImpl();
    }

    public void shutdown() {
        this.cacheMgr.shutdown();
        for (SegmentCacheWorker worker : this.cacheMgr.segmentCacheWorkers) {
            worker.shutdown();
        }
    }

    public static class PinSetImpl
    extends HashSet<Segment>
    implements RolapAggregationManager.PinSet {
    }
}

