/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap.agg;

import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import mondrian.rolap.BitKey;
import mondrian.rolap.RolapStar;
import mondrian.rolap.StarColumnPredicate;
import mondrian.rolap.StarPredicate;
import mondrian.rolap.agg.ValueColumnPredicate;

public class CellRequest {
    private final RolapStar.Measure measure;
    public final boolean extendedContext;
    public final boolean drillThrough;
    private StarColumnPredicate[] sparseColumnPredicateList;
    private int[] columnBitPositions;
    private int numColumns;
    private RolapStar star = null;
    private Object[] singleValues;
    private RolapStar.Column[] columnsCache = null;
    private final BitKey constrainedColumnsBitKey;
    private SortedMap<BitKey, StarPredicate> compoundPredicateMap = null;
    private boolean unsatisfiable;
    private boolean isDirty = true;

    public CellRequest(RolapStar.Measure measure, boolean extendedContext, boolean drillThrough) {
        this.measure = measure;
        this.extendedContext = extendedContext;
        this.drillThrough = drillThrough;
        this.constrainedColumnsBitKey = BitKey.Factory.makeBitKey(measure.getStar().getColumnCount());
        this.sparseColumnPredicateList = new StarColumnPredicate[measure.getStar().getColumnCount()];
    }

    public final void addConstrainedColumn(RolapStar.Column column, StarColumnPredicate predicate) {
        assert (this.columnsCache == null);
        if (this.star == null) {
            this.star = column.getStar();
        } else assert (this.star == column.getStar());
        int bitPosition = column.getBitPosition();
        if (this.constrainedColumnsBitKey.get(bitPosition)) {
            StarColumnPredicate prevValue = this.sparseColumnPredicateList[bitPosition];
            if (prevValue != null) {
                if (predicate == null) {
                    return;
                }
                if (predicate.equalConstraint(prevValue)) {
                    return;
                }
                predicate = null;
                this.unsatisfiable = true;
            }
        } else {
            this.constrainedColumnsBitKey.set(bitPosition);
            ++this.numColumns;
        }
        this.sparseColumnPredicateList[bitPosition] = predicate;
    }

    public void addAggregateList(BitKey compoundBitKey, StarPredicate compoundPredicate) {
        if (this.compoundPredicateMap == null) {
            this.compoundPredicateMap = new TreeMap<BitKey, StarPredicate>();
        }
        this.compoundPredicateMap.put(compoundBitKey, compoundPredicate);
    }

    public RolapStar.Measure getMeasure() {
        return this.measure;
    }

    public RolapStar.Column[] getConstrainedColumns() {
        if (this.columnsCache == null) {
            this.check();
        }
        return this.columnsCache;
    }

    public BitKey getConstrainedColumnsBitKey() {
        return this.constrainedColumnsBitKey;
    }

    SortedMap<BitKey, StarPredicate> getCompoundPredicateMap() {
        return this.compoundPredicateMap;
    }

    private void check() {
        if (this.isDirty) {
            this.columnsCache = new RolapStar.Column[this.numColumns];
            this.columnBitPositions = new int[this.numColumns];
            int i = 0;
            int bitPos = this.constrainedColumnsBitKey.nextSetBit(0);
            while (bitPos >= 0) {
                this.columnBitPositions[i] = bitPos;
                this.columnsCache[i] = this.star.getColumn(bitPos);
                ++i;
                bitPos = this.constrainedColumnsBitKey.nextSetBit(bitPos + 1);
            }
            this.isDirty = false;
        }
    }

    public StarColumnPredicate getValueAt(int index) {
        this.check();
        return this.sparseColumnPredicateList[this.columnBitPositions[index]];
    }

    public int getNumValues() {
        this.check();
        return this.numColumns;
    }

    public Object[] getSingleValues() {
        assert (!this.unsatisfiable);
        if (this.singleValues == null) {
            this.check();
            this.singleValues = new Object[this.numColumns];
            int i = 0;
            int[] nArray = this.columnBitPositions;
            int n = this.columnBitPositions.length;
            int n2 = 0;
            while (n2 < n) {
                int bitPos = nArray[n2];
                ValueColumnPredicate predicate = (ValueColumnPredicate)this.sparseColumnPredicateList[bitPos];
                this.singleValues[i++] = predicate.getValue();
                ++n2;
            }
        }
        return this.singleValues;
    }

    public Map<String, Comparable> getMappedCellValues() {
        HashMap<String, Comparable> map = new HashMap<String, Comparable>();
        RolapStar.Column[] columns = this.getConstrainedColumns();
        Object[] values = this.getSingleValues();
        int i = 0;
        while (i < columns.length) {
            RolapStar.Column column = columns[i];
            Object o = values[i];
            map.put(column.getExpression().getGenericExpression(), (Comparable)o);
            ++i;
        }
        return map;
    }

    public boolean isUnsatisfiable() {
        return this.unsatisfiable;
    }
}

