/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap.agg;

import java.util.BitSet;
import java.util.List;
import java.util.SortedSet;
import mondrian.rolap.CellKey;
import mondrian.rolap.SqlStatement;
import mondrian.rolap.agg.DenseDoubleSegmentBody;
import mondrian.rolap.agg.DenseNativeSegmentDataset;
import mondrian.rolap.agg.SegmentAxis;
import mondrian.rolap.agg.SegmentDataset;
import mondrian.rolap.agg.SegmentLoader;
import mondrian.spi.SegmentBody;
import mondrian.util.Pair;

class DenseDoubleSegmentDataset
extends DenseNativeSegmentDataset {
    final double[] values;

    DenseDoubleSegmentDataset(SegmentAxis[] axes, int size) {
        this(axes, new double[size], new BitSet(size));
    }

    DenseDoubleSegmentDataset(SegmentAxis[] axes, double[] values, BitSet nullIndicators) {
        super(axes, nullIndicators);
        this.values = values;
    }

    @Override
    public double getDouble(CellKey key) {
        int offset = key.getOffset(this.axisMultipliers);
        return this.values[offset];
    }

    @Override
    public Object getObject(CellKey pos) {
        int offset = pos.getOffset(this.axisMultipliers);
        return this.getObject(offset);
    }

    @Override
    public Double getObject(int offset) {
        double value = this.values[offset];
        if (value == 0.0 && this.isNull(offset)) {
            return null;
        }
        return value;
    }

    @Override
    public boolean exists(CellKey pos) {
        return true;
    }

    @Override
    public void populateFrom(int[] pos, SegmentDataset data, CellKey key) {
        int offset = this.getOffset(pos);
        this.values[offset] = data.getDouble(key);
        double value = this.values[offset];
        if (value == 0.0) {
            this.nullIndicators.set(offset, !data.isNull(key));
        }
    }

    @Override
    public void populateFrom(int[] pos, SegmentLoader.RowList rowList, int column) {
        int offset = this.getOffset(pos);
        this.values[offset] = rowList.getDouble(column);
        double d = this.values[offset];
        if (d == 0.0) {
            this.nullIndicators.set(offset, !rowList.isNull(column));
        }
    }

    @Override
    public SqlStatement.Type getType() {
        return SqlStatement.Type.DOUBLE;
    }

    void set(int k, double d) {
        this.values[k] = d;
    }

    @Override
    protected int getSize() {
        return this.values.length;
    }

    @Override
    public SegmentBody createSegmentBody(List<Pair<SortedSet<Comparable>, Boolean>> axes) {
        return new DenseDoubleSegmentBody(this.nullIndicators, this.values, axes);
    }
}

