/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap.agg;

import java.util.BitSet;
import java.util.List;
import java.util.SortedSet;
import mondrian.rolap.agg.AbstractSegmentBody;
import mondrian.util.Pair;

class DenseIntSegmentBody
extends AbstractSegmentBody {
    private static final long serialVersionUID = 5391233622968115488L;
    private final int[] values;
    private final BitSet nullIndicators;

    DenseIntSegmentBody(BitSet nullIndicators, int[] values, List<Pair<SortedSet<Comparable>, Boolean>> axes) {
        super(axes);
        this.values = values;
        this.nullIndicators = nullIndicators;
    }

    @Override
    public Object getValueArray() {
        return this.values;
    }

    @Override
    public BitSet getIndicators() {
        return this.nullIndicators;
    }

    @Override
    protected int getSize() {
        return this.values.length - this.nullIndicators.cardinality();
    }

    @Override
    protected Object getObject(int i) {
        int value = this.values[i];
        if (value == 0 && this.nullIndicators.get(i)) {
            return null;
        }
        return value;
    }
}

