/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap.agg;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import mondrian.rolap.RolapStar;
import mondrian.rolap.StarColumnPredicate;
import mondrian.rolap.StarPredicate;
import mondrian.rolap.agg.AbstractQuerySpec;
import mondrian.rolap.agg.GroupingSetsList;
import mondrian.rolap.agg.Segment;
import mondrian.rolap.sql.SqlQuery;

class SegmentArrayQuerySpec
extends AbstractQuerySpec {
    private final List<Segment> segments;
    private final Segment segment0;
    private final GroupingSetsList groupingSetsList;
    private final List<StarPredicate> compoundPredicateList;

    SegmentArrayQuerySpec(GroupingSetsList groupingSetsList, List<StarPredicate> compoundPredicateList) {
        super(groupingSetsList.getStar(), false);
        this.segments = groupingSetsList.getDefaultSegments();
        this.segment0 = this.segments.get(0);
        this.groupingSetsList = groupingSetsList;
        this.compoundPredicateList = compoundPredicateList;
        assert (this.isValid(true));
    }

    private boolean isValid(boolean fail) {
        assert (this.segments.size() > 0);
        for (Segment segment : this.segments) {
            int n = segment.predicates.length;
            if (n != this.segment0.predicates.length) {
                assert (!fail);
                return false;
            }
            int j = 0;
            while (j < segment.predicates.length) {
                if (segment.predicates[j] != this.segment0.predicates[j]) {
                    assert (!fail);
                    return false;
                }
                ++j;
            }
        }
        return true;
    }

    @Override
    public int getMeasureCount() {
        return this.segments.size();
    }

    @Override
    public RolapStar.Measure getMeasure(int i) {
        return this.segments.get((int)i).measure;
    }

    @Override
    public String getMeasureAlias(int i) {
        return "m" + Integer.toString(i);
    }

    @Override
    public RolapStar.Column[] getColumns() {
        return this.segment0.getColumns();
    }

    @Override
    public String getColumnAlias(int i) {
        return "c" + Integer.toString(i);
    }

    @Override
    public StarColumnPredicate getColumnPredicate(int i) {
        return this.segment0.predicates[i];
    }

    @Override
    protected List<StarPredicate> getPredicateList() {
        if (this.compoundPredicateList == null) {
            return super.getPredicateList();
        }
        return this.compoundPredicateList;
    }

    @Override
    protected void addGroupingFunction(SqlQuery sqlQuery) {
        List<RolapStar.Column> list = this.groupingSetsList.getRollupColumns();
        for (RolapStar.Column column : list) {
            sqlQuery.addGroupingFunction(column.generateExprString(sqlQuery));
        }
    }

    @Override
    protected void addGroupingSets(SqlQuery sqlQuery, Map<String, String> groupingSetsAliases) {
        List<RolapStar.Column[]> groupingSetsColumns = this.groupingSetsList.getGroupingSetsColumns();
        for (RolapStar.Column[] groupingSetsColumn : groupingSetsColumns) {
            ArrayList<String> groupingColumnsExpr = new ArrayList<String>();
            RolapStar.Column[] columnArray = groupingSetsColumn;
            int n = groupingSetsColumn.length;
            int n2 = 0;
            while (n2 < n) {
                RolapStar.Column aColumn = columnArray[n2];
                String columnExpr = aColumn.generateExprString(sqlQuery);
                if (groupingSetsAliases.containsKey(columnExpr)) {
                    groupingColumnsExpr.add(groupingSetsAliases.get(columnExpr));
                } else {
                    groupingColumnsExpr.add(columnExpr);
                }
                ++n2;
            }
            sqlQuery.addGroupingSet(groupingColumnsExpr);
        }
    }

    @Override
    protected boolean isAggregate() {
        return true;
    }
}

