/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap.agg;

import java.lang.ref.WeakReference;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import mondrian.olap.Aggregator;
import mondrian.olap.Util;
import mondrian.rolap.BitKey;
import mondrian.rolap.CellKey;
import mondrian.rolap.RolapSchema;
import mondrian.rolap.RolapStar;
import mondrian.rolap.StarColumnPredicate;
import mondrian.rolap.StarPredicate;
import mondrian.rolap.agg.AbstractColumnPredicate;
import mondrian.rolap.agg.AbstractSegmentBody;
import mondrian.rolap.agg.AggregationKey;
import mondrian.rolap.agg.CellRequest;
import mondrian.rolap.agg.DenseDoubleSegmentBody;
import mondrian.rolap.agg.DenseDoubleSegmentDataset;
import mondrian.rolap.agg.DenseIntSegmentBody;
import mondrian.rolap.agg.DenseIntSegmentDataset;
import mondrian.rolap.agg.DenseObjectSegmentBody;
import mondrian.rolap.agg.DenseObjectSegmentDataset;
import mondrian.rolap.agg.ListColumnPredicate;
import mondrian.rolap.agg.LiteralStarPredicate;
import mondrian.rolap.agg.Segment;
import mondrian.rolap.agg.SegmentAxis;
import mondrian.rolap.agg.SegmentDataset;
import mondrian.rolap.agg.SegmentLoader;
import mondrian.rolap.agg.SegmentWithData;
import mondrian.rolap.agg.SparseSegmentBody;
import mondrian.rolap.agg.SparseSegmentDataset;
import mondrian.rolap.agg.ValueColumnPredicate;
import mondrian.rolap.sql.SqlQuery;
import mondrian.spi.Dialect;
import mondrian.spi.SegmentBody;
import mondrian.spi.SegmentColumn;
import mondrian.spi.SegmentHeader;
import mondrian.util.ArraySortedSet;
import mondrian.util.Pair;

public class SegmentBuilder {
    public static SegmentWithData addData(Segment segment, SegmentBody sb) {
        SegmentAxis[] axes = new SegmentAxis[segment.predicates.length];
        int i = 0;
        while (i < segment.predicates.length) {
            StarColumnPredicate predicate = segment.predicates[i];
            axes[i] = new SegmentAxis(predicate, sb.getAxisValueSets()[i], sb.getNullAxisFlags()[i]);
            ++i;
        }
        SegmentDataset dataSet = SegmentBuilder.createDataset(sb, axes);
        return new SegmentWithData(segment, dataSet, axes);
    }

    private static SegmentDataset createDataset(SegmentBody body, SegmentAxis[] axes) {
        SegmentDataset dataSet;
        if (body instanceof DenseDoubleSegmentBody) {
            dataSet = new DenseDoubleSegmentDataset(axes, (double[])body.getValueArray(), body.getIndicators());
        } else if (body instanceof DenseIntSegmentBody) {
            dataSet = new DenseIntSegmentDataset(axes, (int[])body.getValueArray(), body.getIndicators());
        } else if (body instanceof DenseObjectSegmentBody) {
            dataSet = new DenseObjectSegmentDataset(axes, (Object[])body.getValueArray());
        } else if (body instanceof SparseSegmentBody) {
            dataSet = new SparseSegmentDataset(body.getValueMap());
        } else {
            throw Util.newInternal("Unknown segment body type: " + body.getClass() + ": " + body);
        }
        return dataSet;
    }

    public static Segment toSegment(SegmentHeader header, RolapStar star, BitKey constrainedColumnsBitKey, RolapStar.Column[] constrainedColumns, RolapStar.Measure measure, List<StarPredicate> compoundPredicates) {
        ArrayList<LiteralStarPredicate> predicateList = new ArrayList<LiteralStarPredicate>();
        int i = 0;
        while (i < constrainedColumns.length) {
            AbstractColumnPredicate predicate;
            RolapStar.Column constrainedColumn = constrainedColumns[i];
            SortedSet<Comparable> values = header.getConstrainedColumns().get((int)i).values;
            if (values == null) {
                predicate = new LiteralStarPredicate(constrainedColumn, true);
            } else if (values.size() == 1) {
                predicate = new ValueColumnPredicate(constrainedColumn, values.first());
            } else {
                ArrayList<StarColumnPredicate> valuePredicateList = new ArrayList<StarColumnPredicate>();
                for (Object e : values) {
                    valuePredicateList.add(new ValueColumnPredicate(constrainedColumn, e));
                }
                predicate = new ListColumnPredicate(constrainedColumn, valuePredicateList);
            }
            predicateList.add((LiteralStarPredicate)predicate);
            ++i;
        }
        return new Segment(star, constrainedColumnsBitKey, constrainedColumns, measure, predicateList.toArray(new StarColumnPredicate[predicateList.size()]), new ExcludedRegionList(header), compoundPredicates);
    }

    /*
     * WARNING - void declaration
     */
    public static Pair<SegmentHeader, SegmentBody> rollup(Map<SegmentHeader, SegmentBody> map, Set<String> keepColumns, BitKey targetBitkey, Aggregator rollupAggregator, Dialect.Datatype datatype) {
        void var16_44;
        AbstractSegmentBody body;
        Object axis;
        SegmentHeader firstHeader = map.keySet().iterator().next();
        class AxisInfo {
            SegmentColumn column;
            SortedSet<Comparable> requestedValues;
            SortedSet<Comparable> valueSet;
            Comparable[] values;
            boolean hasNull;
            int src;
            boolean lostPredicate;

            AxisInfo() {
            }
        }
        AxisInfo[] axes = new AxisInfo[keepColumns.size()];
        int z = 0;
        int j = 0;
        for (SegmentColumn segmentColumn : firstHeader.getConstrainedColumns()) {
            if (keepColumns.contains(segmentColumn.columnExpression)) {
                int n = z++;
                AxisInfo axisInfo = new AxisInfo();
                axes[n] = axisInfo;
                AxisInfo axisInfo2 = axisInfo;
                axisInfo2.src = j;
                axisInfo2.column = segmentColumn;
                axisInfo2.requestedValues = segmentColumn.values;
            }
            ++j;
        }
        for (Map.Entry entry : map.entrySet()) {
            SegmentHeader header = (SegmentHeader)entry.getKey();
            AxisInfo[] axisInfoArray = axes;
            int n = axes.length;
            int n2 = 0;
            while (n2 < n) {
                axis = axisInfoArray[n2];
                SortedSet<Comparable> sortedSet = ((SegmentBody)entry.getValue()).getAxisValueSets()[axis.src];
                Iterator headerColumn = header.getConstrainedColumn(axis.column.columnExpression);
                boolean hasNull = ((SegmentBody)entry.getValue()).getNullAxisFlags()[axis.src];
                SortedSet<Comparable> requestedValues = ((SegmentColumn)((Object)headerColumn)).getValues();
                if (axis.valueSet == null) {
                    axis.valueSet = new TreeSet<Comparable>(sortedSet);
                    axis.hasNull = hasNull;
                    axis.requestedValues = requestedValues;
                } else {
                    boolean filteredHasNull;
                    SortedSet<Comparable> filteredValues;
                    if (axis.requestedValues == null) {
                        filteredValues = sortedSet;
                        filteredHasNull = hasNull;
                    } else {
                        filteredValues = Util.intersect(sortedSet, axis.requestedValues);
                        filteredHasNull = false;
                    }
                    axis.valueSet.addAll(filteredValues);
                    boolean bl = axis.hasNull = axis.hasNull || filteredHasNull;
                    if (!Util.equals(axis.requestedValues, requestedValues)) {
                        if (axis.requestedValues == null) {
                            axis.requestedValues = requestedValues;
                        } else {
                            axis.lostPredicate = true;
                        }
                    }
                }
                ++n2;
            }
        }
        axis = axes;
        int header = axes.length;
        int n = 0;
        while (n < header) {
            AxisInfo axisInfo = axis[n];
            axisInfo.values = axisInfo.valueSet.toArray(new Comparable[axisInfo.valueSet.size()]);
            ++n;
        }
        HashMap hashMap = new HashMap();
        for (Map.Entry<SegmentHeader, SegmentBody> entry : map.entrySet()) {
            void var16_35;
            int[] pos = new int[axes.length];
            Comparable[][] valueArrays = new Comparable[firstHeader.getConstrainedColumns().size()][];
            SegmentBody body2 = entry.getValue();
            z = 0;
            SortedSet<Comparable>[] hasNull = body2.getAxisValueSets();
            int headerColumn = hasNull.length;
            boolean bl = false;
            while (var16_35 < headerColumn) {
                SortedSet<Comparable> set = hasNull[var16_35];
                valueArrays[z] = keepColumns.contains(firstHeader.getConstrainedColumns().get((int)z).columnExpression) ? set.toArray(new Comparable[set.size()]) : null;
                ++z;
                ++var16_35;
            }
            Map<CellKey, Object> v = body2.getValueMap();
            block10: for (Map.Entry entry2 : v.entrySet()) {
                z = 0;
                int i = 0;
                while (i < ((CellKey)entry2.getKey()).size()) {
                    Comparable[] valueArray = valueArrays[i];
                    if (valueArray != null) {
                        Comparable value;
                        int ordinal = ((CellKey)entry2.getKey()).getOrdinals()[i];
                        int targetOrdinal = axes[z].hasNull && ordinal == valueArray.length ? axes[z].valueSet.size() : ((value = valueArray[ordinal]) == null ? axes[z].valueSet.size() : Util.binarySearch((Comparable[])axes[z].values, (int)0, (int)axes[z].values.length, (Comparable)value));
                        if (targetOrdinal < 0) continue block10;
                        pos[z++] = targetOrdinal;
                    }
                    ++i;
                }
                CellKey ck = CellKey.Generator.newCellKey(pos);
                if (!hashMap.containsKey(ck)) {
                    hashMap.put(ck, new ArrayList());
                }
                ((List)hashMap.get(ck)).add(entry2.getValue());
            }
        }
        ArrayList<Pair<SortedSet<Comparable>, Boolean>> axisList = new ArrayList<Pair<SortedSet<Comparable>, Boolean>>();
        BitSet nullIndicators = new BitSet(axes.length);
        int nbValues = 1;
        int i = 0;
        while (i < axes.length) {
            axisList.add(new Pair<SortedSet<Comparable>, Boolean>(axes[i].valueSet, axes[i].hasNull));
            nullIndicators.set(i, axes[i].hasNull);
            nbValues *= axes[i].hasNull ? axes[i].values.length + 1 : axes[i].values.length;
            ++i;
        }
        int[] axisMultipliers = SegmentBuilder.computeAxisMultipliers(axisList);
        if (hashMap.size() == 0) {
            body = new DenseObjectSegmentBody(new Object[0], axisList);
        } else if (SegmentLoader.useSparse(hashMap.size(), hashMap.size() - nullIndicators.cardinality())) {
            HashMap<CellKey, Object> data = new HashMap<CellKey, Object>();
            for (Map.Entry entry : hashMap.entrySet()) {
                data.put(CellKey.Generator.newCellKey(((CellKey)entry.getKey()).getOrdinals()), rollupAggregator.aggregate((List)entry.getValue(), datatype));
            }
            body = new SparseSegmentBody(data, axisList);
        } else {
            switch (datatype) {
                case Integer: {
                    int[] ints = new int[nbValues];
                    for (Map.Entry entry : hashMap.entrySet()) {
                        int offset = CellKey.Generator.getOffset(((CellKey)entry.getKey()).getOrdinals(), axisMultipliers);
                        ints[offset] = (Integer)rollupAggregator.aggregate((List)entry.getValue(), datatype);
                    }
                    body = new DenseIntSegmentBody(nullIndicators, ints, axisList);
                    break;
                }
                case Numeric: {
                    double[] dArray = new double[nbValues];
                    for (Map.Entry entry : hashMap.entrySet()) {
                        int offset = CellKey.Generator.getOffset(((CellKey)entry.getKey()).getOrdinals(), axisMultipliers);
                        dArray[offset] = (Double)rollupAggregator.aggregate((List)entry.getValue(), datatype);
                    }
                    body = new DenseDoubleSegmentBody(nullIndicators, dArray, axisList);
                    break;
                }
                default: {
                    Object[] objects = new Object[nbValues];
                    for (Map.Entry entry : hashMap.entrySet()) {
                        int offset = CellKey.Generator.getOffset(((CellKey)entry.getKey()).getOrdinals(), axisMultipliers);
                        objects[offset] = rollupAggregator.aggregate((List)entry.getValue(), datatype);
                    }
                    body = new DenseObjectSegmentBody(objects, axisList);
                }
            }
        }
        ArrayList<SegmentColumn> constrainedColumns = new ArrayList<SegmentColumn>();
        boolean bl = false;
        while (var16_44 < axes.length) {
            AxisInfo axisInfo = axes[var16_44];
            constrainedColumns.add(new SegmentColumn(axisInfo.column.getColumnExpression(), axisInfo.column.getValueCount(), axisInfo.lostPredicate ? (SortedSet)((Pair)axisList.get((int)var16_44)).left : axisInfo.column.values));
            ++var16_44;
        }
        SegmentHeader segmentHeader = new SegmentHeader(firstHeader.schemaName, firstHeader.schemaChecksum, firstHeader.cubeName, firstHeader.measureName, constrainedColumns, firstHeader.compoundPredicates, firstHeader.rolapStarFactTableName, targetBitkey, Collections.<SegmentColumn>emptyList());
        return Pair.of(segmentHeader, body);
    }

    private static int[] computeAxisMultipliers(List<Pair<SortedSet<Comparable>, Boolean>> axes) {
        int[] axisMultipliers = new int[axes.size()];
        int multiplier = 1;
        int i = axes.size() - 1;
        while (i >= 0) {
            axisMultipliers[i] = multiplier;
            multiplier *= ((SortedSet)axes.get((int)i).left).size();
            --i;
        }
        return axisMultipliers;
    }

    public static boolean isSubset(SegmentHeader header, Segment segment) {
        if (!segment.getStar().getSchema().getName().equals(header.schemaName)) {
            return false;
        }
        if (!segment.getStar().getFactTable().getAlias().equals(header.rolapStarFactTableName)) {
            return false;
        }
        if (!segment.measure.getName().equals(header.measureName)) {
            return false;
        }
        if (!segment.measure.getCubeName().equals(header.cubeName)) {
            return false;
        }
        return segment.getConstrainedColumnsBitKey().equals(header.constrainedColsBitKey);
    }

    public static List<SegmentColumn> toConstrainedColumns(StarColumnPredicate[] predicates) {
        return SegmentBuilder.toConstrainedColumns(Arrays.asList(predicates));
    }

    public static List<SegmentColumn> toConstrainedColumns(Collection<StarColumnPredicate> predicates) {
        ArrayList<SegmentColumn> ccs = new ArrayList<SegmentColumn>();
        for (StarColumnPredicate predicate : predicates) {
            ArrayList values = new ArrayList();
            predicate.values(Util.cast(values));
            Comparable[] valuesArray = values.toArray(new Comparable[values.size()]);
            if (valuesArray.length == 1 && valuesArray[0].equals(true)) {
                ccs.add(new SegmentColumn(predicate.getConstrainedColumn().getExpression().getGenericExpression(), predicate.getConstrainedColumn().getCardinality(), null));
                continue;
            }
            Arrays.sort(valuesArray, Util.SqlNullSafeComparator.instance);
            ccs.add(new SegmentColumn(predicate.getConstrainedColumn().getExpression().getGenericExpression(), predicate.getConstrainedColumn().getCardinality(), new ArraySortedSet(valuesArray)));
        }
        return ccs;
    }

    public static SegmentHeader toHeader(Segment segment) {
        List<SegmentColumn> cc = SegmentBuilder.toConstrainedColumns(segment.predicates);
        ArrayList<String> cp = new ArrayList<String>();
        StringBuilder buf = new StringBuilder();
        for (StarPredicate compoundPredicate : segment.compoundPredicateList) {
            buf.setLength(0);
            SqlQuery query = new SqlQuery(segment.star.getSqlQueryDialect());
            compoundPredicate.toSql(query, buf);
            cp.add(buf.toString());
        }
        RolapSchema schema = segment.star.getSchema();
        return new SegmentHeader(schema.getName(), schema.getChecksum(), segment.measure.getCubeName(), segment.measure.getName(), cc, cp, segment.star.getFactTable().getAlias(), segment.constrainedColumnsBitKey, Collections.<SegmentColumn>emptyList());
    }

    private static RolapStar.Column[] getConstrainedColumns(RolapStar star, BitKey bitKey) {
        ArrayList<RolapStar.Column> list = new ArrayList<RolapStar.Column>();
        for (int bit : bitKey) {
            list.add(star.getColumn(bit));
        }
        return list.toArray(new RolapStar.Column[list.size()]);
    }

    private static class ExcludedRegionList
    extends AbstractList<Segment.ExcludedRegion>
    implements Segment.ExcludedRegion {
        private final int cellCount;
        private final SegmentHeader header;

        public ExcludedRegionList(SegmentHeader header) {
            this.header = header;
            int cellCount = 1;
            for (SegmentColumn cc : header.getExcludedRegions()) {
                if (cc.values == null) continue;
                cellCount *= cc.values.size();
            }
            this.cellCount = cellCount;
        }

        @Override
        public void describe(StringBuilder buf) {
        }

        @Override
        public int getArity() {
            return this.header.getConstrainedColumns().size();
        }

        @Override
        public int getCellCount() {
            return this.cellCount;
        }

        @Override
        public boolean wouldContain(Object[] keys) {
            assert (keys.length == this.header.getConstrainedColumns().size());
            int i = 0;
            while (i < keys.length) {
                SegmentColumn excl = this.header.getExcludedRegion(this.header.getConstrainedColumns().get((int)i).columnExpression);
                if (excl != null && excl.values.contains(keys[i])) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        @Override
        public Segment.ExcludedRegion get(int index) {
            return this;
        }

        @Override
        public int size() {
            return 1;
        }
    }

    public static interface SegmentConverter {
        public SegmentWithData convert(SegmentHeader var1, SegmentBody var2);
    }

    public static class SegmentConverterImpl
    implements SegmentConverter {
        private final AggregationKey key;
        private final CellRequest request;

        public SegmentConverterImpl(AggregationKey key, CellRequest request) {
            this.key = key;
            this.request = request;
        }

        @Override
        public SegmentWithData convert(SegmentHeader header, SegmentBody body) {
            Segment segment = SegmentBuilder.toSegment(header, this.key.getStar(), header.getConstrainedColumnsBitKey(), SegmentBuilder.getConstrainedColumns(this.key.getStar(), header.getConstrainedColumnsBitKey()), this.request.getMeasure(), this.key.getCompoundPredicateList());
            return SegmentBuilder.addData(segment, body);
        }
    }

    public static class StarSegmentConverter
    implements SegmentConverter {
        private final WeakReference<RolapStar.Measure> measure;
        private final List<StarPredicate> compoundPredicateList;

        public StarSegmentConverter(RolapStar.Measure measure, List<StarPredicate> compoundPredicateList) {
            this.measure = new WeakReference<RolapStar.Measure>(measure);
            this.compoundPredicateList = compoundPredicateList;
        }

        @Override
        public SegmentWithData convert(SegmentHeader header, SegmentBody body) {
            RolapStar.Measure m1 = (RolapStar.Measure)this.measure.get();
            assert (m1 != null) : "Invalid state. A reference to the measure object was picked up by GC but the index wasn't cleared. This shouldn't happen.";
            Segment segment = SegmentBuilder.toSegment(header, m1.getStar(), header.getConstrainedColumnsBitKey(), SegmentBuilder.getConstrainedColumns(m1.getStar(), header.getConstrainedColumnsBitKey()), m1, this.compoundPredicateList);
            return SegmentBuilder.addData(segment, body);
        }
    }
}

