/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap.agg;

import java.util.ArrayList;
import java.util.List;
import mondrian.olap.MondrianProperties;
import mondrian.resource.MondrianResource;
import mondrian.spi.SegmentBody;
import mondrian.spi.SegmentCache;
import mondrian.spi.SegmentHeader;
import mondrian.util.ServiceDiscovery;
import org.apache.log4j.Logger;

public final class SegmentCacheWorker {
    private static final Logger LOGGER = Logger.getLogger(SegmentCacheWorker.class);
    final SegmentCache cache;
    private final Thread cacheMgrThread;
    private final boolean supportsRichIndex;

    public SegmentCacheWorker(SegmentCache cache, Thread cacheMgrThread) {
        this.cache = cache;
        this.cacheMgrThread = cacheMgrThread;
        this.supportsRichIndex = cache.supportsRichIndex();
        LOGGER.debug((Object)("Segment cache initialized: " + cache.getClass().getName()));
    }

    public static List<SegmentCache> initCache() {
        SegmentCache cache;
        List<Class<SegmentCache>> implementors;
        ArrayList<SegmentCache> caches = new ArrayList<SegmentCache>();
        String cacheName = MondrianProperties.instance().SegmentCache.get();
        if (cacheName != null) {
            caches.add(SegmentCacheWorker.instantiateCache(cacheName));
        }
        if ((implementors = ServiceDiscovery.forClass(SegmentCache.class).getImplementor()).size() > 0 && (cache = SegmentCacheWorker.instantiateCache(implementors.get(0).getName())) != null) {
            caches.add(cache);
        }
        caches.addAll(SegmentCache.SegmentCacheInjector.getCaches());
        return caches;
    }

    private static SegmentCache instantiateCache(String cacheName) {
        try {
            LOGGER.debug((Object)("Starting cache instance: " + cacheName));
            Class<?> clazz = Class.forName(cacheName);
            Object scObject = clazz.newInstance();
            if (!(scObject instanceof SegmentCache)) {
                throw MondrianResource.instance().SegmentCacheIsNotImplementingInterface.ex();
            }
            return (SegmentCache)scObject;
        }
        catch (Exception e) {
            LOGGER.error((Object)MondrianResource.instance().SegmentCacheFailedToInstanciate.baseMessage, (Throwable)e);
            throw MondrianResource.instance().SegmentCacheFailedToInstanciate.ex(e);
        }
    }

    public SegmentBody get(SegmentHeader header) {
        this.checkThread();
        try {
            return this.cache.get(header);
        }
        catch (Throwable t) {
            LOGGER.error((Object)MondrianResource.instance().SegmentCacheFailedToLoadSegment.baseMessage, t);
            throw MondrianResource.instance().SegmentCacheFailedToLoadSegment.ex(t);
        }
    }

    public void put(SegmentHeader header, SegmentBody body) {
        this.checkThread();
        try {
            boolean result = this.cache.put(header, body);
            if (!result) {
                LOGGER.error((Object)MondrianResource.instance().SegmentCacheFailedToSaveSegment.baseMessage);
                throw MondrianResource.instance().SegmentCacheFailedToSaveSegment.ex();
            }
        }
        catch (Throwable t) {
            LOGGER.error((Object)MondrianResource.instance().SegmentCacheFailedToSaveSegment.baseMessage, t);
            throw MondrianResource.instance().SegmentCacheFailedToSaveSegment.ex(t);
        }
    }

    public boolean remove(SegmentHeader header) {
        this.checkThread();
        try {
            return this.cache.remove(header);
        }
        catch (Throwable t) {
            LOGGER.error((Object)MondrianResource.instance().SegmentCacheFailedToDeleteSegment.baseMessage, t);
            throw MondrianResource.instance().SegmentCacheFailedToDeleteSegment.ex(t);
        }
    }

    public List<SegmentHeader> getSegmentHeaders() {
        this.checkThread();
        try {
            return this.cache.getSegmentHeaders();
        }
        catch (Throwable t) {
            LOGGER.error((Object)"Failed to get a list of segment headers.", t);
            throw MondrianResource.instance().SegmentCacheFailedToScanSegments.ex(t);
        }
    }

    public boolean supportsRichIndex() {
        return this.supportsRichIndex;
    }

    public void shutdown() {
        this.checkThread();
        this.cache.tearDown();
    }

    private void checkThread() {
        assert (this.cacheMgrThread != Thread.currentThread()) : "this method is potentially slow; you should not call it from the cache manager thread, " + this.cacheMgrThread;
    }
}

