/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap.agg;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import mondrian.olap.MondrianException;
import mondrian.olap.MondrianProperties;
import mondrian.olap.Util;
import mondrian.resource.MondrianResource;
import mondrian.rolap.BitKey;
import mondrian.rolap.RolapStar;
import mondrian.rolap.RolapUtil;
import mondrian.rolap.SqlStatement;
import mondrian.rolap.StarPredicate;
import mondrian.rolap.agg.AggregationManager;
import mondrian.rolap.agg.GroupingSet;
import mondrian.rolap.agg.GroupingSetsList;
import mondrian.rolap.agg.Segment;
import mondrian.rolap.agg.SegmentAxis;
import mondrian.rolap.agg.SegmentBuilder;
import mondrian.rolap.agg.SegmentCacheManager;
import mondrian.rolap.agg.SegmentDataset;
import mondrian.rolap.agg.SegmentWithData;
import mondrian.rolap.cache.SegmentCacheIndex;
import mondrian.server.Locus;
import mondrian.server.monitor.SqlStatementEvent;
import mondrian.spi.SegmentBody;
import mondrian.spi.SegmentColumn;
import mondrian.spi.SegmentHeader;
import mondrian.util.Pair;
import org.apache.log4j.Logger;

public class SegmentLoader {
    private static final Logger LOGGER = Logger.getLogger(SegmentLoader.class);
    private final SegmentCacheManager cacheMgr;

    public SegmentLoader(SegmentCacheManager cacheMgr) {
        this.cacheMgr = cacheMgr;
    }

    public void load(int cellRequestCount, List<GroupingSet> groupingSets, List<StarPredicate> compoundPredicateList, List<Future<Map<Segment, SegmentWithData>>> segmentFutures) {
        if (!MondrianProperties.instance().DisableCaching.get()) {
            for (GroupingSet groupingSet : groupingSets) {
                for (Segment segment : groupingSet.getSegments()) {
                    SegmentCacheIndex index = this.cacheMgr.getIndexRegistry().getIndex(segment.star);
                    index.add(segment.getHeader(), true, new SegmentBuilder.StarSegmentConverter(segment.measure, compoundPredicateList));
                }
            }
        }
        try {
            segmentFutures.add(this.cacheMgr.sqlExecutor.submit(new SegmentLoadCommand(Locus.peek(), this, cellRequestCount, groupingSets, compoundPredicateList)));
        }
        catch (Exception e) {
            throw new MondrianException(e);
        }
    }

    private Map<Segment, SegmentWithData> loadImpl(int cellRequestCount, List<GroupingSet> groupingSets, List<StarPredicate> compoundPredicateList) {
        Locus.peek().execution.checkCancelOrTimeout();
        SqlStatement stmt = null;
        GroupingSetsList groupingSetsList = new GroupingSetsList(groupingSets);
        RolapStar.Column[] defaultColumns = groupingSetsList.getDefaultColumns();
        HashMap<Segment, SegmentWithData> segmentMap = new HashMap<Segment, SegmentWithData>();
        Throwable throwable = null;
        try {
            int arity = defaultColumns.length;
            SortedSet<Comparable>[] axisValueSets = this.getDistinctValueWorkspace(arity);
            stmt = this.createExecuteSql(cellRequestCount, groupingSetsList, compoundPredicateList);
            boolean[] axisContainsNull = new boolean[arity];
            RowList rows = this.processData(stmt, axisContainsNull, axisValueSets, groupingSetsList);
            boolean sparse = this.setAxisDataAndDecideSparseUse(axisValueSets, axisContainsNull, groupingSetsList, rows);
            Map<BitKey, GroupingSetsList.Cohort> groupingDataSetsMap = this.createDataSetsForGroupingSets(groupingSetsList, sparse, rows.getTypes().subList(arity, rows.getTypes().size()));
            this.loadDataToDataSets(groupingSetsList, rows, groupingDataSetsMap);
            this.setDataToSegments(groupingSetsList, groupingDataSetsMap, segmentMap);
            HashMap<Segment, SegmentWithData> hashMap = segmentMap;
            return hashMap;
        }
        catch (RuntimeException e) {
            throwable = e;
            throw e;
        }
        catch (Error e) {
            throwable = e;
            throw e;
        }
        catch (Throwable e) {
            throwable = e;
            if (stmt == null) {
                throw new MondrianException(e);
            }
            throw stmt.handle(e);
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
            this.setFailOnStillLoadingSegments(segmentMap, groupingSetsList, throwable);
        }
    }

    private void cacheSegment(RolapStar star, SegmentHeader header, SegmentBody body) {
        if (!MondrianProperties.instance().DisableCaching.get()) {
            this.cacheMgr.compositeCache.put(header, body);
            this.cacheMgr.loadSucceeded(star, header, body);
        }
    }

    private boolean setFailOnStillLoadingSegments(Map<Segment, SegmentWithData> segmentMap, GroupingSetsList groupingSetsList, Throwable throwable) {
        int n = 0;
        for (GroupingSet groupingSet : groupingSetsList.getGroupingSets()) {
            for (Segment segment : groupingSet.getSegments()) {
                if (segmentMap.containsKey(segment)) continue;
                if (throwable == null) {
                    throwable = new RuntimeException("Segment failed to load");
                }
                SegmentHeader header = segment.getHeader();
                this.cacheMgr.loadFailed(segment.star, header, throwable);
                ++n;
            }
        }
        return n > 0;
    }

    private void loadDataToDataSets(GroupingSetsList groupingSetsList, RowList rows, Map<BitKey, GroupingSetsList.Cohort> groupingDataSetMap) {
        int arity = groupingSetsList.getDefaultColumns().length;
        SegmentAxis[] axes = groupingSetsList.getDefaultAxes();
        int segmentLength = groupingSetsList.getDefaultSegments().size();
        List<SqlStatement.Type> types = rows.getTypes();
        boolean useGroupingSet = groupingSetsList.useGroupingSets();
        rows.first();
        while (rows.next()) {
            GroupingSetsList.Cohort cohort;
            BitKey groupingBitKey;
            if (useGroupingSet) {
                groupingBitKey = (BitKey)rows.getObject(groupingSetsList.getGroupingBitKeyIndex());
                cohort = groupingDataSetMap.get(groupingBitKey);
            } else {
                groupingBitKey = null;
                cohort = groupingDataSetMap.get(BitKey.EMPTY);
            }
            int[] pos = cohort.pos;
            int j = 0;
            int k = 0;
            while (j < arity) {
                SqlStatement.Type type = types.get(j);
                switch (type) {
                    case OBJECT: 
                    case DOUBLE: 
                    case INT: 
                    case LONG: 
                    case STRING: {
                        Comparable<?> o = rows.getObject(j);
                        if (useGroupingSet && (o == null || o == RolapUtil.sqlNullValue) && groupingBitKey.get(groupingSetsList.findGroupingFunctionIndex(j))) break;
                        SegmentAxis axis = axes[j];
                        if (o == null) {
                            o = RolapUtil.sqlNullValue;
                        }
                        int offset = axis.getOffset(o);
                        pos[k++] = offset;
                        break;
                    }
                    default: {
                        throw Util.unexpected(type);
                    }
                }
                ++j;
            }
            j = 0;
            while (j < segmentLength) {
                cohort.segmentDatasetList.get(j).populateFrom(pos, rows, arity + j);
                ++j;
            }
        }
    }

    private boolean setAxisDataAndDecideSparseUse(SortedSet<Comparable>[] axisValueSets, boolean[] axisContainsNull, GroupingSetsList groupingSetsList, RowList rows) {
        SegmentAxis[] axes = groupingSetsList.getDefaultAxes();
        RolapStar.Column[] allColumns = groupingSetsList.getDefaultColumns();
        boolean sparse = false;
        int n = 1;
        int i = 0;
        while (i < axes.length) {
            SortedSet<Comparable> valueSet = axisValueSets[i];
            axes[i] = new SegmentAxis(groupingSetsList.getDefaultPredicates()[i], valueSet, axisContainsNull[i]);
            int size = axes[i].getKeys().length;
            this.setAxisDataToGroupableList(groupingSetsList, valueSet, axisContainsNull[i], allColumns[i]);
            int previous = n;
            if ((n *= size) < previous || n < size) {
                n = Integer.MAX_VALUE;
                sparse = true;
            }
            ++i;
        }
        return this.useSparse(sparse, n, rows);
    }

    boolean useSparse(boolean sparse, int n, RowList rows) {
        sparse = sparse || SegmentLoader.useSparse(n, rows.size());
        return sparse;
    }

    private void setDataToSegments(GroupingSetsList groupingSetsList, Map<BitKey, GroupingSetsList.Cohort> datasetsMap, Map<Segment, SegmentWithData> segmentSlotMap) {
        List<GroupingSet> groupingSets = groupingSetsList.getGroupingSets();
        int i = 0;
        while (i < groupingSets.size()) {
            List<Segment> segments = groupingSets.get(i).getSegments();
            GroupingSetsList.Cohort cohort = datasetsMap.get(groupingSetsList.getRollupColumnsBitKeyList().get(i));
            int j = 0;
            while (j < segments.size()) {
                Segment segment = segments.get(j);
                SegmentDataset segmentDataset = cohort.segmentDatasetList.get(j);
                final SegmentWithData segmentWithData = new SegmentWithData(segment, segmentDataset, cohort.axes);
                segmentSlotMap.put(segment, segmentWithData);
                SegmentHeader header = segmentWithData.getHeader();
                SegmentBody body = segmentWithData.getData().createSegmentBody((List<Pair<SortedSet<Comparable>, Boolean>>)new AbstractList<Pair<SortedSet<Comparable>, Boolean>>(){

                    @Override
                    public Pair<SortedSet<Comparable>, Boolean> get(int index) {
                        return segmentWithData.axes[index].getValuesAndIndicator();
                    }

                    @Override
                    public int size() {
                        return segmentWithData.axes.length;
                    }
                });
                this.cacheSegment(segment.star, header, body);
                ++j;
            }
            ++i;
        }
    }

    private Map<BitKey, GroupingSetsList.Cohort> createDataSetsForGroupingSets(GroupingSetsList groupingSetsList, boolean sparse, List<SqlStatement.Type> types) {
        if (!groupingSetsList.useGroupingSets()) {
            GroupingSetsList.Cohort datasets = this.createDataSets(sparse, groupingSetsList.getDefaultSegments(), groupingSetsList.getDefaultAxes(), types);
            return Collections.singletonMap(BitKey.EMPTY, datasets);
        }
        HashMap<BitKey, GroupingSetsList.Cohort> datasetsMap = new HashMap<BitKey, GroupingSetsList.Cohort>();
        List<GroupingSet> groupingSets = groupingSetsList.getGroupingSets();
        List<BitKey> groupingColumnsBitKeyList = groupingSetsList.getRollupColumnsBitKeyList();
        int i = 0;
        while (i < groupingSets.size()) {
            GroupingSet groupingSet = groupingSets.get(i);
            GroupingSetsList.Cohort cohort = this.createDataSets(sparse, groupingSet.getSegments(), groupingSet.getAxes(), types);
            datasetsMap.put(groupingColumnsBitKeyList.get(i), cohort);
            ++i;
        }
        return datasetsMap;
    }

    private int calculateMaxDataSize(SegmentAxis[] axes) {
        int n = 1;
        SegmentAxis[] segmentAxisArray = axes;
        int n2 = axes.length;
        int n3 = 0;
        while (n3 < n2) {
            SegmentAxis axis = segmentAxisArray[n3];
            n *= axis.getKeys().length;
            ++n3;
        }
        return n;
    }

    private GroupingSetsList.Cohort createDataSets(boolean sparse, List<Segment> segments, SegmentAxis[] axes, List<SqlStatement.Type> types) {
        ArrayList<SegmentDataset> datasets = new ArrayList<SegmentDataset>(segments.size());
        int n = sparse ? 0 : this.calculateMaxDataSize(axes);
        int i = 0;
        while (i < segments.size()) {
            Segment segment = segments.get(i);
            datasets.add(segment.createDataset(axes, sparse, types.get(i), n));
            ++i;
        }
        return new GroupingSetsList.Cohort(datasets, axes);
    }

    private void setAxisDataToGroupableList(GroupingSetsList groupingSetsList, SortedSet<Comparable> valueSet, boolean axisContainsNull, RolapStar.Column column) {
        for (GroupingSet groupingSet : groupingSetsList.getRollupGroupingSets()) {
            RolapStar.Column[] columns = groupingSet.getColumns();
            int i = 0;
            while (i < columns.length) {
                if (columns[i].equals(column)) {
                    groupingSet.getAxes()[i] = new SegmentAxis(groupingSet.getPredicates()[i], valueSet, axisContainsNull);
                }
                ++i;
            }
        }
    }

    SqlStatement createExecuteSql(int cellRequestCount, GroupingSetsList groupingSetsList, List<StarPredicate> compoundPredicateList) {
        RolapStar star = groupingSetsList.getStar();
        Pair<String, List<SqlStatement.Type>> pair = AggregationManager.generateSql(groupingSetsList, compoundPredicateList);
        return RolapUtil.executeQuery(star.getDataSource(), (String)pair.left, (List)pair.right, 0, 0, new SqlStatement.StatementLocus(Locus.peek().execution, "Segment.load", "Error while loading segment", SqlStatementEvent.Purpose.CELL_SEGMENT, cellRequestCount), -1, -1);
    }

    RowList processData(SqlStatement stmt, boolean[] axisContainsNull, SortedSet<Comparable>[] axisValueSets, GroupingSetsList groupingSetsList) throws SQLException {
        List<SqlStatement.Type> processedTypes;
        List<Segment> segments = groupingSetsList.getDefaultSegments();
        int measureCount = segments.size();
        ResultSet rawRows = this.loadData(stmt, groupingSetsList);
        assert (stmt != null);
        List<SqlStatement.Type> types = stmt.guessTypes();
        int arity = axisValueSets.length;
        int groupingColumnStartIndex = arity + measureCount;
        if (groupingSetsList.useGroupingSets()) {
            processedTypes = new ArrayList<SqlStatement.Type>(types.subList(0, groupingColumnStartIndex));
            processedTypes.add(SqlStatement.Type.OBJECT);
        } else {
            processedTypes = types;
        }
        RowList processedRows = new RowList(processedTypes, 100);
        while (rawRows.next()) {
            this.checkResultLimit(++stmt.rowCount);
            processedRows.createRow();
            int columnIndex = 0;
            int axisIndex = 0;
            while (axisIndex < arity) {
                SqlStatement.Type type = types.get(columnIndex);
                switch (type) {
                    case OBJECT: 
                    case STRING: {
                        Comparable<?> o = rawRows.getObject(columnIndex + 1);
                        if (o == null) {
                            o = RolapUtil.sqlNullValue;
                            if (!groupingSetsList.useGroupingSets() || !this.isAggregateNull(rawRows, groupingColumnStartIndex, groupingSetsList, axisIndex)) {
                                axisContainsNull[axisIndex] = true;
                            }
                        } else {
                            axisValueSets[axisIndex].add(o);
                        }
                        processedRows.setObject(columnIndex, o);
                        break;
                    }
                    case INT: {
                        int intValue = rawRows.getInt(columnIndex + 1);
                        if (intValue == 0 && rawRows.wasNull()) {
                            if (!groupingSetsList.useGroupingSets() || !this.isAggregateNull(rawRows, groupingColumnStartIndex, groupingSetsList, axisIndex)) {
                                axisContainsNull[axisIndex] = true;
                            }
                            processedRows.setNull(columnIndex, true);
                            break;
                        }
                        axisValueSets[axisIndex].add(Integer.valueOf(intValue));
                        processedRows.setInt(columnIndex, intValue);
                        break;
                    }
                    case LONG: {
                        long longValue = rawRows.getLong(columnIndex + 1);
                        if (longValue == 0L && rawRows.wasNull()) {
                            if (!groupingSetsList.useGroupingSets() || !this.isAggregateNull(rawRows, groupingColumnStartIndex, groupingSetsList, axisIndex)) {
                                axisContainsNull[axisIndex] = true;
                            }
                            processedRows.setNull(columnIndex, true);
                            break;
                        }
                        axisValueSets[axisIndex].add(Long.valueOf(longValue));
                        processedRows.setLong(columnIndex, longValue);
                        break;
                    }
                    case DOUBLE: {
                        double doubleValue = Double.parseDouble(rawRows.getObject(columnIndex + 1).toString());
                        if (!(doubleValue != 0.0 || !rawRows.wasNull() || groupingSetsList.useGroupingSets() && this.isAggregateNull(rawRows, groupingColumnStartIndex, groupingSetsList, axisIndex))) {
                            axisContainsNull[axisIndex] = true;
                        }
                        axisValueSets[axisIndex].add(Double.valueOf(doubleValue));
                        processedRows.setDouble(columnIndex, doubleValue);
                        break;
                    }
                    default: {
                        throw Util.unexpected(type);
                    }
                }
                ++axisIndex;
                ++columnIndex;
            }
            boolean[] numeric = new boolean[measureCount];
            int k = 0;
            for (Segment segment : segments) {
                numeric[k++] = segment.measure.getDatatype().isNumeric();
            }
            int i = 0;
            while (i < measureCount) {
                SqlStatement.Type type = types.get(columnIndex);
                switch (type) {
                    case OBJECT: 
                    case STRING: {
                        Object o = rawRows.getObject(columnIndex + 1);
                        if (o == null) {
                            o = Util.nullValue;
                        } else if (numeric[i] && !(o instanceof Double)) {
                            o = o instanceof Number ? Double.valueOf(((Number)o).doubleValue()) : (o instanceof byte[] ? Double.valueOf(Double.parseDouble(new String((byte[])o))) : Double.valueOf(Double.parseDouble(o.toString())));
                        }
                        processedRows.setObject(columnIndex, o);
                        break;
                    }
                    case INT: {
                        int intValue = rawRows.getInt(columnIndex + 1);
                        processedRows.setInt(columnIndex, intValue);
                        if (intValue != 0 || !rawRows.wasNull()) break;
                        processedRows.setNull(columnIndex, true);
                        break;
                    }
                    case LONG: {
                        long longValue = rawRows.getLong(columnIndex + 1);
                        processedRows.setLong(columnIndex, longValue);
                        if (longValue != 0L || !rawRows.wasNull()) break;
                        processedRows.setNull(columnIndex, true);
                        break;
                    }
                    case DOUBLE: {
                        String val = null;
                        try {
                            val = rawRows.getObject(columnIndex + 1).toString();
                        }
                        catch (Exception e) {
                            val = "0";
                        }
                        double doubleValue = Double.parseDouble(val);
                        processedRows.setDouble(columnIndex, doubleValue);
                        if (doubleValue != 0.0 || !rawRows.wasNull()) break;
                        processedRows.setNull(columnIndex, true);
                        break;
                    }
                    default: {
                        throw Util.unexpected(type);
                    }
                }
                ++i;
                ++columnIndex;
            }
            if (!groupingSetsList.useGroupingSets()) continue;
            processedRows.setObject(columnIndex, this.getRollupBitKey(groupingSetsList.getRollupColumns().size(), rawRows, columnIndex));
        }
        return processedRows;
    }

    private void checkResultLimit(int currentCount) {
        int limit = MondrianProperties.instance().ResultLimit.get();
        if (limit > 0 && currentCount > limit) {
            throw MondrianResource.instance().SegmentFetchLimitExceeded.ex(limit);
        }
    }

    BitKey getRollupBitKey(int arity, ResultSet rowList, int k) throws SQLException {
        BitKey groupingBitKey = BitKey.Factory.makeBitKey(arity);
        int i = 0;
        while (i < arity) {
            int o = rowList.getInt(k + i + 1);
            if (o == 1) {
                groupingBitKey.set(i);
            }
            ++i;
        }
        return groupingBitKey;
    }

    private boolean isAggregateNull(ResultSet rowList, int groupingColumnStartIndex, GroupingSetsList groupingSetsList, int axisIndex) throws SQLException {
        int groupingFunctionIndex = groupingSetsList.findGroupingFunctionIndex(axisIndex);
        if (groupingFunctionIndex == -1) {
            return false;
        }
        return rowList.getInt(groupingColumnStartIndex + groupingFunctionIndex + 1) == 1;
    }

    ResultSet loadData(SqlStatement stmt, GroupingSetsList groupingSetsList) throws SQLException {
        int arity = groupingSetsList.getDefaultColumns().length;
        int measureCount = groupingSetsList.getDefaultSegments().size();
        int groupingFunctionsCount = groupingSetsList.getRollupColumns().size();
        List<SqlStatement.Type> types = stmt.guessTypes();
        assert (arity + measureCount + groupingFunctionsCount == types.size());
        return stmt.getResultSet();
    }

    SortedSet<Comparable>[] getDistinctValueWorkspace(int arity) {
        SortedSet[] axisValueSets = new SortedSet[arity];
        int i = 0;
        while (i < axisValueSets.length) {
            axisValueSets[i] = Util.PreJdk15 ? new TreeSet<Object>(BooleanComparator.INSTANCE) : new TreeSet();
            ++i;
        }
        return axisValueSets;
    }

    static boolean useSparse(double possibleCount, double actualCount) {
        boolean sparse;
        int countThreshold;
        MondrianProperties properties = MondrianProperties.instance();
        double densityThreshold = properties.SparseSegmentDensityThreshold.get();
        if (densityThreshold < 0.0) {
            densityThreshold = 0.0;
        }
        if (densityThreshold > 1.0) {
            densityThreshold = 1.0;
        }
        if ((countThreshold = properties.SparseSegmentCountThreshold.get()) < 0) {
            countThreshold = 0;
        }
        boolean bl = sparse = (possibleCount - (double)countThreshold) * densityThreshold > actualCount;
        if (possibleCount < (double)countThreshold) assert (!sparse) : "Should never use sparse if count is less than threshold, possibleCount=" + possibleCount + ", actualCount=" + actualCount + ", countThreshold=" + countThreshold + ", densityThreshold=" + densityThreshold;
        if (possibleCount == actualCount) assert (!sparse) : "Should never use sparse if result is 100% dense: possibleCount=" + possibleCount + ", actualCount=" + actualCount + ", countThreshold=" + countThreshold + ", densityThreshold=" + densityThreshold;
        return sparse;
    }

    private static class BooleanComparator
    implements Comparator<Object>,
    Serializable {
        public static final BooleanComparator INSTANCE = new BooleanComparator();

        private BooleanComparator() {
            if (Util.PreJdk15 ? !$assertionsDisabled && Comparable.class.isAssignableFrom(Boolean.class) : !$assertionsDisabled && !Comparable.class.isAssignableFrom(Boolean.class)) {
                throw new AssertionError();
            }
        }

        @Override
        public int compare(Object o1, Object o2) {
            if (o1 instanceof Boolean) {
                boolean b1 = (Boolean)o1;
                if (o2 instanceof Boolean) {
                    boolean b2 = (Boolean)o2;
                    return b1 == b2 ? 0 : (b1 ? 1 : -1);
                }
                return -1;
            }
            return ((Comparable)o1).compareTo(o2);
        }
    }

    protected static class RowList {
        private final Column[] columns;
        private int rowCount = 0;
        private int capacity = 0;
        private int currentRow = -1;

        RowList(List<SqlStatement.Type> types) {
            this(types, 100);
        }

        RowList(List<SqlStatement.Type> types, int capacity) {
            this.columns = new Column[types.size()];
            this.capacity = capacity;
            int i = 0;
            while (i < this.columns.length) {
                this.columns[i] = Column.forType(i, types.get(i), capacity);
                ++i;
            }
        }

        void createRow() {
            this.currentRow = this.rowCount++;
            if (this.rowCount > this.capacity) {
                this.capacity *= 3;
                Column[] columnArray = this.columns;
                int n = this.columns.length;
                int n2 = 0;
                while (n2 < n) {
                    Column column = columnArray[n2];
                    column.resize(this.capacity);
                    ++n2;
                }
            }
        }

        void setObject(int column, Object value) {
            this.columns[column].setObject(this.currentRow, value);
        }

        void setDouble(int column, double value) {
            this.columns[column].setDouble(this.currentRow, value);
        }

        void setInt(int column, int value) {
            this.columns[column].setInt(this.currentRow, value);
        }

        void setLong(int column, long value) {
            this.columns[column].setLong(this.currentRow, value);
        }

        public int size() {
            return this.rowCount;
        }

        public void createRow(ResultSet resultSet) throws SQLException {
            this.createRow();
            Column[] columnArray = this.columns;
            int n = this.columns.length;
            int n2 = 0;
            while (n2 < n) {
                Column column = columnArray[n2];
                column.populateFrom(this.currentRow, resultSet);
                ++n2;
            }
        }

        public List<SqlStatement.Type> getTypes() {
            return new AbstractList<SqlStatement.Type>(){

                @Override
                public SqlStatement.Type get(int index) {
                    return ((RowList)RowList.this).columns[index].type;
                }

                @Override
                public int size() {
                    return RowList.this.columns.length;
                }
            };
        }

        public void first() {
            this.currentRow = -1;
        }

        public void last() {
            this.currentRow = this.rowCount;
        }

        public boolean next() {
            if (this.currentRow < this.rowCount - 1) {
                ++this.currentRow;
                return true;
            }
            return false;
        }

        public boolean previous() {
            if (this.currentRow > 0) {
                --this.currentRow;
                return true;
            }
            return false;
        }

        public Object getObject(int columnIndex) {
            return this.columns[columnIndex].getObject(this.currentRow);
        }

        public int getInt(int columnIndex) {
            return this.columns[columnIndex].getInt(this.currentRow);
        }

        public double getDouble(int columnIndex) {
            return this.columns[columnIndex].getDouble(this.currentRow);
        }

        public boolean isNull(int columnIndex) {
            return this.columns[columnIndex].isNull(this.currentRow);
        }

        public void setNull(int columnIndex, boolean b) {
            this.columns[columnIndex].setNull(this.currentRow, b);
        }

        static abstract class Column {
            final int ordinal;
            final SqlStatement.Type type;

            protected Column(int ordinal, SqlStatement.Type type) {
                this.ordinal = ordinal;
                this.type = type;
            }

            static Column forType(int ordinal, SqlStatement.Type type, int capacity) {
                switch (type) {
                    case OBJECT: 
                    case STRING: {
                        return new ObjectColumn(ordinal, type, capacity);
                    }
                    case INT: {
                        return new IntColumn(ordinal, type, capacity);
                    }
                    case LONG: {
                        return new LongColumn(ordinal, type, capacity);
                    }
                    case DOUBLE: {
                        return new DoubleColumn(ordinal, type, capacity);
                    }
                }
                throw Util.unexpected(type);
            }

            public abstract void resize(int var1);

            public void setObject(int row, Object value) {
                throw new UnsupportedOperationException();
            }

            public void setDouble(int row, double value) {
                throw new UnsupportedOperationException();
            }

            public void setInt(int row, int value) {
                throw new UnsupportedOperationException();
            }

            public void setLong(int row, long value) {
                throw new UnsupportedOperationException();
            }

            public void setNull(int row, boolean b) {
                throw new UnsupportedOperationException();
            }

            public abstract void populateFrom(int var1, ResultSet var2) throws SQLException;

            public Object getObject(int row) {
                throw new UnsupportedOperationException();
            }

            public int getInt(int row) {
                throw new UnsupportedOperationException();
            }

            public double getDouble(int row) {
                throw new UnsupportedOperationException();
            }

            protected abstract int getCapacity();

            public abstract boolean isNull(int var1);
        }

        static class DoubleColumn
        extends NativeColumn {
            private double[] doubles;

            DoubleColumn(int ordinal, SqlStatement.Type type, int size) {
                super(ordinal, type);
                this.doubles = new double[size];
            }

            @Override
            public void resize(int newSize) {
                this.doubles = Util.copyOf(this.doubles, newSize);
            }

            @Override
            public void populateFrom(int row, ResultSet resultSet) throws SQLException {
                this.doubles[row] = resultSet.getDouble(this.ordinal + 1);
                double d = this.doubles[row];
                if (d == 0.0) {
                    this.getNullIndicators().set(row, resultSet.wasNull());
                }
            }

            @Override
            public void setDouble(int row, double value) {
                this.doubles[row] = value;
            }

            @Override
            public double getDouble(int row) {
                return this.doubles[row];
            }

            @Override
            protected int getCapacity() {
                return this.doubles.length;
            }

            @Override
            public boolean isNull(int row) {
                return this.doubles[row] == 0.0 && this.nullIndicators != null && this.nullIndicators.get(row);
            }

            @Override
            public Double getObject(int row) {
                return this.isNull(row) ? null : Double.valueOf(this.doubles[row]);
            }
        }

        public static interface Handler {
        }

        static class IntColumn
        extends NativeColumn {
            private int[] ints;

            IntColumn(int ordinal, SqlStatement.Type type, int size) {
                super(ordinal, type);
                this.ints = new int[size];
            }

            @Override
            public void resize(int newSize) {
                this.ints = Util.copyOf(this.ints, newSize);
            }

            @Override
            public void populateFrom(int row, ResultSet resultSet) throws SQLException {
                this.ints[row] = resultSet.getInt(this.ordinal + 1);
                int i = this.ints[row];
                if (i == 0) {
                    this.getNullIndicators().set(row, resultSet.wasNull());
                }
            }

            @Override
            public void setInt(int row, int value) {
                this.ints[row] = value;
            }

            @Override
            public int getInt(int row) {
                return this.ints[row];
            }

            @Override
            public boolean isNull(int row) {
                return this.ints[row] == 0 && this.nullIndicators != null && this.nullIndicators.get(row);
            }

            @Override
            protected int getCapacity() {
                return this.ints.length;
            }

            @Override
            public Integer getObject(int row) {
                return this.isNull(row) ? null : Integer.valueOf(this.ints[row]);
            }
        }

        static class LongColumn
        extends NativeColumn {
            private long[] longs;

            LongColumn(int ordinal, SqlStatement.Type type, int size) {
                super(ordinal, type);
                this.longs = new long[size];
            }

            @Override
            public void resize(int newSize) {
                this.longs = Util.copyOf(this.longs, newSize);
            }

            @Override
            public void populateFrom(int row, ResultSet resultSet) throws SQLException {
                this.longs[row] = resultSet.getLong(this.ordinal + 1);
                long i = this.longs[row];
                if (i == 0L) {
                    this.getNullIndicators().set(row, resultSet.wasNull());
                }
            }

            @Override
            public void setLong(int row, long value) {
                this.longs[row] = value;
            }

            public long getLong(int row) {
                return this.longs[row];
            }

            @Override
            public boolean isNull(int row) {
                return this.longs[row] == 0L && this.nullIndicators != null && this.nullIndicators.get(row);
            }

            @Override
            protected int getCapacity() {
                return this.longs.length;
            }

            @Override
            public Long getObject(int row) {
                return this.isNull(row) ? null : Long.valueOf(this.longs[row]);
            }
        }

        static abstract class NativeColumn
        extends Column {
            protected BitSet nullIndicators;

            NativeColumn(int ordinal, SqlStatement.Type type) {
                super(ordinal, type);
            }

            @Override
            public void setNull(int row, boolean b) {
                this.getNullIndicators().set(row, b);
            }

            protected BitSet getNullIndicators() {
                if (this.nullIndicators == null) {
                    this.nullIndicators = new BitSet(this.getCapacity());
                }
                return this.nullIndicators;
            }
        }

        static class ObjectColumn
        extends Column {
            private Object[] objects;

            ObjectColumn(int ordinal, SqlStatement.Type type, int size) {
                super(ordinal, type);
                this.objects = new Object[size];
            }

            @Override
            protected int getCapacity() {
                return this.objects.length;
            }

            @Override
            public boolean isNull(int row) {
                return this.objects[row] == null;
            }

            @Override
            public void resize(int newSize) {
                this.objects = Util.copyOf(this.objects, newSize);
            }

            @Override
            public void populateFrom(int row, ResultSet resultSet) throws SQLException {
                this.objects[row] = resultSet.getObject(this.ordinal + 1);
            }

            @Override
            public void setObject(int row, Object value) {
                this.objects[row] = value;
            }

            @Override
            public Object getObject(int row) {
                return this.objects[row];
            }
        }
    }

    private static class SegmentLoadCommand
    implements Callable<Map<Segment, SegmentWithData>> {
        private final Locus locus;
        private final SegmentLoader segmentLoader;
        private final int cellRequestCount;
        private final List<GroupingSet> groupingSets;
        private final List<StarPredicate> compoundPredicateList;

        public SegmentLoadCommand(Locus locus, SegmentLoader segmentLoader, int cellRequestCount, List<GroupingSet> groupingSets, List<StarPredicate> compoundPredicateList) {
            this.locus = locus;
            this.segmentLoader = segmentLoader;
            this.cellRequestCount = cellRequestCount;
            this.groupingSets = groupingSets;
            this.compoundPredicateList = compoundPredicateList;
        }

        @Override
        public Map<Segment, SegmentWithData> call() throws Exception {
            Locus.push(this.locus);
            try {
                Map map = this.segmentLoader.loadImpl(this.cellRequestCount, this.groupingSets, this.compoundPredicateList);
                return map;
            }
            finally {
                Locus.pop(this.locus);
            }
        }
    }

    abstract class SegmentRollupWrapper {
        SegmentRollupWrapper() {
        }

        abstract BitKey getConstrainedColumnsBitKey();

        abstract SegmentColumn[] getConstrainedColumns();

        abstract SegmentDataset getDataset();

        abstract Object[] getValuesForColumn(SegmentColumn var1);

        abstract SegmentColumn getHeader();

        public int hashCode() {
            return this.getHeader().hashCode();
        }

        public boolean equals(Object obj) {
            return this.getHeader().equals(obj);
        }
    }
}

