/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap.aggmatcher;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import mondrian.olap.Hierarchy;
import mondrian.olap.Id;
import mondrian.olap.Level;
import mondrian.olap.Util;
import mondrian.recorder.MessageRecorder;
import mondrian.rolap.HierarchyUsage;
import mondrian.rolap.RolapAggregator;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapLevel;
import mondrian.rolap.RolapStar;
import mondrian.rolap.aggmatcher.ExplicitRules;
import mondrian.rolap.aggmatcher.JdbcSchema;
import mondrian.rolap.aggmatcher.Recognizer;
import mondrian.util.Pair;

class ExplicitRecognizer
extends Recognizer {
    private ExplicitRules.TableDef tableDef;
    private RolapCube cube;

    ExplicitRecognizer(ExplicitRules.TableDef tableDef, RolapStar star, RolapCube cube, JdbcSchema.Table dbFactTable, JdbcSchema.Table aggTable, MessageRecorder msgRecorder) {
        super(star, dbFactTable, aggTable, msgRecorder);
        this.tableDef = tableDef;
        this.cube = cube;
    }

    protected ExplicitRules.TableDef getTableDef() {
        return this.tableDef;
    }

    @Override
    protected Recognizer.Matcher getIgnoreMatcher() {
        return this.getTableDef().getIgnoreMatcher();
    }

    @Override
    protected Recognizer.Matcher getFactCountMatcher() {
        return this.getTableDef().getFactCountMatcher();
    }

    @Override
    protected int checkMeasures() {
        this.msgRecorder.pushContextName("ExplicitRecognizer.checkMeasures");
        try {
            int measureColumnCounts = 0;
            for (JdbcSchema.Table.Column aggColumn : this.aggTable.getColumns()) {
                if (aggColumn.hasUsage(JdbcSchema.UsageType.IGNORE)) continue;
                String aggColumnName = aggColumn.getName();
                for (ExplicitRules.TableDef.Measure measure : this.getTableDef().getMeasures()) {
                    if (!measure.getColumnName().equalsIgnoreCase(aggColumnName)) continue;
                    String name = measure.getName();
                    List<Id.Segment> parts = Util.parseIdentifier(name);
                    Id.Segment nameLast = Util.last(parts);
                    RolapStar.Measure m = null;
                    if (nameLast instanceof Id.NameSegment) {
                        m = this.star.getFactTable().lookupMeasureByName(this.cube.getName(), ((Id.NameSegment)nameLast).name);
                    }
                    RolapAggregator agg = null;
                    if (m != null) {
                        agg = m.getAggregator();
                    }
                    this.makeMeasure(measure, agg, aggColumn);
                    ++measureColumnCounts;
                }
            }
            Iterator<JdbcSchema.Table.Column.Usage> it = this.dbFactTable.getColumnUsages(JdbcSchema.UsageType.MEASURE);
            while (it.hasNext()) {
                String aggFK;
                JdbcSchema.Table.Column.Usage factUsage = it.next();
                JdbcSchema.Table.Column factColumn = factUsage.getColumn();
                if (!factColumn.hasUsage(JdbcSchema.UsageType.FOREIGN_KEY) || (aggFK = this.getTableDef().getAggregateFK(factColumn.getName())) == null) continue;
                JdbcSchema.Table.Column aggColumn = this.aggTable.getColumn(aggFK);
                if (aggColumn == null) {
                    aggColumn = this.aggTable.getColumn(aggFK.toLowerCase());
                }
                if (aggColumn == null) {
                    aggColumn = this.aggTable.getColumn(aggFK.toUpperCase());
                }
                if (aggColumn == null) continue;
                this.makeMeasure(factUsage, aggColumn);
                ++measureColumnCounts;
            }
            int n = measureColumnCounts;
            return n;
        }
        finally {
            this.msgRecorder.popContextName();
        }
    }

    protected void makeMeasure(ExplicitRules.TableDef.Measure measure, RolapAggregator factAgg, JdbcSchema.Table.Column aggColumn) {
        RolapStar.Measure rm = measure.getRolapStarMeasure();
        JdbcSchema.Table.Column.Usage aggUsage = aggColumn.newUsage(JdbcSchema.UsageType.MEASURE);
        aggUsage.setSymbolicName(measure.getSymbolicName());
        RolapAggregator ra = factAgg == null ? this.convertAggregator(aggUsage, rm.getAggregator()) : this.convertAggregator(aggUsage, factAgg, rm.getAggregator());
        aggUsage.setAggregator(ra);
        aggUsage.rMeasure = rm;
    }

    @Override
    protected int matchForeignKey(JdbcSchema.Table.Column.Usage factUsage) {
        JdbcSchema.Table.Column factColumn = factUsage.getColumn();
        String aggFK = this.getTableDef().getAggregateFK(factColumn.getName());
        if (aggFK == null) {
            return 0;
        }
        int matchCount = 0;
        for (JdbcSchema.Table.Column aggColumn : this.aggTable.getColumns()) {
            if (aggColumn.hasUsage(JdbcSchema.UsageType.IGNORE) || !aggFK.equals(aggColumn.getName())) continue;
            this.makeForeignKey(factUsage, aggColumn, aggFK);
            ++matchCount;
        }
        return matchCount;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void matchLevels(Hierarchy hierarchy, HierarchyUsage hierarchyUsage) {
        this.msgRecorder.pushContextName("ExplicitRecognizer.matchLevel");
        try {
            void var6_9;
            ArrayList<Pair<RolapLevel, JdbcSchema.Table.Column>> levelMatches = new ArrayList<Pair<RolapLevel, JdbcSchema.Table.Column>>();
            ArrayList<ExplicitRules.TableDef.Level> aggLevels = new ArrayList<ExplicitRules.TableDef.Level>();
            Level[] levelArray = hierarchy.getLevels();
            int n = levelArray.length;
            boolean n2 = false;
            while (var6_9 < n) {
                Level hLevel = levelArray[var6_9];
                if (!hLevel.isAll()) {
                    RolapLevel rLevel = (RolapLevel)hLevel;
                    String levelUniqueName = rLevel.getUniqueName();
                    block6: for (ExplicitRules.TableDef.Level level : this.getTableDef().getLevels()) {
                        if (!level.getName().equals(levelUniqueName)) continue;
                        String columnName = level.getColumnName();
                        for (JdbcSchema.Table.Column aggColumn : this.aggTable.getColumns()) {
                            if (!aggColumn.getName().equalsIgnoreCase(columnName)) continue;
                            levelMatches.add(new Pair<RolapLevel, JdbcSchema.Table.Column>(rLevel, aggColumn));
                            aggLevels.add(level);
                            break block6;
                        }
                    }
                }
                ++var6_9;
            }
            if (levelMatches.size() == 0) {
                return;
            }
            Collections.sort(levelMatches, new Comparator<Pair<RolapLevel, JdbcSchema.Table.Column>>(){

                @Override
                public int compare(Pair<RolapLevel, JdbcSchema.Table.Column> o1, Pair<RolapLevel, JdbcSchema.Table.Column> o2) {
                    return Util.compareIntegers(((RolapLevel)o1.left).getDepth(), ((RolapLevel)o2.left).getDepth());
                }
            });
            Collections.sort(aggLevels, new Comparator<ExplicitRules.TableDef.Level>(){

                @Override
                public int compare(ExplicitRules.TableDef.Level o1, ExplicitRules.TableDef.Level o2) {
                    return Util.compareIntegers(o1.getRolapLevel().getDepth(), o2.getRolapLevel().getDepth());
                }
            });
            boolean forceCollapse = false;
            for (Pair pair : levelMatches) {
                if (levelMatches.indexOf(pair) > 0 && ((RolapLevel)pair.left).getDepth() - 1 != ((RolapLevel)((Pair)levelMatches.get((int)(levelMatches.indexOf((Object)pair) - 1))).left).getDepth()) {
                    this.msgRecorder.reportError("The aggregate table " + this.aggTable.getName() + " contains the column " + ((JdbcSchema.Table.Column)pair.right).getName() + " which maps to the level " + ((RolapLevel)pair.left).getUniqueName() + " but its parent level is not part of that aggregation.");
                }
                if (levelMatches.indexOf(pair) > 0 && !((ExplicitRules.TableDef.Level)aggLevels.get(levelMatches.indexOf(pair))).isCollapsed()) {
                    forceCollapse = true;
                    this.msgRecorder.reportWarning("The aggregate table " + this.aggTable.getName() + " contains the column " + ((JdbcSchema.Table.Column)pair.right).getName() + " which maps to the level " + ((RolapLevel)pair.left).getUniqueName() + " and is marked as non-collapsed, but its parent column is already present.");
                }
                if (levelMatches.indexOf(pair) == 0 && ((RolapLevel)pair.left).getDepth() > 1 && ((ExplicitRules.TableDef.Level)aggLevels.get(levelMatches.indexOf(pair))).isCollapsed()) {
                    this.msgRecorder.reportError("The aggregate table " + this.aggTable.getName() + " contains the column " + ((JdbcSchema.Table.Column)pair.right).getName() + " which maps to the level " + ((RolapLevel)pair.left).getUniqueName() + " but its parent level is not part of that aggregation and this level is marked as collapsed.");
                }
                if (((ExplicitRules.TableDef.Level)aggLevels.get(levelMatches.indexOf(pair))).isCollapsed() || ((RolapLevel)pair.left).isUnique()) continue;
                this.msgRecorder.reportError("The aggregate table " + this.aggTable.getName() + " contains the column " + ((JdbcSchema.Table.Column)pair.right).getName() + " which maps to the level " + ((RolapLevel)pair.left).getUniqueName() + " but that level doesn't have unique members and this level is marked as non collapsed.");
            }
            if (this.msgRecorder.hasErrors()) {
                return;
            }
            for (Pair pair : levelMatches) {
                this.makeLevel((JdbcSchema.Table.Column)pair.right, hierarchy, hierarchyUsage, this.getColumnName(((RolapLevel)pair.left).getKeyExp()), ((ExplicitRules.TableDef.Level)aggLevels.get(levelMatches.indexOf(pair))).getColumnName(), ((RolapLevel)pair.left).getName(), forceCollapse ? true : ((ExplicitRules.TableDef.Level)aggLevels.get(levelMatches.indexOf(pair))).isCollapsed(), (RolapLevel)pair.left);
            }
        }
        finally {
            this.msgRecorder.popContextName();
        }
    }
}

