/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap.cache;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.concurrent.Future;
import mondrian.rolap.BitKey;
import mondrian.rolap.RolapUtil;
import mondrian.rolap.agg.AggregationKey;
import mondrian.rolap.agg.CellRequest;
import mondrian.rolap.agg.SegmentBuilder;
import mondrian.rolap.cache.SegmentCacheIndex;
import mondrian.spi.SegmentBody;
import mondrian.spi.SegmentColumn;
import mondrian.spi.SegmentHeader;
import mondrian.util.ByteString;
import mondrian.util.CartesianProductList;
import mondrian.util.Pair;
import mondrian.util.PartiallyOrderedSet;
import mondrian.util.SlotFuture;

public class SegmentCacheIndexImpl
implements SegmentCacheIndex {
    private final Map<List, List<SegmentHeader>> bitkeyMap = new HashMap<List, List<SegmentHeader>>();
    private final Map<List, FactInfo> factMap = new HashMap<List, FactInfo>();
    private final Map<List, FuzzyFactInfo> fuzzyFactMap = new HashMap<List, FuzzyFactInfo>();
    private final Map<SegmentHeader, HeaderInfo> headerMap = new HashMap<SegmentHeader, HeaderInfo>();
    private final Thread thread;

    public SegmentCacheIndexImpl(Thread thread) {
        this.thread = thread;
        assert (thread != null);
    }

    public static List makeConverterKey(SegmentHeader header) {
        return Arrays.asList(header.schemaName, header.schemaChecksum, header.cubeName, header.rolapStarFactTableName, header.measureName, header.compoundPredicates);
    }

    public static List makeConverterKey(CellRequest request, AggregationKey key) {
        return Arrays.asList(request.getMeasure().getStar().getSchema().getName(), request.getMeasure().getStar().getSchema().getChecksum(), request.getMeasure().getCubeName(), request.getMeasure().getStar().getFactTable().getAlias(), request.getMeasure().getName(), AggregationKey.getCompoundPredicateStringList(key.getStar(), key.getCompoundPredicateList()));
    }

    @Override
    public List<SegmentHeader> locate(String schemaName, ByteString schemaChecksum, String cubeName, String measureName, String rolapStarFactTableName, BitKey constrainedColsBitKey, Map<String, Comparable> coordinates, List<String> compoundPredicates) {
        this.checkThread();
        List<SegmentHeader> list = Collections.emptyList();
        List starKey = this.makeBitkeyKey(schemaName, schemaChecksum, cubeName, rolapStarFactTableName, constrainedColsBitKey, measureName, compoundPredicates);
        List<SegmentHeader> headerList = this.bitkeyMap.get(starKey);
        if (headerList == null) {
            return Collections.emptyList();
        }
        for (SegmentHeader header : headerList) {
            if (!SegmentCacheIndexImpl.matches(header, coordinates, compoundPredicates)) continue;
            if (list.isEmpty()) {
                list = new ArrayList<SegmentHeader>();
            }
            list.add(header);
        }
        return list;
    }

    @Override
    public boolean add(SegmentHeader header, boolean loading, SegmentBuilder.SegmentConverter converter) {
        List fuzzyFactKey;
        FuzzyFactInfo fuzzyFactInfo;
        this.checkThread();
        HeaderInfo headerInfo = this.headerMap.get(header);
        if (headerInfo != null) {
            if (loading && headerInfo.slot == null) {
                headerInfo.slot = new SlotFuture();
                return true;
            }
            return false;
        }
        headerInfo = new HeaderInfo();
        if (loading) {
            headerInfo.slot = new SlotFuture();
        }
        this.headerMap.put(header, headerInfo);
        List bitkeyKey = this.makeBitkeyKey(header);
        List<SegmentHeader> headerList = this.bitkeyMap.get(bitkeyKey);
        if (headerList == null) {
            headerList = new ArrayList<SegmentHeader>();
            this.bitkeyMap.put(bitkeyKey, headerList);
        }
        headerList.add(header);
        List factKey = this.makeFactKey(header);
        FactInfo factInfo = this.factMap.get(factKey);
        if (factInfo == null) {
            factInfo = new FactInfo();
            this.factMap.put(factKey, factInfo);
        }
        factInfo.headerList.add(header);
        factInfo.bitkeyPoset.add(header.getConstrainedColumnsBitKey());
        if (converter != null) {
            factInfo.converter = converter;
        }
        if ((fuzzyFactInfo = this.fuzzyFactMap.get(fuzzyFactKey = this.makeFuzzyFactKey(header))) == null) {
            fuzzyFactInfo = new FuzzyFactInfo();
            this.fuzzyFactMap.put(fuzzyFactKey, fuzzyFactInfo);
        }
        fuzzyFactInfo.headerList.add(header);
        return true;
    }

    @Override
    public void loadSucceeded(SegmentHeader header, SegmentBody body) {
        this.checkThread();
        HeaderInfo headerInfo = this.headerMap.get(header);
        assert (headerInfo != null) : "segment header " + header.getUniqueID() + " is missing";
        assert (headerInfo.slot != null) : "segment header " + header.getUniqueID() + " is not loading";
        if (!headerInfo.slot.isDone()) {
            headerInfo.slot.put(body);
        }
        if (headerInfo.removeAfterLoad) {
            this.remove(header);
        }
    }

    @Override
    public void loadFailed(SegmentHeader header, Throwable throwable) {
        this.checkThread();
        HeaderInfo headerInfo = this.headerMap.get(header);
        assert (headerInfo != null) : "segment header " + header.getUniqueID() + " is missing";
        assert (headerInfo.slot != null) : "segment header " + header.getUniqueID() + " is not loading";
        headerInfo.slot.fail(throwable);
        this.remove(header);
    }

    @Override
    public void remove(SegmentHeader header) {
        List fuzzyFactKey;
        FuzzyFactInfo fuzzyFactInfo;
        this.checkThread();
        HeaderInfo headerInfo = this.headerMap.get(header);
        if (headerInfo == null) {
            return;
        }
        if (headerInfo.slot != null && !headerInfo.slot.isDone()) {
            headerInfo.removeAfterLoad = true;
        } else {
            this.headerMap.remove(header);
        }
        List factKey = this.makeFactKey(header);
        FactInfo factInfo = this.factMap.get(factKey);
        if (factInfo != null) {
            factInfo.headerList.remove(header);
            if (factInfo.headerList.size() == 0) {
                this.factMap.remove(factKey);
            }
        }
        if ((fuzzyFactInfo = this.fuzzyFactMap.get(fuzzyFactKey = this.makeFuzzyFactKey(header))) != null) {
            fuzzyFactInfo.headerList.remove(header);
            if (fuzzyFactInfo.headerList.size() == 0) {
                this.fuzzyFactMap.remove(fuzzyFactKey);
            }
        }
        List bitkeyKey = this.makeBitkeyKey(header);
        List<SegmentHeader> headerList = this.bitkeyMap.get(bitkeyKey);
        headerList.remove(header);
        if (headerList.size() == 0) {
            this.bitkeyMap.remove(bitkeyKey);
            factInfo.bitkeyPoset.remove(header.getConstrainedColumnsBitKey());
        }
        this.headerMap.remove(header);
    }

    private void checkThread() {
        assert (this.thread == Thread.currentThread()) : "expected " + this.thread + ", but was " + Thread.currentThread();
    }

    public static boolean matches(SegmentHeader header, Map<String, Comparable> coords, List<String> compoundPredicates) {
        if (!header.compoundPredicates.equals(compoundPredicates)) {
            return false;
        }
        for (Map.Entry<String, Comparable> entry : coords.entrySet()) {
            SortedSet<Comparable> values;
            SegmentColumn excludedColumn = header.getExcludedRegion(entry.getKey());
            if (excludedColumn != null && ((values = excludedColumn.getValues()) == null || values.contains(entry.getValue()))) {
                return false;
            }
            SegmentColumn constrainedColumn = header.getConstrainedColumn(entry.getKey());
            if (constrainedColumn == null) {
                return false;
            }
            SortedSet<Comparable> values2 = constrainedColumn.getValues();
            if (values2 == null || values2.contains(entry.getValue())) continue;
            return false;
        }
        return true;
    }

    @Override
    public List<SegmentHeader> intersectRegion(String schemaName, ByteString schemaChecksum, String cubeName, String measureName, String rolapStarFactTableName, SegmentColumn[] region) {
        this.checkThread();
        List factKey = this.makeFuzzyFactKey(schemaName, schemaChecksum, cubeName, rolapStarFactTableName, measureName);
        FuzzyFactInfo factInfo = this.fuzzyFactMap.get(factKey);
        List<SegmentHeader> list = Collections.emptyList();
        if (factInfo == null) {
            return list;
        }
        for (SegmentHeader header : factInfo.headerList) {
            if (!this.intersects(header, region)) continue;
            if (list.isEmpty()) {
                list = new ArrayList<SegmentHeader>();
            }
            list.add(header);
        }
        return list;
    }

    private boolean intersects(SegmentHeader header, SegmentColumn[] region) {
        if (region.length == 0) {
            return true;
        }
        SegmentColumn[] segmentColumnArray = region;
        int n = region.length;
        int n2 = 0;
        while (n2 < n) {
            SegmentColumn regionColumn = segmentColumnArray[n2];
            SegmentColumn headerColumn = header.getConstrainedColumn(regionColumn.getColumnExpression());
            if (headerColumn == null) {
                return true;
            }
            SortedSet<Comparable> regionValues = regionColumn.getValues();
            SortedSet<Comparable> headerValues = headerColumn.getValues();
            if (headerValues == null || regionValues == null) {
                return true;
            }
            for (Comparable myValue : regionValues) {
                if (!headerValues.contains(myValue)) continue;
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public void printCacheState(PrintWriter pw) {
        this.checkThread();
        ArrayList<List<SegmentHeader>> values = new ArrayList<List<SegmentHeader>>(this.bitkeyMap.values());
        Collections.sort(values, new Comparator<List<SegmentHeader>>(){

            @Override
            public int compare(List<SegmentHeader> o1, List<SegmentHeader> o2) {
                if (o1.size() == 0) {
                    return -1;
                }
                if (o2.size() == 0) {
                    return 1;
                }
                return o1.get(0).getUniqueID().compareTo(o2.get(0).getUniqueID());
            }
        });
        for (List list : values) {
            ArrayList headerList = new ArrayList(list);
            Collections.sort(headerList, new Comparator<SegmentHeader>(){

                @Override
                public int compare(SegmentHeader o1, SegmentHeader o2) {
                    return o1.getUniqueID().compareTo(o2.getUniqueID());
                }
            });
            for (SegmentHeader header : headerList) {
                pw.println(header.getDescription());
            }
        }
    }

    @Override
    public Future<SegmentBody> getFuture(SegmentHeader header) {
        this.checkThread();
        return this.headerMap.get(header).slot;
    }

    @Override
    public SegmentBuilder.SegmentConverter getConverter(String schemaName, ByteString schemaChecksum, String cubeName, String rolapStarFactTableName, String measureName, List<String> compoundPredicates) {
        this.checkThread();
        List factKey = this.makeFactKey(schemaName, schemaChecksum, cubeName, rolapStarFactTableName, measureName, compoundPredicates);
        FactInfo factInfo = this.factMap.get(factKey);
        if (factInfo == null) {
            return null;
        }
        return factInfo.converter;
    }

    @Override
    public void setConverter(String schemaName, ByteString schemaChecksum, String cubeName, String rolapStarFactTableName, String measureName, List<String> compoundPredicates, SegmentBuilder.SegmentConverter converter) {
        this.checkThread();
        List factKey = this.makeFactKey(schemaName, schemaChecksum, cubeName, rolapStarFactTableName, measureName, compoundPredicates);
        FactInfo factInfo = this.factMap.get(factKey);
        assert (factInfo != null) : "should have called 'add' first";
        if (factInfo == null) {
            return;
        }
        factInfo.converter = converter;
    }

    private List makeBitkeyKey(SegmentHeader header) {
        return this.makeBitkeyKey(header.schemaName, header.schemaChecksum, header.cubeName, header.rolapStarFactTableName, header.constrainedColsBitKey, header.measureName, header.compoundPredicates);
    }

    private List makeBitkeyKey(String schemaName, ByteString schemaChecksum, String cubeName, String rolapStarFactTableName, BitKey constrainedColsBitKey, String measureName, List<String> compoundPredicates) {
        return Arrays.asList(schemaName, schemaChecksum, cubeName, rolapStarFactTableName, constrainedColsBitKey, measureName, compoundPredicates);
    }

    private List makeFactKey(SegmentHeader header) {
        return this.makeFactKey(header.schemaName, header.schemaChecksum, header.cubeName, header.rolapStarFactTableName, header.measureName, header.compoundPredicates);
    }

    private List makeFactKey(String schemaName, ByteString schemaChecksum, String cubeName, String rolapStarFactTableName, String measureName, List<String> compoundPredicates) {
        return Arrays.asList(schemaName, schemaChecksum, cubeName, rolapStarFactTableName, measureName, compoundPredicates);
    }

    private List makeFuzzyFactKey(SegmentHeader header) {
        return this.makeFuzzyFactKey(header.schemaName, header.schemaChecksum, header.cubeName, header.rolapStarFactTableName, header.measureName);
    }

    private List makeFuzzyFactKey(String schemaName, ByteString schemaChecksum, String cubeName, String rolapStarFactTableName, String measureName) {
        return Arrays.asList(schemaName, schemaChecksum, cubeName, rolapStarFactTableName, measureName);
    }

    @Override
    public List<List<SegmentHeader>> findRollupCandidates(String schemaName, ByteString schemaChecksum, String cubeName, String measureName, String rolapStarFactTableName, BitKey constrainedColsBitKey, Map<String, Comparable> coordinates, List<String> compoundPredicates) {
        List factKey = this.makeFactKey(schemaName, schemaChecksum, cubeName, rolapStarFactTableName, measureName, compoundPredicates);
        FactInfo factInfo = this.factMap.get(factKey);
        if (factInfo == null) {
            return Collections.emptyList();
        }
        ArrayList<List<SegmentHeader>> list = new ArrayList<List<SegmentHeader>>();
        List<BitKey> ancestors = factInfo.bitkeyPoset.getAncestors(constrainedColsBitKey);
        for (BitKey bitKey : ancestors) {
            List bitkeyKey = this.makeBitkeyKey(schemaName, schemaChecksum, cubeName, rolapStarFactTableName, bitKey, measureName, compoundPredicates);
            List<SegmentHeader> headers = this.bitkeyMap.get(bitkeyKey);
            assert (headers != null) : "bitkeyPoset / bitkeyMap inconsistency";
            this.findRollupCandidatesAmong(coordinates, list, headers);
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private void findRollupCandidatesAmong(Map<String, Comparable> coordinates, List<List<SegmentHeader>> list, List<SegmentHeader> headers) {
        ArrayList matchingHeaders = new ArrayList();
        block0: for (SegmentHeader header : headers) {
            if (!header.getExcludedRegions().isEmpty()) continue;
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (SegmentColumn segmentColumn : header.getConstrainedColumns()) {
                SegmentColumn constrainedColumn = header.getConstrainedColumn(segmentColumn.columnExpression);
                if (coordinates.containsKey(segmentColumn.columnExpression)) {
                    void var11_18;
                    Comparable comparable = coordinates.get(segmentColumn.columnExpression);
                    if (comparable == null) {
                        Comparable<?> comparable2 = RolapUtil.sqlNullValue;
                    }
                    if (constrainedColumn.values == null || constrainedColumn.values.contains(var11_18)) continue;
                    continue block0;
                }
                if (constrainedColumn.values == null) continue;
                arrayList.add(constrainedColumn);
            }
            if (arrayList.isEmpty()) {
                list.add(Collections.singletonList(header));
                continue;
            }
            matchingHeaders.add(Pair.of(header, arrayList));
        }
        if (matchingHeaders.size() < 2) {
            return;
        }
        ArrayList<Object> columnList = new ArrayList<Object>();
        ArrayList<String> columnNameList = new ArrayList<String>();
        for (Pair pair : matchingHeaders) {
            for (Object column : (List)pair.right) {
                if (columnNameList.contains(((SegmentColumn)column).columnExpression)) continue;
                int n = ((SegmentColumn)column).getValueCount();
                if (n <= 0) {
                    return;
                }
                columnList.add(column);
                columnNameList.add(((SegmentColumn)column).columnExpression);
            }
        }
        ArrayList arrayList = new ArrayList();
        for (SegmentColumn segmentColumn : columnList) {
            TreeMap<Comparable, BitSet> valueMap = new TreeMap<Comparable, BitSet>(RolapUtil.ROLAP_COMPARATOR);
            int n = -1;
            for (SegmentHeader header : Pair.leftIter(matchingHeaders)) {
                void var11_23;
                ++var11_23;
                SegmentColumn column1 = header.getConstrainedColumn(segmentColumn.columnExpression);
                if (column1.getValues() == null) {
                    for (Map.Entry entry : valueMap.entrySet()) {
                        int pos = 0;
                        while (pos < ((BitSet)entry.getValue()).cardinality()) {
                            ((BitSet)entry.getValue()).set(pos);
                            ++pos;
                        }
                    }
                    continue;
                }
                for (Comparable value : column1.getValues()) {
                    BitSet bitSet = (BitSet)valueMap.get(value);
                    if (bitSet == null) {
                        bitSet = new BitSet();
                        valueMap.put(value, bitSet);
                    }
                    bitSet.set((int)var11_23);
                }
            }
            if (valueMap.size() < segmentColumn.valueCount) {
                return;
            }
            HashMap<BitSet, Comparable> eqclassPrimaryValues = new HashMap<BitSet, Comparable>();
            for (Map.Entry entry : valueMap.entrySet()) {
                BitSet bitSet = (BitSet)entry.getValue();
                if (eqclassPrimaryValues.containsKey(bitSet)) continue;
                Comparable value = (Comparable)entry.getKey();
                eqclassPrimaryValues.put(bitSet, value);
            }
            arrayList.add(new ArrayList(eqclassPrimaryValues.values()));
        }
        CartesianProductList cartesianProductList = new CartesianProductList(arrayList);
        ArrayList<SegmentHeader> usedSegments = new ArrayList<SegmentHeader>();
        ArrayList unusedSegments = new ArrayList(Pair.left(matchingHeaders));
        block10: for (List<Comparable> list2 : cartesianProductList) {
            for (SegmentHeader segmentHeader : usedSegments) {
                if (this.contains(segmentHeader, list2, columnNameList)) continue block10;
            }
            for (SegmentHeader segmentHeader : unusedSegments) {
                if (!this.contains(segmentHeader, list2, columnNameList)) continue;
                unusedSegments.remove(segmentHeader);
                usedSegments.add(segmentHeader);
                continue block10;
            }
            return;
        }
        list.add(usedSegments);
    }

    private boolean contains(SegmentHeader segment, List<Comparable> values, List<String> columns) {
        int i = 0;
        while (i < columns.size()) {
            String columnName = columns.get(i);
            SegmentColumn column = segment.getConstrainedColumn(columnName);
            SortedSet<Comparable> valueSet = column.getValues();
            if (valueSet != null && !valueSet.contains(values.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static class FactInfo {
        private static final PartiallyOrderedSet.Ordering<BitKey> ORDERING = new PartiallyOrderedSet.Ordering<BitKey>(){

            @Override
            public boolean lessThan(BitKey e1, BitKey e2) {
                return e2.isSuperSetOf(e1);
            }
        };
        private final List<SegmentHeader> headerList = new ArrayList<SegmentHeader>();
        private final PartiallyOrderedSet<BitKey> bitkeyPoset = new PartiallyOrderedSet<BitKey>(ORDERING);
        private SegmentBuilder.SegmentConverter converter;

        FactInfo() {
        }
    }

    private static class FuzzyFactInfo {
        private final List<SegmentHeader> headerList = new ArrayList<SegmentHeader>();

        FuzzyFactInfo() {
        }
    }

    private static class HeaderInfo {
        private SlotFuture<SegmentBody> slot;
        private boolean removeAfterLoad;

        private HeaderInfo() {
        }
    }
}

