/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap.cache;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import mondrian.rolap.cache.SmartCache;

public abstract class SmartCacheImpl<K, V>
implements SmartCache<K, V> {
    private final ReadWriteLock lock = new ReentrantReadWriteLock();

    protected abstract Iterator<Map.Entry<K, V>> iteratorImpl();

    protected abstract V putImpl(K var1, V var2);

    protected abstract V getImpl(K var1);

    protected abstract V removeImpl(K var1);

    protected abstract void clearImpl();

    protected abstract int sizeImpl();

    @Override
    public V put(K key, V value) {
        this.lock.writeLock().lock();
        try {
            V v = this.putImpl(key, value);
            return v;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public V get(K key) {
        this.lock.readLock().lock();
        try {
            V v = this.getImpl(key);
            return v;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public V remove(K key) {
        this.lock.writeLock().lock();
        try {
            V v = this.removeImpl(key);
            return v;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void clear() {
        this.lock.writeLock().lock();
        try {
            this.clearImpl();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public int size() {
        this.lock.readLock().lock();
        try {
            int n = this.sizeImpl();
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public void execute(SmartCache.SmartCacheTask<K, V> task) {
        this.lock.writeLock().lock();
        try {
            task.execute(this.iteratorImpl());
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }
}

