/*
 * Decompiled with CFR 0.152.
 */
package mondrian.server;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import mondrian.olap.Util;
import mondrian.rolap.RolapUtil;
import mondrian.server.monitor.CellCacheSegmentCreateEvent;
import mondrian.server.monitor.CellCacheSegmentDeleteEvent;
import mondrian.server.monitor.ConnectionEndEvent;
import mondrian.server.monitor.ConnectionInfo;
import mondrian.server.monitor.ConnectionStartEvent;
import mondrian.server.monitor.Event;
import mondrian.server.monitor.ExecutionEndEvent;
import mondrian.server.monitor.ExecutionInfo;
import mondrian.server.monitor.ExecutionPhaseEvent;
import mondrian.server.monitor.ExecutionStartEvent;
import mondrian.server.monitor.Message;
import mondrian.server.monitor.Monitor;
import mondrian.server.monitor.ServerInfo;
import mondrian.server.monitor.SqlStatementEndEvent;
import mondrian.server.monitor.SqlStatementExecuteEvent;
import mondrian.server.monitor.SqlStatementInfo;
import mondrian.server.monitor.SqlStatementStartEvent;
import mondrian.server.monitor.StatementEndEvent;
import mondrian.server.monitor.StatementInfo;
import mondrian.server.monitor.StatementStartEvent;
import mondrian.server.monitor.Visitor;
import mondrian.util.Pair;
import org.apache.log4j.Logger;

class MonitorImpl
implements Monitor {
    private static final Logger LOGGER = Logger.getLogger(MonitorImpl.class);
    private final Handler handler = new Handler();
    protected static final Util.MemoryInfo MEMORY_INFO = Util.getMemoryInfo();
    private static final Actor ACTOR = new Actor();

    static {
        Thread thread = new Thread((Runnable)ACTOR, "Mondrian Monitor");
        thread.setDaemon(true);
        thread.start();
    }

    public void shutdown() {
    }

    @Override
    public void sendEvent(Event event) {
        try {
            if (Thread.interrupted()) {
                throw new AssertionError();
            }
            ACTOR.eventQueue.put(Pair.of(this.handler, event));
        }
        catch (InterruptedException e) {
            throw Util.newError(e, "Exception while sending event " + event);
        }
    }

    @Override
    public ServerInfo getServer() {
        return (ServerInfo)this.execute(new ServerCommand());
    }

    @Override
    public List<ConnectionInfo> getConnections() {
        return (List)this.execute(new ConnectionsCommand());
    }

    @Override
    public List<StatementInfo> getStatements() {
        return (List)this.execute(new StatementsCommand());
    }

    @Override
    public List<SqlStatementInfo> getSqlStatements() {
        return (List)this.execute(new SqlStatementsCommand());
    }

    private Object execute(Command command) {
        return ACTOR.execute(this.handler, command);
    }

    private static class Actor
    implements Runnable {
        private boolean running = true;
        private final BlockingQueue<Pair<Handler, Message>> eventQueue = new ArrayBlockingQueue<Pair<Handler, Message>>(1000);
        private final ResponseQueue<Command, Object> responseQueue = new ResponseQueue(1000);

        private Actor() {
        }

        @Override
        public void run() {
            while (true) {
                try {
                    Message message;
                    do {
                        Pair<Handler, Message> entry = this.eventQueue.take();
                        Handler handler = (Handler)entry.left;
                        message = (Message)entry.right;
                        Object result = message.accept(handler);
                        if (message instanceof Command) {
                            this.responseQueue.put((Command)message, result);
                            continue;
                        }
                        RolapUtil.MONITOR_LOGGER.debug((Object)message);
                    } while (!(message instanceof ShutdownCommand));
                    return;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    LOGGER.warn((Object)"Monitor thread interrupted.", (Throwable)e);
                    return;
                }
                catch (Throwable t) {
                    LOGGER.error((Object)"Runtime error on the monitor thread.", t);
                    continue;
                }
                break;
            }
            finally {
                this.running = false;
            }
        }

        public void shutdown() {
            if (this.running) {
                this.execute(null, new ShutdownCommand());
            }
        }

        Object execute(Handler handler, Command command) {
            try {
                this.eventQueue.put(Pair.of(handler, command));
            }
            catch (InterruptedException e) {
                throw Util.newError(e, "Interrupted while sending " + command);
            }
            try {
                return this.responseQueue.take(command);
            }
            catch (InterruptedException e) {
                throw Util.newError(e, "Interrupted while awaiting " + command);
            }
        }
    }

    static abstract class Command
    implements Message {
        Command() {
        }
    }

    static interface CommandVisitor<T>
    extends Visitor<T> {
        public T visit(ConnectionsCommand var1);

        public T visit(ServerCommand var1);

        public T visit(SqlStatementsCommand var1);

        public T visit(StatementsCommand var1);

        public T visit(ShutdownCommand var1);
    }

    static class ConnectionsCommand
    extends Command {
        ConnectionsCommand() {
        }

        @Override
        public <T> T accept(Visitor<T> visitor) {
            return ((CommandVisitor)visitor).visit(this);
        }
    }

    private static class Handler
    implements CommandVisitor<Object> {
        private final MutableServerInfo server = new MutableServerInfo();
        private final Map<Integer, MutableConnectionInfo> connectionMap = new HashMap<Integer, MutableConnectionInfo>();
        private final Map<Long, MutableSqlStatementInfo> sqlStatementMap = new HashMap<Long, MutableSqlStatementInfo>();
        private final Map<Long, MutableStatementInfo> statementMap = new HashMap<Long, MutableStatementInfo>();
        private final Map<Long, MutableExecutionInfo> executionMap = new HashMap<Long, MutableExecutionInfo>();
        private final Map<Long, MutableExecutionInfo> retiredExecutionMap = new HashMap<Long, MutableExecutionInfo>();

        private Handler() {
        }

        private Object missing(Event event) {
            return null;
        }

        @Override
        public Object visit(ConnectionStartEvent event) {
            MutableConnectionInfo conn = new MutableConnectionInfo();
            this.connectionMap.put(event.connectionId, conn);
            this.foo(conn, event);
            this.foo(this.server.aggConn, event);
            return null;
        }

        private void foo(MutableConnectionInfo conn, ConnectionStartEvent event) {
            MutableConnectionInfo mutableConnectionInfo = conn;
            mutableConnectionInfo.startCount = mutableConnectionInfo.startCount + 1;
        }

        @Override
        public Object visit(ConnectionEndEvent event) {
            MutableConnectionInfo conn = this.connectionMap.remove(event.connectionId);
            if (conn == null) {
                return this.missing(event);
            }
            this.foo(conn, event);
            this.foo(this.server.aggConn, event);
            RolapUtil.MONITOR_LOGGER.debug((Object)conn.fix());
            return null;
        }

        private void foo(MutableConnectionInfo conn, ConnectionEndEvent event) {
            MutableConnectionInfo mutableConnectionInfo = conn;
            mutableConnectionInfo.endCount = mutableConnectionInfo.endCount + 1;
        }

        @Override
        public Object visit(StatementStartEvent event) {
            MutableConnectionInfo conn = this.connectionMap.get(event.connectionId);
            if (conn == null) {
                return this.missing(event);
            }
            MutableStatementInfo stmt = new MutableStatementInfo(conn, event.statementId);
            this.statementMap.put(event.statementId, stmt);
            this.foo(stmt, event);
            this.foo(conn.aggStmt, event);
            this.foo(this.server.aggStmt, event);
            return null;
        }

        private void foo(MutableStatementInfo stmt, StatementStartEvent event) {
            MutableStatementInfo mutableStatementInfo = stmt;
            mutableStatementInfo.startCount = mutableStatementInfo.startCount + 1;
        }

        @Override
        public Object visit(StatementEndEvent event) {
            MutableStatementInfo stmt = this.statementMap.remove(event.statementId);
            if (stmt == null) {
                return this.missing(event);
            }
            this.foo(stmt, event);
            this.foo(stmt.conn.aggStmt, event);
            this.foo(this.server.aggStmt, event);
            RolapUtil.MONITOR_LOGGER.debug((Object)stmt.fix());
            return null;
        }

        private void foo(MutableStatementInfo stmt, StatementEndEvent event) {
            MutableStatementInfo mutableStatementInfo = stmt;
            mutableStatementInfo.endCount = mutableStatementInfo.endCount + 1;
        }

        @Override
        public Object visit(ExecutionStartEvent event) {
            MutableStatementInfo stmt = this.statementMap.get(event.statementId);
            if (stmt == null) {
                return this.missing(event);
            }
            MutableExecutionInfo exec = new MutableExecutionInfo(stmt, event.executionId);
            this.executionMap.put(event.executionId, exec);
            this.foo(exec, event);
            this.foo(stmt.aggExec, event);
            this.foo(stmt.conn.aggExec, event);
            this.foo(this.server.aggExec, event);
            return null;
        }

        private void foo(MutableExecutionInfo exec, ExecutionStartEvent event) {
            MutableExecutionInfo mutableExecutionInfo = exec;
            mutableExecutionInfo.startCount = mutableExecutionInfo.startCount + 1;
        }

        @Override
        public Object visit(ExecutionPhaseEvent event) {
            MutableExecutionInfo exec = this.executionMap.get(event.executionId);
            if (exec == null) {
                return this.missing(event);
            }
            this.executionMap.put(event.executionId, exec);
            this.foo(exec, event);
            this.foo(exec.stmt.aggExec, event);
            this.foo(exec.stmt.conn.aggExec, event);
            this.foo(this.server.aggExec, event);
            return null;
        }

        private void foo(MutableExecutionInfo exec, ExecutionPhaseEvent event) {
            MutableExecutionInfo mutableExecutionInfo = exec;
            mutableExecutionInfo.phaseCount = mutableExecutionInfo.phaseCount + 1;
            exec.cellCacheHitCountDelta = event.hitCount;
            exec.cellCacheMissCountDelta = event.missCount;
            exec.cellCachePendingCountDelta = event.pendingCount;
        }

        @Override
        public Object visit(ExecutionEndEvent event) {
            MutableExecutionInfo exec = this.executionMap.remove(event.executionId);
            if (exec == null) {
                return this.missing(event);
            }
            this.retiredExecutionMap.put(exec.executionId, exec);
            this.foo(exec, event);
            this.foo(exec.stmt.aggExec, event);
            this.foo(exec.stmt.conn.aggExec, event);
            this.foo(this.server.aggExec, event);
            RolapUtil.MONITOR_LOGGER.debug((Object)exec.fix());
            return null;
        }

        private void foo(MutableExecutionInfo exec, ExecutionEndEvent event) {
            MutableExecutionInfo mutableExecutionInfo = exec;
            mutableExecutionInfo.endCount = mutableExecutionInfo.endCount + 1;
            MutableExecutionInfo mutableExecutionInfo2 = exec;
            mutableExecutionInfo2.phaseCount = mutableExecutionInfo2.phaseCount + 1;
            MutableExecutionInfo mutableExecutionInfo3 = exec;
            mutableExecutionInfo3.cellCacheHitCount = mutableExecutionInfo3.cellCacheHitCount + event.cellCacheHitCount;
            MutableExecutionInfo mutableExecutionInfo4 = exec;
            mutableExecutionInfo4.cellCacheMissCount = mutableExecutionInfo4.cellCacheMissCount + event.cellCacheMissCount;
            MutableExecutionInfo mutableExecutionInfo5 = exec;
            mutableExecutionInfo5.cellCachePendingCount = mutableExecutionInfo5.cellCachePendingCount + event.cellCachePendingCount;
            MutableExecutionInfo mutableExecutionInfo6 = exec;
            mutableExecutionInfo6.cellCacheRequestCount = mutableExecutionInfo6.cellCacheRequestCount + (event.cellCacheHitCount + event.cellCacheMissCount + event.cellCachePendingCount);
            exec.cellCacheHitCountDelta = 0;
            exec.cellCacheMissCountDelta = 0;
            exec.cellCachePendingCountDelta = 0;
        }

        @Override
        public Object visit(CellCacheSegmentCreateEvent event) {
            MutableExecutionInfo exec = this.executionMap.get(event.executionId);
            if (exec == null && (exec = this.retiredExecutionMap.get(event.executionId)) == null) {
                return this.missing(event);
            }
            this.foo(exec, event);
            this.foo(exec.stmt.aggExec, event);
            this.foo(exec.stmt.conn.aggExec, event);
            this.foo(this.server.aggExec, event);
            return null;
        }

        private void foo(MutableExecutionInfo exec, CellCacheSegmentCreateEvent event) {
            MutableExecutionInfo mutableExecutionInfo = exec;
            mutableExecutionInfo.cellCacheSegmentCreateCount = mutableExecutionInfo.cellCacheSegmentCreateCount + 1;
            MutableExecutionInfo mutableExecutionInfo2 = exec;
            mutableExecutionInfo2.cellCacheSegmentCoordinateSum = mutableExecutionInfo2.cellCacheSegmentCoordinateSum + event.coordinateCount;
            MutableExecutionInfo mutableExecutionInfo3 = exec;
            mutableExecutionInfo3.cellCacheSegmentCellCount = mutableExecutionInfo3.cellCacheSegmentCellCount + event.actualCellCount;
            switch (event.source) {
                case ROLLUP: {
                    MutableExecutionInfo mutableExecutionInfo4 = exec;
                    mutableExecutionInfo4.cellCacheSegmentCreateViaRollupCount = mutableExecutionInfo4.cellCacheSegmentCreateViaRollupCount + 1;
                    break;
                }
                case EXTERNAL: {
                    MutableExecutionInfo mutableExecutionInfo5 = exec;
                    mutableExecutionInfo5.cellCacheSegmentCreateViaExternalCount = mutableExecutionInfo5.cellCacheSegmentCreateViaExternalCount + 1;
                    break;
                }
                case SQL: {
                    MutableExecutionInfo mutableExecutionInfo6 = exec;
                    mutableExecutionInfo6.cellCacheSegmentCreateViaSqlCount = mutableExecutionInfo6.cellCacheSegmentCreateViaSqlCount + 1;
                    break;
                }
                default: {
                    throw Util.unexpected(event.source);
                }
            }
        }

        @Override
        public Object visit(CellCacheSegmentDeleteEvent event) {
            MutableExecutionInfo exec = this.executionMap.get(event.executionId);
            if (exec == null) {
                return this.missing(event);
            }
            this.foo(exec, event);
            this.foo(exec.stmt.aggExec, event);
            this.foo(exec.stmt.conn.aggExec, event);
            this.foo(this.server.aggExec, event);
            return null;
        }

        private void foo(MutableExecutionInfo exec, CellCacheSegmentDeleteEvent event) {
            MutableExecutionInfo mutableExecutionInfo = exec;
            mutableExecutionInfo.cellCacheSegmentDeleteCount = mutableExecutionInfo.cellCacheSegmentDeleteCount + 1;
            MutableExecutionInfo mutableExecutionInfo2 = exec;
            mutableExecutionInfo2.cellCacheSegmentCoordinateSum = mutableExecutionInfo2.cellCacheSegmentCoordinateSum - event.coordinateCount;
            switch (event.source) {
                case EXTERNAL: {
                    MutableExecutionInfo mutableExecutionInfo3 = exec;
                    mutableExecutionInfo3.cellCacheSegmentDeleteViaExternalCount = mutableExecutionInfo3.cellCacheSegmentDeleteViaExternalCount + 1;
                }
            }
        }

        @Override
        public Object visit(SqlStatementStartEvent event) {
            MutableStatementInfo stmt = this.statementMap.get(event.getStatementId());
            if (stmt == null) {
                return this.missing(event);
            }
            MutableSqlStatementInfo sql = new MutableSqlStatementInfo(stmt, event.sqlStatementId);
            this.sqlStatementMap.put(event.sqlStatementId, sql);
            this.foo(sql, event);
            this.foo(sql.stmt.aggSql, event);
            this.foo(this.server.aggSql, event);
            return null;
        }

        private void foo(MutableSqlStatementInfo sql, SqlStatementStartEvent event) {
            MutableSqlStatementInfo mutableSqlStatementInfo = sql;
            mutableSqlStatementInfo.startCount = mutableSqlStatementInfo.startCount + 1;
            MutableSqlStatementInfo mutableSqlStatementInfo2 = sql;
            mutableSqlStatementInfo2.cellRequestCount = mutableSqlStatementInfo2.cellRequestCount + event.cellRequestCount;
        }

        @Override
        public Object visit(SqlStatementExecuteEvent event) {
            MutableSqlStatementInfo sql = this.sqlStatementMap.get(event.sqlStatementId);
            if (sql == null) {
                return this.missing(event);
            }
            this.foo(sql, event);
            this.foo(sql.stmt.aggSql, event);
            this.foo(this.server.aggSql, event);
            return null;
        }

        private void foo(MutableSqlStatementInfo sql, SqlStatementExecuteEvent event) {
            MutableSqlStatementInfo mutableSqlStatementInfo = sql;
            mutableSqlStatementInfo.executeCount = mutableSqlStatementInfo.executeCount + 1;
            MutableSqlStatementInfo mutableSqlStatementInfo2 = sql;
            mutableSqlStatementInfo2.executeNanos = mutableSqlStatementInfo2.executeNanos + event.executeNanos;
        }

        @Override
        public Object visit(SqlStatementEndEvent event) {
            MutableSqlStatementInfo sql = this.sqlStatementMap.remove(event.sqlStatementId);
            if (sql == null) {
                return this.missing(event);
            }
            this.foo(sql, event);
            this.foo(sql.stmt.aggSql, event);
            this.foo(this.server.aggSql, event);
            RolapUtil.MONITOR_LOGGER.debug((Object)sql.fix());
            return null;
        }

        private void foo(MutableSqlStatementInfo sql, SqlStatementEndEvent event) {
            MutableSqlStatementInfo mutableSqlStatementInfo = sql;
            mutableSqlStatementInfo.endCount = mutableSqlStatementInfo.endCount + 1;
            MutableSqlStatementInfo mutableSqlStatementInfo2 = sql;
            mutableSqlStatementInfo2.rowFetchCount = mutableSqlStatementInfo2.rowFetchCount + event.rowFetchCount;
        }

        @Override
        public Object visit(ConnectionsCommand connectionsCommand) {
            ArrayList<ConnectionInfo> list = new ArrayList<ConnectionInfo>();
            for (MutableConnectionInfo info : this.connectionMap.values()) {
                list.add(info.fix());
            }
            return list;
        }

        @Override
        public Object visit(ServerCommand serverCommand) {
            return this.server.fix();
        }

        @Override
        public Object visit(SqlStatementsCommand command) {
            ArrayList<SqlStatementInfo> list = new ArrayList<SqlStatementInfo>();
            for (MutableSqlStatementInfo info : this.sqlStatementMap.values()) {
                list.add(info.fix());
            }
            return list;
        }

        @Override
        public Object visit(StatementsCommand command) {
            ArrayList<StatementInfo> list = new ArrayList<StatementInfo>();
            for (MutableStatementInfo info : this.statementMap.values()) {
                list.add(info.fix());
            }
            return list;
        }

        @Override
        public Object visit(ShutdownCommand command) {
            return "Shutdown succeeded";
        }
    }

    private static class MutableConnectionInfo {
        private final MutableExecutionInfo aggExec = new MutableExecutionInfo(null, -1L);
        private final MutableStatementInfo aggStmt = new MutableStatementInfo(null, -1L);
        private int startCount;
        private int endCount;

        private MutableConnectionInfo() {
        }

        public ConnectionInfo fix() {
            return new ConnectionInfo(this.aggExec.cellCacheHitCount, this.aggExec.cellCacheRequestCount, this.aggExec.cellCacheMissCount, this.aggExec.cellCachePendingCount, this.aggStmt.startCount, this.aggStmt.endCount, this.aggExec.startCount, this.aggExec.endCount);
        }
    }

    private static class MutableExecutionInfo {
        private final MutableStatementInfo stmt;
        private final long executionId;
        private final MutableSqlStatementInfo aggSql = new MutableSqlStatementInfo(null, -1L);
        private int startCount;
        private int phaseCount;
        private int endCount;
        private int cellCacheRequestCount;
        private int cellCacheHitCount;
        private int cellCacheMissCount;
        private int cellCachePendingCount;
        private int cellCacheHitCountDelta;
        private int cellCacheMissCountDelta;
        private int cellCachePendingCountDelta;
        private int cellCacheSegmentCreateCount;
        private int cellCacheSegmentCreateViaRollupCount;
        private int cellCacheSegmentCreateViaSqlCount;
        private int cellCacheSegmentCreateViaExternalCount;
        private int cellCacheSegmentDeleteViaExternalCount;
        private int cellCacheSegmentDeleteCount;
        private int cellCacheSegmentCoordinateSum;
        private int cellCacheSegmentCellCount;

        public MutableExecutionInfo(MutableStatementInfo stmt, long executionId) {
            this.stmt = stmt;
            this.executionId = executionId;
        }

        public ExecutionInfo fix() {
            return new ExecutionInfo(this.executionId, this.phaseCount, this.cellCacheRequestCount, this.cellCacheHitCount, this.cellCacheMissCount, this.cellCachePendingCount, this.aggSql.startCount, this.aggSql.executeCount, this.aggSql.endCount, this.aggSql.rowFetchCount, this.aggSql.executeNanos, this.aggSql.cellRequestCount);
        }
    }

    private static class MutableServerInfo {
        private final MutableSqlStatementInfo aggSql = new MutableSqlStatementInfo(null, -1L);
        private final MutableExecutionInfo aggExec = new MutableExecutionInfo(null, -1L);
        private final MutableStatementInfo aggStmt = new MutableStatementInfo(null, -1L);
        private final MutableConnectionInfo aggConn = new MutableConnectionInfo();

        private MutableServerInfo() {
        }

        public ServerInfo fix() {
            Util.MemoryInfo.Usage memoryUsage = MEMORY_INFO.get();
            return new ServerInfo(this.aggConn.startCount, this.aggConn.endCount, this.aggStmt.startCount, this.aggStmt.endCount, this.aggSql.startCount, this.aggSql.executeCount, this.aggSql.endCount, this.aggSql.rowFetchCount, this.aggSql.executeNanos, this.aggSql.cellRequestCount, this.aggExec.cellCacheHitCount, this.aggExec.cellCacheRequestCount, this.aggExec.cellCacheMissCount, this.aggExec.cellCachePendingCount, this.aggExec.startCount, this.aggExec.endCount, memoryUsage.getUsed(), memoryUsage.getCommitted(), memoryUsage.getMax(), this.aggExec.cellCacheSegmentCreateCount - this.aggExec.cellCacheSegmentDeleteCount, this.aggExec.cellCacheSegmentCreateCount, this.aggExec.cellCacheSegmentCreateViaExternalCount, this.aggExec.cellCacheSegmentDeleteViaExternalCount, this.aggExec.cellCacheSegmentCreateViaRollupCount, this.aggExec.cellCacheSegmentCreateViaSqlCount, this.aggExec.cellCacheSegmentCellCount, this.aggExec.cellCacheSegmentCoordinateSum);
        }
    }

    private static class MutableSqlStatementInfo {
        private final MutableStatementInfo stmt;
        private final long sqlStatementId;
        private int startCount;
        private int executeCount;
        private int endCount;
        private int cellRequestCount;
        private long executeNanos;
        private long rowFetchCount;

        public MutableSqlStatementInfo(MutableStatementInfo stmt, long sqlStatementId) {
            this.sqlStatementId = sqlStatementId;
            this.stmt = stmt;
        }

        public SqlStatementInfo fix() {
            return new SqlStatementInfo(this.sqlStatementId);
        }
    }

    private static class MutableStatementInfo {
        private final MutableConnectionInfo conn;
        private final long statementId;
        private final MutableExecutionInfo aggExec = new MutableExecutionInfo(null, -1L);
        private final MutableSqlStatementInfo aggSql = new MutableSqlStatementInfo(null, -1L);
        private int startCount;
        private int endCount;

        public MutableStatementInfo(MutableConnectionInfo conn, long statementId) {
            this.statementId = statementId;
            this.conn = conn;
        }

        public StatementInfo fix() {
            return new StatementInfo(this.statementId, this.aggExec.startCount, this.aggExec.endCount, this.aggExec.phaseCount, this.aggExec.cellCacheRequestCount, this.aggExec.cellCacheHitCount, this.aggExec.cellCacheMissCount, this.aggExec.cellCachePendingCount, this.aggSql.startCount, this.aggSql.executeCount, this.aggSql.endCount, this.aggSql.rowFetchCount, this.aggSql.executeNanos, this.aggSql.cellRequestCount);
        }
    }

    private static class ResponseQueue<K, V> {
        private final BlockingQueue<Pair<K, V>> queue;
        private final Map<K, V> taken = new WeakHashMap();

        public ResponseQueue(int capacity) {
            this.queue = new ArrayBlockingQueue<Pair<K, V>>(capacity);
        }

        public void put(K k, V v) throws InterruptedException {
            this.queue.put(Pair.of(k, v));
        }

        public synchronized V take(K k) throws InterruptedException {
            V v = this.taken.remove(k);
            if (v != null) {
                return v;
            }
            while (true) {
                Pair<K, V> pair = this.queue.take();
                if (pair.left.equals(k)) {
                    return (V)pair.right;
                }
                this.taken.put(pair.left, pair.right);
            }
        }
    }

    static class ServerCommand
    extends Command {
        ServerCommand() {
        }

        @Override
        public <T> T accept(Visitor<T> visitor) {
            return ((CommandVisitor)visitor).visit(this);
        }
    }

    static class ShutdownCommand
    extends Command {
        ShutdownCommand() {
        }

        @Override
        public <T> T accept(Visitor<T> visitor) {
            return ((CommandVisitor)visitor).visit(this);
        }
    }

    static class SqlStatementsCommand
    extends Command {
        SqlStatementsCommand() {
        }

        @Override
        public <T> T accept(Visitor<T> visitor) {
            return ((CommandVisitor)visitor).visit(this);
        }
    }

    static class StatementsCommand
    extends Command {
        StatementsCommand() {
        }

        @Override
        public <T> T accept(Visitor<T> visitor) {
            return ((CommandVisitor)visitor).visit(this);
        }
    }
}

