/*
 * Decompiled with CFR 0.152.
 */
package mondrian.spi;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import mondrian.olap.Util;
import mondrian.rolap.BitKey;
import mondrian.spi.SegmentColumn;
import mondrian.util.ByteString;

public class SegmentHeader
implements Serializable {
    private static final long serialVersionUID = 8696439182886512850L;
    private final int arity;
    private final List<SegmentColumn> constrainedColumns;
    private final List<SegmentColumn> excludedRegions;
    public final List<String> compoundPredicates;
    public final String measureName;
    public final String cubeName;
    public final String schemaName;
    public final String rolapStarFactTableName;
    public final BitKey constrainedColsBitKey;
    private final int hashCode;
    private ByteString uniqueID;
    private String description;
    public final ByteString schemaChecksum;

    public SegmentHeader(String schemaName, ByteString schemaChecksum, String cubeName, String measureName, List<SegmentColumn> constrainedColumns, List<String> compoundPredicates, String rolapStarFactTableName, BitKey constrainedColsBitKey, List<SegmentColumn> excludedRegions) {
        this.constrainedColumns = constrainedColumns;
        this.excludedRegions = excludedRegions;
        this.schemaName = schemaName;
        this.schemaChecksum = schemaChecksum;
        assert (schemaChecksum != null);
        this.cubeName = cubeName;
        this.measureName = measureName;
        this.compoundPredicates = compoundPredicates;
        this.rolapStarFactTableName = rolapStarFactTableName;
        this.constrainedColsBitKey = constrainedColsBitKey;
        this.arity = constrainedColumns.size();
        this.hashCode = this.computeHashCode();
    }

    private int computeHashCode() {
        int hash = 42;
        hash = Util.hash(hash, this.schemaName);
        hash = Util.hash(hash, this.schemaChecksum);
        hash = Util.hash(hash, this.cubeName);
        hash = Util.hash(hash, this.measureName);
        for (SegmentColumn col : this.constrainedColumns) {
            hash = Util.hash(hash, col.columnExpression);
            if (col.values == null) continue;
            hash = Util.hashArray(hash, col.values.toArray());
        }
        for (SegmentColumn col : this.excludedRegions) {
            hash = Util.hash(hash, col.columnExpression);
            if (col.values == null) continue;
            hash = Util.hashArray(hash, col.values.toArray());
        }
        hash = Util.hash(hash, this.compoundPredicates);
        return hash;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SegmentHeader)) {
            return false;
        }
        SegmentHeader that = (SegmentHeader)obj;
        return this.getUniqueID().equals(that.getUniqueID()) && this.excludedRegions.equals(that.excludedRegions);
    }

    public SegmentHeader clone(SegmentColumn[] overrideValues) {
        HashMap<String, SegmentColumn> colsToAdd = new HashMap<String, SegmentColumn>();
        for (SegmentColumn cc : this.constrainedColumns) {
            colsToAdd.put(cc.columnExpression, cc);
        }
        SegmentColumn[] segmentColumnArray = overrideValues;
        int n = overrideValues.length;
        int n2 = 0;
        while (n2 < n) {
            SegmentColumn override = segmentColumnArray[n2];
            colsToAdd.put(override.columnExpression, override);
            ++n2;
        }
        return new SegmentHeader(this.schemaName, this.schemaChecksum, this.cubeName, this.measureName, new ArrayList<SegmentColumn>(colsToAdd.values()), Collections.<String>emptyList(), this.rolapStarFactTableName, this.constrainedColsBitKey, Collections.<SegmentColumn>emptyList());
    }

    public boolean canConstrain(SegmentColumn[] region) {
        boolean atLeastOnePresent = false;
        SegmentColumn[] segmentColumnArray = region;
        int n = region.length;
        int n2 = 0;
        while (n2 < n) {
            SegmentColumn ccToFlush = segmentColumnArray[n2];
            SegmentColumn ccActual = this.getConstrainedColumn(ccToFlush.columnExpression);
            if (ccActual != null) {
                SegmentColumn ccActualExcl = this.getExcludedRegion(ccToFlush.columnExpression);
                if (ccToFlush.values == null || ccActualExcl != null && ccActualExcl.values != null && ccActualExcl.merge((SegmentColumn)ccToFlush).values == null) {
                    return false;
                }
                if (ccActual.values != null && ccActual.values.equals(ccToFlush.values)) {
                    return false;
                }
                atLeastOnePresent = true;
            }
            ++n2;
        }
        return atLeastOnePresent;
    }

    public SegmentHeader constrain(SegmentColumn[] region) {
        HashMap<String, SegmentColumn> newRegions = new HashMap<String, SegmentColumn>();
        for (SegmentColumn excludedRegion : this.excludedRegions) {
            newRegions.put(excludedRegion.columnExpression, excludedRegion);
        }
        SegmentColumn[] segmentColumnArray = region;
        int n = region.length;
        int n2 = 0;
        while (n2 < n) {
            SegmentColumn col = segmentColumnArray[n2];
            if (this.getConstrainedColumn(col.columnExpression) != null) {
                if (newRegions.containsKey(col.columnExpression)) {
                    newRegions.put(col.columnExpression, ((SegmentColumn)newRegions.get(col.columnExpression)).merge(col));
                } else {
                    newRegions.put(col.columnExpression, col);
                }
            }
            ++n2;
        }
        assert (newRegions.size() > 0);
        return new SegmentHeader(this.schemaName, this.schemaChecksum, this.cubeName, this.measureName, this.constrainedColumns, this.compoundPredicates, this.rolapStarFactTableName, this.constrainedColsBitKey, new ArrayList<SegmentColumn>(newRegions.values()));
    }

    public String toString() {
        return this.getDescription();
    }

    public int getArity() {
        return this.arity;
    }

    public List<SegmentColumn> getExcludedRegions() {
        return this.excludedRegions;
    }

    public List<SegmentColumn> getConstrainedColumns() {
        return this.constrainedColumns;
    }

    public SegmentColumn getConstrainedColumn(String columnExpression) {
        for (SegmentColumn c : this.constrainedColumns) {
            if (!c.columnExpression.equals(columnExpression)) continue;
            return c;
        }
        return null;
    }

    public SegmentColumn getExcludedRegion(String columnExpression) {
        for (SegmentColumn c : this.excludedRegions) {
            if (!c.columnExpression.equals(columnExpression)) continue;
            return c;
        }
        return null;
    }

    public BitKey getConstrainedColumnsBitKey() {
        return this.constrainedColsBitKey.copy();
    }

    public ByteString getUniqueID() {
        if (this.uniqueID == null) {
            StringBuilder hashSB = new StringBuilder();
            hashSB.append(this.schemaName);
            hashSB.append(this.schemaChecksum);
            hashSB.append(this.cubeName);
            hashSB.append(this.measureName);
            for (SegmentColumn segmentColumn : this.constrainedColumns) {
                hashSB.append(segmentColumn.columnExpression);
                if (segmentColumn.values == null) continue;
                for (Object e : segmentColumn.values) {
                    hashSB.append(String.valueOf(e));
                }
            }
            for (SegmentColumn segmentColumn : this.excludedRegions) {
                hashSB.append(segmentColumn.columnExpression);
                if (segmentColumn.values == null) continue;
                for (Object e : segmentColumn.values) {
                    hashSB.append(String.valueOf(e));
                }
            }
            for (String string : this.compoundPredicates) {
                hashSB.append(string);
            }
            this.uniqueID = new ByteString(Util.digestSha256(hashSB.toString()));
        }
        return this.uniqueID;
    }

    public String getDescription() {
        if (this.description == null) {
            StringBuilder descriptionSB = new StringBuilder();
            descriptionSB.append("*Segment Header\n");
            descriptionSB.append("Schema:[");
            descriptionSB.append(this.schemaName);
            descriptionSB.append("]\nChecksum:[");
            descriptionSB.append(this.schemaChecksum);
            descriptionSB.append("]\nCube:[");
            descriptionSB.append(this.cubeName);
            descriptionSB.append("]\nMeasure:[");
            descriptionSB.append(this.measureName);
            descriptionSB.append("]\n");
            descriptionSB.append("Axes:[");
            for (SegmentColumn segmentColumn : this.constrainedColumns) {
                descriptionSB.append("\n    {");
                descriptionSB.append(segmentColumn.columnExpression);
                descriptionSB.append("=(");
                if (segmentColumn.values == null) {
                    descriptionSB.append("* ");
                } else {
                    for (Object e : segmentColumn.values) {
                        descriptionSB.append("'");
                        descriptionSB.append(e);
                        descriptionSB.append("',");
                    }
                }
                descriptionSB.deleteCharAt(descriptionSB.length() - 1);
                descriptionSB.append(")}");
            }
            descriptionSB.append("]\n");
            descriptionSB.append("Excluded Regions:[");
            for (SegmentColumn segmentColumn : this.excludedRegions) {
                descriptionSB.append("\n    {");
                descriptionSB.append(segmentColumn.columnExpression);
                descriptionSB.append("=(");
                if (segmentColumn.values == null) {
                    descriptionSB.append("* ");
                } else {
                    for (Object e : segmentColumn.values) {
                        descriptionSB.append("'");
                        descriptionSB.append(e);
                        descriptionSB.append("',");
                    }
                }
                descriptionSB.deleteCharAt(descriptionSB.length() - 1);
                descriptionSB.append(")}");
            }
            descriptionSB.append("]\n");
            descriptionSB.append("Compound Predicates:[");
            for (String string : this.compoundPredicates) {
                descriptionSB.append("\n\t{");
                descriptionSB.append(string);
            }
            descriptionSB.append("]\n").append("ID:[").append(this.getUniqueID()).append("]\n");
            this.description = descriptionSB.toString();
        }
        return this.description;
    }
}

