/*
 * Decompiled with CFR 0.152.
 */
package mondrian.spi.impl;

import java.sql.Connection;
import java.sql.SQLException;
import mondrian.olap.Util;
import mondrian.spi.Dialect;
import mondrian.spi.impl.JdbcDialectFactory;
import mondrian.spi.impl.MySqlDialect;

public class InfobrightDialect
extends MySqlDialect {
    public static final JdbcDialectFactory FACTORY = new JdbcDialectFactory(InfobrightDialect.class, Dialect.DatabaseProduct.MYSQL){

        @Override
        protected boolean acceptsConnection(Connection connection) {
            try {
                return super.acceptsConnection(connection) && InfobrightDialect.isInfobright(connection.getMetaData());
            }
            catch (SQLException e) {
                throw Util.newError(e, "Error while instantiating dialect");
            }
        }
    };

    public InfobrightDialect(Connection connection) throws SQLException {
        super(connection);
    }

    @Override
    public Dialect.DatabaseProduct getDatabaseProduct() {
        return Dialect.DatabaseProduct.INFOBRIGHT;
    }

    @Override
    public boolean allowsCompoundCountDistinct() {
        return false;
    }

    public String generateOrderItem(String expr, boolean nullable, boolean ascending) {
        if (ascending) {
            return String.valueOf(expr) + " ASC";
        }
        return String.valueOf(expr) + " DESC";
    }

    @Override
    public boolean supportsGroupByExpressions() {
        return false;
    }

    @Override
    public boolean requiresGroupByAlias() {
        return true;
    }

    @Override
    public boolean allowsOrderByAlias() {
        return false;
    }

    @Override
    public boolean requiresOrderByAlias() {
        return true;
    }

    @Override
    public boolean supportsMultiValueInExpr() {
        return false;
    }
}

