/*
 * Decompiled with CFR 0.152.
 */
package mondrian.spi.impl;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.sql.DataSource;
import mondrian.olap.Util;
import mondrian.server.Execution;
import mondrian.spi.Dialect;
import mondrian.spi.StatisticsProvider;
import org.apache.log4j.Logger;

public class JdbcStatisticsProvider
implements StatisticsProvider {
    private static final Logger LOG = Logger.getLogger(JdbcStatisticsProvider.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int getTableCardinality(Dialect dialect, DataSource dataSource, String catalog, String schema, String table, Execution execution) {
        Connection connection = null;
        ResultSet resultSet = null;
        try {
            connection = dataSource.getConnection();
            resultSet = connection.getMetaData().getIndexInfo(catalog, schema, table, false, true);
            int maxNonUnique = -1;
            block9: while (true) {
                if (!resultSet.next()) {
                    int n = maxNonUnique;
                    Util.close(resultSet, null, connection);
                    return n;
                }
                int type = resultSet.getInt(7);
                int cardinality = resultSet.getInt(11);
                boolean unique = !resultSet.getBoolean(4);
                switch (type) {
                    case 0: {
                        int n = cardinality;
                        Util.close(resultSet, null, connection);
                        return n;
                    }
                    default: {
                        if (unique) continue block9;
                        maxNonUnique = Math.max(maxNonUnique, cardinality);
                        break;
                    }
                }
            }
        }
        catch (SQLException e) {
            if (!LOG.isDebugEnabled()) return -1;
            LOG.debug((Object)("JdbcStatisticsProvider failed to get the cardinality of the table " + table), (Throwable)e);
            return -1;
        }
        finally {
            Util.close(resultSet, null, connection);
        }
    }

    @Override
    public int getQueryCardinality(Dialect dialect, DataSource dataSource, String sql, Execution execution) {
        return -1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int getColumnCardinality(Dialect dialect, DataSource dataSource, String catalog, String schema, String table, String column, Execution execution) {
        Connection connection = null;
        ResultSet resultSet = null;
        try {
            connection = dataSource.getConnection();
            resultSet = connection.getMetaData().getIndexInfo(catalog, schema, table, false, true);
            while (true) {
                if (!resultSet.next()) {
                    Util.close(resultSet, null, connection);
                    return -1;
                }
                int type = resultSet.getInt(7);
                switch (type) {
                    case 0: {
                        int n = resultSet.getInt(11);
                        Util.close(resultSet, null, connection);
                        return n;
                    }
                }
            }
        }
        catch (SQLException e) {
            if (!LOG.isDebugEnabled()) return -1;
            LOG.debug((Object)("JdbcStatisticsProvider failed to get the cardinality of the table " + table), (Throwable)e);
            return -1;
        }
        finally {
            Util.close(resultSet, null, connection);
        }
    }
}

