/*
 * Decompiled with CFR 0.152.
 */
package mondrian.tui;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import mondrian.olap.Util;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xerces.impl.Version;
import org.apache.xerces.parsers.DOMParser;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.apache.xpath.domapi.XPathEvaluatorImpl;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.w3c.dom.xpath.XPathException;
import org.w3c.dom.xpath.XPathNSResolver;
import org.w3c.dom.xpath.XPathResult;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;

public class XmlUtil {
    public static final String LINE_SEP = System.getProperty("line.separator", "\n");
    public static final String SOAP_PREFIX = "SOAP-ENV";
    public static final String XSD_PREFIX = "xsd";
    public static final String XMLNS = "xmlns";
    public static final String NAMESPACES_FEATURE_ID = "http://xml.org/sax/features/namespaces";
    public static final String VALIDATION_FEATURE_ID = "http://xml.org/sax/features/validation";
    public static final String SCHEMA_VALIDATION_FEATURE_ID = "http://apache.org/xml/features/validation/schema";
    public static final String FULL_SCHEMA_VALIDATION_FEATURE_ID = "http://apache.org/xml/features/validation/schema-full-checking";
    public static final String DEFER_NODE_EXPANSION = "http://apache.org/xml/features/dom/defer-node-expansion";
    public static final String SCHEMA_LOCATION = "http://apache.org/xml/properties/schema/external-schemaLocation";
    private static final Node[] NULL_NODE_ARRAY = new Node[0];
    private static int[] versionNumbers = null;
    private static final String ALWAYS_ATTEMPT_VALIDATION = "mondrian.xml.always.attempt.validation";
    private static final boolean alwaysAttemptValidation = Boolean.getBoolean("mondrian.xml.always.attempt.validation");
    private static TransformerFactory tfactory = null;

    public static final String getSoapXmlaXds2xd(String xmlaPrefix) {
        return "<?xml version='1.0'?>" + LINE_SEP + "<xsl:stylesheet " + LINE_SEP + "xmlns:xsl='http://www.w3.org/1999/XSL/Transform' " + LINE_SEP + "xmlns:xalan='http://xml.apache.org/xslt' " + LINE_SEP + "xmlns:xsd='http://www.w3.org/2001/XMLSchema' " + LINE_SEP + "xmlns:ROW='urn:schemas-microsoft-com:xml-analysis:rowset' " + LINE_SEP + "xmlns:SOAP-ENV='http://schemas.xmlsoap.org/soap/envelope/' " + LINE_SEP + "xmlns:xmla='urn:schemas-microsoft-com:xml-analysis' " + LINE_SEP + "version='1.0' " + LINE_SEP + "> " + LINE_SEP + "<xsl:output method='xml'  " + LINE_SEP + "encoding='UTF-8' " + LINE_SEP + "indent='yes'  " + LINE_SEP + "xalan:indent-amount='2'/> " + LINE_SEP + "  " + LINE_SEP + "<!-- consume '/' and apply --> " + LINE_SEP + "<xsl:template match='/'> " + LINE_SEP + "<xsl:apply-templates/> " + LINE_SEP + "</xsl:template> " + LINE_SEP + "<!-- consume 'Envelope' and apply --> " + LINE_SEP + "<xsl:template match='SOAP-ENV:Envelope'> " + LINE_SEP + "<xsl:apply-templates/> " + LINE_SEP + "</xsl:template> " + LINE_SEP + "<!-- consume 'Header' --> " + LINE_SEP + "<xsl:template match='SOAP-ENV:Header'> " + LINE_SEP + "</xsl:template> " + LINE_SEP + "<!-- consume 'Body' and apply --> " + LINE_SEP + "<xsl:template match='SOAP-ENV:Body'> " + LINE_SEP + "<xsl:apply-templates/> " + LINE_SEP + "</xsl:template> " + LINE_SEP + "<!-- consume 'DiscoverResponse' and apply --> " + LINE_SEP + "<xsl:template match='" + xmlaPrefix + ":DiscoverResponse'> " + LINE_SEP + "<xsl:apply-templates/> " + LINE_SEP + "</xsl:template> " + LINE_SEP + "<!-- consume 'return' and apply --> " + LINE_SEP + "<xsl:template match='" + xmlaPrefix + ":return'> " + LINE_SEP + "<xsl:apply-templates/> " + LINE_SEP + "</xsl:template> " + LINE_SEP + "<!-- consume 'xsd:schema' --> " + LINE_SEP + "<xsl:template match='xsd:schema'> " + LINE_SEP + "</xsl:template> " + LINE_SEP + "<!-- copy everything else --> " + LINE_SEP + "<xsl:template match='*|@*'> " + LINE_SEP + "<xsl:copy> " + LINE_SEP + "<xsl:apply-templates select='@*|node()'/> " + LINE_SEP + "</xsl:copy> " + LINE_SEP + "</xsl:template> " + LINE_SEP + "</xsl:stylesheet>";
    }

    public static final String getSoapXmlaXds2xs(String xmlaPrefix) {
        return "<?xml version='1.0'?> " + LINE_SEP + "<xsl:stylesheet  " + LINE_SEP + "xmlns:xsl='http://www.w3.org/1999/XSL/Transform'  " + LINE_SEP + "xmlns:xalan='http://xml.apache.org/xslt' " + LINE_SEP + "xmlns:xsd='http://www.w3.org/2001/XMLSchema' " + LINE_SEP + "xmlns:ROW='urn:schemas-microsoft-com:xml-analysis:rowset' " + LINE_SEP + "xmlns:SOAP-ENV='http://schemas.xmlsoap.org/soap/envelope/'  " + LINE_SEP + "xmlns:xmla='urn:schemas-microsoft-com:xml-analysis' " + LINE_SEP + "version='1.0' " + LINE_SEP + "> " + LINE_SEP + "<xsl:output method='xml'  " + LINE_SEP + "encoding='UTF-8' " + LINE_SEP + "indent='yes'  " + LINE_SEP + "xalan:indent-amount='2'/> " + LINE_SEP + "<!-- consume '/' and apply --> " + LINE_SEP + "<xsl:template match='/'> " + LINE_SEP + "<xsl:apply-templates/> " + LINE_SEP + "</xsl:template> " + LINE_SEP + "<!-- consume 'Envelope' and apply --> " + LINE_SEP + "<xsl:template match='SOAP-ENV:Envelope'> " + LINE_SEP + "<xsl:apply-templates/> " + LINE_SEP + "</xsl:template> " + LINE_SEP + "<!-- consume 'Header' --> " + LINE_SEP + "<xsl:template match='SOAP-ENV:Header'> " + LINE_SEP + "</xsl:template> " + LINE_SEP + "<!-- consume 'Body' and apply --> " + LINE_SEP + "<xsl:template match='SOAP-ENV:Body'> " + LINE_SEP + "<xsl:apply-templates/> " + LINE_SEP + "</xsl:template> " + LINE_SEP + "<!-- consume 'DiscoverResponse' and apply --> " + LINE_SEP + "<xsl:template match='" + xmlaPrefix + ":DiscoverResponse'> " + LINE_SEP + "<xsl:apply-templates/> " + LINE_SEP + "</xsl:template> " + LINE_SEP + "<!-- consume 'return' and apply --> " + LINE_SEP + "<xsl:template match='" + xmlaPrefix + ":return'> " + LINE_SEP + "<xsl:apply-templates/> " + LINE_SEP + "</xsl:template> " + LINE_SEP + "<!-- consume 'root' and apply --> " + LINE_SEP + "<xsl:template match='ROW:root'> " + LINE_SEP + "<xsl:apply-templates/> " + LINE_SEP + "</xsl:template> " + LINE_SEP + "<!-- consume 'row' --> " + LINE_SEP + "<xsl:template match='ROW:row'> " + LINE_SEP + "</xsl:template> " + LINE_SEP + "<!-- copy everything else --> " + LINE_SEP + "<xsl:template match='*|@*'> " + LINE_SEP + "<xsl:copy> " + LINE_SEP + "<xsl:apply-templates select='@*|node()'/> " + LINE_SEP + "</xsl:copy> " + LINE_SEP + "</xsl:template> " + LINE_SEP + "</xsl:stylesheet>";
    }

    public static final String getXmlaXds2xd(String ns) {
        String xmlaPrefix = ns == null ? "" : String.valueOf(ns) + ":";
        return "<?xml version='1.0'?>" + LINE_SEP + "<xsl:stylesheet " + LINE_SEP + "xmlns:xsl='http://www.w3.org/1999/XSL/Transform' " + LINE_SEP + "xmlns:xalan='http://xml.apache.org/xslt' " + LINE_SEP + "xmlns:xsd='http://www.w3.org/2001/XMLSchema' " + LINE_SEP + "xmlns:ROW='urn:schemas-microsoft-com:xml-analysis:rowset' " + LINE_SEP + "xmlns:SOAP-ENV='http://schemas.xmlsoap.org/soap/envelope/' " + LINE_SEP + "xmlns:xmla='urn:schemas-microsoft-com:xml-analysis' " + LINE_SEP + "version='1.0' " + LINE_SEP + "> " + LINE_SEP + "<xsl:output method='xml'  " + LINE_SEP + "encoding='UTF-8' " + LINE_SEP + "indent='yes'  " + LINE_SEP + "xalan:indent-amount='2'/> " + LINE_SEP + "  " + LINE_SEP + "<!-- consume '/' and apply --> " + LINE_SEP + "<xsl:template match='/'> " + LINE_SEP + "<xsl:apply-templates/> " + LINE_SEP + "</xsl:template> " + LINE_SEP + "<!-- consume 'DiscoverResponse' and apply --> " + LINE_SEP + "<xsl:template match='" + xmlaPrefix + "DiscoverResponse'> " + LINE_SEP + "<xsl:apply-templates/> " + LINE_SEP + "</xsl:template> " + LINE_SEP + "<!-- consume 'return' and apply --> " + LINE_SEP + "<xsl:template match='" + xmlaPrefix + "return'> " + LINE_SEP + "<xsl:apply-templates/> " + LINE_SEP + "</xsl:template> " + LINE_SEP + "<!-- consume 'xsd:schema' --> " + LINE_SEP + "<xsl:template match='xsd:schema'> " + LINE_SEP + "</xsl:template> " + LINE_SEP + "<!-- copy everything else --> " + LINE_SEP + "<xsl:template match='*|@*'> " + LINE_SEP + "<xsl:copy> " + LINE_SEP + "<xsl:apply-templates select='@*|node()'/> " + LINE_SEP + "</xsl:copy> " + LINE_SEP + "</xsl:template> " + LINE_SEP + "</xsl:stylesheet>";
    }

    public static final String getXmlaXds2xs(String ns) {
        String xmlaPrefix = ns == null ? "" : String.valueOf(ns) + ":";
        return "<?xml version='1.0'?> " + LINE_SEP + "<xsl:stylesheet  " + LINE_SEP + "xmlns:xsl='http://www.w3.org/1999/XSL/Transform'  " + LINE_SEP + "xmlns:xalan='http://xml.apache.org/xslt' " + LINE_SEP + "xmlns:xsd='http://www.w3.org/2001/XMLSchema' " + LINE_SEP + "xmlns:ROW='urn:schemas-microsoft-com:xml-analysis:rowset' " + LINE_SEP + "xmlns:SOAP-ENV='http://schemas.xmlsoap.org/soap/envelope/'  " + LINE_SEP + "xmlns:xmla='urn:schemas-microsoft-com:xml-analysis' " + LINE_SEP + "version='1.0' " + LINE_SEP + "> " + LINE_SEP + "<xsl:output method='xml'  " + LINE_SEP + "encoding='UTF-8' " + LINE_SEP + "indent='yes'  " + LINE_SEP + "xalan:indent-amount='2'/> " + LINE_SEP + "<!-- consume '/' and apply --> " + LINE_SEP + "<xsl:template match='/'> " + LINE_SEP + "<xsl:apply-templates/> " + LINE_SEP + "</xsl:template> " + LINE_SEP + "<!-- consume 'DiscoverResponse' and apply --> " + LINE_SEP + "<xsl:template match='" + xmlaPrefix + "DiscoverResponse'> " + LINE_SEP + "<xsl:apply-templates/> " + LINE_SEP + "</xsl:template> " + LINE_SEP + "<!-- consume 'return' and apply --> " + LINE_SEP + "<xsl:template match='" + xmlaPrefix + "return'> " + LINE_SEP + "<xsl:apply-templates/> " + LINE_SEP + "</xsl:template> " + LINE_SEP + "<!-- consume 'root' and apply --> " + LINE_SEP + "<xsl:template match='ROW:root'> " + LINE_SEP + "<xsl:apply-templates/> " + LINE_SEP + "</xsl:template> " + LINE_SEP + "<!-- consume 'row' --> " + LINE_SEP + "<xsl:template match='ROW:row'> " + LINE_SEP + "</xsl:template> " + LINE_SEP + "<!-- copy everything else --> " + LINE_SEP + "<xsl:template match='*|@*'> " + LINE_SEP + "<xsl:copy> " + LINE_SEP + "<xsl:apply-templates select='@*|node()'/> " + LINE_SEP + "</xsl:copy> " + LINE_SEP + "</xsl:template> " + LINE_SEP + "</xsl:stylesheet>";
    }

    public static Document newDocument(Node firstElement, boolean deepcopy) {
        DocumentImpl newDoc = new DocumentImpl();
        newDoc.appendChild(newDoc.importNode(firstElement, deepcopy));
        return newDoc;
    }

    public static DOMParser getParser(String schemaLocationPropertyValue, EntityResolver entityResolver, boolean validate) throws SAXNotRecognizedException, SAXNotSupportedException {
        boolean doingValidation = validate || schemaLocationPropertyValue != null;
        DOMParser parser = new DOMParser();
        parser.setEntityResolver(entityResolver);
        parser.setErrorHandler((ErrorHandler)new SaxErrorHandler());
        parser.setFeature(DEFER_NODE_EXPANSION, false);
        parser.setFeature(NAMESPACES_FEATURE_ID, true);
        parser.setFeature(SCHEMA_VALIDATION_FEATURE_ID, doingValidation);
        parser.setFeature(VALIDATION_FEATURE_ID, doingValidation);
        if (schemaLocationPropertyValue != null) {
            parser.setProperty(SCHEMA_LOCATION, (Object)schemaLocationPropertyValue.replace('\\', '/'));
        }
        return parser;
    }

    private static void checkForParseError(DOMParser parser, Throwable t) {
        if (Util.IBM_JVM) {
            return;
        }
        ErrorHandler errorHandler = parser.getErrorHandler();
        if (errorHandler instanceof SaxErrorHandler) {
            SaxErrorHandler saxEH = (SaxErrorHandler)errorHandler;
            List<SaxErrorHandler.ErrorInfo> errors = saxEH.getErrors();
            if (errors != null && errors.size() > 0) {
                String errorStr = SaxErrorHandler.formatErrorInfos(saxEH);
                throw new RuntimeException(errorStr, t);
            }
        } else {
            System.out.println("errorHandler=" + errorHandler);
        }
    }

    private static void checkForParseError(DOMParser parser) {
        XmlUtil.checkForParseError(parser, null);
    }

    public static Document parseString(String s) throws SAXException, IOException {
        int length = s.length();
        if (length > 0x1000000 && length % 4 == 1) {
            StringBuilder buf = new StringBuilder(length + 1);
            buf.append(s);
            buf.append('\n');
            s = buf.toString();
        }
        return XmlUtil.parse(s.getBytes());
    }

    public static Document parse(byte[] bytes) throws SAXException, IOException {
        return XmlUtil.parse(new ByteArrayInputStream(bytes));
    }

    public static Document parse(File file) throws SAXException, IOException {
        return XmlUtil.parse(new FileInputStream(file));
    }

    public static Document parse(InputStream in) throws SAXException, IOException {
        InputSource source = new InputSource(in);
        DOMParser parser = XmlUtil.getParser(null, null, false);
        try {
            parser.parse(source);
            XmlUtil.checkForParseError(parser);
        }
        catch (SAXParseException ex) {
            XmlUtil.checkForParseError(parser, ex);
        }
        Document document = parser.getDocument();
        return document;
    }

    public static Document createContextDocument(String[][] nsArray) throws SAXException, IOException {
        StringBuilder buf = new StringBuilder(256);
        buf.append("<?xml version='1.0' encoding='utf-8'?>");
        buf.append("<DOES_NOT_MATTER");
        int i = 0;
        while (i < nsArray.length) {
            String prefix = nsArray[i][0];
            String nsURI = nsArray[i][1];
            buf.append(" xmlns:");
            buf.append(prefix);
            buf.append("=\"");
            buf.append(nsURI);
            buf.append("\"");
            ++i;
        }
        buf.append(" />");
        String docStr = buf.toString();
        return XmlUtil.parseString(docStr);
    }

    public static String makeSoapPath() {
        return XmlUtil.makeSoapPath(SOAP_PREFIX);
    }

    public static String makeSoapPath(String prefix) {
        StringBuilder buf = new StringBuilder(20);
        buf.append('/');
        if (prefix != null) {
            buf.append(prefix);
            buf.append(':');
        }
        buf.append("Envelope");
        buf.append('/');
        if (prefix != null) {
            buf.append(prefix);
            buf.append(':');
        }
        buf.append("Body");
        buf.append('/');
        buf.append('*');
        return buf.toString();
    }

    public static String makeRootPathInSoapBody() {
        return XmlUtil.makeRootPathInSoapBody("xmla", XSD_PREFIX);
    }

    public static String makeRootPathInSoapBody(String xmlaPrefix, String xsdPrefix) {
        StringBuilder buf = new StringBuilder(20);
        buf.append("/").append(xmlaPrefix).append(":DiscoverResponse");
        buf.append("/").append(xmlaPrefix).append(":return");
        buf.append("/ROW:root");
        buf.append('/');
        buf.append('*');
        return buf.toString();
    }

    public static String selectAsString(Node node, String xpath) throws XPathException {
        return XmlUtil.selectAsString(node, xpath, node);
    }

    public static String selectAsString(Node node, String xpath, Node namespaceNode) throws XPathException {
        XPathResult xpathResult = XmlUtil.select(node, xpath, namespaceNode);
        return XmlUtil.convertToString(xpathResult, false);
    }

    public static Node[] selectAsNodes(Node node, String xpath) throws XPathException {
        return XmlUtil.selectAsNodes(node, xpath, node);
    }

    public static Node[] selectAsNodes(Node node, String xpath, Node namespaceNode) throws XPathException {
        XPathResult xpathResult = XmlUtil.select(node, xpath, namespaceNode);
        return XmlUtil.convertToNodes(xpathResult);
    }

    public static XPathResult select(Node contextNode, String xpath, Node namespaceNode) throws XPathException {
        XPathEvaluatorImpl evaluator = new XPathEvaluatorImpl();
        XPathNSResolver resolver = evaluator.createNSResolver(namespaceNode);
        return (XPathResult)evaluator.evaluate(xpath, contextNode, resolver, (short)0, null);
    }

    public static String convertToString(XPathResult xpathResult, boolean prettyPrint) {
        switch (xpathResult.getResultType()) {
            case 1: {
                double d = xpathResult.getNumberValue();
                return Double.toString(d);
            }
            case 2: {
                String s = xpathResult.getStringValue();
                return s;
            }
            case 3: {
                boolean b = xpathResult.getBooleanValue();
                return String.valueOf(b);
            }
            case 8: 
            case 9: {
                Node node = xpathResult.getSingleNodeValue();
                return XmlUtil.toString(node, prettyPrint);
            }
            case 4: 
            case 5: {
                StringBuilder buf = new StringBuilder(512);
                Node node = xpathResult.iterateNext();
                while (node != null) {
                    buf.append(XmlUtil.toString(node, prettyPrint));
                    node = xpathResult.iterateNext();
                }
                return buf.toString();
            }
            case 6: 
            case 7: {
                StringBuilder buf = new StringBuilder(512);
                int len = xpathResult.getSnapshotLength();
                int i = 0;
                while (i < len) {
                    Node node = xpathResult.snapshotItem(i);
                    buf.append(XmlUtil.toString(node, prettyPrint));
                    ++i;
                }
                return buf.toString();
            }
        }
        String msg = "Unknown xpathResult.type = " + xpathResult.getResultType();
        throw new XPathException(2, msg);
    }

    public static Node[] convertToNodes(XPathResult xpathResult) {
        switch (xpathResult.getResultType()) {
            case 1: {
                return NULL_NODE_ARRAY;
            }
            case 2: {
                return NULL_NODE_ARRAY;
            }
            case 3: {
                return NULL_NODE_ARRAY;
            }
            case 8: 
            case 9: {
                Node node = xpathResult.getSingleNodeValue();
                return new Node[]{node};
            }
            case 4: 
            case 5: {
                ArrayList<Node> list = new ArrayList<Node>();
                Node node = xpathResult.iterateNext();
                while (node != null) {
                    list.add(node);
                    node = xpathResult.iterateNext();
                }
                return list.toArray(NULL_NODE_ARRAY);
            }
            case 6: 
            case 7: {
                int len = xpathResult.getSnapshotLength();
                Node[] nodes = new Node[len];
                int i = 0;
                while (i < len) {
                    Node node;
                    nodes[i] = node = xpathResult.snapshotItem(i);
                    ++i;
                }
                return nodes;
            }
        }
        String msg = "Unknown xpathResult.type = " + xpathResult.getResultType();
        throw new XPathException(2, msg);
    }

    public static String toString(Node node, boolean prettyPrint) {
        if (node == null) {
            return null;
        }
        try {
            OutputFormat format;
            Document doc = node.getOwnerDocument();
            if (doc != null) {
                format = new OutputFormat(doc, null, prettyPrint);
            } else {
                format = new OutputFormat("xml", null, prettyPrint);
                format.setLineWidth(0);
            }
            if (prettyPrint) {
                format.setLineSeparator(LINE_SEP);
            } else {
                format.setLineSeparator("");
            }
            StringWriter writer = new StringWriter(1000);
            XMLSerializer serial = new XMLSerializer((Writer)writer, format);
            serial.asDOMSerializer();
            if (node instanceof Document) {
                serial.serialize((Document)node);
            } else if (node instanceof Element) {
                format.setOmitXMLDeclaration(true);
                serial.serialize((Element)node);
            } else if (node instanceof DocumentFragment) {
                format.setOmitXMLDeclaration(true);
                serial.serialize((DocumentFragment)node);
            } else {
                if (node instanceof Text) {
                    Text text = (Text)node;
                    return text.getData();
                }
                if (node instanceof Attr) {
                    Attr attr = (Attr)node;
                    String name = attr.getName();
                    String value = attr.getValue();
                    writer.write(name);
                    writer.write("=\"");
                    writer.write(value);
                    writer.write("\"");
                    if (prettyPrint) {
                        writer.write(LINE_SEP);
                    }
                } else {
                    writer.write("node class = " + node.getClass().getName());
                    if (prettyPrint) {
                        writer.write(LINE_SEP);
                    } else {
                        writer.write(32);
                    }
                    writer.write("XmlUtil.toString: fix me: ");
                    writer.write(node.toString());
                    if (prettyPrint) {
                        writer.write(LINE_SEP);
                    }
                }
            }
            return writer.toString();
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static String getXercesVersion() {
        try {
            return Version.getVersion();
        }
        catch (NoClassDefFoundError ex) {
            return "Xerces-J 2.2.0";
        }
    }

    public static String getXercesVersionNumberString() {
        String version = XmlUtil.getXercesVersion();
        int index = version.indexOf(32);
        return index == -1 ? "0.0.0" : version.substring(index + 1);
    }

    public static synchronized int[] getXercesVersionNumbers() {
        if (versionNumbers == null) {
            int[] verNums = new int[3];
            String verNumStr = XmlUtil.getXercesVersionNumberString();
            int index = verNumStr.indexOf(46);
            verNums[0] = Integer.parseInt(verNumStr.substring(0, index));
            verNumStr = verNumStr.substring(index + 1);
            index = verNumStr.indexOf(46);
            verNums[1] = Integer.parseInt(verNumStr.substring(0, index));
            verNumStr = verNumStr.substring(index + 1);
            verNums[2] = Integer.parseInt(verNumStr);
            versionNumbers = verNums;
        }
        return versionNumbers;
    }

    public static boolean supportsValidation() {
        if (alwaysAttemptValidation) {
            return true;
        }
        int[] verNums = XmlUtil.getXercesVersionNumbers();
        return verNums[0] >= 3 || verNums[0] == 2 && verNums[1] >= 6;
    }

    public static void validate(Document doc, String schemaLocationPropertyValue, EntityResolver resolver) throws IOException, SAXException {
        OutputFormat format = new OutputFormat(doc, null, true);
        StringWriter writer = new StringWriter(1000);
        XMLSerializer serial = new XMLSerializer((Writer)writer, format);
        serial.asDOMSerializer();
        serial.serialize(doc);
        String docString = writer.toString();
        XmlUtil.validate(docString, schemaLocationPropertyValue, resolver);
    }

    public static void validate(String docStr, String schemaLocationPropertyValue, EntityResolver resolver) throws IOException, SAXException {
        if (resolver == null) {
            resolver = new Resolver();
        }
        DOMParser parser = XmlUtil.getParser(schemaLocationPropertyValue, resolver, true);
        try {
            parser.parse(new InputSource(new StringReader(docStr)));
            XmlUtil.checkForParseError(parser);
        }
        catch (SAXParseException ex) {
            XmlUtil.checkForParseError(parser, ex);
        }
    }

    public static String getNamespaceAttributeValue(Document doc) {
        Element el = doc.getDocumentElement();
        String prefix = el.getPrefix();
        Attr attr = prefix == null ? el.getAttributeNode(XMLNS) : el.getAttributeNode("xmlns:" + prefix);
        return attr == null ? null : attr.getValue();
    }

    public static TransformerFactory getTransformerFactory() throws TransformerFactoryConfigurationError {
        if (tfactory == null) {
            tfactory = TransformerFactory.newInstance();
        }
        return tfactory;
    }

    public static Node transform(Document inDoc, String xslFileName, String[][] namevalueParameters) throws ParserConfigurationException, SAXException, IOException, TransformerConfigurationException, TransformerException {
        DocumentBuilderFactory dfactory = DocumentBuilderFactory.newInstance();
        dfactory.setNamespaceAware(true);
        DocumentBuilder docBuilder = dfactory.newDocumentBuilder();
        Document xslDOM = docBuilder.parse(new InputSource(xslFileName));
        TransformerFactory tfactory = XmlUtil.getTransformerFactory();
        Templates stylesheet = tfactory.newTemplates(new DOMSource(xslDOM, xslFileName));
        Transformer transformer = stylesheet.newTransformer();
        if (namevalueParameters != null) {
            int i = 0;
            while (i < namevalueParameters.length) {
                String name = namevalueParameters[i][0];
                String value = namevalueParameters[i][1];
                transformer.setParameter(name, value);
                ++i;
            }
        }
        DOMResult domResult = new DOMResult();
        transformer.transform(new DOMSource(inDoc, null), domResult);
        return domResult.getNode();
    }

    public static Node transform(Document inDoc, String xslFileName) throws ParserConfigurationException, SAXException, IOException, TransformerConfigurationException, TransformerException {
        return XmlUtil.transform(inDoc, xslFileName, null);
    }

    public static Node transform(Document inDoc, Reader xslReader, String[][] namevalueParameters) throws ParserConfigurationException, SAXException, IOException, TransformerConfigurationException, TransformerException {
        DocumentBuilderFactory dfactory = DocumentBuilderFactory.newInstance();
        dfactory.setNamespaceAware(true);
        DocumentBuilder docBuilder = dfactory.newDocumentBuilder();
        Document xslDOM = docBuilder.parse(new InputSource(xslReader));
        TransformerFactory tfactory = XmlUtil.getTransformerFactory();
        Templates stylesheet = tfactory.newTemplates(new DOMSource(xslDOM));
        Transformer transformer = stylesheet.newTransformer();
        if (namevalueParameters != null) {
            int i = 0;
            while (i < namevalueParameters.length) {
                String name = namevalueParameters[i][0];
                String value = namevalueParameters[i][1];
                transformer.setParameter(name, value);
                ++i;
            }
        }
        DOMResult domResult = new DOMResult();
        transformer.transform(new DOMSource(inDoc, null), domResult);
        return domResult.getNode();
    }

    public static Node transform(Document inDoc, Reader xslReader) throws ParserConfigurationException, SAXException, IOException, TransformerConfigurationException, TransformerException {
        return XmlUtil.transform(inDoc, xslReader, null);
    }

    private XmlUtil() {
    }

    public static class Resolver
    implements EntityResolver {
        private InputSource source;

        protected Resolver() {
            this((InputSource)null);
        }

        public Resolver(Document doc) {
            this(XmlUtil.toString(doc, false));
        }

        public Resolver(String str) {
            this(new InputSource(new StringReader(str)));
        }

        public Resolver(InputSource source) {
            this.source = source;
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            return this.source;
        }
    }

    public static class SaxErrorHandler
    implements ErrorHandler {
        public static final String WARNING_STRING = "WARNING";
        public static final String ERROR_STRING = "ERROR";
        public static final String FATAL_ERROR_STRING = "FATAL";
        public static final short SEVERITY_WARNING = 1;
        public static final short SEVERITY_ERROR = 2;
        public static final short SEVERITY_FATAL_ERROR = 3;
        private List<ErrorInfo> errors;

        public void printErrorInfos(PrintStream out) {
            if (this.errors != null) {
                for (ErrorInfo error : this.errors) {
                    out.println(SaxErrorHandler.formatErrorInfo(error));
                }
            }
        }

        public static String formatErrorInfos(SaxErrorHandler saxEH) {
            if (!saxEH.hasErrors()) {
                return "";
            }
            StringBuilder buf = new StringBuilder(512);
            for (ErrorInfo error : saxEH.getErrors()) {
                buf.append(SaxErrorHandler.formatErrorInfo(error));
                buf.append(LINE_SEP);
            }
            return buf.toString();
        }

        public static String formatErrorInfo(ErrorInfo ei) {
            StringBuilder buf = new StringBuilder(128);
            buf.append("[");
            switch (ei.severity) {
                case 1: {
                    buf.append(WARNING_STRING);
                    break;
                }
                case 2: {
                    buf.append(ERROR_STRING);
                    break;
                }
                case 3: {
                    buf.append(FATAL_ERROR_STRING);
                }
            }
            buf.append(']');
            String systemId = ei.exception.getSystemId();
            if (systemId != null) {
                int index = systemId.lastIndexOf(47);
                if (index != -1) {
                    systemId = systemId.substring(index + 1);
                }
                buf.append(systemId);
            }
            buf.append(':');
            buf.append(ei.exception.getLineNumber());
            buf.append(':');
            buf.append(ei.exception.getColumnNumber());
            buf.append(": ");
            buf.append(ei.exception.getMessage());
            return buf.toString();
        }

        public List<ErrorInfo> getErrors() {
            return this.errors;
        }

        public boolean hasErrors() {
            return this.errors != null;
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
            this.addError(new ErrorInfo(1, exception));
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            this.addError(new ErrorInfo(2, exception));
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            this.addError(new ErrorInfo(3, exception));
        }

        protected void addError(ErrorInfo ei) {
            if (this.errors == null) {
                this.errors = new ArrayList<ErrorInfo>();
            }
            this.errors.add(ei);
        }

        public String getFirstError() {
            return this.hasErrors() ? SaxErrorHandler.formatErrorInfo(this.errors.get(0)) : "";
        }

        public static class ErrorInfo {
            public SAXParseException exception;
            public short severity;

            ErrorInfo(short severity, SAXParseException exception) {
                this.severity = severity;
                this.exception = exception;
            }
        }
    }
}

