/*
 * Decompiled with CFR 0.152.
 */
package mondrian.util;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import mondrian.util.Pair;

public class BeanMap
extends AbstractMap<String, Object> {
    private final Object o;
    private final Info info;
    private static final Map<Class, Info> INFO_MAP = new WeakHashMap<Class, Info>();

    public BeanMap(Object o) {
        this.o = o;
        this.info = BeanMap.getInfo(o.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Info getInfo(Class<?> clazz) {
        Map<Class, Info> map = INFO_MAP;
        synchronized (map) {
            Info info = INFO_MAP.get(clazz);
            if (info == null) {
                info = new Info(clazz);
                INFO_MAP.put(clazz, info);
            }
            return info;
        }
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return new AbstractSet<Map.Entry<String, Object>>(){

            @Override
            public Iterator<Map.Entry<String, Object>> iterator() {
                final Iterator fieldIterator = BeanMap.this.info.fields.iterator();
                return new Iterator<Map.Entry<String, Object>>(){

                    @Override
                    public boolean hasNext() {
                        return fieldIterator.hasNext();
                    }

                    @Override
                    public Map.Entry<String, Object> next() {
                        BeanField field = (BeanField)fieldIterator.next();
                        return Pair.of(field.name(), field.value(BeanMap.this.o));
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            @Override
            public int size() {
                return BeanMap.this.info.fields.size();
            }
        };
    }

    public static String xxx(Object o) {
        return String.valueOf(o.getClass().getSimpleName()) + new BeanMap(o);
    }

    private static interface BeanField {
        public String name();

        public Object value(Object var1);
    }

    private static class Info {
        private List<BeanField> fields = new ArrayList<BeanField>();

        public Info(Class<? extends Object> clazz) {
            Field[] fieldArray = clazz.getDeclaredFields();
            int n = fieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                final Field field = fieldArray[n2];
                int mod = field.getModifiers();
                if (!Modifier.isStatic(mod) && Modifier.isPublic(mod)) {
                    this.fields.add(new BeanField(){

                        @Override
                        public String name() {
                            return field.getName();
                        }

                        @Override
                        public Object value(Object o) {
                            try {
                                return field.get(o);
                            }
                            catch (IllegalAccessException e) {
                                return null;
                            }
                        }
                    });
                }
                ++n2;
            }
        }
    }
}

